/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.counters.GamePiece;
import VASSAL.i18n.Resources;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import javax.swing.JOptionPane;

public class TextSaver
extends AbstractToolbarItem {
    protected static final String BUTTON_TEXT = "buttonText";
    protected static final String ICON_NAME = "icon";
    @Deprecated
    protected static final String HOTKEY = "hotkey";
    @Deprecated
    protected static final String TOOLTIP = "tooltip";
    protected Map map;
    protected LaunchButton launch;

    public TextSaver() {
        ActionListener al = e -> this.apply();
        this.setNameKey("");
        this.setButtonTextKey(BUTTON_TEXT);
        this.launch = this.makeLaunchButton(Resources.getString("Editor.TextSaver.save_tooltip"), Resources.getString("Editor.TextSaver.save_text"), "", al);
    }

    @Override
    public void addTo(Buildable b) {
        this.map = (Map)b;
        this.map.getToolBar().add(this.getLaunchButton());
    }

    @Override
    public void removeFrom(Buildable b) {
        this.map = (Map)b;
        this.map.getToolBar().remove(this.getLaunchButton());
        this.map.getToolBar().revalidate();
    }

    public void apply() {
        switch (JOptionPane.showConfirmDialog(null, Resources.getString("Editor.TextSaver.by_opponents"), "", 0)) {
            case 1: {
                this.writeMapAsText();
                break;
            }
            case 0: {
                String myId = GameModule.getUserId();
                GameModule.setUserId("yendoR117");
                this.writeMapAsText();
                GameModule.setUserId(myId);
            }
        }
    }

    protected void writeMapAsText() {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        if (fc.showSaveDialog(this.map.getView()) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        try (BufferedWriter bw = Files.newBufferedWriter(file.toPath(), Charset.defaultCharset(), new OpenOption[0]);
             PrintWriter p = new PrintWriter(bw);){
            for (GamePiece gp : this.map.getPieces()) {
                String s = gp.getName();
                if (s.length() <= 0) continue;
                p.println(this.map.locationName(gp.getPosition()) + ": " + s);
            }
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, file);
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "TextCapture");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.TextSaver.component_type");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ((TextSaver)c).launch.getAttributeValueString(TextSaver.ICON_NAME));
        }
    }
}

