/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.AbstractTiledOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.opcache.Op;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GridOp
extends AbstractTiledOpImpl {
    private static Logger logger = LoggerFactory.getLogger(GridOp.class);
    protected final ImageOp sop;
    protected final MapGrid grid;
    protected final double scale;
    protected final boolean reversed;
    protected final RenderingHints hints;
    protected final int hash;

    public GridOp(ImageOp sop, MapGrid grid, double scale, boolean reversed, RenderingHints hints) {
        this.sop = sop;
        this.grid = grid;
        this.scale = scale;
        this.reversed = reversed;
        this.hints = hints;
        this.size = sop.getSize();
        this.hash = Objects.hash(sop, grid, scale, reversed, hints);
    }

    public MapGrid getGrid() {
        return this.grid;
    }

    public double getScale() {
        return this.scale;
    }

    public boolean getReversed() {
        return this.reversed;
    }

    public RenderingHints getHints() {
        return this.hints;
    }

    @Override
    public List<Op<?>> getSources() {
        return Collections.singletonList(this.sop);
    }

    @Override
    public BufferedImage eval() throws Exception {
        Rectangle bounds = new Rectangle(0, 0, this.size.width, this.size.height);
        return GridOp.draw(0, 0, this.size.width, this.size.height, this.sop, this.grid, bounds, this.scale, this.reversed, this.hints);
    }

    private static BufferedImage draw(int x0, int y0, int w, int h, ImageOp sop, MapGrid grid, Rectangle bounds, double scale, boolean reversed, RenderingHints hints) throws ExecutionException, InterruptedException {
        BufferedImage dst;
        if (w < 1 || h < 1) {
            return ImageUtils.NULL_IMAGE;
        }
        Rectangle visible = new Rectangle(x0, y0, w, h);
        Point[] tiles = sop.getTileIndices(visible);
        int tw = sop.getTileWidth();
        int th = sop.getTileHeight();
        try {
            dst = ImageUtils.createCompatibleImage(w, h, sop.getTile(tiles[0], null).getTransparency() != 1);
        }
        catch (IndexOutOfBoundsException | NullPointerException e) {
            logger.warn("{}, {}, {}, {}, {}", new Object[]{visible, sop, tw, th, tiles});
            throw e;
        }
        Graphics2D g = (Graphics2D)dst.getGraphics();
        g.setRenderingHints(hints);
        for (Point tile : tiles) {
            g.drawImage((Image)sop.getTile(tile, null), tile.x * tw - x0, tile.y * th - y0, null);
        }
        g.translate(-x0, -y0);
        g.setClip(visible);
        grid.draw(g, bounds, visible, scale, reversed);
        g.dispose();
        return dst;
    }

    @Override
    protected void fixSize() {
    }

    @Override
    protected ImageOp createTileOp(int tileX, int tileY) {
        return new TileOp(this, tileX, tileY);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        GridOp op = (GridOp)o;
        return this.reversed == op.reversed && this.scale == op.scale && this.sop.equals(op.sop) && this.grid.equals(op.grid) && this.hints.equals(op.hints);
    }

    public int hashCode() {
        return this.hash;
    }

    public String toString() {
        return this.getClass().getName() + "[sop=" + this.sop + ",grid=" + this.grid + ",scale=" + this.scale + ",reversed=" + this.reversed + ",hints=" + this.hints + "]";
    }

    private static class TileOp
    extends AbstractTileOpImpl {
        private final ImageOp sop;
        private final Rectangle bounds;
        private final int dx0;
        private final int dy0;
        private final int dw;
        private final int dh;
        private final MapGrid grid;
        private final double scale;
        private final boolean reversed;
        private final RenderingHints hints;
        private final int hash;

        public TileOp(GridOp gop, int tileX, int tileY) {
            if (gop == null) {
                throw new IllegalArgumentException();
            }
            if (tileX < 0 || tileX >= gop.getNumXTiles() || tileY < 0 || tileY >= gop.getNumYTiles()) {
                throw new IndexOutOfBoundsException();
            }
            this.sop = (ImageOp)gop.getSources().get(0);
            this.scale = gop.getScale();
            this.grid = gop.getGrid();
            this.reversed = gop.getReversed();
            this.hints = gop.getHints();
            this.bounds = new Rectangle(0, 0, gop.getWidth(), gop.getHeight());
            int stw = gop.getTileWidth();
            int sth = gop.getTileHeight();
            this.dx0 = tileX * stw;
            this.dy0 = tileY * sth;
            this.dw = Math.min(stw, gop.getWidth() - this.dx0);
            this.dh = Math.min(sth, gop.getHeight() - this.dy0);
            this.size = new Dimension(this.dw, this.dh);
            this.hash = Objects.hash(this.sop, this.dx0, this.dy0, this.dw, this.dh);
        }

        @Override
        public List<Op<?>> getSources() {
            return Collections.singletonList(this.sop);
        }

        @Override
        public BufferedImage eval() throws Exception {
            return GridOp.draw(this.dx0, this.dy0, this.dw, this.dh, this.sop, this.grid, this.bounds, this.scale, this.reversed, this.hints);
        }

        @Override
        protected void fixSize() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            TileOp op = (TileOp)o;
            return this.dx0 == op.dx0 && this.dy0 == op.dy0 && this.dw == op.dw && this.dh == op.dh && this.sop.equals(op.sop);
        }

        public int hashCode() {
            return this.hash;
        }

        public String toString() {
            return this.getClass().getName() + "[sop=" + this.sop + ",dx0=" + this.dx0 + ",dy0=" + this.dy0 + ",dw=" + this.dw + ",dy=" + this.dh + ",scale=" + this.scale + ",reversed=" + this.reversed + ",hints=" + this.hints + "]";
        }
    }
}

