/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map.boardPicker.board;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.Region;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridContainer;
import VASSAL.build.module.map.boardPicker.board.mapgrid.GridNumbering;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.Configurer;
import VASSAL.configure.EditPropertiesAction;
import VASSAL.configure.PropertiesWindow;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.swing.SwingUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.SystemUtils;

public class RegionGrid
extends AbstractConfigurable
implements MapGrid,
ConfigureTree.Mutable {
    private static final long serialVersionUID = 1L;
    protected Map<Point, Region> regionList = new HashMap<Point, Region>();
    protected GridContainer container;
    protected boolean visible = false;
    protected static boolean inConfig = false;
    protected int fontSize = 9;
    protected boolean snapTo = true;
    protected Config regionConfigurer;
    protected GridNumbering gridNumbering;
    public static final String SNAPTO = "snapto";
    public static final String VISIBLE = "visible";
    public static final String FONT_SIZE = "fontsize";

    public void addRegion(Region a) {
        this.regionList.put(a.getOrigin(), a);
        if (inConfig && this.regionConfigurer != null) {
            this.regionConfigurer.view.repaint();
        }
    }

    public void removeRegion(Region a) {
        this.regionList.remove(a.getOrigin());
    }

    public void removeAllRegions() {
        this.regionList.clear();
        this.buildComponents.clear();
    }

    @Override
    public GridNumbering getGridNumbering() {
        return this.gridNumbering;
    }

    public void setGridNumbering(GridNumbering gridNumbering) {
        this.gridNumbering = gridNumbering;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{SNAPTO, VISIBLE, FONT_SIZE};
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.Grid.snap"), Resources.getString("Editor.IrregularGrid.draw"), Resources.getString("Editor.font_size")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{Boolean.class, Boolean.class, Integer.class};
    }

    @Override
    public Configurer getConfigurer() {
        boolean buttonExists = this.config != null;
        Configurer c = super.getConfigurer();
        if (!buttonExists) {
            JButton b = new JButton(Resources.getString("Editor.IrregularGrid.define_regions"));
            b.addActionListener(e -> this.configureRegions());
            ((Container)c.getControls()).add(b);
        }
        return c;
    }

    @Override
    public void addTo(Buildable b) {
        this.container = (GridContainer)((Object)b);
        this.container.setGrid(this);
    }

    @Override
    public void removeFrom(Buildable b) {
        this.container.removeGrid(this);
        this.container = null;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.IrregularGrid.component_type");
    }

    @Override
    public String getConfigureName() {
        return null;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("IrregularGrid.html");
    }

    @Override
    public String getAttributeValueString(String key) {
        if (VISIBLE.equals(key)) {
            return String.valueOf(this.visible);
        }
        if (FONT_SIZE.equals(key)) {
            return String.valueOf(this.fontSize);
        }
        if (SNAPTO.equals(key)) {
            return String.valueOf(this.snapTo);
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (FONT_SIZE.equals(name)) {
            return () -> this.visible;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void setAttribute(String key, Object val) {
        if (val == null) {
            return;
        }
        if (VISIBLE.equals(key)) {
            if (val instanceof Boolean) {
                this.visible = (Boolean)val;
            } else if (val instanceof String) {
                this.visible = "true".equals(val);
            }
        } else if (FONT_SIZE.equals(key)) {
            if (val instanceof String) {
                val = Integer.valueOf((String)val);
            }
            this.fontSize = (Integer)val;
        } else if (SNAPTO.equals(key)) {
            if (val instanceof Boolean) {
                this.snapTo = (Boolean)val;
            } else if (val instanceof String) {
                this.snapTo = "true".equals(val);
            }
        }
    }

    public void configureRegions() {
        for (Region r : this.regionList.values()) {
            r.setSelected(false);
        }
        this.regionConfigurer = new Config(this);
        this.regionConfigurer.setVisible(true);
        inConfig = true;
    }

    @Override
    public boolean isVisible() {
        return this.visible || inConfig;
    }

    public void setVisible(boolean b) {
        this.visible = b;
    }

    public Board getBoard() {
        return this.container.getBoard();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{Region.class};
    }

    @Override
    public Point getLocation(String name) throws MapGrid.BadCoords {
        Region reg = this.findRegion(name);
        if (reg == null) {
            throw new MapGrid.BadCoords();
        }
        return new Point(reg.getOrigin());
    }

    @Override
    public int range(Point p1, Point p2) {
        return (int)Math.round(p1.distance(p2));
    }

    @Override
    public Point snapTo(Point p) {
        if (!this.snapTo || this.regionList.isEmpty()) {
            return p;
        }
        return this.doSnap(p);
    }

    @Override
    public boolean isLocationRestricted(Point p) {
        return this.snapTo;
    }

    protected Point doSnap(Point p) {
        double minDistSq = Double.MAX_VALUE;
        Point snapPoint = p;
        for (Point checkPoint : this.regionList.keySet()) {
            double distSq = (p.x - checkPoint.x) * (p.x - checkPoint.x) + (p.y - checkPoint.y) * (p.y - checkPoint.y);
            if (!(distSq < minDistSq)) continue;
            minDistSq = distSq;
            snapPoint = checkPoint;
        }
        return new Point(snapPoint);
    }

    @Override
    public String locationName(Point p) {
        if (this.regionList.isEmpty()) {
            return null;
        }
        Region region = this.regionList.get(this.doSnap(p));
        return region != null ? region.getName() : null;
    }

    @Override
    public String localizedLocationName(Point p) {
        if (this.regionList.isEmpty()) {
            return null;
        }
        Region region = this.regionList.get(this.doSnap(p));
        return region != null ? region.getLocalizedName() : null;
    }

    public Region getRegion(Point p) {
        for (Region checkRegion : this.regionList.values()) {
            if (!checkRegion.contains(p)) continue;
            return checkRegion;
        }
        return null;
    }

    public Region findRegion(String name) {
        for (Region checkRegion : this.regionList.values()) {
            if (!checkRegion.getConfigureName().equals(name)) continue;
            return checkRegion;
        }
        return null;
    }

    @Override
    public void draw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        if (this.visible) {
            this.forceDraw(g, bounds, visibleRect, scale, reversed);
        }
    }

    public void forceDraw(Graphics g, Rectangle bounds, Rectangle visibleRect, double scale, boolean reversed) {
        for (Region r : this.regionList.values()) {
            r.draw(g, bounds, visibleRect, scale, reversed);
        }
    }

    public void unSelectAll() {
        this.regionList.values().forEach(this::unSelect);
    }

    public void unSelect(Region r) {
        r.setSelected(false);
    }

    public static class Config
    extends JFrame
    implements MouseListener,
    MouseMotionListener,
    ActionListener,
    KeyListener {
        private static final long serialVersionUID = 1L;
        protected RegionGrid grid;
        protected Board board;
        protected JPanel view;
        protected JScrollPane scroll;
        protected JPopupMenu myPopup;
        protected List<Region> selectedRegions = new ArrayList<Region>();
        protected Region lastClickedRegion = null;
        protected Point lastClick;
        protected Rectangle selectionRect = null;
        protected Point anchor;
        protected List<Region> saveRegions;
        protected boolean dirty = false;
        protected static final String ADD_REGION = Resources.getString("Editor.IrregularGrid.add_region");
        protected static final String DELETE_REGION = Resources.getString("Editor.IrregularGrid.delete_region");
        protected static final String PROPERTIES = Resources.getString("Editor.properties");

        public Config(RegionGrid grid) {
            super(Resources.getString("Editor.IrregularGrid.regions_for", grid.container.getBoard().getName()));
            this.board = grid.container.getBoard();
            this.grid = grid;
            this.initComponents();
            this.save();
        }

        protected void initComponents() {
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    this.doCancel();
                }
            });
            this.view = new View(this.board, this.grid, this);
            this.view.addMouseListener(this);
            this.view.addMouseMotionListener(this);
            this.view.addKeyListener(this);
            this.view.setFocusable(true);
            this.scroll = new AdjustableSpeedScrollPane(this.view, 22, 32);
            this.scroll.setPreferredSize(new Dimension(800, 600));
            this.add((Component)this.scroll, "Center");
            Box bottomPanel = Box.createVerticalBox();
            JPanel buttonPanel = new JPanel();
            JButton okButton = new JButton(Resources.getString("General.ok"));
            okButton.addActionListener(e -> this.close());
            buttonPanel.add(okButton);
            JButton canButton = new JButton(Resources.getString("General.cancel"));
            canButton.addActionListener(e -> this.doCancel());
            buttonPanel.add(canButton);
            JLabel mess = new JLabel(SystemUtils.IS_OS_MAC ? Resources.getString("Editor.IrregularGrid.drag_and_drop_mac") : Resources.getString("Editor.IrregularGrid.drag_and_drop"));
            mess.setAlignmentY(0.5f);
            bottomPanel.add(mess);
            bottomPanel.add(buttonPanel);
            this.add((Component)bottomPanel, "South");
            this.scroll.revalidate();
            this.pack();
            this.repaint();
        }

        protected void setDirty(boolean b) {
            this.dirty = b;
        }

        protected void doCancel() {
            if (this.dirty) {
                if (0 == JOptionPane.showConfirmDialog(this, Resources.getString("Editor.IrregularGrid.changes_made"), "", 0)) {
                    this.restore();
                    this.close();
                }
            } else {
                this.close();
            }
        }

        protected void close() {
            inConfig = false;
            this.setVisible(false);
        }

        public void init() {
            for (Region r : this.selectedRegions) {
                r.setSelected(false);
            }
        }

        public void save() {
            this.saveRegions = new ArrayList<Region>(this.grid.regionList.size());
            for (Region r : this.grid.regionList.values()) {
                this.saveRegions.add(new Region(r));
            }
        }

        public void restore() {
            this.grid.removeAllRegions();
            for (Region r : this.saveRegions) {
                r.addTo(this.grid);
                this.grid.add(r);
            }
        }

        protected void doScroll(int dx, int dy) {
            Rectangle r = new Rectangle(this.scroll.getViewport().getViewRect());
            r.translate(dx, dy);
            r = r.intersection(new Rectangle(new Point(0, 0), this.view.getPreferredSize()));
            this.view.scrollRectToVisible(r);
        }

        protected void scrollAtEdge(Point evtPt, int dist) {
            Point p = new Point(evtPt.x - this.scroll.getViewport().getViewPosition().x, evtPt.y - this.scroll.getViewport().getViewPosition().y);
            int dx = 0;
            int dy = 0;
            Dimension viewSize = this.scroll.getViewport().getSize();
            if (p.x < dist && p.x >= 0) {
                dx = -1;
            }
            if (p.x >= viewSize.width - dist && p.x < viewSize.width) {
                dx = 1;
            }
            if (p.y < dist && p.y >= 0) {
                dy = -1;
            }
            if (p.y >= viewSize.height - dist && p.y < viewSize.height) {
                dy = 1;
            }
            if (dx != 0 || dy != 0) {
                this.doScroll(2 * dist * dx, 2 * dist * dy);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.lastClick = e.getPoint();
            if (SwingUtils.isMainMouseButtonDown(e)) {
                if (this.lastClickedRegion != null && e.getClickCount() >= 2 && this.lastClickedRegion.getConfigurer() != null) {
                    EditPropertiesAction a = new EditPropertiesAction(this.lastClickedRegion, null, this);
                    a.actionPerformed(new ActionEvent(e.getSource(), 1001, "Edit"));
                }
                this.view.repaint();
            }
        }

        protected void doPopupMenu(MouseEvent e) {
            this.myPopup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(ADD_REGION);
            menuItem.addActionListener(this);
            menuItem.setEnabled(this.lastClickedRegion == null);
            this.myPopup.add(menuItem);
            menuItem = new JMenuItem(DELETE_REGION);
            menuItem.addActionListener(this);
            menuItem.setEnabled(this.lastClickedRegion != null);
            this.myPopup.add(menuItem);
            this.myPopup.addSeparator();
            menuItem = new JMenuItem(PROPERTIES);
            menuItem.addActionListener(this);
            menuItem.setEnabled(this.lastClickedRegion != null);
            this.myPopup.add(menuItem);
            Point p = e.getPoint();
            this.myPopup.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuCanceled(PopupMenuEvent evt) {
                    view.repaint();
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                    view.repaint();
                }

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                }
            });
            this.myPopup.show(e.getComponent(), p.x, p.y);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String command = e.getActionCommand();
            if (command.equals("close")) {
                this.setVisible(false);
            } else if (command.equals("showhide")) {
                this.grid.setVisible(!this.grid.isVisible());
                this.view.repaint();
            } else if (command.equals(ADD_REGION)) {
                Region r = new Region(this.lastClick);
                r.addTo(this.grid);
                this.grid.add(r);
                this.select(r);
                this.lastClickedRegion = r;
                this.setDirty(true);
                EditPropertiesAction a = new EditPropertiesAction(this.lastClickedRegion, null, this);
                a.actionPerformed(new ActionEvent(e.getSource(), 1001, "Edit"));
                this.view.repaint();
            } else if (command.equals(DELETE_REGION)) {
                for (Region r : this.selectedRegions) {
                    r.removeFrom(this.grid);
                    this.grid.remove(r);
                    this.lastClickedRegion = null;
                    this.setDirty(true);
                }
                this.selectedRegions.clear();
                this.view.repaint();
            } else if (command.equals(PROPERTIES) && this.lastClickedRegion != null) {
                EditRegionAction a = new EditRegionAction(this.lastClickedRegion, null, this);
                a.actionPerformed(new ActionEvent(e.getSource(), 1001, "Edit"));
            }
        }

        protected void select(Region r) {
            r.setSelected(true);
            if (!this.selectedRegions.contains(r)) {
                this.selectedRegions.add(r);
            }
            this.view.repaint(r.getSelectionRect());
        }

        protected void unselect(Region r) {
            if (r != null) {
                r.setSelected(false);
                this.selectedRegions.remove(r);
                if (this.lastClickedRegion == r) {
                    this.lastClickedRegion = null;
                }
                this.view.repaint(r.getSelectionRect());
            }
        }

        protected void unSelectAll() {
            for (Region r : this.selectedRegions) {
                r.setSelected(false);
                this.view.repaint(r.getSelectionRect());
            }
            this.selectedRegions.clear();
        }

        public Rectangle getSelectionRect() {
            return this.selectionRect;
        }

        public Rectangle getSelectedBox() {
            Rectangle rect = null;
            for (Region r : this.selectedRegions) {
                Rectangle sel = r.getSelectionRect();
                if (rect == null) {
                    rect = sel;
                    continue;
                }
                rect.add(sel);
            }
            return rect;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Point p;
            this.lastClick = p = e.getPoint();
            this.lastClickedRegion = this.grid.getRegion(p);
            if (e.isPopupTrigger()) {
                this.doPopupMenu(e);
            } else if (SwingUtils.isMainMouseButtonDown(e)) {
                if (!(e.isShiftDown() || SwingUtils.isSelectionToggle(e) || this.lastClickedRegion != null && this.lastClickedRegion.isSelected())) {
                    this.unSelectAll();
                }
                if (this.lastClickedRegion == null) {
                    this.anchor = p;
                    this.selectionRect = new Rectangle(this.anchor.x, this.anchor.y, 0, 0);
                } else if (SwingUtils.isSelectionToggle(e)) {
                    this.unselect(this.lastClickedRegion);
                } else {
                    this.select(this.lastClickedRegion);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopupMenu(e);
            } else if (this.selectionRect != null && SwingUtils.isMainMouseButtonDown(e)) {
                for (Region r : this.grid.regionList.values()) {
                    if (!this.selectionRect.contains(r.getOrigin())) continue;
                    if (SwingUtils.isSelectionToggle(e)) {
                        this.unselect(r);
                        continue;
                    }
                    this.select(r);
                }
                this.selectionRect = null;
                this.view.repaint();
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (SwingUtils.isMainMouseButtonDown(e)) {
                this.scrollAtEdge(e.getPoint(), 15);
            }
            if (this.selectionRect != null) {
                Rectangle repaintRect = new Rectangle(this.selectionRect.x - 1, this.selectionRect.y - 1, this.selectionRect.width + 3, this.selectionRect.height + 3);
                this.selectionRect.x = Math.min(e.getX(), this.anchor.x);
                this.selectionRect.y = Math.min(e.getY(), this.anchor.y);
                this.selectionRect.width = Math.abs(e.getX() - this.anchor.x);
                this.selectionRect.height = Math.abs(e.getY() - this.anchor.y);
                repaintRect.add(new Rectangle(this.selectionRect.x - 1, this.selectionRect.y - 1, this.selectionRect.width + 3, this.selectionRect.height + 3));
                this.view.repaint(repaintRect);
            }
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (this.selectedRegions.isEmpty() || !SwingUtils.isModifierKeyDown(e)) {
                return;
            }
            int dx = 0;
            int dy = 0;
            int delta = 1;
            if (e.isShiftDown()) {
                delta = 5;
            }
            switch (e.getKeyCode()) {
                case 38: {
                    dy = -delta;
                    break;
                }
                case 40: {
                    dy = delta;
                    break;
                }
                case 37: {
                    dx = -delta;
                    break;
                }
                case 39: {
                    dx = delta;
                    break;
                }
                default: {
                    return;
                }
            }
            for (Region r : this.selectedRegions) {
                r.move(dx, dy, this.view);
            }
            this.view.repaint();
            e.consume();
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        public static class View
        extends JPanel
        implements DropTargetListener,
        DragGestureListener,
        DragSourceListener,
        DragSourceMotionListener {
            private static final long serialVersionUID = 1L;
            protected Board myBoard;
            protected RegionGrid grid;
            protected Config config;
            protected DragSource ds = DragSource.getDefaultDragSource();
            @Deprecated
            protected boolean isDragging = false;
            protected JLabel dragCursor;
            protected JLayeredPane drawWin;
            protected Point dragStart;
            protected Point lastDragLocation = new Point();
            protected Point drawOffset = new Point();
            protected Rectangle boundingBox;
            protected int currentPieceOffsetX;
            protected int currentPieceOffsetY;
            protected int originalPieceOffsetX;
            protected int originalPieceOffsetY;

            public View(Board b, RegionGrid grid, Config config) {
                this.myBoard = b;
                this.grid = grid;
                this.config = config;
                new DropTarget(this, 2, this);
                this.ds.createDefaultDragGestureRecognizer(this, 2, this);
                this.setFocusTraversalKeysEnabled(false);
            }

            @Override
            public void paint(Graphics g) {
                Rectangle b = this.getVisibleRect();
                g.clearRect(b.x, b.y, b.width, b.height);
                this.myBoard.draw(g, 0, 0, 1.0, this);
                Rectangle bounds = new Rectangle(new Point(), this.myBoard.bounds().getSize());
                this.grid.forceDraw(g, bounds, bounds, 1.0, false);
                Rectangle selection = this.config.getSelectionRect();
                if (selection != null) {
                    Graphics2D g2d = (Graphics2D)g;
                    Stroke str = g2d.getStroke();
                    g2d.setStroke(new BasicStroke(2.0f));
                    g2d.setColor(Color.RED);
                    g2d.drawRect(selection.x, selection.y, selection.width, selection.height);
                    g2d.setStroke(str);
                }
            }

            @Override
            public void update(Graphics g) {
                this.paint(g);
            }

            @Override
            public Dimension getPreferredSize() {
                return new Dimension(this.myBoard.bounds().width, this.myBoard.bounds().height);
            }

            @Override
            public void dragEnter(DropTargetDragEvent arg0) {
            }

            @Override
            public void dragExit(DropTargetEvent arg0) {
            }

            @Override
            public void dragOver(DropTargetDragEvent arg0) {
            }

            @Override
            public void drop(DropTargetDropEvent event) {
                this.removeDragCursor();
                Point dragEnd = event.getLocation();
                int x = dragEnd.x - this.dragStart.x;
                int y = dragEnd.y - this.dragStart.y;
                for (Region r : this.config.selectedRegions) {
                    r.move(x, y, this);
                    this.config.setDirty(true);
                }
                this.repaint();
            }

            @Override
            public void dropActionChanged(DropTargetDragEvent arg0) {
            }

            @Override
            public void dragGestureRecognized(DragGestureEvent dge) {
                if (!SwingUtils.isDragTrigger(dge)) {
                    return;
                }
                Point mousePosition = dge.getDragOrigin();
                this.dragStart = new Point(mousePosition);
                Region r = this.grid.getRegion(mousePosition);
                if (r == null) {
                    return;
                }
                Point piecePosition = new Point(r.getOrigin());
                this.originalPieceOffsetX = piecePosition.x - mousePosition.x;
                this.originalPieceOffsetY = piecePosition.y - mousePosition.y;
                this.drawWin = null;
                this.makeDragCursor();
                this.setDragCursor();
                SwingUtilities.convertPointToScreen(this.drawOffset, this.drawWin);
                SwingUtilities.convertPointToScreen(mousePosition, this.drawWin);
                this.moveDragCursor(mousePosition.x, mousePosition.y);
                try {
                    dge.startDrag(Cursor.getPredefinedCursor(12), new StringSelection(""), this);
                    dge.getDragSource().addDragSourceMotionListener(this);
                }
                catch (InvalidDnDOperationException e) {
                    ErrorDialog.bug(e);
                }
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent arg0) {
                this.removeDragCursor();
            }

            @Override
            public void dragEnter(DragSourceDragEvent arg0) {
            }

            @Override
            public void dragExit(DragSourceEvent arg0) {
            }

            @Override
            public void dragOver(DragSourceDragEvent arg0) {
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent arg0) {
            }

            @Override
            public void dragMouseMoved(DragSourceDragEvent event) {
                if (!event.getLocation().equals(this.lastDragLocation)) {
                    this.lastDragLocation = event.getLocation();
                    this.moveDragCursor(event.getX(), event.getY());
                    if (this.dragCursor != null && !this.dragCursor.isVisible()) {
                        this.dragCursor.setVisible(true);
                    }
                }
            }

            private void removeDragCursor() {
                if (this.drawWin != null) {
                    if (this.dragCursor != null) {
                        this.dragCursor.setVisible(false);
                        this.drawWin.remove(this.dragCursor);
                    }
                    this.drawWin = null;
                }
            }

            protected void moveDragCursor(int dragX, int dragY) {
                if (this.drawWin != null) {
                    this.dragCursor.setLocation(dragX - this.drawOffset.x, dragY - this.drawOffset.y);
                }
            }

            protected void setDragCursor() {
                JRootPane rootWin = SwingUtilities.getRootPane(this);
                if (rootWin != null) {
                    if (this.dragCursor.getParent() != null) {
                        this.dragCursor.getParent().remove(this.dragCursor);
                    }
                    this.drawWin = rootWin.getLayeredPane();
                    this.dragCursor.setVisible(true);
                    this.drawWin.add((Component)this.dragCursor, JLayeredPane.DRAG_LAYER);
                }
            }

            private void makeDragCursor() {
                if (this.dragCursor == null) {
                    this.dragCursor = new JLabel();
                    this.dragCursor.setVisible(false);
                }
                this.currentPieceOffsetX = this.originalPieceOffsetX;
                this.currentPieceOffsetY = this.originalPieceOffsetY;
                this.boundingBox = this.config.getSelectedBox();
                this.drawOffset.move(this.dragStart.x - this.boundingBox.x, this.dragStart.y - this.boundingBox.y);
                BufferedImage cursorImage = ImageUtils.createCompatibleTranslucentImage(this.boundingBox.width, this.boundingBox.height);
                Graphics2D g = cursorImage.createGraphics();
                g.setComposite(AlphaComposite.getInstance(3, 0.5f));
                for (Region r : this.config.selectedRegions) {
                    int x = -this.boundingBox.x * 2;
                    int y = -this.boundingBox.y * 2;
                    r.draw(g, this.boundingBox, this.getVisibleRect(), 1.0, false, x, y);
                }
                g.dispose();
                this.dragCursor.setSize(this.boundingBox.width, this.boundingBox.height);
                this.dragCursor.setIcon(new ImageIcon(cursorImage));
            }
        }

        protected static class EditRegionAction
        extends EditPropertiesAction {
            Config owner;
            Region origRegion;
            Region region;
            private static final long serialVersionUID = 1L;

            public EditRegionAction(Region target, HelpWindow helpWindow, Config dialogOwner) {
                super(target, helpWindow, dialogOwner);
                this.owner = dialogOwner;
                this.origRegion = new Region(target);
                this.region = target;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                PropertiesWindow w = (PropertiesWindow)openWindows.get(this.target);
                if (w == null) {
                    w = new PropertiesWindow(this.dialogOwner, false, this.target, this.helpWindow);
                    w.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosed(WindowEvent e) {
                            openWindows.remove(target);
                            owner.setDirty(!region.getName().equals(origRegion.getName()) || !region.getOrigin().equals(origRegion.getOrigin()));
                            owner.repaint();
                        }
                    });
                    openWindows.put(this.target, w);
                    w.setVisible(true);
                }
                w.toFront();
            }
        }
    }
}

