/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat;

import VASSAL.build.module.GlobalOptions;
import VASSAL.chat.Player;
import VASSAL.chat.PlayerEncoder;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.SoundConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.SequenceEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;

public class SoundEncoder
implements CommandEncoder {
    public static final String COMMAND_PREFIX = "PLAY\t";
    private final PlayerEncoder playerEncoder;

    public SoundEncoder(PlayerEncoder p) {
        this.playerEncoder = p;
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(command, '\t');
        sd.nextToken();
        String soundKey = sd.nextToken();
        Player sender = this.playerEncoder.stringToPlayer(sd.nextToken(""));
        return new Cmd(soundKey, sender);
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof Cmd)) {
            return null;
        }
        Cmd cmd = (Cmd)c;
        SequenceEncoder se = new SequenceEncoder('\t');
        se.append(cmd.soundKey);
        se.append(this.playerEncoder.playerToString(cmd.getSender()));
        return COMMAND_PREFIX + se.getValue();
    }

    public static class Cmd
    extends Command {
        private static final int TOO_MANY = 4;
        public static final int TOO_SOON = 10000;
        private static long lastTime = System.currentTimeMillis();
        private static Player lastSender;
        private static int sendCount;
        private static final List<Player> banned;
        private static boolean updating;
        private final String soundKey;
        private final Player sender;

        public Cmd(String soundKey, Player player) {
            this.soundKey = soundKey;
            this.sender = player;
        }

        @Override
        protected void executeCommand() {
            long now = System.currentTimeMillis();
            if (banned.contains(this.sender) || updating || now - lastTime < 10000L) {
                updating = false;
                return;
            }
            updating = true;
            lastTime = now;
            SoundConfigurer c = (SoundConfigurer)Prefs.getGlobalPrefs().getOption(this.soundKey);
            if (!GlobalOptions.getInstance().isSoundWakeupMute().booleanValue()) {
                if (c != null) {
                    c.play();
                }
                if (this.sender.equals(lastSender)) {
                    if (sendCount++ >= 4) {
                        if (0 == JOptionPane.showConfirmDialog(null, Resources.getString("Chat.ignore_wakeups", this.sender.getName()), null, 0)) {
                            banned.add(this.sender);
                        } else {
                            sendCount = 1;
                        }
                    }
                } else {
                    lastSender = this.sender;
                    sendCount = 1;
                }
            }
            updating = false;
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }

        public Player getSender() {
            return this.sender;
        }

        static {
            banned = new ArrayList<Player>();
            updating = false;
        }
    }
}

