/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.GlobalCommandTarget;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class GlobalCommandTargetConfigurer
extends Configurer {
    private JPanel controls;
    private BooleanConfigurer fastMatchLocationConfig;
    private BooleanConfigurer fastMatchPropertyConfig;
    private TranslatingStringEnumConfigurer targetTypeConfig;
    private JLabel targetTypeLabel;
    private FormattedExpressionConfigurer targetMapConfig;
    private JLabel targetMapLabel;
    private FormattedExpressionConfigurer targetBoardConfig;
    private JLabel targetBoardLabel;
    private FormattedExpressionConfigurer targetZoneConfig;
    private JLabel targetZoneLabel;
    private FormattedExpressionConfigurer targetLocationConfig;
    private JLabel targetLocationLabel;
    private FormattedExpressionConfigurer targetXConfig;
    private JLabel targetXLabel;
    private FormattedExpressionConfigurer targetYConfig;
    private JLabel targetYLabel;
    private FormattedExpressionConfigurer targetDeckConfig;
    private JLabel targetDeckLabel;
    private FormattedExpressionConfigurer targetPropertyConfig;
    private JLabel targetPropertyLabel;
    private CompareConfigurer targetCompareConfig;
    private JLabel targetCompareLabel;
    private FormattedExpressionConfigurer targetValueConfig;
    private JLabel targetValueLabel;

    public GlobalCommandTargetConfigurer(String key, String name, GlobalCommandTarget target) {
        super(key, name, target);
    }

    public GlobalCommandTargetConfigurer(String key, String name) {
        this(key, name, null);
    }

    public GlobalCommandTargetConfigurer(GlobalCommandTarget target) {
        this(null, null, target);
    }

    public GlobalCommandTarget getTarget() {
        return (GlobalCommandTarget)this.getValue();
    }

    @Override
    public String getValueString() {
        return this.getTarget().encode();
    }

    @Override
    public void setValue(String s) {
        this.setValue(new GlobalCommandTarget(s));
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel((LayoutManager)new MigLayout("hidemode 3,gapy 4", "[]rel[]rel[fill,grow]"));
            GlobalCommandTarget target = this.getTarget();
            this.fastMatchLocationConfig = new BooleanConfigurer(target.isFastMatchLocation());
            this.fastMatchLocationConfig.addPropertyChangeListener(evt -> this.targetChanged());
            this.controls.add(this.fastMatchLocationConfig.getControls());
            this.controls.add((Component)new JLabel(Resources.getString("Editor.GlobalKeyCommand.by_location")), "wrap");
            ArrayList<String> options = new ArrayList<String>();
            ArrayList<String> i18nKeys = new ArrayList<String>();
            if (this.getTarget().getGKCtype() == GlobalCommandTarget.GKCtype.COUNTER) {
                options.add(GlobalCommandTarget.Target.CURSTACK.toString());
                options.add(GlobalCommandTarget.Target.CURMAP.toString());
                options.add(GlobalCommandTarget.Target.CURZONE.toString());
                options.add(GlobalCommandTarget.Target.CURLOC.toString());
                i18nKeys.add(GlobalCommandTarget.Target.CURSTACK.toTranslatedString());
                i18nKeys.add(GlobalCommandTarget.Target.CURMAP.toTranslatedString());
                i18nKeys.add(GlobalCommandTarget.Target.CURZONE.toTranslatedString());
                i18nKeys.add(GlobalCommandTarget.Target.CURLOC.toTranslatedString());
            }
            options.add(GlobalCommandTarget.Target.MAP.toString());
            options.add(GlobalCommandTarget.Target.ZONE.toString());
            options.add(GlobalCommandTarget.Target.LOCATION.toString());
            options.add(GlobalCommandTarget.Target.XY.toString());
            options.add(GlobalCommandTarget.Target.DECK.toString());
            i18nKeys.add(GlobalCommandTarget.Target.MAP.toTranslatedString());
            i18nKeys.add(GlobalCommandTarget.Target.ZONE.toTranslatedString());
            i18nKeys.add(GlobalCommandTarget.Target.LOCATION.toTranslatedString());
            i18nKeys.add(GlobalCommandTarget.Target.XY.toTranslatedString());
            i18nKeys.add(GlobalCommandTarget.Target.DECK.toTranslatedString());
            this.targetTypeConfig = new TranslatingStringEnumConfigurer(options, i18nKeys, target.getTargetType().toString());
            this.targetTypeConfig.addPropertyChangeListener(evt -> this.targetChanged());
            this.targetTypeLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.select_by"));
            this.controls.add((Component)this.targetTypeLabel, "span 2");
            this.controls.add(this.targetTypeConfig.getControls(), "growx, wrap");
            this.targetMapConfig = new FormattedExpressionConfigurer(target.getTargetMap().getExpression());
            this.targetMapConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetMap(this.targetMapConfig.getValueString()));
            this.targetMapLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.map_name"));
            this.controls.add((Component)this.targetMapLabel, "span 2");
            this.controls.add(this.targetMapConfig.getControls(), "growx, wrap");
            this.targetBoardConfig = new FormattedExpressionConfigurer(target.getTargetBoard().getExpression());
            this.targetBoardConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetBoard(this.targetBoardConfig.getValueString()));
            this.targetBoardLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.board_name"));
            this.controls.add((Component)this.targetBoardLabel, "span 2");
            this.controls.add(this.targetBoardConfig.getControls(), "growx, wrap");
            this.targetZoneConfig = new FormattedExpressionConfigurer(target.getTargetZone().getExpression());
            this.targetZoneConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetZone(this.targetZoneConfig.getValueString()));
            this.targetZoneLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.zone_name"));
            this.controls.add((Component)this.targetZoneLabel, "span 2");
            this.controls.add(this.targetZoneConfig.getControls(), "growx, wrap");
            this.targetLocationConfig = new FormattedExpressionConfigurer(target.getTargetLocation().getExpression());
            this.targetLocationConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetLocation(this.targetLocationConfig.getValueString()));
            this.targetLocationLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.location_name"));
            this.controls.add((Component)this.targetLocationLabel, "span 2");
            this.controls.add(this.targetLocationConfig.getControls(), "growx, wrap");
            this.targetXConfig = new FormattedExpressionConfigurer(target.getTargetX().getExpression());
            this.targetXConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetX(this.targetXConfig.getValueString()));
            this.targetXLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.x_position"));
            this.controls.add((Component)this.targetXLabel, "span 2");
            this.controls.add(this.targetXConfig.getControls(), "growx, wrap");
            this.targetYConfig = new FormattedExpressionConfigurer(target.getTargetY().getExpression());
            this.targetYConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetY(this.targetYConfig.getValueString()));
            this.targetYLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.y_position"));
            this.controls.add((Component)this.targetYLabel, "span 2");
            this.controls.add(this.targetYConfig.getControls(), "growY, wrap");
            this.targetDeckConfig = new FormattedExpressionConfigurer(target.getTargetDeck().getExpression());
            this.targetDeckConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetDeck(this.targetDeckConfig.getValueString()));
            this.targetDeckLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.deck_name"));
            this.controls.add((Component)this.targetDeckLabel, "span 2");
            this.controls.add(this.targetDeckConfig.getControls(), "growx, wrap");
            this.fastMatchPropertyConfig = new BooleanConfigurer(target.isFastMatchProperty());
            this.fastMatchPropertyConfig.addPropertyChangeListener(evt -> this.fastMatchPropertyChanged());
            this.controls.add(this.fastMatchPropertyConfig.getControls());
            this.controls.add((Component)new JLabel(Resources.getString("Editor.GlobalKeyCommand.by_property")), "wrap");
            this.targetPropertyConfig = new FormattedExpressionConfigurer(target.getTargetProperty().getExpression());
            this.targetPropertyConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetProperty(this.targetPropertyConfig.getValueString()));
            this.targetPropertyLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.property_name"));
            this.controls.add((Component)this.targetPropertyLabel, "span 2");
            this.controls.add(this.targetPropertyConfig.getControls(), "wrap");
            this.targetCompareConfig = new CompareConfigurer();
            this.targetCompareConfig.setValue(this.getTarget().getTargetCompare().getSymbol());
            this.targetCompareConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetCompare(GlobalCommandTarget.CompareMode.whichSymbol(this.targetCompareConfig.getValueString())));
            this.targetCompareLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.property_compare"));
            this.controls.add((Component)this.targetCompareLabel, "span 2");
            this.controls.add(this.targetCompareConfig.getControls(), "wrap");
            this.targetValueConfig = new FormattedExpressionConfigurer(target.getTargetValue().getExpression());
            this.targetValueConfig.addPropertyChangeListener(evt -> this.getTarget().setTargetValue(this.targetValueConfig.getValueString()));
            this.targetValueLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.property_value"));
            this.controls.add((Component)this.targetValueLabel, "span 2");
            this.controls.add(this.targetValueConfig.getControls(), "wrap");
            this.targetChanged();
            this.fastMatchPropertyChanged();
            this.controls.setBorder(BorderFactory.createEtchedBorder());
            if (this.getName() != null && !this.getName().isEmpty()) {
                JPanel controls2 = this.controls;
                this.controls = new JPanel((LayoutManager)new MigLayout("ins 0", "[]rel[fill,grow]"));
                this.controls.add(new JLabel(this.getName()));
                this.controls.add((Component)controls2, "growx");
            }
        }
        return this.controls;
    }

    private void targetChanged() {
        GlobalCommandTarget target = this.getTarget();
        boolean fastMatchLocation = this.fastMatchLocationConfig.getValueBoolean();
        target.setFastMatchLocation(fastMatchLocation);
        target.setTargetType(this.targetTypeConfig.getValueString());
        GlobalCommandTarget.Target targetType = target.getTargetType();
        this.targetTypeConfig.getControls().setVisible(fastMatchLocation);
        this.targetTypeLabel.setVisible(fastMatchLocation);
        boolean mapVisible = fastMatchLocation && (targetType.equals((Object)GlobalCommandTarget.Target.MAP) || targetType.equals((Object)GlobalCommandTarget.Target.ZONE) || targetType.equals((Object)GlobalCommandTarget.Target.LOCATION) || targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetMapConfig.getControls().setVisible(fastMatchLocation && mapVisible);
        this.targetMapLabel.setVisible(fastMatchLocation && mapVisible);
        this.targetBoardConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetBoardLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetZoneConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.ZONE));
        this.targetZoneLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.ZONE));
        this.targetLocationConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.LOCATION));
        this.targetLocationLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.LOCATION));
        this.targetXConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetXLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetYConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetYLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetDeckLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.DECK));
        this.targetDeckConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.DECK));
        this.repack();
    }

    private void fastMatchPropertyChanged() {
        GlobalCommandTarget target = this.getTarget();
        target.setFastMatchProperty(this.fastMatchPropertyConfig.getValueBoolean());
        this.targetPropertyConfig.getControls().setVisible(target.isFastMatchProperty());
        this.targetPropertyLabel.setVisible(target.isFastMatchProperty());
        this.targetValueConfig.getControls().setVisible(target.isFastMatchProperty());
        this.targetValueLabel.setVisible(target.isFastMatchProperty());
        this.targetCompareConfig.getControls().setVisible(target.isFastMatchProperty());
        this.targetCompareLabel.setVisible(target.isFastMatchProperty());
        this.repack();
    }

    @Override
    public void repack() {
        this.repack(this.controls);
    }

    private static class CompareConfigurer
    extends StringEnumConfigurer {
        CompareConfigurer() {
            super((String)null, (String)null, GlobalCommandTarget.CompareMode.getSymbols());
        }
    }
}

