/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.FileConfigurer;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ZipUpdater;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class ModuleUpdaterDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public ModuleUpdaterDialog(Frame owner) throws HeadlessException {
        super(owner, false);
        this.setTitle(Resources.getString("Editor.ModuleUpdaterDialog.title"));
        this.setLayout(new BoxLayout(this.getContentPane(), 1));
        FileConfigurer fileConfig = new FileConfigurer(null, Resources.getString("Editor.ModuleUpdaterDialog.file_older"));
        this.add(fileConfig.getControls());
        Box b = Box.createHorizontalBox();
        JButton saveButton = new JButton(Resources.getString("Editor.ModuleUpdaterDialog.create_updater"));
        saveButton.setEnabled(false);
        fileConfig.addPropertyChangeListener(evt -> saveButton.setEnabled(fileConfig.getValue() != null));
        saveButton.addActionListener(e -> {
            FileChooser fc = GameModule.getGameModule().getFileChooser();
            if (fc.showSaveDialog(this.getOwner()) != 0) {
                return;
            }
            File output = fc.getSelectedFile();
            ZipUpdater updater = null;
            try {
                updater = new ZipUpdater((File)fileConfig.getValue());
                updater.createUpdater(new File(GameModule.getGameModule().getArchiveWriter().getName()), output);
            }
            catch (IOException e1) {
                String msg = e1.getMessage();
                if (msg == null) {
                    msg = Resources.getString("Editor.ModuleUpdaterDialog.unable");
                }
                JOptionPane.showMessageDialog(this, msg, Resources.getString("Editor.ModuleUpdaterDialog.error_writing"), 0);
            }
        });
        JButton cancelButton = new JButton(Resources.getString("Editor.ModuleUpdaterDialog.close"));
        cancelButton.addActionListener(e -> this.dispose());
        JButton helpButton = new JButton(Resources.getString("Editor.ModuleUpdaterDialog.help"));
        this.add(b);
        HelpFile hf = null;
        try {
            hf = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "ModuleUpdater.html"));
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
        }
        helpButton.addActionListener(new ShowHelpAction(hf.getContents(), null));
        b.add(saveButton);
        b.add(helpButton);
        b.add(cancelButton);
        this.add(b);
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }
}

