/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PlayerAccess;
import VASSAL.counters.SideAccess;
import VASSAL.counters.SpecifiedSideAccess;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;

public class PieceAccessConfigurer
extends Configurer {
    protected static final String PLAYER = "player:";
    protected static final String SIDE = "side:";
    protected static final String SIDES = "sides:";
    protected JPanel controls;
    protected String[] prompts = new String[]{"Any Player", "Any side", "Any of the specified sides"};
    protected String[] promptKeys = new String[]{"Editor.PieceAccessConfigurer.any_player", "Editor.PieceAccessConfigurer.any_side", "Editor.PieceAccessConfigurer.any_specified"};
    protected TranslatingStringEnumConfigurer selectType;
    protected StringArrayConfigurer sideConfig;

    public PieceAccessConfigurer(String key, String name, PieceAccess value) {
        super(key, name, value);
    }

    public PieceAccessConfigurer(PieceAccess value) {
        this(null, "", value);
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        this.updateControls();
    }

    @Override
    public String getValueString() {
        return PieceAccessConfigurer.encode(this.getPieceAccess());
    }

    @Override
    public void setValue(String s) {
        this.setValue(PieceAccessConfigurer.decode(s));
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new ConfigurerPanel(this.getName(), "[fill,grow]", "[][fill,grow]");
            this.selectType = new TranslatingStringEnumConfigurer(this.prompts, this.promptKeys);
            this.selectType.addPropertyChangeListener(e -> {
                this.updateValue();
                this.sideConfig.getControls().setVisible(this.getValue() instanceof SpecifiedSideAccess);
                this.repack();
            });
            this.controls.add(this.selectType.getControls(), "wrap");
            this.sideConfig = new StringArrayConfigurer("", null);
            this.sideConfig.addPropertyChangeListener(evt -> this.updateValue());
            this.controls.add(this.sideConfig.getControls(), "growx,wrap");
            this.updateControls();
        }
        return this.controls;
    }

    protected void updateValue() {
        this.noUpdate = true;
        if (this.prompts[1].equals(this.selectType.getValueString())) {
            this.setValue(SideAccess.getInstance());
        } else if (this.prompts[2].equals(this.selectType.getValueString())) {
            this.setValue(new SpecifiedSideAccess(Arrays.asList(this.sideConfig.getStringArray())));
        } else {
            this.setValue(PlayerAccess.getInstance());
        }
        this.noUpdate = false;
    }

    protected void updateControls() {
        if (!this.noUpdate && this.controls != null) {
            this.sideConfig.getControls().setVisible(this.getValue() instanceof SpecifiedSideAccess);
            if (this.getValue() instanceof SideAccess) {
                this.selectType.setValue(this.prompts[1]);
            } else if (this.getValue() instanceof SpecifiedSideAccess) {
                this.sideConfig.setValue(((SpecifiedSideAccess)this.getPieceAccess()).getSides().toArray(new String[0]));
                this.selectType.setValue(this.prompts[2]);
            } else {
                this.selectType.setValue(this.prompts[0]);
            }
        }
    }

    public String[] getPrompts() {
        return this.prompts;
    }

    public PieceAccess getPieceAccess() {
        return (PieceAccess)this.getValue();
    }

    public static PieceAccess decode(String s) {
        if (SIDE.equals(s)) {
            return SideAccess.getInstance();
        }
        if (s != null && s.startsWith(SIDES)) {
            SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s.substring(SIDES.length()), ':');
            ArrayList<String> l = new ArrayList<String>();
            while (sd.hasMoreTokens()) {
                l.add(sd.nextToken());
            }
            return new SpecifiedSideAccess(l);
        }
        return PlayerAccess.getInstance();
    }

    public static String encode(PieceAccess p) {
        String s = null;
        if (p instanceof SideAccess) {
            s = SIDE;
        } else if (p instanceof SpecifiedSideAccess) {
            SequenceEncoder se = new SequenceEncoder(':');
            for (String side : ((SpecifiedSideAccess)p).getSides()) {
                se.append(side);
            }
            s = se.getValue() == null ? SIDES : SIDES + se.getValue();
        } else if (p instanceof PlayerAccess) {
            s = PLAYER;
        }
        return s;
    }

    @Deprecated(since="2020-08-05", forRemoval=true)
    public void setPrompts(String[] prompts) {
        ProblemDialog.showDeprecated("2020-08-05");
    }
}

