/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.swing.FlowLabel;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Collections;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoveUnusedImagesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LoggerFactory.getLogger(RemoveUnusedImagesDialog.class);
    private final DefaultListModel<String> keepModel = new DefaultListModel();
    private final DefaultListModel<String> dumpModel = new DefaultListModel();
    private final SortedSet<String> keep = new TreeSet<String>();
    private final SortedSet<String> dump = new TreeSet<String>();
    private final JButton ok;
    private final GameModule module;

    public RemoveUnusedImagesDialog(Frame owner) {
        super(owner, Resources.getString("Editor.UnusedImages.remove_unused_images"), true);
        FlowLabel text = new FlowLabel(Resources.getString("Editor.UnusedImages.unused_1"));
        this.module = GameModule.getGameModule();
        Collections.addAll(this.keep, this.module.getDataArchive().getImageNames());
        this.keep.removeAll(this.module.getAllImageNames());
        this.keepModel.addAll(this.keep);
        JList<String> keepList = new JList<String>(this.keepModel);
        JScrollPane keepScroll = new JScrollPane(keepList);
        keepScroll.setBorder(BorderFactory.createTitledBorder(Resources.getString("Editor.UnusedImages.files_to_keep")));
        JList<String> dropList = new JList<String>(this.dumpModel);
        JScrollPane dropScroll = new JScrollPane(dropList);
        dropScroll.setBorder(BorderFactory.createTitledBorder(Resources.getString("Editor.UnusedImages.files_to_remove")));
        JButton dropButton = new JButton(IconFactory.getIcon("go-next", 0));
        JButton keepButton = new JButton(IconFactory.getIcon("go-previous", 0));
        this.ok = new JButton(Resources.getString("Editor.UnusedImages.remove_files"));
        JButton cancel = new JButton(Resources.getString("General.cancel"));
        this.ok.addActionListener(e -> this.removeImages());
        keepButton.addActionListener(e -> this.updateSelection(dropList, this.dumpModel, this.dump, this.keep));
        dropButton.addActionListener(e -> this.updateSelection(keepList, this.keepModel, this.keep, this.dump));
        keepList.addListSelectionListener(e -> dropButton.setEnabled(!keepList.isSelectionEmpty()));
        dropButton.setEnabled(!keepList.isSelectionEmpty());
        dropList.addListSelectionListener(e -> keepButton.setEnabled(!dropList.isSelectionEmpty()));
        keepButton.setEnabled(!dropList.isSelectionEmpty());
        this.ok.setEnabled(!this.dumpModel.isEmpty());
        cancel.addActionListener(e -> this.dispose());
        JPanel panel = new JPanel((LayoutManager)new MigLayout("insets dialog", "[]rel[]rel[]", "[]unrel[]unrel[]"));
        panel.add((Component)text, "span, wrap");
        panel.add((Component)keepScroll, "grow, push, sizegroup list");
        panel.add((Component)dropButton, "align center, flowy, split 2");
        panel.add((Component)keepButton, "align center");
        panel.add((Component)dropScroll, "grow, push, sizegroup list, wrap");
        panel.add((Component)this.ok, "tag ok, span, split");
        panel.add((Component)cancel, "tag cancel");
        this.add(panel);
        this.pack();
    }

    private void updateSelection(JList srclist, DefaultListModel<String> srcmodel, SortedSet<String> src, SortedSet<String> dst) {
        int[] indices = srclist.getSelectedIndices();
        int lastSelect = indices[indices.length - 1];
        Arrays.stream(indices).forEach(i -> {
            String item = (String)srcmodel.getElementAt(i);
            src.remove(item);
            dst.add(item);
        });
        this.keepModel.removeAllElements();
        this.dumpModel.removeAllElements();
        this.keepModel.addAll(this.keep);
        this.dumpModel.addAll(this.dump);
        srclist.setSelectedIndex(Math.max(0, Math.min(lastSelect, srcmodel.getSize()) - 1));
        this.ok.setEnabled(!this.dumpModel.isEmpty());
    }

    private void removeImages() {
        ArchiveWriter aw = this.module.getDataArchive().getWriter();
        File dir = new File(new File(aw.getName()).getParent(), "removed");
        dir.mkdir();
        for (String u : this.dump) {
            GameModule.getGameModule().warn("- " + Resources.getString("Editor.UnusedImages.removing", u));
            System.out.println(Resources.getString("Editor.UnusedImages.removing", u));
            try (InputStream in = aw.getInputStream("images/" + u);){
                Files.copy(in, dir.toPath().resolve(u), new CopyOption[0]);
            }
            catch (IOException ex) {
                logger.error("Augh!", (Throwable)ex);
            }
            aw.removeImage(u);
        }
        if (!this.dump.isEmpty()) {
            GameModule.getGameModule().setDirty(true);
        }
        this.dispose();
    }
}

