/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.AbstractConfigurableListEntry;
import VASSAL.configure.ConfigurableList;
import VASSAL.configure.ConfigurableListController;
import VASSAL.configure.ConfigurableListEntry;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;

public class StringArrayConfigurer
extends Configurer
implements ConfigurableList {
    @Deprecated(since="2020-11-12", forRemoval=true)
    protected JList<String> list;
    @Deprecated(since="2020-11-12", forRemoval=true)
    protected DefaultListModel<String> model;
    @Deprecated(since="2020-11-12", forRemoval=true)
    protected JTextField textField;
    @Deprecated(since="2020-11-12", forRemoval=true)
    protected int minRows = 3;
    @Deprecated(since="2020-11-12", forRemoval=true)
    protected int maxRows = 3;
    protected JPanel panel;
    private static final String[] EMPTY = new String[0];
    private final List<StringEntry> entries = new ArrayList<StringEntry>();
    private int selectedEntryIndex = -1;
    private ConfigurableListController controller;
    private JPanel controls;
    private FocusListener sharedFocusListener;

    public StringArrayConfigurer(String key, String name, Object val) {
        super(key, name, val);
    }

    public StringArrayConfigurer(Object val) {
        this(null, "", val);
    }

    public StringArrayConfigurer(String key, String name) {
        super(key, name);
    }

    @Deprecated(since="2020-11-12", forRemoval=true)
    public DefaultListModel<String> getModel() {
        return this.model;
    }

    @Deprecated(since="2020-11-12", forRemoval=true)
    public void addValue(String s) {
        Object[] objectArray;
        if (this.value == null) {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = s;
        } else {
            objectArray = ArrayUtils.add((Object[])((String[])this.value), (Object)s);
        }
        this.setValue(objectArray);
    }

    public void removeValue(String s) {
        String[] newValue;
        Object[] oldValue = this.getStringArray();
        if (oldValue != (newValue = (String[])ArrayUtils.removeElement((Object[])oldValue, (Object)s))) {
            this.setValue(newValue);
        }
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel((LayoutManager)new MigLayout("hidemode 3,ins 0,gapy 4", "[grow,fill][]"));
            this.controls = new JPanel((LayoutManager)new MigLayout("gapy 4", "[grow,fill][]"));
            this.controls.setBorder(BorderFactory.createEtchedBorder());
            this.panel.add((Component)this.controls, "grow");
            this.panel.add((Component)this.getListController(), "growy 0,aligny center");
            this.rebuildControls();
        }
        return this.panel;
    }

    @Deprecated(since="2020-11-12", forRemoval=true)
    public void updateViewable(int rows) {
    }

    @Deprecated(since="2020-11-12", forRemoval=true)
    protected Component getTextComponent() {
        return this.textField;
    }

    @Deprecated(since="2020-11-12", forRemoval=true)
    protected String getTextValue() {
        return this.textField.getText();
    }

    @Deprecated(since="2020-11-12", forRemoval=true)
    protected void setTextValue(String s) {
        this.textField.setText(s);
    }

    @Deprecated(since="2020-11-12", forRemoval=true)
    protected void addTextActionListener(ActionListener a) {
        this.textField.addActionListener(a);
    }

    public String[] getStringArray() {
        if (this.value instanceof String[]) {
            return (String[])this.value;
        }
        return EMPTY;
    }

    @Override
    public String getValueString() {
        return StringArrayConfigurer.arrayToString(this.getStringArray());
    }

    public static String arrayToString(String[] s) {
        if (s == null || s.length == 0) {
            return "";
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (String item : s) {
            se.append(item != null ? item : "");
        }
        return se.getValue();
    }

    @Override
    public void setValue(Object o) {
        if (o == null) {
            o = EMPTY;
        }
        super.setValue(o);
        if (this.controls != null) {
            this.rebuildControls();
        }
    }

    @Override
    public void setValue(String s) {
        String[] val = StringArrayConfigurer.stringToArray(s);
        this.setValue(val);
    }

    public static String[] stringToArray(String s) {
        if (s == null || s.length() == 0) {
            return EMPTY;
        }
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ',');
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        return l.toArray(new String[0]);
    }

    @Deprecated(since="2020-11-12", forRemoval=true)
    protected void updateModel() {
    }

    private void rebuildControls() {
        String[] strings;
        for (StringEntry entry : this.entries) {
            entry.removeFocusListener(this.sharedFocusListener);
        }
        this.entries.clear();
        this.controls.removeAll();
        for (String string : strings = this.getStringArray()) {
            StringEntry entry = new StringEntry(this, string);
            entry.addFocusListener(this.sharedFocusListener);
            this.controls.add(entry.getConfigurer().getControls());
            this.controls.add((Component)entry.getRemoveButton(), "growx 0,wrap");
            this.entries.add(entry);
        }
        this.updateControls();
        this.repack();
    }

    private void updateControls() {
        int i = 0;
        for (StringEntry entry : this.entries) {
            entry.setHighlighted(i++ == this.getSelectedEntryIndex());
        }
        this.getListController();
        this.controller.setCanMoveUp(this.getSelectedEntryIndex() > 0);
        this.controller.setCanMoveDown(this.getSelectedEntryIndex() >= 0 && this.getSelectedEntryIndex() < this.entries.size() - 1);
        this.controls.repaint();
    }

    public Configurer buildChildConfigurer(Object value) {
        StringConfigurer s = new StringConfigurer((String)value);
        s.setHint(this.getHint());
        return s;
    }

    @Override
    public void moveEntryUp() {
        if (this.getSelectedEntryIndex() < 0) {
            return;
        }
        int pos = this.getSelectedEntryIndex();
        Object[] strings = this.getStringArray();
        String moving = strings[pos];
        strings = (String[])ArrayUtils.remove((Object[])strings, (int)pos);
        strings = (String[])ArrayUtils.insert((int)(pos - 1), (Object[])strings, (Object[])new String[]{moving});
        this.setValue(strings);
        this.setSelectedEntryIndex(pos - 1);
        this.rebuildControls();
    }

    @Override
    public void moveEntryDown() {
        if (this.getSelectedEntryIndex() < 0) {
            return;
        }
        int pos = this.getSelectedEntryIndex();
        Object[] strings = this.getStringArray();
        String moving = strings[pos];
        strings = (String[])ArrayUtils.remove((Object[])strings, (int)pos);
        strings = (String[])ArrayUtils.insert((int)(pos + 1), (Object[])strings, (Object[])new String[]{moving});
        this.setValue(strings);
        this.setSelectedEntryIndex(pos + 1);
        this.rebuildControls();
    }

    @Override
    public void addEntry() {
        int pos = this.getSelectedEntryIndex();
        if (this.entries.isEmpty() || this.getSelectedEntryIndex() < 0) {
            this.setValue(ArrayUtils.add((Object[])this.getStringArray(), (Object)""));
            this.setSelectedEntryIndex(this.getStringArray().length - 1);
        } else {
            this.setValue(ArrayUtils.insert((int)(pos + 1), (Object[])this.getStringArray(), (Object[])new String[]{""}));
            this.setSelectedEntryIndex(pos + 1);
        }
        this.rebuildControls();
    }

    @Override
    public void deleteEntry(ConfigurableListEntry entry) {
        int pos = this.entries.indexOf(entry);
        this.setValue(ArrayUtils.remove((Object[])this.getStringArray(), (int)pos));
        this.setSelectedEntryIndex(Math.min(pos, this.entries.size() - 1));
        if (this.selectedEntryIndex >= 0) {
            this.entries.get(this.selectedEntryIndex).requestFocus();
        }
    }

    @Override
    public JComponent getListController() {
        if (this.controller == null) {
            this.controller = new ConfigurableListController(this);
        }
        return this.controller;
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        this.sharedFocusListener = listener;
        for (StringEntry entry : this.entries) {
            entry.addFocusListener(listener);
        }
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        for (StringEntry entry : this.entries) {
            entry.removeFocusListener(listener);
        }
        this.sharedFocusListener = null;
    }

    @Override
    public void selectEntry(ConfigurableListEntry entry) {
        this.setSelectedEntryIndex(entry == null ? -1 : this.entries.indexOf(entry));
        this.updateControls();
    }

    @Override
    public void repack() {
        this.repack(this.panel);
    }

    @Override
    public void setSelectedEntryIndex(int index) {
        this.selectedEntryIndex = Math.min(index, this.entries.size() - 1);
    }

    @Override
    public int getSelectedEntryIndex() {
        return this.selectedEntryIndex;
    }

    @Override
    public void entryChanged(ConfigurableListEntry entry) {
        this.getStringArray()[this.entries.indexOf((Object)entry)] = entry.getConfigurer().getValueString();
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        if (!highlighted) {
            this.selectEntry(null);
        }
    }

    static class StringEntry
    extends AbstractConfigurableListEntry {
        public StringEntry(ConfigurableList parentConfig, Object value) {
            super(parentConfig, value);
        }

        @Override
        public Configurer buildChildConfigurer(Object value) {
            return ((StringArrayConfigurer)this.getParent()).buildChildConfigurer(value);
        }

        @Override
        public void setHighlighted(boolean b) {
            this.getConfigurer().setHighlighted(b);
        }

        @Override
        public void requestFocus() {
            this.getConfigurer().getControls().requestFocus();
        }

        public void addFocusListener(FocusListener listener) {
            this.getConfigurer().addFocusListener(listener);
        }

        public void removeFocusListener(FocusListener listener) {
            this.getConfigurer().removeFocusListener(listener);
        }
    }
}

