/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.map.DeckGlobalKeyCommand;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.StackMetrics;
import VASSAL.build.module.properties.MutableProperty;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.AddPiece;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.command.NullCommand;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.PieceIterator;
import VASSAL.counters.PropertiesPieceFilter;
import VASSAL.counters.Stack;
import VASSAL.i18n.Localization;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.NamedKeyStrokeListener;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.ReadErrorDialog;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;

public class Deck
extends Stack
implements PlayerRoster.SideChangeListener {
    public static final String ID = "deck;";
    public static final String ALWAYS = "Always";
    public static final String NEVER = "Never";
    public static final String USE_MENU = "Via right-click Menu";
    public static final String NO_USER = "nobody";
    protected static final StackMetrics deckStackMetrics = new StackMetrics(false, 2, 2, 2, 2);
    protected boolean drawOutline = true;
    protected Color outlineColor = Color.black;
    protected Dimension size = new Dimension(40, 40);
    protected boolean shuffle = true;
    protected String faceDownOption = "Always";
    protected String shuffleOption = "Always";
    protected String shuffleCommand = "";
    protected boolean allowMultipleDraw = false;
    protected boolean allowSelectDraw = false;
    protected boolean reversible = false;
    protected String reshuffleCommand = "";
    protected String reshuffleTarget;
    protected String reshuffleMsgFormat;
    protected NamedKeyStrokeListener reshuffleListener;
    protected NamedKeyStroke reshuffleKey;
    protected String reverseMsgFormat;
    protected String reverseCommand;
    protected NamedKeyStroke reverseKey;
    protected NamedKeyStrokeListener reverseListener;
    protected String shuffleMsgFormat;
    protected NamedKeyStrokeListener shuffleListener;
    protected NamedKeyStroke shuffleKey;
    protected String faceDownMsgFormat;
    protected boolean drawFaceUp;
    protected boolean persistable;
    protected FormattedString selectDisplayProperty = new FormattedString("$BasicName$");
    protected String selectSortProperty = "";
    protected MutableProperty.Impl countProperty = new MutableProperty.Impl("", this);
    protected List<MutableProperty.Impl> expressionProperties = new ArrayList<MutableProperty.Impl>();
    protected String deckName;
    protected String localizedDeckName;
    protected boolean faceDown;
    protected int dragCount = 0;
    protected int maxStack = 10;
    protected CountExpression[] countExpressions = new CountExpression[0];
    protected boolean expressionCounting = false;
    protected List<GamePiece> nextDraw = null;
    protected KeyCommand[] commands;
    protected List<DeckGlobalKeyCommand> globalCommands = new ArrayList<DeckGlobalKeyCommand>();
    protected boolean hotkeyOnEmpty;
    protected NamedKeyStroke emptyKey;
    protected boolean restrictOption;
    protected PropertyExpression restrictExpression = new PropertyExpression();
    protected PropertySource propertySource;
    protected CommandEncoder commandEncoder = new CommandEncoder(){

        @Override
        public Command decode(String command) {
            if (!command.startsWith("DECK\t")) {
                return null;
            }
            return new LoadDeckCommand(Deck.this);
        }

        @Override
        public String encode(Command c) {
            if (!(c instanceof LoadDeckCommand)) {
                return null;
            }
            return "DECK\t";
        }
    };
    private final GameModule gameModule;

    @Deprecated
    public Deck() {
        this(GameModule.getGameModule());
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Deck(String type) {
        this(GameModule.getGameModule(), type);
        ProblemDialog.showDeprecated("2020-08-06");
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public Deck(String type, PropertySource source) {
        this(GameModule.getGameModule(), type, source);
        ProblemDialog.showDeprecated("2020-08-06");
    }

    public Deck(GameModule gameModule) {
        this(gameModule, ID);
    }

    public Deck(GameModule gameModule, String type) {
        this.gameModule = gameModule;
        this.mySetType(type);
        gameModule.addSideChangeListenerToPlayerRoster(this);
    }

    public Deck(GameModule gameModule, String type, PropertySource source) {
        this(gameModule, type);
        this.propertySource = source;
    }

    public void setPropertySource(PropertySource source) {
        this.propertySource = source;
        if (this.globalCommands != null) {
            for (DeckGlobalKeyCommand globalCommand : this.globalCommands) {
                globalCommand.setPropertySource(this.propertySource);
            }
        }
    }

    @Override
    public void sideChanged(String oldSide, String newSide) {
        this.updateCountsAll();
    }

    public void addGlobalKeyCommand(DeckGlobalKeyCommand globalCommand) {
        this.globalCommands.add(globalCommand);
    }

    public void removeGlobalKeyCommand(DeckGlobalKeyCommand globalCommand) {
        this.globalCommands.remove(globalCommand);
    }

    protected String[] getGlobalCommands() {
        String[] commands = new String[this.globalCommands.size()];
        for (int i = 0; i < this.globalCommands.size(); ++i) {
            commands[i] = this.globalCommands.get(i).encode();
        }
        return commands;
    }

    protected void setGlobalCommands(String[] commands) {
        this.globalCommands = new ArrayList<DeckGlobalKeyCommand>(commands.length);
        for (String command : commands) {
            this.globalCommands.add(new DeckGlobalKeyCommand(command, this.propertySource));
        }
    }

    private void updateCountsAll() {
        if (!this.doesExpressionCounting() || this.getMap() == null) {
            return;
        }
        for (int index = 0; index < this.countExpressions.length; ++index) {
            this.expressionProperties.get(index).setPropertyValue("0");
        }
        this.asList().stream().filter(Objects::nonNull).forEach(p -> this.updateCounts((GamePiece)p, true));
    }

    private void updateCounts(int index) {
        if (!this.doesExpressionCounting()) {
            return;
        }
        if (index >= 0 && index < this.getPieceCount()) {
            GamePiece p = this.getPieceAt(index);
            if (p == null) {
                this.updateCountsAll();
            } else {
                this.updateCounts(p, false);
            }
        } else {
            this.updateCountsAll();
        }
    }

    private void updateCounts(GamePiece p, boolean increase) {
        if (!this.doesExpressionCounting() || this.getMap() == null) {
            return;
        }
        for (int index = 0; index < this.countExpressions.length; ++index) {
            String mapProperty;
            MutableProperty.Impl prop = this.expressionProperties.get(index);
            FormattedString formatted = new FormattedString(this.countExpressions[index].getExpression());
            PieceFilter f = PropertiesPieceFilter.parse(formatted.getText());
            if (!f.accept(p) || (mapProperty = prop.getPropertyValue()) == null) continue;
            int newValue = Integer.decode(mapProperty);
            newValue = increase ? ++newValue : --newValue;
            prop.setPropertyValue(String.valueOf(newValue));
        }
    }

    protected void fireNumCardsProperty() {
        this.countProperty.setPropertyValue(String.valueOf(this.pieceCount));
    }

    @Override
    protected void insertPieceAt(GamePiece p, int index) {
        super.insertPieceAt(p, index);
        this.updateCounts(p, true);
        this.fireNumCardsProperty();
    }

    @Override
    protected void removePieceAt(int index) {
        int startCount = this.pieceCount;
        this.updateCounts(index);
        super.removePieceAt(index);
        this.fireNumCardsProperty();
        if (this.hotkeyOnEmpty && this.emptyKey != null && startCount > 0 && this.pieceCount == 0) {
            this.gameModule.fireKeyStroke(this.emptyKey);
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        this.updateCountsAll();
        this.fireNumCardsProperty();
    }

    @Override
    public void setMap(Map map) {
        if (map != this.getMap()) {
            this.countProperty.removeFromContainer();
            if (map != null) {
                this.countProperty.addTo(map);
            }
            for (MutableProperty.Impl prop : this.expressionProperties) {
                prop.removeFromContainer();
                if (map == null) continue;
                prop.addTo(map);
            }
        }
        super.setMap(map);
        this.updateCountsAll();
        this.fireNumCardsProperty();
    }

    protected void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.drawOutline = st.nextBoolean(true);
        this.outlineColor = ColorConfigurer.stringToColor(st.nextToken("0,0,0"));
        this.size.setSize(st.nextInt(40), st.nextInt(40));
        this.faceDownOption = st.nextToken(ALWAYS);
        this.shuffleOption = st.nextToken(ALWAYS);
        this.allowMultipleDraw = st.nextBoolean(true);
        this.allowSelectDraw = st.nextBoolean(true);
        this.reversible = st.nextBoolean(true);
        this.reshuffleCommand = st.nextToken("");
        this.reshuffleTarget = st.nextToken("");
        this.reshuffleMsgFormat = st.nextToken("");
        this.setDeckName(st.nextToken(Resources.getString("Deck.deck")));
        this.shuffleMsgFormat = st.nextToken("");
        this.reverseMsgFormat = st.nextToken("");
        this.faceDownMsgFormat = st.nextToken("");
        this.drawFaceUp = st.nextBoolean(false);
        this.persistable = st.nextBoolean(false);
        this.shuffleKey = st.nextNamedKeyStroke(null);
        this.reshuffleKey = st.nextNamedKeyStroke(null);
        this.maxStack = st.nextInt(10);
        this.setCountExpressions(st.nextStringArray(0));
        this.expressionCounting = st.nextBoolean(false);
        this.setGlobalCommands(st.nextStringArray(0));
        this.hotkeyOnEmpty = st.nextBoolean(false);
        this.emptyKey = st.nextNamedKeyStroke(null);
        this.selectDisplayProperty.setFormat(st.nextToken("$BasicName$"));
        this.selectSortProperty = st.nextToken("");
        this.restrictOption = st.nextBoolean(false);
        this.restrictExpression.setExpression(st.nextToken(""));
        this.shuffleCommand = st.nextToken(Resources.getString("Deck.shuffle"));
        this.reverseCommand = st.nextToken(Resources.getString("Deck.reverse"));
        this.reverseKey = st.nextNamedKeyStroke(null);
        if (this.shuffleListener == null) {
            this.shuffleListener = new NamedKeyStrokeListener(e -> {
                this.gameModule.sendAndLog(this.shuffle());
                this.repaintMap();
            });
            this.gameModule.addKeyStrokeListener(this.shuffleListener);
        }
        this.shuffleListener.setKeyStroke(this.getShuffleKey());
        if (this.reshuffleListener == null) {
            this.reshuffleListener = new NamedKeyStrokeListener(e -> {
                this.gameModule.sendAndLog(this.sendToDeck());
                this.repaintMap();
            });
            this.gameModule.addKeyStrokeListener(this.reshuffleListener);
        }
        this.reshuffleListener.setKeyStroke(this.getReshuffleKey());
        if (this.reverseListener == null) {
            this.reverseListener = new NamedKeyStrokeListener(e -> {
                this.gameModule.sendAndLog(this.reverse());
                this.repaintMap();
            });
            this.gameModule.addKeyStrokeListener(this.reverseListener);
        }
        this.reverseListener.setKeyStroke(this.getReverseKey());
        DrawPile myPile = DrawPile.findDrawPile(this.getDeckName());
        if (myPile != null && !GameModule.getGameModule().getGameState().isGameStarted()) {
            myPile.setDeck(this);
        }
    }

    public String getFaceDownOption() {
        return this.faceDownOption;
    }

    public boolean isDrawFaceUp() {
        return this.drawFaceUp;
    }

    public void setDrawFaceUp(boolean drawFaceUp) {
        this.drawFaceUp = drawFaceUp;
    }

    public void setFaceDownOption(String faceDownOption) {
        this.faceDownOption = faceDownOption;
        this.faceDown = !faceDownOption.equals(NEVER);
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize(Dimension size) {
        this.size.setSize(size);
    }

    public String getShuffleOption() {
        return this.shuffleOption;
    }

    public void setShuffleOption(String shuffleOption) {
        this.shuffleOption = shuffleOption;
    }

    public boolean isShuffle() {
        return this.shuffle;
    }

    public int getMaxStack() {
        return this.maxStack;
    }

    @Override
    public int getMaximumVisiblePieceCount() {
        return Math.min(this.pieceCount, this.maxStack);
    }

    public String[] getCountExpressions() {
        String[] fullstrings = new String[this.countExpressions.length];
        for (int index = 0; index < this.countExpressions.length; ++index) {
            fullstrings[index] = this.countExpressions[index].getFullString();
        }
        return fullstrings;
    }

    public boolean doesExpressionCounting() {
        return this.expressionCounting;
    }

    public String getFaceDownMsgFormat() {
        return this.faceDownMsgFormat;
    }

    public void setFaceDownMsgFormat(String faceDownMsgFormat) {
        this.faceDownMsgFormat = faceDownMsgFormat;
    }

    public String getReverseMsgFormat() {
        return this.reverseMsgFormat;
    }

    public void setReverseMsgFormat(String reverseMsgFormat) {
        this.reverseMsgFormat = reverseMsgFormat;
    }

    public String getReverseCommand() {
        return this.reverseCommand;
    }

    public void setReverseCommand(String s) {
        this.reverseCommand = s;
    }

    public NamedKeyStroke getReverseKey() {
        return this.reverseKey;
    }

    public void setReverseKey(NamedKeyStroke reverseKey) {
        this.reverseKey = reverseKey;
    }

    public String getShuffleMsgFormat() {
        return this.shuffleMsgFormat;
    }

    public void setShuffleMsgFormat(String shuffleMsgFormat) {
        this.shuffleMsgFormat = shuffleMsgFormat;
    }

    public NamedKeyStroke getShuffleKey() {
        return this.shuffleKey;
    }

    public void setShuffleKey(NamedKeyStroke shuffleKey) {
        this.shuffleKey = shuffleKey;
    }

    public String getShuffleCommand() {
        return this.shuffleCommand;
    }

    public void setShuffleCommand(String s) {
        this.shuffleCommand = s;
    }

    public void setShuffle(boolean shuffle) {
        this.shuffle = shuffle;
    }

    public boolean isAllowMultipleDraw() {
        return this.allowMultipleDraw;
    }

    public void setAllowMultipleDraw(boolean allowMultipleDraw) {
        this.allowMultipleDraw = allowMultipleDraw;
    }

    public boolean isAllowSelectDraw() {
        return this.allowSelectDraw;
    }

    public void setMaxStack(int maxStack) {
        this.maxStack = maxStack;
    }

    public void setCountExpressions(String[] countExpressionsString) {
        CountExpression[] c = new CountExpression[countExpressionsString.length];
        int goodExpressionCount = 0;
        for (int index = 0; index < countExpressionsString.length; ++index) {
            CountExpression n = new CountExpression(countExpressionsString[index]);
            if (n.getName() == null) continue;
            c[index] = n;
            ++goodExpressionCount;
        }
        this.countExpressions = Arrays.copyOf(c, goodExpressionCount);
        while (this.countExpressions.length > this.expressionProperties.size()) {
            this.expressionProperties.add(new MutableProperty.Impl("", this));
        }
        for (int i = 0; i < this.countExpressions.length; ++i) {
            this.expressionProperties.get(i).setPropertyName(this.deckName + "_" + this.countExpressions[i].getName());
        }
    }

    public void setExpressionCounting(boolean expressionCounting) {
        this.expressionCounting = expressionCounting;
    }

    public void setAllowSelectDraw(boolean allowSelectDraw) {
        this.allowSelectDraw = allowSelectDraw;
    }

    public boolean isReversible() {
        return this.reversible;
    }

    public void setReversible(boolean reversible) {
        this.reversible = reversible;
    }

    public void setDeckName(String n) {
        if (Localization.getInstance().isTranslationInProgress()) {
            this.localizedDeckName = n;
        } else {
            this.deckName = n;
        }
        this.countProperty.setPropertyName(this.deckName + "_numPieces");
        for (int i = 0; i < this.countExpressions.length; ++i) {
            this.expressionProperties.get(i).setPropertyName(this.deckName + "_" + this.countExpressions[i].getName());
        }
    }

    public String getDeckName() {
        return this.deckName;
    }

    public String getLocalizedDeckName() {
        return this.localizedDeckName == null ? this.deckName : this.localizedDeckName;
    }

    public String getReshuffleCommand() {
        return this.reshuffleCommand;
    }

    public void setReshuffleCommand(String reshuffleCommand) {
        this.reshuffleCommand = reshuffleCommand;
    }

    public NamedKeyStroke getReshuffleKey() {
        return this.reshuffleKey;
    }

    public void setReshuffleKey(NamedKeyStroke reshuffleKey) {
        this.reshuffleKey = reshuffleKey;
    }

    public String getReshuffleTarget() {
        return this.reshuffleTarget;
    }

    public void setReshuffleTarget(String reshuffleTarget) {
        this.reshuffleTarget = reshuffleTarget;
    }

    public String getReshuffleMsgFormat() {
        return this.reshuffleMsgFormat;
    }

    public void setReshuffleMsgFormat(String reshuffleMsgFormat) {
        this.reshuffleMsgFormat = reshuffleMsgFormat;
    }

    public boolean isHotkeyOnEmpty() {
        return this.hotkeyOnEmpty;
    }

    public void setHotkeyOnEmpty(boolean b) {
        this.hotkeyOnEmpty = b;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public KeyStroke getEmptyKey() {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.emptyKey.getKeyStroke();
    }

    public NamedKeyStroke getNamedEmptyKey() {
        return this.emptyKey;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public void setEmptyKey(KeyStroke k) {
        ProblemDialog.showDeprecated("2020-08-06");
        this.emptyKey = new NamedKeyStroke(k);
    }

    public void setEmptyKey(NamedKeyStroke k) {
        this.emptyKey = k;
    }

    public void setRestrictOption(boolean restrictOption) {
        this.restrictOption = restrictOption;
    }

    public boolean isRestrictOption() {
        return this.restrictOption;
    }

    public void setRestrictExpression(PropertyExpression restrictExpression) {
        this.restrictExpression = restrictExpression;
    }

    public PropertyExpression getRestrictExpression() {
        return this.restrictExpression;
    }

    public boolean mayContain(GamePiece piece) {
        if (!this.restrictOption || this.restrictExpression.isNull()) {
            return true;
        }
        return this.restrictExpression.accept(piece);
    }

    @Override
    public String getType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.drawOutline).append(ColorConfigurer.colorToString(this.outlineColor)).append(String.valueOf(this.size.width)).append(String.valueOf(this.size.height)).append(this.faceDownOption).append(this.shuffleOption).append(String.valueOf(this.allowMultipleDraw)).append(String.valueOf(this.allowSelectDraw)).append(String.valueOf(this.reversible)).append(this.reshuffleCommand).append(this.reshuffleTarget).append(this.reshuffleMsgFormat).append(this.deckName).append(this.shuffleMsgFormat).append(this.reverseMsgFormat).append(this.faceDownMsgFormat).append(this.drawFaceUp).append(this.persistable).append(this.shuffleKey).append(this.reshuffleKey).append(String.valueOf(this.maxStack)).append(this.getCountExpressions()).append(this.expressionCounting).append(this.getGlobalCommands()).append(this.hotkeyOnEmpty).append(this.emptyKey).append(this.selectDisplayProperty.getFormat()).append(this.selectSortProperty).append(this.restrictOption).append(this.restrictExpression).append(this.shuffleCommand).append(this.reverseCommand).append(this.reverseKey);
        return ID + se.getValue();
    }

    public Command shuffle() {
        GamePiece[] a = new GamePiece[this.pieceCount];
        System.arraycopy(this.contents, 0, a, 0, this.pieceCount);
        List<GamePiece> l = Arrays.asList(a);
        DragBuffer.getBuffer().clear();
        Collections.shuffle(l, this.gameModule.getRNG());
        return this.setContents(l).append(this.reportCommand(this.shuffleMsgFormat, Resources.getString("Deck.shuffle")));
    }

    public Command maybeShuffle() {
        if (!ALWAYS.equals(this.shuffleOption)) {
            return new NullCommand();
        }
        GamePiece[] a = new GamePiece[this.pieceCount];
        System.arraycopy(this.contents, 0, a, 0, this.pieceCount);
        List<GamePiece> l = Arrays.asList(a);
        DragBuffer.getBuffer().clear();
        Collections.shuffle(l, this.gameModule.getRNG());
        return this.setContents(l);
    }

    public PieceIterator drawCards() {
        Iterator<GamePiece> it;
        if (this.nextDraw != null) {
            it = this.nextDraw.iterator();
        } else if (this.getPieceCount() == 0) {
            it = Collections.emptyIterator();
        } else {
            int count = Math.max(this.dragCount, Math.min(1, this.getPieceCount()));
            ArrayList<GamePiece> pieces = new ArrayList<GamePiece>();
            if (ALWAYS.equals(this.shuffleOption)) {
                ArrayList<Integer> indices = new ArrayList<Integer>();
                for (int i = 0; i < this.getPieceCount(); ++i) {
                    indices.add(i);
                }
                Random rng = this.gameModule.getRNG();
                while (count-- > 0 && !indices.isEmpty()) {
                    int i = rng.nextInt(indices.size());
                    int index = (Integer)indices.get(i);
                    indices.remove(i);
                    GamePiece p = this.getPieceAt(index);
                    pieces.add(p);
                }
            } else {
                Iterator<GamePiece> i = this.getPiecesReverseIterator();
                while (count-- > 0 && i.hasNext()) {
                    pieces.add(i.next());
                }
            }
            it = pieces.iterator();
        }
        this.dragCount = 0;
        this.nextDraw = null;
        return new PieceIterator(it){

            @Override
            public GamePiece nextPiece() {
                GamePiece p = super.nextPiece();
                p.setProperty("ObscuredPreDraw", p.getProperty("obs;"));
                if (Deck.this.faceDown) {
                    p.setProperty("obs;", Deck.NO_USER);
                }
                return p;
            }
        };
    }

    protected Command setContents(Collection<GamePiece> c) {
        ChangeTracker track = new ChangeTracker(this);
        this.removeAll();
        for (GamePiece child : c) {
            this.insertChild(child, this.pieceCount);
        }
        return track.getChangeCommand();
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected Command setContents(Iterator<GamePiece> it) {
        ProblemDialog.showDeprecated("2020-08-06");
        ChangeTracker track = new ChangeTracker(this);
        this.removeAll();
        while (it.hasNext()) {
            GamePiece child = it.next();
            this.insertChild(child, this.pieceCount);
        }
        return track.getChangeCommand();
    }

    @Override
    public String getState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.getMap() == null ? "null" : this.getMap().getIdentifier()).append(this.getPosition().x).append(this.getPosition().y);
        se.append(this.faceDown);
        SequenceEncoder se2 = new SequenceEncoder(',');
        this.asList().forEach(gamePiece -> se2.append(gamePiece.getId()));
        if (se2.getValue() != null) {
            se.append(se2.getValue());
        }
        return se.getValue();
    }

    @Override
    public void setState(String state) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(state, ';');
        String mapId = st.nextToken();
        this.setPosition(new Point(st.nextInt(0), st.nextInt(0)));
        Map m = null;
        if (!"null".equals(mapId) && (m = Map.getMapById(mapId)) == null) {
            ErrorDialog.dataWarning(new BadDataReport("No such map", mapId, null));
        }
        if (m != this.getMap()) {
            if (m != null) {
                m.addPiece(this);
            } else {
                this.setMap(null);
            }
        }
        this.faceDown = "true".equals(st.nextToken());
        ArrayList<GamePiece> l = new ArrayList<GamePiece>();
        if (st.hasMoreTokens()) {
            SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(st.nextToken(), ',');
            while (st2.hasMoreTokens()) {
                GamePiece p = this.gameModule.getGameState().getPieceForId(st2.nextToken());
                if (p == null) continue;
                l.add(p);
            }
        }
        this.setContents(l);
        this.commands = null;
    }

    public Command setContentsFaceDown(boolean value) {
        ChangeTracker t = new ChangeTracker(this);
        NullCommand c = new NullCommand();
        this.faceDown = value;
        return t.getChangeCommand().append(c).append(this.reportCommand(this.faceDownMsgFormat, value ? Resources.getString("Deck.face_down") : Resources.getString("Deck.face_up")));
    }

    public Command reverse() {
        ArrayList<GamePiece> list = new ArrayList<GamePiece>();
        Iterator<GamePiece> i = this.getPiecesReverseIterator();
        while (i.hasNext()) {
            list.add(i.next());
        }
        return this.setContents(list).append(this.reportCommand(this.reverseMsgFormat, Resources.getString("Deck.reverse")));
    }

    public boolean isDrawOutline() {
        return this.drawOutline;
    }

    public void setOutlineColor(Color outlineColor) {
        this.outlineColor = outlineColor;
    }

    public void setDrawOutline(boolean drawOutline) {
        this.drawOutline = drawOutline;
    }

    public Color getOutlineColor() {
        return this.outlineColor;
    }

    public boolean isFaceDown() {
        return this.faceDown;
    }

    @Override
    public Command pieceAdded(GamePiece p) {
        return null;
    }

    @Override
    public Command pieceRemoved(GamePiece p) {
        ChangeTracker tracker = new ChangeTracker(p);
        p.setProperty("ObscuredToOthers", this.isFaceDown() && !this.isDrawFaceUp());
        return tracker.getChangeCommand();
    }

    public void setFaceDown(boolean faceDown) {
        this.faceDown = faceDown;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        GamePiece top;
        int count = Math.min(this.getPieceCount(), this.maxStack);
        GamePiece gamePiece = top = this.nextDraw != null && !this.nextDraw.isEmpty() ? this.nextDraw.get(0) : this.topPiece();
        if (top != null) {
            Object owner = top.getProperty("obs;");
            top.setProperty("obs;", this.faceDown ? NO_USER : null);
            Color blankColor = this.getBlankColor();
            Rectangle r = top.getShape().getBounds();
            r.setLocation(x + (int)(zoom * (double)r.x), y + (int)(zoom * (double)r.y));
            r.setSize((int)(zoom * (double)r.width), (int)(zoom * (double)r.height));
            for (int i = 0; i < count - 1; ++i) {
                if (blankColor != null) {
                    g.setColor(blankColor);
                    g.fillRect(r.x + (int)(zoom * 2.0 * (double)i), r.y - (int)(zoom * 2.0 * (double)i), r.width, r.height);
                    g.setColor(Color.black);
                    g.drawRect(r.x + (int)(zoom * 2.0 * (double)i), r.y - (int)(zoom * 2.0 * (double)i), r.width, r.height);
                    continue;
                }
                if (this.faceDown) {
                    top.draw(g, x + (int)(zoom * 2.0 * (double)i), y - (int)(zoom * 2.0 * (double)i), obs, zoom);
                    continue;
                }
                this.getPieceAt(count - i - 1).draw(g, x + (int)(zoom * 2.0 * (double)i), y - (int)(zoom * 2.0 * (double)i), obs, zoom);
            }
            top.draw(g, x + (int)(zoom * 2.0 * (double)(count - 1)), y - (int)(zoom * 2.0 * (double)(count - 1)), obs, zoom);
            top.setProperty("obs;", owner);
        } else if (this.drawOutline) {
            Rectangle r = this.boundingBox();
            r.setLocation(x + (int)(zoom * (double)r.x), y + (int)(zoom * (double)r.y));
            r.setSize((int)(zoom * (double)r.width), (int)(zoom * (double)r.height));
            g.setColor(this.outlineColor);
            g.drawRect(r.x, r.y, r.width, r.height);
        }
    }

    protected Color getBlankColor() {
        Color c = Color.white;
        if (this.getMap() != null) {
            c = this.getMap().getStackMetrics().getBlankColor();
        }
        return c;
    }

    @Override
    public StackMetrics getStackMetrics() {
        return deckStackMetrics;
    }

    @Override
    public Rectangle boundingBox() {
        GamePiece top = this.topPiece();
        Dimension d = top == null ? this.size : top.getShape().getBounds().getSize();
        Rectangle r = new Rectangle(new Point(), d);
        r.translate(-r.width / 2, -r.height / 2);
        int n = this.getMaximumVisiblePieceCount();
        for (int i = 0; i < n; ++i) {
            r.y -= 2;
            r.height += 2;
            r.width += 2;
        }
        return r;
    }

    @Override
    public Shape getShape() {
        return this.boundingBox();
    }

    @Override
    public Object getProperty(Object key) {
        KeyCommand[] value = null;
        if ("NoStack".equals(key)) {
            value = Boolean.TRUE;
        } else if ("KeyCommands".equals(key)) {
            value = this.getKeyCommands();
        }
        return value;
    }

    protected KeyCommand[] getKeyCommands() {
        if (this.commands == null) {
            KeyCommand c;
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            if (USE_MENU.equals(this.shuffleOption)) {
                c = new KeyCommand(this.shuffleCommand, this.getShuffleKey(), this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.gameModule.sendAndLog(Deck.this.shuffle());
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
            }
            if (this.reshuffleCommand.length() > 0) {
                c = new KeyCommand(this.reshuffleCommand, this.getReshuffleKey(), this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent evt) {
                        Deck.this.gameModule.sendAndLog(Deck.this.sendToDeck());
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
            }
            if (USE_MENU.equals(this.faceDownOption)) {
                KeyCommand faceDownAction = new KeyCommand(this.faceDown ? Resources.getString("Deck.face_up") : Resources.getString("Deck.face_down"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Command c = Deck.this.setContentsFaceDown(!Deck.this.faceDown);
                        Deck.this.gameModule.sendAndLog(c);
                        Deck.this.repaintMap();
                    }
                };
                l.add(faceDownAction);
            }
            if (this.reversible) {
                c = new KeyCommand(this.reverseCommand, NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Command c = Deck.this.reverse();
                        Deck.this.gameModule.sendAndLog(c);
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
            }
            if (this.allowMultipleDraw) {
                c = new KeyCommand(Resources.getString("Deck.draw_multiple"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.promptForDragCount();
                    }
                };
                l.add(c);
            }
            if (this.allowSelectDraw) {
                c = new KeyCommand(Resources.getString("Deck.draw_specific"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.promptForNextDraw();
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
            }
            if (this.persistable) {
                c = new KeyCommand(Resources.getString("General.save"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.gameModule.sendAndLog(Deck.this.saveDeck());
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
                c = new KeyCommand(Resources.getString("General.load"), NamedKeyStroke.NULL_KEYSTROKE, this){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Deck.this.gameModule.sendAndLog(Deck.this.loadDeck());
                        Deck.this.repaintMap();
                    }
                };
                l.add(c);
            }
            for (DeckGlobalKeyCommand cmd : this.globalCommands) {
                l.add(cmd.getKeyCommand(this));
            }
            this.commands = l.toArray(new KeyCommand[0]);
        }
        for (KeyCommand command : this.commands) {
            if (Resources.getString("Deck.face_up").equals(command.getValue("Name")) && !this.faceDown) {
                command.putValue("Name", Resources.getString("Deck.face_down"));
                continue;
            }
            if (!Resources.getString("Deck.face_down").equals(command.getValue("Name")) || !this.faceDown) continue;
            command.putValue("Name", Resources.getString("Deck.face_up"));
        }
        return this.commands;
    }

    protected Command reportCommand(String format, String commandName) {
        Chatter.DisplayText c = null;
        FormattedString reportFormat = new FormattedString(format);
        reportFormat.setProperty("deckName", this.getLocalizedDeckName());
        reportFormat.setProperty("commandName", commandName);
        String rep = reportFormat.getLocalizedText();
        if (rep.length() > 0) {
            c = new Chatter.DisplayText(this.gameModule.getChatter(), "* " + rep);
            c.execute();
        }
        return c;
    }

    public void promptForDragCount() {
        String s;
        while ((s = JOptionPane.showInputDialog(Resources.getString("Deck.enter_the_number"))) != null) {
            try {
                this.dragCount = Integer.parseInt(s);
                this.dragCount = Math.min(this.dragCount, this.getPieceCount());
                if (this.dragCount < 0) continue;
                break;
            }
            catch (NumberFormatException numberFormatException) {
            }
        }
    }

    protected void promptForNextDraw() {
        JDialog d = new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.map.getView()), true);
        d.setTitle(Resources.getString("Deck.draw"));
        d.setLayout(new BoxLayout(d.getContentPane(), 1));
        class AvailablePiece
        implements Comparable<AvailablePiece> {
            private final GamePiece piece;

            public AvailablePiece(GamePiece piece) {
                this.piece = piece;
            }

            @Override
            public int compareTo(AvailablePiece other) {
                if (other == null) {
                    return 1;
                }
                String otherProperty = (String)other.piece.getProperty(Deck.this.selectSortProperty);
                if (otherProperty == null) {
                    return 1;
                }
                String myProperty = (String)this.piece.getProperty(Deck.this.selectSortProperty);
                if (myProperty == null) {
                    return -1;
                }
                return -otherProperty.compareTo(myProperty);
            }

            public String toString() {
                return Deck.this.selectDisplayProperty.getText(this.piece);
            }

            public boolean equals(Object o) {
                if (!(o instanceof AvailablePiece)) {
                    return false;
                }
                return ((AvailablePiece)o).piece.equals(this.piece);
            }
        }
        Object[] pieces = new AvailablePiece[this.getPieceCount()];
        for (int i = 0; i < pieces.length; ++i) {
            pieces[pieces.length - i - 1] = new AvailablePiece(this.getPieceAt(i));
        }
        if (this.selectSortProperty != null && this.selectSortProperty.length() > 0) {
            Arrays.sort(pieces);
        }
        JList<AvailablePiece> list = new JList<AvailablePiece>(pieces);
        list.setSelectionMode(2);
        d.add(new ScrollPane(list));
        d.add(new JLabel(Resources.getString("Deck.select_cards")));
        d.add(new JLabel(Resources.getString("Deck.then_click")));
        Box box = Box.createHorizontalBox();
        JButton b = new JButton(Resources.getString("General.ok"));
        b.addActionListener(arg_0 -> this.lambda$promptForNextDraw$5(list, (AvailablePiece[])pieces, d, arg_0));
        box.add(b);
        b = new JButton(Resources.getString("General.cancel"));
        b.addActionListener(e -> d.dispose());
        box.add(b);
        d.add(box);
        d.pack();
        d.setLocationRelativeTo(d.getOwner());
        d.setVisible(true);
    }

    public Command sendToDeck() {
        Command c = null;
        this.nextDraw = null;
        DrawPile target = DrawPile.findDrawPile(this.reshuffleTarget);
        if (target != null) {
            int cnt;
            if (this.reshuffleMsgFormat.length() > 0) {
                c = this.reportCommand(this.reshuffleMsgFormat, this.reshuffleCommand);
                if (c == null) {
                    c = new NullCommand();
                }
            } else {
                c = new NullCommand();
            }
            for (int i = cnt = this.getPieceCount() - 1; i >= 0; --i) {
                c.append(target.addToContents(this.getPieceAt(i)));
            }
        }
        return c;
    }

    @Override
    public boolean isExpanded() {
        return false;
    }

    public boolean isPersistable() {
        return this.persistable;
    }

    public void setPersistable(boolean persistable) {
        this.persistable = persistable;
    }

    private File getSaveFileName() {
        Object name;
        int index;
        FileChooser fc = this.gameModule.getFileChooser();
        File sf = fc.getSelectedFile();
        if (sf != null && (index = ((String)(name = sf.getPath())).lastIndexOf(46)) > 0) {
            name = ((String)name).substring(0, index) + ".sav";
            fc.setSelectedFile(new File((String)name));
        }
        if (fc.showSaveDialog(this.map.getView()) != 0) {
            return null;
        }
        File outputFile = fc.getSelectedFile();
        if (outputFile != null && outputFile.exists() && this.shouldConfirmOverwrite() && 1 == JOptionPane.showConfirmDialog(this.gameModule.getPlayerWindow(), Resources.getString("Deck.overwrite", outputFile.getName()), Resources.getString("Deck.file_exists"), 0)) {
            outputFile = null;
        }
        return outputFile;
    }

    private boolean shouldConfirmOverwrite() {
        return System.getProperty("os.name").trim().equalsIgnoreCase("linux");
    }

    private Command saveDeck() {
        NullCommand c = new NullCommand();
        this.gameModule.warn(Resources.getString("Deck.saving_deck"));
        File saveFile = this.getSaveFileName();
        try {
            if (saveFile != null) {
                this.saveDeck(saveFile);
                this.gameModule.warn(Resources.getString("Deck.deck_saved"));
            } else {
                this.gameModule.warn(Resources.getString("Deck.save_canceled"));
            }
        }
        catch (IOException e) {
            WriteErrorDialog.error(e, saveFile);
        }
        return c;
    }

    public void saveDeck(File f) throws IOException {
        Command comm = new LoadDeckCommand(null);
        for (GamePiece p : this.asList()) {
            p.setMap(null);
            comm = comm.append(new AddPiece(p));
        }
        try (BufferedWriter w = Files.newBufferedWriter(f.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
            this.gameModule.addCommandEncoder(this.commandEncoder);
            w.write(this.gameModule.encode(comm));
            this.gameModule.removeCommandEncoder(this.commandEncoder);
        }
    }

    private File getLoadFileName() {
        FileChooser fc = this.gameModule.getFileChooser();
        fc.selectDotSavFile();
        if (fc.showOpenDialog(this.map.getView()) != 0) {
            return null;
        }
        return fc.getSelectedFile();
    }

    private Command loadDeck() {
        Command c = new NullCommand();
        this.gameModule.warn(Resources.getString("Deck.loading_deck"));
        File loadFile = this.getLoadFileName();
        try {
            if (loadFile != null) {
                c = this.loadDeck(loadFile);
                this.gameModule.warn(Resources.getString("Deck.deck_loaded"));
            } else {
                this.gameModule.warn(Resources.getString("Deck.load_canceled"));
            }
        }
        catch (IOException e) {
            ReadErrorDialog.error(e, loadFile);
        }
        return c;
    }

    public Command loadDeck(File f) throws IOException {
        String ds = Files.readString(f.toPath(), StandardCharsets.UTF_8);
        this.gameModule.addCommandEncoder(this.commandEncoder);
        Command c = this.gameModule.decode(ds);
        this.gameModule.removeCommandEncoder(this.commandEncoder);
        if (c instanceof LoadDeckCommand) {
            ChangeTracker t = new ChangeTracker(this);
            c.execute();
            Command[] sub = c.getSubCommands();
            c = new NullCommand();
            for (Command command : sub) {
                c.append(command);
            }
            c.append(t.getChangeCommand());
            this.updateCountsAll();
        } else {
            this.gameModule.warn(Resources.getString("Deck.not_a_saved_deck", f.getName()));
            c = null;
        }
        return c;
    }

    public int getDragCount() {
        return this.dragCount;
    }

    public void setDragCount(int dragCount) {
        this.dragCount = dragCount;
    }

    public void setSelectDisplayProperty(String promptDisplayProperty) {
        this.selectDisplayProperty.setFormat(promptDisplayProperty);
    }

    public void setSelectSortProperty(String promptSortProperty) {
        this.selectSortProperty = promptSortProperty;
    }

    public String getSelectDisplayProperty() {
        return this.selectDisplayProperty.getFormat();
    }

    public String getSelectSortProperty() {
        return this.selectSortProperty;
    }

    protected void repaintMap() {
        if (this.map != null) {
            this.map.repaint();
        }
    }

    private /* synthetic */ void lambda$promptForNextDraw$5(JList list, 1AvailablePiece[] pieces, JDialog d, ActionEvent e) {
        int[] selection = list.getSelectedIndices();
        if (selection.length > 0) {
            this.nextDraw = new ArrayList<GamePiece>();
            for (int value : selection) {
                this.nextDraw.add(pieces[value].piece);
            }
        } else {
            this.nextDraw = null;
        }
        d.dispose();
    }

    public static class CountExpression {
        private String fullstring;
        private String name;
        private String expression;

        public CountExpression(String expressionString) {
            String[] split = expressionString.split("\\s*:\\s*", 2);
            if (split.length == 2) {
                this.name = split[0];
                this.expression = split[1];
                this.fullstring = expressionString;
            }
        }

        public String getName() {
            return this.name;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getFullString() {
            return this.fullstring;
        }
    }

    protected static class LoadDeckCommand
    extends Command {
        public static final String PREFIX = "DECK\t";
        private final Deck target;

        public LoadDeckCommand(Deck target) {
            this.target = target;
        }

        @Override
        protected void executeCommand() {
            Command[] sub;
            this.target.removeAll();
            for (Command command : sub = this.getSubCommands()) {
                if (!(command instanceof AddPiece)) continue;
                GamePiece p = ((AddPiece)command).getTarget();
                p.setId(null);
                this.target.add(p);
            }
        }

        public String getTargetId() {
            return this.target == null ? "" : this.target.getId();
        }

        @Override
        protected Command myUndoCommand() {
            return null;
        }
    }
}

