/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyNameExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MultiImagePicker;
import VASSAL.counters.PieceEditor;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.script.expression.Expression;
import VASSAL.script.expression.ExpressionException;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.icon.IconFactory;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.imageop.ScaledImagePainter;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.KeyStroke;
import net.miginfocom.swing.MigLayout;

public class Embellishment
extends Decorator
implements TranslatablePiece {
    public static final String OLD_ID = "emb;";
    public static final String ID = "emb2;";
    public static final String IMAGE = "_Image";
    public static final String NAME = "_Name";
    public static final String LEVEL = "_Level";
    public static final String ACTIVE = "_Active";
    protected String activateKey = "";
    protected String upKey;
    protected String downKey;
    protected int activateModifiers;
    protected int upModifiers;
    protected int downModifiers;
    protected String upCommand;
    protected String downCommand;
    protected String activateCommand;
    protected String resetCommand;
    protected FormattedString resetLevel = new FormattedString("1");
    protected boolean loopLevels;
    protected NamedKeyStroke resetKey;
    protected boolean followProperty;
    protected String propertyName = "";
    protected Expression followPropertyExpression;
    protected int firstLevelValue;
    protected NamedKeyStroke rndKey;
    private String rndText = "";
    protected int value = -1;
    protected int nValues;
    protected int xOff;
    protected int yOff;
    protected String[] imageName;
    protected String[] commonName;
    protected Rectangle[] size;
    protected ScaledImagePainter[] imagePainter;
    protected boolean drawUnderneathWhenSelected = false;
    protected String name = "";
    protected KeyCommand[] commands;
    protected KeyCommand up = null;
    protected KeyCommand down = null;
    protected Rectangle lastBounds = null;
    protected Area lastShape = null;
    public static final int BASE_VERSION = 0;
    public static final int CURRENT_VERSION = 1;
    protected int version;
    protected boolean alwaysActive;
    protected NamedKeyStroke activateKeyStroke;
    protected NamedKeyStroke increaseKeyStroke;
    protected NamedKeyStroke decreaseKeyStroke;

    public Embellishment() {
        this(ID + Resources.getString("Editor.Embellishment.activate"), null);
    }

    public Embellishment(String type, GamePiece d) {
        this.mySetType(type);
        this.setInner(d);
    }

    public boolean isActive() {
        return this.value > 0;
    }

    public void setActive(boolean act) {
        this.value = Math.abs(this.value) * (act ? 1 : -1);
    }

    public int getValue() {
        return Math.abs(this.value) - 1;
    }

    public void setValue(int val) {
        int theVal = val;
        if (val >= this.nValues) {
            Embellishment.reportDataError(this, Resources.getString("Error.bad_layer"), "Layer=" + val);
            theVal = this.nValues;
        }
        this.value = this.value > 0 ? theVal + 1 : -theVal - 1;
    }

    @Override
    public void mySetType(String s) {
        if (!s.startsWith(ID)) {
            this.originalSetType(s);
        } else {
            s = s.substring(ID.length());
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
            this.activateCommand = st.nextToken("");
            this.activateModifiers = st.nextInt(128);
            this.activateKey = st.nextToken("A");
            this.upCommand = st.nextToken("");
            this.upModifiers = st.nextInt(128);
            this.upKey = st.nextToken("");
            this.downCommand = st.nextToken("");
            this.downModifiers = st.nextInt(128);
            this.downKey = st.nextToken("");
            this.resetCommand = st.nextToken("");
            this.resetKey = st.nextNamedKeyStroke();
            this.resetLevel = new FormattedString(st.nextToken("1"));
            this.drawUnderneathWhenSelected = st.nextBoolean(false);
            this.xOff = st.nextInt(0);
            this.yOff = st.nextInt(0);
            this.imageName = st.nextStringArray(1);
            this.commonName = st.nextStringArray(this.imageName.length);
            this.loopLevels = st.nextBoolean(true);
            this.name = st.nextToken("");
            this.rndKey = st.nextNamedKeyStroke(null);
            this.rndText = st.nextToken("");
            this.followProperty = st.nextBoolean(false);
            this.propertyName = st.nextToken("");
            this.firstLevelValue = st.nextInt(1);
            this.version = st.nextInt(0);
            this.alwaysActive = st.nextBoolean(false);
            this.activateKeyStroke = st.nextNamedKeyStroke();
            this.increaseKeyStroke = st.nextNamedKeyStroke();
            this.decreaseKeyStroke = st.nextNamedKeyStroke();
            if (this.version == 0) {
                boolean bl = this.alwaysActive = this.activateKey.length() == 0;
                if (this.activateKey.length() <= 1 && this.upKey.length() <= 1 && this.downKey.length() <= 1) {
                    this.activateKeyStroke = this.activateKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.activateKey.charAt(0), this.activateModifiers);
                    this.increaseKeyStroke = this.upKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.upKey.charAt(0), this.upModifiers);
                    this.decreaseKeyStroke = this.downKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.downKey.charAt(0), this.downModifiers);
                    this.version = 1;
                }
            }
            this.value = this.canBeActivated() ? -1 : 1;
            this.nValues = this.imageName.length;
            this.size = new Rectangle[this.imageName.length];
            this.imagePainter = new ScaledImagePainter[this.imageName.length];
            for (int i = 0; i < this.imageName.length; ++i) {
                this.imagePainter[i] = new ScaledImagePainter();
                this.imagePainter[i].setImageName(this.imageName[i]);
            }
        }
        this.commands = null;
    }

    public boolean canBeActivated() {
        return this.getVersion() == 0 ? this.activateKey.length() > 0 : !this.alwaysActive;
    }

    private void originalSetType(String s) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        st.nextToken();
        SequenceEncoder.Decoder st2 = new SequenceEncoder.Decoder(st.nextToken(), ';');
        this.activateKey = st2.nextToken().toUpperCase();
        if (this.activateKey.length() > 0) {
            this.activateKeyStroke = new NamedKeyStroke(KeyStroke.getKeyStroke(this.activateKey));
        }
        this.activateModifiers = 128;
        if (st2.hasMoreTokens()) {
            this.resetCommand = st2.nextToken();
            this.resetKey = st2.nextNamedKeyStroke(null);
            this.resetLevel.setFormat(st2.nextToken("0"));
        } else {
            this.resetKey = null;
            this.resetCommand = "";
            this.resetLevel.setFormat("0");
        }
        this.activateCommand = st.nextToken();
        this.drawUnderneathWhenSelected = this.activateCommand.startsWith("_");
        if (this.drawUnderneathWhenSelected) {
            this.activateCommand = this.activateCommand.substring(1);
        }
        this.value = this.activateKey.length() > 0 ? -1 : 1;
        this.upKey = st.nextToken().toUpperCase();
        this.upCommand = st.nextToken();
        this.upModifiers = 128;
        this.downKey = st.nextToken().toUpperCase();
        this.downCommand = st.nextToken();
        this.downModifiers = 128;
        this.xOff = st.nextInt(0);
        this.yOff = st.nextInt(0);
        ArrayList<String> l = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            l.add(st.nextToken());
        }
        this.nValues = l.size();
        this.imageName = new String[l.size()];
        this.commonName = new String[l.size()];
        this.size = new Rectangle[this.imageName.length];
        this.imagePainter = new ScaledImagePainter[this.imageName.length];
        for (int i = 0; i < this.imageName.length; ++i) {
            String sub = (String)l.get(i);
            SequenceEncoder.Decoder subSt = new SequenceEncoder.Decoder(sub, ',');
            this.imageName[i] = subSt.nextToken();
            this.imagePainter[i] = new ScaledImagePainter();
            this.imagePainter[i].setImageName(this.imageName[i]);
            if (!subSt.hasMoreTokens()) continue;
            this.commonName[i] = subSt.nextToken();
        }
        this.loopLevels = true;
        this.alwaysActive = this.activateKey.length() == 0;
        this.activateKeyStroke = this.activateKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.activateKey.charAt(0), this.activateModifiers);
        this.increaseKeyStroke = this.upKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.upKey.charAt(0), this.upModifiers);
        this.decreaseKeyStroke = this.downKey.length() == 0 ? NamedKeyStroke.NULL_KEYSTROKE : new NamedKeyStroke(this.downKey.charAt(0), this.downModifiers);
        this.version = 1;
    }

    @Override
    public String getLocalizedName() {
        return this.getName(true);
    }

    @Override
    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean localized) {
        Object ret;
        String cname;
        this.checkPropertyLevel();
        String string = cname = 0 < this.value && this.value - 1 < this.commonName.length ? this.getCommonName(localized, this.value - 1) : null;
        if (cname != null && cname.length() > 0) {
            SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(cname, '+');
            String first = st.nextToken();
            if (st.hasMoreTokens()) {
                String second = st.nextToken();
                ret = first.length() == 0 ? (localized ? this.piece.getLocalizedName() : this.piece.getName()) + second : first + (localized ? this.piece.getLocalizedName() : this.piece.getName());
            } else {
                ret = first;
            }
        } else {
            ret = localized ? this.piece.getLocalizedName() : this.piece.getName();
        }
        return ret;
    }

    public String getLayerName() {
        return this.name == null ? "" : this.name;
    }

    @Override
    public void mySetState(String s) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        this.value = st.nextInt(-1);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.activateCommand).append(this.activateModifiers).append(this.activateKey).append(this.upCommand).append(this.upModifiers).append(this.upKey).append(this.downCommand).append(this.downModifiers).append(this.downKey).append(this.resetCommand).append(this.resetKey).append(this.resetLevel.getFormat()).append(this.drawUnderneathWhenSelected).append(this.xOff).append(this.yOff).append(this.imageName).append(this.commonName).append(this.loopLevels).append(this.name).append(this.rndKey).append(this.rndText).append(this.followProperty).append(this.propertyName).append(this.firstLevelValue).append(this.version).append(this.alwaysActive).append(this.activateKeyStroke).append(this.increaseKeyStroke).append(this.decreaseKeyStroke);
        return ID + se.getValue();
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public String oldGetType() {
        ProblemDialog.showDeprecated("2020-08-06");
        SequenceEncoder se = new SequenceEncoder(';');
        SequenceEncoder se2 = new SequenceEncoder(this.activateKey, ';');
        se2.append(this.resetCommand).append(this.resetKey).append(String.valueOf(this.resetLevel));
        se.append(se2.getValue()).append((String)(this.drawUnderneathWhenSelected ? "_" + this.activateCommand : this.activateCommand)).append(this.upKey).append(this.upCommand).append(this.downKey).append(this.downCommand).append(this.xOff).append(this.yOff);
        for (int i = 0; i < this.nValues; ++i) {
            if (this.commonName[i] != null) {
                SequenceEncoder sub = new SequenceEncoder(this.imageName[i], ',');
                se.append(sub.append(this.commonName[i]).getValue());
                continue;
            }
            se.append(this.imageName[i]);
        }
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        return se.append(String.valueOf(this.value)).getValue();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        boolean drawUnder;
        boolean bl = drawUnder = this.drawUnderneathWhenSelected && Boolean.TRUE.equals(this.getProperty("Selected"));
        if (!drawUnder) {
            this.piece.draw(g, x, y, obs, zoom);
        }
        this.checkPropertyLevel();
        if (!this.isActive()) {
            if (drawUnder) {
                this.piece.draw(g, x, y, obs, zoom);
            }
            return;
        }
        int i = this.value - 1;
        if (i < this.imagePainter.length && this.imagePainter[i] != null) {
            Rectangle r = this.getCurrentImageBounds();
            this.imagePainter[i].draw(g, x + (int)(zoom * (double)r.x), y + (int)(zoom * (double)r.y), zoom, obs);
        }
        if (drawUnder) {
            this.piece.draw(g, x, y, obs, zoom);
        }
    }

    protected void checkPropertyLevel() {
        if (!this.followProperty || this.propertyName.length() == 0) {
            return;
        }
        if (this.followPropertyExpression == null) {
            this.followPropertyExpression = Expression.createSimplePropertyExpression(this.propertyName);
        }
        String val = "";
        try {
            int v;
            val = this.followPropertyExpression.evaluate(Decorator.getOutermost(this));
            if (val == null || val.length() == 0) {
                val = String.valueOf(this.firstLevelValue);
            }
            if ((v = Integer.parseInt(val) - this.firstLevelValue + 1) <= 0) {
                v = 1;
            }
            if (v > this.nValues) {
                v = this.nValues;
            }
            this.value = this.isActive() ? v : -v;
        }
        catch (NumberFormatException e) {
            Embellishment.reportDataError(this, Resources.getString("Error.non_number_error"), "followProperty[" + this.propertyName + "]=" + val, e);
        }
        catch (ExpressionException e) {
            Embellishment.reportDataError(this, Resources.getString("Error.expression_error"), "followProperty[" + this.propertyName + "]", e);
        }
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
            GamePiece outer = Decorator.getOutermost(this);
            if (this.activateCommand != null && this.activateCommand.length() > 0 && !this.alwaysActive) {
                KeyCommand k = new KeyCommand(this.activateCommand, this.activateKeyStroke, outer, (TranslatablePiece)this);
                k.setEnabled(this.nValues > 0);
                l.add(k);
            }
            if (!this.followProperty) {
                if (this.nValues > 1) {
                    if (this.upCommand != null && this.upCommand.length() > 0 && this.increaseKeyStroke != null && !this.increaseKeyStroke.isNull()) {
                        this.up = new KeyCommand(this.upCommand, this.increaseKeyStroke, outer, (TranslatablePiece)this);
                        l.add(this.up);
                    }
                    if (this.downCommand != null && this.downCommand.length() > 0 && this.decreaseKeyStroke != null && !this.decreaseKeyStroke.isNull()) {
                        this.down = new KeyCommand(this.downCommand, this.decreaseKeyStroke, outer, (TranslatablePiece)this);
                        l.add(this.down);
                    }
                }
                if (this.resetKey != null && !this.resetKey.isNull() && this.resetCommand.length() > 0) {
                    l.add(new KeyCommand(this.resetCommand, this.resetKey, outer, (TranslatablePiece)this));
                }
                if (this.rndKey != null && !this.rndKey.isNull() && this.rndText.length() > 0) {
                    l.add(new KeyCommand(this.rndText, this.rndKey, outer, (TranslatablePiece)this));
                }
            }
            this.commands = l.toArray(new KeyCommand[0]);
        }
        if (this.up != null) {
            this.up.setEnabled(this.loopLevels || Math.abs(this.value) < this.imageName.length);
        }
        if (this.down != null) {
            this.down.setEnabled(this.loopLevels || Math.abs(this.value) > 1);
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        ChangeTracker tracker = new ChangeTracker(this);
        if (this.activateKeyStroke.equals(stroke) && this.nValues > 0 && !this.alwaysActive) {
            this.value = -this.value;
        }
        if (!this.followProperty) {
            if (this.increaseKeyStroke.equals(stroke)) {
                this.doIncrease();
            }
            if (this.decreaseKeyStroke.equals(stroke)) {
                this.doDecrease();
            }
            if (this.resetKey != null && this.resetKey.equals(stroke)) {
                GamePiece outer = Decorator.getOutermost(this);
                String levelText = this.resetLevel.getText(outer);
                try {
                    int level = Integer.parseInt(levelText);
                    this.setValue(Math.abs(level) - 1);
                    this.setActive(level > 0);
                }
                catch (NumberFormatException e) {
                    Embellishment.reportDataError(this, Resources.getString("Error.non_number_error"), this.resetLevel.debugInfo(levelText, "resetLevel"), e);
                }
            }
            if (this.rndKey != null && this.rndKey.equals(stroke)) {
                int val = GameModule.getGameModule().getRNG().nextInt(this.nValues) + 1;
                this.value = this.value > 0 ? val : -val;
            }
        }
        return tracker.isChanged() ? tracker.getChangeCommand() : null;
    }

    protected void doIncrease() {
        int val = Math.abs(this.value);
        if (++val > this.nValues) {
            val = this.loopLevels ? 1 : this.nValues;
        }
        this.value = this.value > 0 ? val : -val;
    }

    protected void doDecrease() {
        int val = Math.abs(this.value);
        if (--val < 1) {
            val = this.loopLevels ? this.nValues : 1;
        }
        this.value = this.value > 0 ? val : -val;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected Image getCurrentImage() {
        ProblemDialog.showDeprecated("2020-08-06");
        if (this.value <= 0 || this.imageName[this.value - 1] == null || this.imageName[this.value - 1].length() == 0 || this.imagePainter[this.value - 1] == null || this.imagePainter[this.value - 1].getSource() == null) {
            return null;
        }
        return this.imagePainter[this.value - 1].getSource().getImage();
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r = this.piece.boundingBox();
        if (this.value > 0) {
            r.add(this.getCurrentImageBounds());
        }
        return r;
    }

    public Rectangle getCurrentImageBounds() {
        if (this.value > 0) {
            int i = this.value - 1;
            if (i >= this.size.length) {
                return new Rectangle();
            }
            if (this.size[i] == null) {
                if (this.imagePainter[i] != null) {
                    this.size[i] = ImageUtils.getBounds(this.imagePainter[i].getImageSize());
                    this.size[i].translate(this.xOff, this.yOff);
                } else {
                    this.size[i] = new Rectangle();
                }
            }
            return this.size[i];
        }
        return new Rectangle();
    }

    @Override
    public Shape getShape() {
        Shape innerShape = this.piece.getShape();
        if (this.value > 0 && !this.drawUnderneathWhenSelected) {
            Rectangle r = this.getCurrentImageBounds();
            if (innerShape.contains(r.x, r.y, r.width, r.height)) {
                return innerShape;
            }
            Area a = new Area(innerShape);
            if (!r.equals(this.lastBounds)) {
                this.lastShape = new Area(r);
                this.lastBounds = new Rectangle(r);
            }
            a.add(this.lastShape);
            return a;
        }
        return innerShape;
    }

    @Override
    public String getDescription() {
        String displayName = this.name;
        if ((this.name == null || this.name.length() == 0) && this.imageName.length > 0 && this.imageName[0] != null && this.imageName[0].length() > 0) {
            displayName = this.imageName[0];
        }
        return Resources.getString("Editor.Embellishment.trait_description") + (String)(displayName == null || displayName.isEmpty() ? "" : " - " + displayName);
    }

    @Override
    public Object getProperty(Object key) {
        if (key.equals(this.name + IMAGE)) {
            this.checkPropertyLevel();
            return this.value > 0 ? this.imageName[this.value - 1] : "";
        }
        if (key.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            return this.value > 0 ? this.strip(this.commonName[this.value - 1]) : "";
        }
        if (key.equals(this.name + LEVEL)) {
            this.checkPropertyLevel();
            return String.valueOf(this.value);
        }
        if (key.equals(this.name + ACTIVE)) {
            return String.valueOf(this.isActive());
        }
        if (key.equals("visibleState")) {
            this.checkPropertyLevel();
            Object s = String.valueOf(super.getProperty(key));
            s = (String)s + this.value;
            if (this.drawUnderneathWhenSelected) {
                s = (String)s + this.getProperty("Selected");
            }
            return s;
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (key.equals(this.name + IMAGE) || key.equals(this.name + LEVEL) || key.equals(this.name + ACTIVE) || key.equals("visibleState")) {
            return this.getProperty(key);
        }
        if (key.equals(this.name + NAME)) {
            this.checkPropertyLevel();
            return this.value > 0 ? this.strip(this.getLocalizedCommonName(this.value - 1)) : "";
        }
        return super.getLocalizedProperty(key);
    }

    protected String strip(String s) {
        if (s == null) {
            return null;
        }
        if (s.startsWith("+")) {
            return s.substring(1);
        }
        if (s.endsWith("+")) {
            return s.substring(0, s.length() - 1);
        }
        return s;
    }

    protected String getCommonName(boolean localized, int i) {
        return localized ? this.getLocalizedCommonName(i) : this.commonName[i];
    }

    protected String getLocalizedCommonName(int i) {
        String cname = this.commonName[i];
        if (cname == null) {
            return null;
        }
        String translation = this.getTranslation(this.strip(cname));
        if (cname.startsWith("+")) {
            return "+" + translation;
        }
        if (cname.endsWith("+")) {
            return translation + "+";
        }
        return translation;
    }

    @Override
    public List<String> getExpressionList() {
        if (this.followProperty) {
            return List.of(this.propertyName);
        }
        return Collections.emptyList();
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>();
        if (!this.alwaysActive) {
            l.add(this.activateKeyStroke);
        }
        if (!this.followProperty) {
            l.add(this.increaseKeyStroke);
            l.add(this.decreaseKeyStroke);
            l.add(this.resetKey);
            l.add(this.rndKey);
        }
        return l;
    }

    @Override
    public List<String> getMenuTextList() {
        ArrayList<String> l = new ArrayList<String>();
        if (!this.alwaysActive) {
            l.add(this.activateCommand);
        }
        if (!this.followProperty) {
            l.add(this.upCommand);
            l.add(this.downCommand);
            l.add(this.resetCommand);
        }
        return l;
    }

    @Override
    public List<String> getFormattedStringList() {
        if (!this.followProperty) {
            return List.of(this.resetLevel.getFormat());
        }
        return Collections.emptyList();
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Layer.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    public int getVersion() {
        return this.version;
    }

    public static Embellishment getLayerWithMatchingActivateCommand(GamePiece piece, KeyStroke stroke, boolean active) {
        Embellishment layer = (Embellishment)Decorator.getDecorator(piece, Embellishment.class);
        while (layer != null) {
            for (int i = 0; i < layer.activateKey.length(); ++i) {
                if (!stroke.equals(KeyStroke.getKeyStroke((int)layer.activateKey.charAt(i), layer.activateModifiers))) continue;
                if (active && layer.isActive()) {
                    return layer;
                }
                if (active || layer.isActive()) break;
                return layer;
            }
            layer = (Embellishment)Decorator.getDecorator(layer.piece, Embellishment.class);
        }
        return null;
    }

    public static Embellishment getLayerWithMatchingActivateCommand(GamePiece piece, NamedKeyStroke stroke, boolean active) {
        return Embellishment.getLayerWithMatchingActivateCommand(piece, stroke.getKeyStroke(), active);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.name + IMAGE);
        l.add(this.name + LEVEL);
        l.add(this.name + ACTIVE);
        l.add(this.name + NAME);
        return l;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Embellishment)) {
            return false;
        }
        Embellishment c = (Embellishment)o;
        if (!Objects.equals(this.value, c.value)) {
            return false;
        }
        if (!Objects.equals(this.activateCommand, c.activateCommand)) {
            return false;
        }
        if (!Objects.equals(this.activateModifiers, c.activateModifiers)) {
            return false;
        }
        if (!Objects.equals(this.activateKey, c.activateKey)) {
            return false;
        }
        if (!Objects.equals(this.upCommand, c.upCommand)) {
            return false;
        }
        if (!Objects.equals(this.upModifiers, c.upModifiers)) {
            return false;
        }
        if (!Objects.equals(this.upKey, c.upKey)) {
            return false;
        }
        if (!Objects.equals(this.downCommand, c.downCommand)) {
            return false;
        }
        if (!Objects.equals(this.downModifiers, c.downModifiers)) {
            return false;
        }
        if (!Objects.equals(this.downKey, c.downKey)) {
            return false;
        }
        if (!Objects.equals(this.resetCommand, c.resetCommand)) {
            return false;
        }
        if (!Objects.equals(this.resetKey, c.resetKey)) {
            return false;
        }
        if (!Objects.equals(this.resetLevel.getFormat(), c.resetLevel.getFormat())) {
            return false;
        }
        if (!Objects.equals(this.drawUnderneathWhenSelected, c.drawUnderneathWhenSelected)) {
            return false;
        }
        if (!Objects.equals(this.xOff, c.xOff)) {
            return false;
        }
        if (!Objects.equals(this.yOff, c.yOff)) {
            return false;
        }
        if (!Arrays.equals(this.imageName, c.imageName)) {
            return false;
        }
        if (!Arrays.equals(this.commonName, c.commonName)) {
            return false;
        }
        if (!Objects.equals(this.loopLevels, c.loopLevels)) {
            return false;
        }
        if (!Objects.equals(this.name, c.name)) {
            return false;
        }
        if (!Objects.equals(this.rndKey, c.rndKey)) {
            return false;
        }
        if (!Objects.equals(this.rndText, c.rndText)) {
            return false;
        }
        if (!Objects.equals(this.followProperty, c.followProperty)) {
            return false;
        }
        if (!Objects.equals(this.propertyName, c.propertyName)) {
            return false;
        }
        if (!Objects.equals(this.firstLevelValue, c.firstLevelValue)) {
            return false;
        }
        if (!Objects.equals(this.version, c.version)) {
            return false;
        }
        if (!Objects.equals(this.alwaysActive, c.alwaysActive)) {
            return false;
        }
        if (!Objects.equals(this.activateKeyStroke, c.activateKeyStroke)) {
            return false;
        }
        if (!Objects.equals(this.increaseKeyStroke, c.increaseKeyStroke)) {
            return false;
        }
        return Objects.equals(this.decreaseKeyStroke, c.decreaseKeyStroke);
    }

    @Override
    public PieceI18nData getI18nData() {
        String prefix;
        PieceI18nData data = new PieceI18nData(this);
        String string = prefix = this.name.length() > 0 ? this.name + ": " : "";
        if (this.canBeActivated()) {
            data.add(this.activateCommand, prefix + Resources.getString("Editor.Embellishment.activate_command"));
        }
        if (!this.followProperty) {
            data.add(this.upCommand, prefix + Resources.getString("Editor.Embellishment.increase_command"));
            data.add(this.downCommand, prefix + Resources.getString("Editor.Embellishment.decrease_command"));
            data.add(this.resetCommand, prefix + Resources.getString("Editor.Embellishment.reset_command"));
            data.add(this.rndText, prefix + Resources.getString("Editor.Embellishment.random_command"));
        }
        for (int i = 0; i < this.commonName.length; ++i) {
            data.add(this.strip(this.commonName[i]), prefix + Resources.getString("Editor.Embellishment.level_name_description", i + 1));
        }
        return data;
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        Collections.addAll(s, this.imageName);
    }

    protected static class Ed
    implements PieceEditor {
        private final MultiImagePicker images;
        private final StringConfigurer activateCommand;
        private final StringConfigurer upCommand;
        private final StringConfigurer downCommand;
        private final StringConfigurer rndCommand;
        private final IntConfigurer xOffInput = new IntConfigurer(0);
        private final IntConfigurer yOffInput = new IntConfigurer(0);
        private final StringConfigurer levelNameInput = new StringConfigurer("");
        private final JRadioButton prefix = new JRadioButton(Resources.getString("Editor.Embellishment.is_prefix"));
        private final JRadioButton suffix = new JRadioButton(Resources.getString("Editor.Embellishment.is_suffix"));
        private final JCheckBox drawUnderneath = new JCheckBox();
        private final JLabel resetLevelLabel = new JLabel(Resources.getString("Editor.Embellishment.level_number"));
        private final FormattedExpressionConfigurer resetLevel = new FormattedExpressionConfigurer("");
        private final StringConfigurer resetCommand;
        private final JCheckBox loop = new JCheckBox();
        private final JPanel controls;
        private List<String> names;
        private List<Integer> isPrefix;
        private static final Integer NEITHER = 0;
        private static final Integer PREFIX = 1;
        private static final Integer SUFFIX = 2;
        private final BooleanConfigurer followConfig;
        private final JLabel propertyLabel;
        private final PropertyNameExpressionConfigurer propertyConfig;
        private final JLabel levelLabel;
        private final IntConfigurer firstLevelConfig;
        private final StringConfigurer nameConfig;
        private final JButton up;
        private final JButton down;
        private final int version;
        private final BooleanConfigurer alwaysActiveConfig;
        private final NamedHotKeyConfigurer activateConfig;
        private final NamedHotKeyConfigurer increaseConfig;
        private final NamedHotKeyConfigurer decreaseConfig;
        private final NamedHotKeyConfigurer resetConfig;
        private final NamedHotKeyConfigurer rndKeyConfig;
        private final JLabel activateLabel;
        private final JLabel increaseLabel;
        private final JLabel decreaseLabel;
        private final JLabel resetLabel;
        private final JLabel rndLabel;
        private final JLabel actionLabel;
        private final JLabel menuLabel;
        private final JLabel keyLabel;

        public Ed(Embellishment e) {
            this.version = e.version;
            this.controls = new JPanel();
            this.controls.setLayout((LayoutManager)new MigLayout("hidemode 2,fillx,gapy 4", "[grow 0]rel[]rel[]rel[grow 0]"));
            this.nameConfig = new StringConfigurer(e.getName());
            this.controls.add(new JLabel(Resources.getString("Editor.name_label")));
            this.controls.add(this.nameConfig.getControls(), "span 3,wrap,growx");
            this.alwaysActiveConfig = new BooleanConfigurer(e.alwaysActive);
            this.alwaysActiveConfig.addPropertyChangeListener(evt -> this.showHideFields());
            this.controls.add(new JLabel(Resources.getString("Editor.Embellishment.always_active")));
            this.controls.add(this.alwaysActiveConfig.getControls(), "wrap");
            this.controls.add(new JLabel(Resources.getString("Editor.Embellishment.underneath_when_highlighted")));
            this.controls.add((Component)this.drawUnderneath, "wrap");
            this.controls.add(new JLabel(Resources.getString("Editor.Embellishment.loop_through_levels")));
            this.controls.add((Component)this.loop, "wrap");
            JPanel offsetControls = new JPanel((LayoutManager)new MigLayout("ins 0", "[]2[]2[]"));
            offsetControls.add(this.xOffInput.getControls());
            offsetControls.add(new JLabel(","));
            offsetControls.add(this.yOffInput.getControls());
            this.controls.add(new JLabel(Resources.getString("Editor.Embellishment.offset")));
            this.controls.add((Component)offsetControls, "wrap");
            this.followConfig = new BooleanConfigurer(e.followProperty);
            this.controls.add(new JLabel(Resources.getString("Editor.Embellishment.levels_follow_expression_value")));
            this.controls.add(this.followConfig.getControls(), "span 2,split 3");
            JPanel levelBox = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]rel[]rel[]"));
            this.propertyLabel = new JLabel(Resources.getString("Editor.Embellishment.follow_expression"));
            this.propertyConfig = new PropertyNameExpressionConfigurer("");
            levelBox.add(this.propertyConfig.getControls(), "growx");
            this.firstLevelConfig = new IntConfigurer(e.firstLevelValue);
            this.levelLabel = new JLabel(Resources.getString("Editor.Embellishment.level_1"));
            levelBox.add(this.levelLabel);
            levelBox.add(this.firstLevelConfig.getControls());
            this.controls.add((Component)this.propertyLabel, "gapleft 10");
            this.controls.add((Component)levelBox, "grow,wrap");
            this.followConfig.addPropertyChangeListener(e1 -> this.showHideFields());
            this.actionLabel = new JLabel(Resources.getString("Editor.Embellishment.action"));
            Font defaultFont = this.actionLabel.getFont();
            Font boldFont = new Font(defaultFont.getFamily(), 1, defaultFont.getSize());
            this.actionLabel.setFont(boldFont);
            this.controls.add(this.actionLabel);
            this.menuLabel = new JLabel(Resources.getString("Editor.menu_command"));
            this.menuLabel.setFont(boldFont);
            this.controls.add((Component)this.menuLabel, "align center");
            this.keyLabel = new JLabel(Resources.getString("Editor.keyboard_command"));
            this.keyLabel.setFont(boldFont);
            this.controls.add((Component)this.keyLabel, "align center,wrap");
            this.activateConfig = new NamedHotKeyConfigurer(null, "", e.activateKeyStroke);
            this.increaseConfig = new NamedHotKeyConfigurer(null, "", e.increaseKeyStroke);
            this.decreaseConfig = new NamedHotKeyConfigurer(null, "", e.decreaseKeyStroke);
            this.resetConfig = new NamedHotKeyConfigurer(null, "", e.resetKey);
            this.rndKeyConfig = new NamedHotKeyConfigurer(null, "", e.rndKey);
            this.activateLabel = new JLabel(Resources.getString("Editor.Embellishment.activate_layer"));
            this.controls.add(this.activateLabel);
            this.activateCommand = new StringConfigurer(e.activateCommand);
            this.controls.add(this.activateCommand.getControls(), "grow 1");
            this.controls.add(this.activateConfig.getControls(), "grow 2,wrap");
            this.increaseLabel = new JLabel(Resources.getString("Editor.Embellishment.increase_level"));
            this.controls.add(this.increaseLabel);
            this.upCommand = new StringConfigurer(e.upCommand);
            this.controls.add(this.upCommand.getControls(), "grow 1");
            this.controls.add(this.increaseConfig.getControls(), "grow 2,wrap");
            this.decreaseLabel = new JLabel(Resources.getString("Editor.Embellishment.decrease_level"));
            this.controls.add(this.decreaseLabel);
            this.downCommand = new StringConfigurer(e.downCommand);
            this.controls.add(this.downCommand.getControls(), "grow 1");
            this.controls.add(this.decreaseConfig.getControls(), "grow 2,wrap");
            this.resetLabel = new JLabel(Resources.getString("Editor.Embellishment.reset_to_level"));
            this.controls.add(this.resetLabel);
            this.resetCommand = new StringConfigurer(e.resetCommand);
            this.controls.add(this.resetCommand.getControls(), "grow 1");
            this.controls.add(this.resetConfig.getControls(), "grow 2,wrap");
            this.controls.add(this.resetLevelLabel);
            this.controls.add(this.resetLevel.getControls(), "wrap");
            this.rndLabel = new JLabel(Resources.getString("Editor.Embellishment.randomize"));
            this.controls.add(this.rndLabel);
            this.rndCommand = new StringConfigurer(e.rndText);
            this.controls.add(this.rndCommand.getControls(), "grow 1");
            this.controls.add(this.rndKeyConfig.getControls(), "grow 2,wrap");
            this.images = this.getImagePicker();
            this.images.addListSelectionListener(e12 -> this.setUpDownEnabled());
            this.controls.add((Component)this.images, "span 4,split,grow");
            this.up = new JButton(IconFactory.getIcon("go-up", 0));
            this.up.addActionListener(e13 -> this.moveSelectedUp());
            this.down = new JButton(IconFactory.getIcon("go-down", 0));
            this.down.addActionListener(e14 -> this.moveSelectedDown());
            Box upDownPanel = Box.createVerticalBox();
            upDownPanel.add(Box.createVerticalGlue());
            upDownPanel.add(this.up);
            upDownPanel.add(this.down);
            upDownPanel.add(Box.createVerticalGlue());
            this.controls.add((Component)upDownPanel, "wrap");
            this.controls.add(new JLabel(Resources.getString("Editor.Embellishment.level_name")));
            this.controls.add(this.levelNameInput.getControls(), "growx");
            Box box = Box.createHorizontalBox();
            this.prefix.addActionListener(evt -> {
                if (this.prefix.isSelected()) {
                    this.suffix.setSelected(false);
                }
                this.changeLevelName();
            });
            this.suffix.addActionListener(evt -> {
                if (this.suffix.isSelected()) {
                    this.prefix.setSelected(false);
                }
                this.changeLevelName();
            });
            box.add(this.prefix);
            box.add(this.suffix);
            this.controls.add((Component)box, "wrap");
            JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow 1]rel[grow 1]"));
            JButton b = new JButton(Resources.getString("Editor.Embellishment.add_level"));
            b.addActionListener(evt -> {
                this.names.add(null);
                this.isPrefix.add(null);
                this.images.addEntry();
            });
            buttonPanel.add((Component)b, "growx");
            b = new JButton(Resources.getString("Editor.Embellishment.remove_level"));
            b.addActionListener(evt -> {
                int index = this.images.getList().getSelectedIndex();
                if (index >= 0) {
                    this.names.remove(index);
                    this.isPrefix.remove(index);
                    this.images.removeEntryAt(index);
                }
            });
            buttonPanel.add((Component)b, "growx");
            this.controls.add((Component)buttonPanel, "span 4,center,growx,wrap");
            this.images.getList().addListSelectionListener(evt -> this.updateLevelName());
            this.showHideFields();
            this.reset(e);
        }

        protected void moveSelectedUp() {
            int selected = this.images.getList().getSelectedIndex();
            int count = this.images.getList().getModel().getSize();
            if (count > 1 && selected > 0) {
                this.swap(selected, selected - 1);
            }
        }

        protected void moveSelectedDown() {
            int selected = this.images.getList().getSelectedIndex();
            int count = this.images.getList().getModel().getSize();
            if (count > 1 && selected < count - 1) {
                this.swap(selected, selected + 1);
            }
        }

        protected void swap(int index1, int index2) {
            String name = this.names.get(index1);
            this.names.set(index1, this.names.get(index2));
            this.names.set(index2, name);
            Integer prefix = this.isPrefix.get(index1);
            this.isPrefix.set(index1, this.isPrefix.get(index2));
            this.isPrefix.set(index2, prefix);
            this.images.swap(index1, index2);
        }

        protected void setUpDownEnabled() {
            int selected = this.images.getList().getSelectedIndex();
            int count = this.images.getList().getModel().getSize();
            this.up.setEnabled(count > 1 && selected > 0);
            this.down.setEnabled(count > 1 && selected < count - 1);
        }

        protected void showHideFields() {
            boolean alwaysActive = this.alwaysActiveConfig.getValueBoolean();
            if (alwaysActive) {
                this.activateLabel.setVisible(false);
                this.activateCommand.getControls().setVisible(false);
                this.activateConfig.getControls().setVisible(false);
            } else {
                this.activateLabel.setVisible(true);
                this.activateCommand.getControls().setVisible(true);
                this.activateConfig.getControls().setVisible(true);
            }
            boolean controlled = this.followConfig.booleanValue() == false;
            this.loop.setEnabled(controlled);
            this.propertyConfig.getControls().setVisible(!controlled);
            this.propertyLabel.setVisible(!controlled);
            this.firstLevelConfig.getControls().setVisible(!controlled);
            this.levelLabel.setVisible(!controlled);
            this.increaseLabel.setVisible(controlled);
            this.upCommand.getControls().setVisible(controlled);
            this.increaseConfig.getControls().setVisible(controlled);
            this.decreaseLabel.setVisible(controlled);
            this.downCommand.getControls().setVisible(controlled);
            this.decreaseConfig.getControls().setVisible(controlled);
            this.resetLabel.setVisible(controlled);
            this.resetCommand.getControls().setVisible(controlled);
            this.resetConfig.getControls().setVisible(controlled);
            this.resetLevel.getControls().setVisible(controlled);
            this.resetLevelLabel.setVisible(controlled);
            this.rndLabel.setVisible(controlled);
            this.rndCommand.getControls().setVisible(controlled);
            this.rndKeyConfig.getControls().setVisible(controlled);
            boolean labelsVisible = !alwaysActive || controlled;
            this.actionLabel.setVisible(labelsVisible);
            this.menuLabel.setVisible(labelsVisible);
            this.keyLabel.setVisible(labelsVisible);
            Decorator.repack(this.controls);
        }

        private void updateLevelName() {
            int index = this.images.getList().getSelectedIndex();
            if (index < 0) {
                this.levelNameInput.setValue(null);
            } else {
                this.levelNameInput.setValue(this.names.get(index));
                this.prefix.setSelected(PREFIX.equals(this.isPrefix.get(index)));
                this.suffix.setSelected(SUFFIX.equals(this.isPrefix.get(index)));
            }
        }

        private void changeLevelName() {
            int index = this.images.getList().getSelectedIndex();
            if (index >= 0) {
                String s = this.levelNameInput.getValueString();
                this.names.set(index, s);
                if (this.prefix.isSelected()) {
                    this.isPrefix.set(index, PREFIX);
                } else if (this.suffix.isSelected()) {
                    this.isPrefix.set(index, SUFFIX);
                } else {
                    this.isPrefix.set(index, NEITHER);
                }
            }
        }

        protected MultiImagePicker getImagePicker() {
            return new MultiImagePicker();
        }

        @Override
        public String getState() {
            return this.alwaysActiveConfig.getValueBoolean() ? "1" : "-1";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            ArrayList<String> imageNames = new ArrayList<String>();
            ArrayList<String> commonNames = new ArrayList<String>();
            int i = 0;
            for (String n : this.images.getImageNameList()) {
                imageNames.add(n);
                String commonName = this.names.get(i);
                if (commonName != null && commonName.length() > 0) {
                    commonName = PREFIX.equals(this.isPrefix.get(i)) ? new SequenceEncoder(commonName, '+').append("").getValue() : (SUFFIX.equals(this.isPrefix.get(i)) ? new SequenceEncoder("", '+').append(commonName).getValue() : new SequenceEncoder(commonName, '+').getValue());
                }
                commonNames.add(commonName);
                ++i;
            }
            try {
                Integer.parseInt(this.xOffInput.getValueString());
            }
            catch (NumberFormatException xNAN) {
                this.xOffInput.setValue(0);
            }
            try {
                Integer.parseInt(this.yOffInput.getValueString());
            }
            catch (NumberFormatException yNAN) {
                this.yOffInput.setValue(0);
            }
            se.append(this.activateCommand.getValueString()).append(128).append("A").append(this.upCommand.getValueString()).append(128).append("").append(this.downCommand.getValueString()).append(128).append("").append(this.resetCommand.getValueString()).append(this.resetConfig.getValueString()).append(this.resetLevel.getValueString()).append(this.drawUnderneath.isSelected()).append(this.xOffInput.getValueString()).append(this.yOffInput.getValueString()).append(imageNames.toArray(new String[0])).append(commonNames.toArray(new String[0])).append(this.loop.isSelected()).append(this.nameConfig.getValueString()).append(this.rndKeyConfig.getValueString()).append(this.rndCommand.getValueString() == null ? "" : this.rndCommand.getValueString().trim()).append(this.followConfig.getValueString()).append(this.propertyConfig.getValueString()).append(this.firstLevelConfig.getValueString()).append(this.version).append(this.alwaysActiveConfig.getValueString()).append(this.activateConfig.getValueString()).append(this.increaseConfig.getValueString()).append(this.decreaseConfig.getValueString());
            return Embellishment.ID + se.getValue();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        public void reset(Embellishment e) {
            this.nameConfig.setValue(e.name);
            this.names = new ArrayList<String>();
            this.isPrefix = new ArrayList<Integer>();
            for (int i = 0; i < e.commonName.length; ++i) {
                String s = e.commonName[i];
                Integer is = NEITHER;
                if (s != null && s.length() > 0) {
                    SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, '+');
                    String first = st.nextToken();
                    if (st.hasMoreTokens()) {
                        String second = st.nextToken();
                        if (first.length() == 0) {
                            s = second;
                            is = SUFFIX;
                        } else {
                            s = first;
                            is = PREFIX;
                        }
                    } else {
                        s = first;
                    }
                }
                this.names.add(s);
                this.isPrefix.add(is);
            }
            this.alwaysActiveConfig.setValue(e.alwaysActive);
            this.drawUnderneath.setSelected(e.drawUnderneathWhenSelected);
            this.loop.setSelected(e.loopLevels);
            this.images.clear();
            this.activateCommand.setValue(e.activateCommand);
            this.upCommand.setValue(e.upCommand);
            this.downCommand.setValue(e.downCommand);
            this.resetConfig.setValue(e.resetKey);
            this.resetCommand.setValue(e.resetCommand);
            this.resetLevel.setValue(e.resetLevel.getFormat());
            this.xOffInput.setValue(String.valueOf(e.xOff));
            this.yOffInput.setValue(String.valueOf(e.yOff));
            this.images.setImageList(e.imageName);
            this.followConfig.setValue(e.followProperty);
            this.propertyConfig.setValue(e.propertyName);
            if (this.images.getImageNameList().isEmpty()) {
                this.names.add(null);
                this.isPrefix.add(null);
                this.images.addEntry();
            }
            this.updateLevelName();
            this.showHideFields();
        }
    }
}

