/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.EventFilter;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class Immobilized
extends Decorator
implements EditablePiece {
    public static final String ID = "immob;";
    protected boolean shiftToSelect = false;
    protected boolean altToSelect = false;
    protected boolean ignoreGrid = false;
    protected boolean neverSelect = false;
    protected boolean neverMove = false;
    protected boolean moveIfSelected = false;
    protected boolean neverBandSelect = false;
    protected boolean altToBandSelect = false;
    protected EventFilter selectFilter;
    protected EventFilter moveFilter;
    protected EventFilter bandselectFilter;
    protected static final char MOVE_SELECTED = 'I';
    protected static final char MOVE_NORMAL = 'N';
    protected static final char NEVER_MOVE = 'V';
    protected static final char IGNORE_GRID = 'g';
    protected static final char SHIFT_SELECT = 'i';
    protected static final char ALT_SELECT = 'c';
    protected static final char NEVER_SELECT = 'n';
    protected static final char NEVER_BAND_SELECT = 'Z';
    protected static final char ALT_BAND_SELECT = 'A';
    protected static final EventFilter NEVER = evt -> true;

    public Immobilized() {
        this(ID, null);
    }

    @Deprecated
    public Immobilized(GamePiece p, String type) {
        this(type, p);
    }

    public Immobilized(String type, GamePiece p) {
        this.setInner(p);
        this.mySetType(type);
    }

    @Override
    public void mySetType(String type) {
        this.shiftToSelect = false;
        this.altToSelect = false;
        this.neverSelect = false;
        this.ignoreGrid = false;
        this.neverMove = false;
        this.moveIfSelected = false;
        this.neverBandSelect = false;
        this.altToBandSelect = false;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        String selectionOptions = st.nextToken("");
        String movementOptions = st.nextToken("");
        if (selectionOptions.indexOf(105) >= 0) {
            this.shiftToSelect = true;
            this.moveIfSelected = true;
        }
        if (selectionOptions.indexOf(99) >= 0) {
            this.altToSelect = true;
            this.moveIfSelected = true;
        }
        if (selectionOptions.indexOf(110) >= 0) {
            this.neverSelect = true;
            this.neverMove = true;
        }
        if (selectionOptions.indexOf(103) >= 0) {
            this.ignoreGrid = true;
        }
        if (selectionOptions.indexOf(65) >= 0) {
            this.altToBandSelect = true;
        }
        if (selectionOptions.indexOf(90) >= 0) {
            this.neverBandSelect = true;
        }
        if (movementOptions.length() > 0) {
            switch (movementOptions.charAt(0)) {
                case 'V': {
                    this.neverMove = true;
                    this.moveIfSelected = false;
                    break;
                }
                case 'I': {
                    this.neverMove = false;
                    this.moveIfSelected = true;
                    break;
                }
                default: {
                    this.neverMove = false;
                    this.moveIfSelected = false;
                }
            }
        }
        this.selectFilter = this.neverSelect ? NEVER : (this.shiftToSelect ? new UseShift() : (this.altToSelect ? new UseAlt() : null));
        this.moveFilter = this.neverMove ? NEVER : (this.moveIfSelected ? new MoveIfSelected() : null);
        this.bandselectFilter = this.neverBandSelect ? NEVER : (this.altToBandSelect ? new UseAlt() : null);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public Command myKeyEvent(KeyStroke e) {
        return null;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("NoStack".equals(key)) {
            return Boolean.TRUE;
        }
        if ("Immobile".equals(key)) {
            return this.moveIfSelected || this.neverMove;
        }
        if ("IgnoreGrid".equals(key)) {
            return this.ignoreGrid;
        }
        if ("selectEventFilter".equals(key)) {
            return this.selectFilter;
        }
        if ("moveEventFilter".equals(key)) {
            return this.moveFilter;
        }
        if ("cannotMove".equals(key)) {
            return this.neverMove;
        }
        if ("bandSelectEventFilter".equals(key)) {
            return this.bandselectFilter;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if ("NoStack".equals(key)) {
            return Boolean.TRUE;
        }
        if ("Immobile".equals(key)) {
            return this.moveIfSelected || this.neverMove;
        }
        if ("IgnoreGrid".equals(key)) {
            return this.ignoreGrid;
        }
        if ("selectEventFilter".equals(key)) {
            return this.selectFilter;
        }
        if ("moveEventFilter".equals(key)) {
            return this.moveFilter;
        }
        if ("cannotMove".equals(key)) {
            return this.neverMove;
        }
        if ("bandSelectEventFilter".equals(key)) {
            return this.bandselectFilter;
        }
        return super.getProperty(key);
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String myGetType() {
        StringBuilder buffer = new StringBuilder(ID);
        if (this.neverSelect) {
            buffer.append('n');
        } else if (this.shiftToSelect) {
            buffer.append('i');
        } else if (this.altToSelect) {
            buffer.append('c');
        }
        if (this.ignoreGrid) {
            buffer.append('g');
        }
        if (this.neverBandSelect) {
            buffer.append('Z');
        } else if (this.altToBandSelect) {
            buffer.append('A');
        }
        buffer.append(';');
        if (this.neverMove) {
            buffer.append('V');
        } else if (this.moveIfSelected) {
            buffer.append('I');
        } else {
            buffer.append('N');
        }
        return buffer.toString();
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetState(String s) {
    }

    @Override
    public String getDescription() {
        return Resources.getString("Editor.Immobilized.trait_description");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("NonStacking.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Immobile");
        l.add("IgnoreGrid");
        l.add("cannotMove");
        return l;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Immobilized)) {
            return false;
        }
        Immobilized c = (Immobilized)o;
        if (!Objects.equals(this.shiftToSelect, c.shiftToSelect)) {
            return false;
        }
        if (!Objects.equals(this.altToSelect, c.altToSelect)) {
            return false;
        }
        if (!Objects.equals(this.neverSelect, c.neverSelect)) {
            return false;
        }
        if (!Objects.equals(this.ignoreGrid, c.ignoreGrid)) {
            return false;
        }
        if (!Objects.equals(this.neverMove, c.neverMove)) {
            return false;
        }
        if (!Objects.equals(this.moveIfSelected, c.moveIfSelected)) {
            return false;
        }
        if (!Objects.equals(this.neverBandSelect, c.neverBandSelect)) {
            return false;
        }
        return Objects.equals(this.altToBandSelect, c.altToBandSelect);
    }

    public class UseShift
    implements EventFilter {
        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !evt.isShiftDown() && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    public class UseAlt
    implements EventFilter {
        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !evt.isAltDown() && !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    protected class MoveIfSelected
    implements EventFilter {
        protected MoveIfSelected() {
        }

        @Override
        public boolean rejectEvent(InputEvent evt) {
            return !Boolean.TRUE.equals(Immobilized.this.getProperty("Selected"));
        }
    }

    private static class Ed
    implements PieceEditor {
        private final TranslatingStringEnumConfigurer selectionOption;
        private final TranslatingStringEnumConfigurer movementOption;
        private final TranslatingStringEnumConfigurer bandSelectOption;
        private final BooleanConfigurer ignoreGridBox;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private static final String NORMAL = "normally";
        private static final String SHIFT = "when shift-key down";
        private static final String ALT = "when alt-key down";
        private static final String NEVER = "never";
        private static final String SELECTED = "only if selected";
        private static final String[] SELECT_OPTIONS = new String[]{"normally", "when shift-key down", "when alt-key down", "never"};
        private static final String[] SELECT_KEYS = new String[]{"Editor.Immobilized.normally", "Editor.Immobilized.when_shift_key_down", "Editor.Immobilized.when_alt_key_down", "Editor.Immobilized.never"};
        private static final String[] BAND_SELECT_OPTIONS = new String[]{"normally", "when alt-key down", "never"};
        private static final String[] BAND_SELECT_KEYS = new String[]{"Editor.Immobilized.normally", "Editor.Immobilized.when_alt_key_down", "Editor.Immobilized.never"};
        private static final String[] MOVE_OPTIONS = new String[]{"normally", "only if selected", "never"};
        private static final String[] MOVE_KEYS = new String[]{"Editor.Immobilized.normally", "Editor.Immobilized.only_if_selected", "Editor.Immobilized.never"};

        public Ed(Immobilized p) {
            this.selectionOption = new TranslatingStringEnumConfigurer(SELECT_OPTIONS, SELECT_KEYS);
            if (p.neverSelect) {
                this.selectionOption.setValue(NEVER);
            } else if (p.altToSelect) {
                this.selectionOption.setValue(ALT);
            } else if (p.shiftToSelect) {
                this.selectionOption.setValue(SHIFT);
            } else {
                this.selectionOption.setValue(NORMAL);
            }
            this.controls.add("Editor.Immobilized.select_piece", (Configurer)this.selectionOption);
            this.bandSelectOption = new TranslatingStringEnumConfigurer(BAND_SELECT_OPTIONS, BAND_SELECT_KEYS);
            if (p.neverBandSelect) {
                this.bandSelectOption.setValue(NEVER);
            } else if (p.altToBandSelect) {
                this.bandSelectOption.setValue(ALT);
            } else {
                this.bandSelectOption.setValue(NORMAL);
            }
            this.controls.add("Editor.Immobilized.band_select_piece", (Configurer)this.bandSelectOption);
            this.movementOption = new TranslatingStringEnumConfigurer(MOVE_OPTIONS, MOVE_KEYS);
            if (p.neverMove) {
                this.movementOption.setValue(NEVER);
            } else if (p.moveIfSelected) {
                this.movementOption.setValue(SELECTED);
            } else {
                this.movementOption.setValue(NORMAL);
            }
            this.controls.add("Editor.Immobilized.move_piece", (Configurer)this.movementOption);
            this.ignoreGridBox = new BooleanConfigurer(p.ignoreGrid);
            this.controls.add("Editor.Immobilized.ignore_map_grid_when_moving", (Configurer)this.ignoreGridBox);
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            Object s = Immobilized.ID;
            switch (this.selectionOption.getValueString()) {
                case "when shift-key down": {
                    s = (String)s + "i";
                    break;
                }
                case "when alt-key down": {
                    s = (String)s + "c";
                    break;
                }
                case "never": {
                    s = (String)s + "n";
                }
            }
            if (this.ignoreGridBox.getValueBoolean()) {
                s = (String)s + "g";
            }
            switch (this.bandSelectOption.getValueString()) {
                case "when alt-key down": {
                    s = (String)s + "A";
                    break;
                }
                case "never": {
                    s = (String)s + "Z";
                }
            }
            s = (String)s + ";";
            switch (this.movementOption.getValueString()) {
                case "normally": {
                    s = (String)s + "N";
                    break;
                }
                case "only if selected": {
                    s = (String)s + "I";
                    break;
                }
                case "never": {
                    s = (String)s + "V";
                }
            }
            return s;
        }

        @Override
        public Component getControls() {
            return this.controls;
        }
    }
}

