/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.LabelUtils;
import VASSAL.tools.imageop.AbstractTileOpImpl;
import VASSAL.tools.imageop.ImageOp;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.ScaledImagePainter;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.DoubleConsumer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.plaf.basic.BasicHTML;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Labeler
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "label;";
    protected Color textBg = Color.black;
    protected Color textFg = Color.white;
    @Deprecated(since="2020-08-27", forRemoval=true)
    public static final int CENTER = 0;
    @Deprecated(since="2020-08-27", forRemoval=true)
    public static final int RIGHT = 1;
    @Deprecated(since="2020-08-27", forRemoval=true)
    public static final int LEFT = 2;
    @Deprecated(since="2020-08-27", forRemoval=true)
    public static final int TOP = 3;
    @Deprecated(since="2020-08-27", forRemoval=true)
    public static final int BOTTOM = 4;
    @Deprecated(since="2020-08-27", forRemoval=true)
    public static int HORIZONTAL_ALIGNMENT = 0;
    @Deprecated(since="2020-08-27", forRemoval=true)
    public static int VERTICAL_ALIGNMENT = 3;
    private String label = "";
    private String lastCachedLabel;
    private NamedKeyStroke labelKey;
    private String menuCommand = Resources.getString("Editor.TextLabel.change_label");
    private Font font = new Font("Dialog", 0, 10);
    private KeyCommand[] commands;
    private final FormattedString nameFormat = new FormattedString("$pieceName$ ($label$)");
    private final FormattedString labelFormat = new FormattedString("");
    private static final String PIECE_NAME = "pieceName";
    private static final String BAD_PIECE_NAME = "PieceName";
    private static final String LABEL = "label";
    private double lastZoom = -1.0;
    private ImageOp lastCachedOp;
    private ImageOp baseOp;
    @Deprecated
    protected ScaledImagePainter imagePainter = new ScaledImagePainter();
    private char verticalJust = (char)98;
    private char horizontalJust = (char)99;
    private char verticalPos = (char)116;
    private char horizontalPos = (char)99;
    private int verticalOffset = 0;
    private int horizontalOffset = 0;
    protected int rotateDegrees;
    protected String propertyName;
    protected KeyCommand menuKeyCommand;
    protected String description;
    private Point position = null;
    private final DoubleConsumer updateCachedOpForZoom = SystemUtils.IS_OS_WINDOWS ? this::updateCachedOpForZoomWindows : this::updateCachedOpForZoomNotWindows;
    protected Rectangle lastRect = null;
    protected Area lastShape = null;

    public Labeler() {
        this(ID, null);
    }

    public Labeler(String s, GamePiece d) {
        this.mySetType(s);
        this.setInner(d);
    }

    @Override
    public void mySetType(String type) {
        this.commands = null;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.labelKey = st.nextNamedKeyStroke(null);
        this.menuCommand = st.nextToken(Resources.getString("Editor.TextLabel.change_label"));
        int fontSize = st.nextInt(10);
        this.textBg = st.nextColor(null);
        this.textFg = st.nextColor(Color.black);
        this.verticalPos = st.nextChar('t');
        this.verticalOffset = st.nextInt(0);
        this.horizontalPos = st.nextChar('c');
        this.horizontalOffset = st.nextInt(0);
        this.verticalJust = st.nextChar('b');
        this.horizontalJust = st.nextChar('c');
        this.nameFormat.setFormat(this.clean(st.nextToken("$pieceName$ ($label$)")));
        String fontFamily = st.nextToken("Dialog");
        int fontStyle = st.nextInt(0);
        this.font = new Font(fontFamily, fontStyle, fontSize);
        this.rotateDegrees = st.nextInt(0);
        this.propertyName = st.nextToken("TextLabel");
        this.description = st.nextToken("");
    }

    protected String clean(String s) {
        return s.replace("$PieceName$", "$pieceName$");
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (key.equals(this.propertyName)) {
            return this.getLocalizedLabel();
        }
        if ("visibleState".equals(key)) {
            return this.getLocalizedLabel() + this.piece.getProperty(key);
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if (key.equals(this.propertyName)) {
            return this.getLabel();
        }
        if ("visibleState".equals(key)) {
            return this.getLabel() + this.piece.getProperty(key);
        }
        return super.getProperty(key);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.labelKey).append(this.menuCommand).append(this.font.getSize()).append(this.textBg).append(this.textFg).append(this.verticalPos).append(this.verticalOffset).append(this.horizontalPos).append(this.horizontalOffset).append(this.verticalJust).append(this.horizontalJust).append(this.nameFormat.getFormat()).append(this.font.getFamily()).append(this.font.getStyle()).append(this.rotateDegrees).append(this.propertyName).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        return this.label;
    }

    @Override
    public void mySetState(String s) {
        this.setLabel(s.trim());
    }

    @Override
    public String getName() {
        String result = "";
        if (this.label.length() == 0) {
            result = this.piece.getName();
        } else {
            this.nameFormat.setProperty(PIECE_NAME, this.piece.getName());
            if (!RecursionLimiter.isReportingInfiniteLoop()) {
                this.nameFormat.setProperty(LABEL, this.getLabel());
            }
            try {
                RecursionLimiter.startExecution(this);
                result = this.nameFormat.getText(Decorator.getOutermost(this));
            }
            catch (RecursionLimitException e) {
                e.printStackTrace();
            }
            finally {
                RecursionLimiter.endExecution();
            }
        }
        return result;
    }

    @Override
    public String getLocalizedName() {
        if (this.label.length() == 0) {
            return this.piece.getLocalizedName();
        }
        FormattedString f = new FormattedString(this.getTranslation(this.nameFormat.getFormat()));
        f.setProperty(PIECE_NAME, this.piece.getLocalizedName());
        f.setProperty(LABEL, this.getLocalizedLabel());
        return f.getLocalizedText(Decorator.getOutermost(this));
    }

    public String getActualDescription() {
        return this.description;
    }

    private void updateCachedOpForZoomWindows(double zoom) {
        if (zoom == this.lastZoom && this.lastCachedOp != null) {
            return;
        }
        float fsize = (float)((double)this.font.getSize() * zoom);
        boolean isHTML = BasicHTML.isHTMLString(this.lastCachedLabel);
        if (!isHTML && (float)Math.round(fsize) == 8.0f) {
            Font zfont = this.font.deriveFont((float)((double)(3 * this.font.getSize()) * zoom));
            this.lastCachedOp = Op.scale(new LabelOp(this.lastCachedLabel, zfont, this.textFg, this.textBg), 0.3333333333333333);
        } else if (zoom == 1.0) {
            this.lastCachedOp = this.baseOp;
        } else if (isHTML) {
            this.lastCachedOp = Op.scale(this.baseOp, zoom);
        } else {
            Font zfont = this.font.deriveFont(fsize);
            this.lastCachedOp = new LabelOp(this.lastCachedLabel, zfont, this.textFg, this.textBg);
        }
        this.lastZoom = zoom;
    }

    private void updateCachedOpForZoomNotWindows(double zoom) {
        if (zoom == this.lastZoom && this.lastCachedOp != null) {
            return;
        }
        if (zoom == 1.0) {
            this.lastCachedOp = this.baseOp;
        } else if (BasicHTML.isHTMLString(this.lastCachedLabel)) {
            this.lastCachedOp = Op.scale(this.baseOp, zoom);
        } else {
            float fsize = (float)((double)this.font.getSize() * zoom);
            Font zfont = this.font.deriveFont(fsize);
            this.lastCachedOp = new LabelOp(this.lastCachedLabel, zfont, this.textFg, this.textBg);
        }
        this.lastZoom = zoom;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
        this.updateCachedImage();
        if (this.lastCachedLabel == null) {
            return;
        }
        this.updateCachedOpForZoom.accept(zoom);
        Point p = this.getLabelPosition();
        int labelX = x + (int)(zoom * (double)p.x);
        int labelY = y + (int)(zoom * (double)p.y);
        AffineTransform saveXForm = null;
        Graphics2D g2d = (Graphics2D)g;
        if (this.rotateDegrees != 0) {
            saveXForm = g2d.getTransform();
            AffineTransform newXForm = AffineTransform.getRotateInstance(Math.toRadians(this.rotateDegrees), x, y);
            g2d.transform(newXForm);
        }
        g.drawImage(this.lastCachedOp.getImage(), labelX, labelY, obs);
        if (this.rotateDegrees != 0) {
            g2d.setTransform(saveXForm);
        }
    }

    protected void updateCachedImage() {
        String ll = this.getLocalizedLabel();
        if (ll == null || ll.isEmpty()) {
            if (this.lastCachedLabel != null) {
                this.position = null;
                this.lastCachedLabel = null;
                this.lastCachedOp = null;
                this.baseOp = null;
            }
        } else if (!ll.equals(this.lastCachedLabel)) {
            this.position = null;
            this.lastCachedLabel = ll;
            this.baseOp = BasicHTML.isHTMLString(this.lastCachedLabel) ? new HTMLLabelOp(this.lastCachedLabel, this.font, this.textFg, this.textBg) : new LabelOp(this.lastCachedLabel, this.font, this.textFg, this.textBg);
            this.lastCachedOp = null;
        }
    }

    private Point getLabelPosition() {
        if (this.position != null) {
            return this.position;
        }
        int x = this.horizontalOffset;
        int y = this.verticalOffset;
        this.updateCachedImage();
        Dimension lblSize = this.baseOp != null ? this.baseOp.getSize() : new Dimension();
        Rectangle selBnds = this.piece.getShape().getBounds();
        switch (this.verticalPos) {
            case 't': {
                y += selBnds.y;
                break;
            }
            case 'b': {
                y += selBnds.y + selBnds.height;
            }
        }
        switch (this.horizontalPos) {
            case 'l': {
                x += selBnds.x;
                break;
            }
            case 'r': {
                x += selBnds.x + selBnds.width;
            }
        }
        switch (this.verticalJust) {
            case 'b': {
                y -= lblSize.height;
                break;
            }
            case 'c': {
                y -= lblSize.height / 2;
            }
        }
        switch (this.horizontalJust) {
            case 'c': {
                x -= lblSize.width / 2;
                break;
            }
            case 'r': {
                x -= lblSize.width;
            }
        }
        Point result = new Point(x, y);
        if (lblSize.height > 0 && lblSize.width > 0) {
            this.position = result;
        }
        return result;
    }

    public void setLabel(String s) {
        if (s == null) {
            s = "";
        }
        int index = ((String)s).indexOf("$" + this.propertyName + "$");
        while (index >= 0) {
            s = ((String)s).substring(0, index) + ((String)s).substring(index + this.propertyName.length() + 2);
            index = ((String)s).indexOf("$" + this.propertyName + "$");
        }
        this.label = s;
        this.labelFormat.setProperty(BAD_PIECE_NAME, this.piece.getName());
        this.labelFormat.setFormat(this.label);
        this.position = null;
        this.lastCachedLabel = null;
        this.lastCachedOp = null;
        this.baseOp = null;
    }

    public void setBackground(Color textBg) {
        this.textBg = textBg;
    }

    public void setForeground(Color textFg) {
        this.textFg = textFg;
    }

    public String getLabel() {
        return this.labelFormat.getText(Decorator.getOutermost(this));
    }

    public String getLocalizedLabel() {
        FormattedString f = new FormattedString(this.getTranslation(this.labelFormat.getFormat()));
        return f.getLocalizedText(Decorator.getOutermost(this));
    }

    @Override
    public Rectangle boundingBox() {
        Rectangle r = this.piece.boundingBox();
        r.add(new Rectangle(this.getLabelPosition(), this.baseOp != null ? this.baseOp.getSize() : new Dimension()));
        return r;
    }

    @Override
    public Shape getShape() {
        Shape innerShape = this.piece.getShape();
        if (!this.labelKey.isNull()) {
            return innerShape;
        }
        Rectangle r = new Rectangle(this.getLabelPosition(), this.baseOp != null ? this.baseOp.getSize() : new Dimension());
        if (innerShape.contains(r.x, r.y, r.width, r.height)) {
            return innerShape;
        }
        Area a = new Area(innerShape);
        if (!r.equals(this.lastRect)) {
            this.lastShape = new Area(r);
            this.lastRect = new Rectangle(r);
        }
        a.add(this.lastShape);
        return a;
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.menuKeyCommand = new KeyCommand(this.menuCommand, this.labelKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.labelKey == null || this.labelKey.isNull() || this.menuCommand == null || this.menuCommand.length() == 0 ? new KeyCommand[0] : new KeyCommand[]{this.menuKeyCommand};
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        Command c = null;
        if (this.menuKeyCommand.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            String s = (String)JOptionPane.showInputDialog(this.getMap() == null ? null : this.getMap().getView().getTopLevelAncestor(), this.menuKeyCommand.getName(), null, 3, null, null, this.label);
            if (s == null) {
                tracker = null;
            } else {
                this.setLabel(s);
                c = tracker.getChangeCommand();
            }
        }
        return c;
    }

    @Override
    public String getDescription() {
        return Resources.getString("Editor.TextLabel.component_type") + (String)(this.description.length() > 0 ? " - " + this.description : "");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Label.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Labeler)) {
            return false;
        }
        Labeler l = (Labeler)o;
        if (!Objects.equals(this.labelKey, l.labelKey)) {
            return false;
        }
        if (!Objects.equals(this.menuCommand, l.menuCommand)) {
            return false;
        }
        if (!Objects.equals(this.font, l.font)) {
            return false;
        }
        if (!Objects.equals(this.textBg, l.textBg)) {
            return false;
        }
        if (!Objects.equals(this.textFg, l.textFg)) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.verticalPos), Character.valueOf(l.verticalPos))) {
            return false;
        }
        if (!Objects.equals(this.verticalOffset, l.verticalOffset)) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.horizontalPos), Character.valueOf(l.horizontalPos))) {
            return false;
        }
        if (!Objects.equals(this.horizontalOffset, l.horizontalOffset)) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.verticalJust), Character.valueOf(l.verticalJust))) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.horizontalJust), Character.valueOf(l.horizontalJust))) {
            return false;
        }
        if (!Objects.equals(this.nameFormat, l.nameFormat)) {
            return false;
        }
        if (!Objects.equals(this.rotateDegrees, l.rotateDegrees)) {
            return false;
        }
        if (!Objects.equals(this.propertyName, l.propertyName)) {
            return false;
        }
        if (!Objects.equals(this.description, l.description)) {
            return false;
        }
        return Objects.equals(this.label, l.label);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        if (this.propertyName.length() > 0) {
            l.add(this.propertyName);
        }
        return l;
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.labelFormat.getFormat(), this.nameFormat.getFormat(), this.menuCommand}, new String[]{Resources.getString("Editor.TextLabel.label_text"), Resources.getString("Editor.TextLabel.name_format"), Resources.getString("Editor.TextLabel.change_label_command")});
    }

    @Override
    public String getComponentTypeName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentName() {
        return this.getDescription();
    }

    @Deprecated(since="2020-08-27", forRemoval=true)
    public static void drawLabel(Graphics g, String text, int x, int y, int hAlign, int vAlign, Color fgColor, Color bgColor) {
        ProblemDialog.showDeprecated("2020-08-27");
        LabelUtils.drawLabel(g, text, x, y, hAlign, vAlign, fgColor, bgColor);
    }

    @Deprecated(since="2020-08-27", forRemoval=true)
    public static void drawLabel(Graphics g, String text, int x, int y, Font f, int hAlign, int vAlign, Color fgColor, Color bgColor, Color borderColor) {
        ProblemDialog.showDeprecated("2020-08-27");
        LabelUtils.drawLabel(g, text, x, y, f, hAlign, vAlign, fgColor, bgColor, borderColor);
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.propertyName);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.labelKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.menuCommand);
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.label, this.nameFormat.getFormat(), this.labelFormat.getFormat());
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        HTMLImageFinder h = new HTMLImageFinder(this.label);
        h.addImageNames(s);
    }

    protected static class LabelOp
    extends AbstractTileOpImpl {
        protected final String txt;
        protected final Font font;
        protected final Color fg;
        protected final Color bg;
        protected final int hash;

        public LabelOp(String txt, Font font, Color fg, Color bg) {
            this.txt = txt;
            this.font = font;
            this.fg = fg;
            this.bg = bg;
            this.hash = new HashCodeBuilder().append((Object)txt).append((Object)font).append((Object)fg).append((Object)bg).toHashCode();
        }

        @Override
        public List<VASSAL.tools.opcache.Op<?>> getSources() {
            return Collections.emptyList();
        }

        @Override
        public BufferedImage eval() throws Exception {
            if (this.size == null) {
                this.fixSize();
            }
            if (this.size.width <= 0 || this.size.height <= 0) {
                return ImageUtils.NULL_IMAGE;
            }
            BufferedImage im = ImageUtils.createCompatibleImage(this.size.width, this.size.height, this.bg == null || this.bg.getTransparency() != 1);
            Graphics2D g = im.createGraphics();
            g.addRenderingHints(SwingUtils.FONT_HINTS);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.bg != null) {
                g.setColor(this.bg);
                g.fillRect(0, 0, this.size.width, this.size.height);
            }
            if (this.fg != null) {
                g.setColor(this.fg);
                g.setFont(this.font);
                FontMetrics fm = g.getFontMetrics(this.font);
                g.drawString(this.txt, 0, this.size.height - fm.getDescent());
            }
            g.dispose();
            return im;
        }

        protected Dimension buildDimensions() {
            Graphics2D g = ImageUtils.NULL_IMAGE.createGraphics();
            FontMetrics fm = g.getFontMetrics(this.font);
            Dimension s = new Dimension(fm.stringWidth(this.txt), fm.getHeight());
            g.dispose();
            return s;
        }

        @Override
        protected void fixSize() {
            this.size = this.getSizeFromCache();
            if (this.size == null) {
                Dimension s = this.buildDimensions();
                if (s.width <= 0 || s.height <= 0) {
                    s.height = 1;
                    s.width = 1;
                }
                this.size = s;
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LabelOp)) {
                return false;
            }
            LabelOp lop = (LabelOp)o;
            return Objects.equals(this.txt, lop.txt) && Objects.equals(this.font, lop.font) && Objects.equals(this.fg, lop.fg) && Objects.equals(this.bg, lop.bg);
        }

        public int hashCode() {
            return this.hash;
        }
    }

    protected static class HTMLLabelOp
    extends LabelOp {
        public HTMLLabelOp(String txt, Font font, Color fg, Color bg) {
            super(txt, font, fg, bg);
        }

        @Override
        public BufferedImage eval() throws Exception {
            if (this.size == null) {
                this.fixSize();
            }
            if (this.size.width <= 0 || this.size.height <= 0) {
                return ImageUtils.NULL_IMAGE;
            }
            BufferedImage im = ImageUtils.createCompatibleImage(this.size.width, this.size.height, this.bg == null || this.bg.getTransparency() != 1);
            Graphics2D g = im.createGraphics();
            g.addRenderingHints(SwingUtils.FONT_HINTS);
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            if (this.bg != null) {
                g.setColor(this.bg);
                g.fillRect(0, 0, this.size.width, this.size.height);
            }
            if (this.fg != null) {
                JLabel l = this.makeLabel();
                l.paint(g);
            }
            g.dispose();
            return im;
        }

        protected JLabel makeLabel() {
            JLabel l = new JLabel(this.txt);
            l.setForeground(this.fg);
            l.setFont(this.font);
            l.setSize(l.getPreferredSize());
            return l;
        }

        @Override
        protected Dimension buildDimensions() {
            return this.makeLabel().getSize();
        }
    }

    private static class Ed
    implements PieceEditor {
        private final NamedHotKeyConfigurer labelKeyInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer command;
        private final StringConfigurer initialValue;
        private final ColorConfigurer fg;
        private final ColorConfigurer bg;
        private final TranslatingStringEnumConfigurer vPos;
        private final TranslatingStringEnumConfigurer hPos;
        private final TranslatingStringEnumConfigurer vJust;
        private final TranslatingStringEnumConfigurer hJust;
        private final IntConfigurer hOff;
        private final IntConfigurer vOff;
        private final IntConfigurer fontSize;
        private final FormattedStringConfigurer format;
        private final TranslatingStringEnumConfigurer fontFamily;
        private final IntConfigurer rotate;
        private final BooleanConfigurer bold;
        private final BooleanConfigurer italic;
        private final StringConfigurer propertyNameConfig;
        private final StringConfigurer descConfig;

        public Ed(Labeler l) {
            this.descConfig = new StringConfigurer(l.description);
            this.controls.add("Editor.description_label", (Configurer)this.descConfig);
            this.initialValue = new StringConfigurer(l.label);
            this.controls.add("Editor.TextLabel.label_text", (Configurer)this.initialValue);
            this.format = new FormattedStringConfigurer(new String[]{Labeler.PIECE_NAME, Labeler.LABEL});
            this.format.setValue(l.nameFormat.getFormat());
            this.controls.add("Editor.TextLabel.name_format", (Configurer)this.format);
            this.command = new StringConfigurer(l.menuCommand);
            this.controls.add("Editor.menu_command", (Configurer)this.command);
            this.labelKeyInput = new NamedHotKeyConfigurer(l.labelKey);
            this.controls.add("Editor.keyboard_command", (Configurer)this.labelKeyInput);
            this.fontFamily = new TranslatingStringEnumConfigurer(new String[]{"Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput"}, new String[]{"Editor.Font.serif", "Editor.Font.sans_serif", "Editor.Font.monospaced", "Editor.Font.dialog", "Editor.Font.dialog_input"}, l.font.getFamily());
            JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0", "[]unrel[]rel[]unrel[]rel[]unrel[]rel[]"));
            p.add(this.fontFamily.getControls());
            p.add(new JLabel(Resources.getString("Editor.size_label")));
            this.fontSize = new IntConfigurer(l.font.getSize());
            p.add(this.fontSize.getControls());
            p.add(new JLabel(Resources.getString("Editor.TextLabel.bold")));
            int fontStyle = l.font.getStyle();
            this.bold = new BooleanConfigurer((Boolean)(fontStyle != 0 && fontStyle != 2 ? 1 : 0));
            p.add(this.bold.getControls());
            p.add(new JLabel(Resources.getString("Editor.TextLabel.italic")));
            this.italic = new BooleanConfigurer((Boolean)(fontStyle != 0 && fontStyle != 1 ? 1 : 0));
            p.add(this.italic.getControls());
            this.controls.add("Editor.TextLabel.label_font", p);
            this.fg = new ColorConfigurer(l.textFg);
            this.controls.add("Editor.TextLabel.text_color", (Configurer)this.fg);
            this.bg = new ColorConfigurer(l.textBg);
            this.controls.add("Editor.TextLabel.background_color", (Configurer)this.bg);
            this.vPos = new TranslatingStringEnumConfigurer(new String[]{"c", "t", "b"}, new String[]{"Editor.center", "Editor.top", "Editor.bottom"}, l.verticalPos);
            p = new JPanel((LayoutManager)new MigLayout("ins 0", "[100]unrel[]rel[]"));
            p.add(this.vPos.getControls());
            p.add(new JLabel(Resources.getString("Editor.TextLabel.offset")));
            this.vOff = new IntConfigurer(l.verticalOffset);
            p.add(this.vOff.getControls());
            this.controls.add("Editor.TextLabel.vertical_position", p);
            this.hPos = new TranslatingStringEnumConfigurer(new String[]{"c", "l", "r"}, new String[]{"Editor.center", "Editor.left", "Editor.right"}, l.horizontalPos);
            p = new JPanel((LayoutManager)new MigLayout("ins 0", "[100]unrel[]rel[]"));
            p.add(this.hPos.getControls());
            p.add(new JLabel(Resources.getString("Editor.TextLabel.offset")));
            this.hOff = new IntConfigurer(l.horizontalOffset);
            p.add(this.hOff.getControls());
            this.controls.add("Editor.TextLabel.horizontal_position", p);
            this.vJust = new TranslatingStringEnumConfigurer(new String[]{"c", "t", "b"}, new String[]{"Editor.center", "Editor.top", "Editor.bottom"}, l.verticalJust);
            this.controls.add("Editor.TextLabel.vertical_text_justification", (Configurer)this.vJust, "grow 0");
            this.hJust = new TranslatingStringEnumConfigurer(new String[]{"c", "l", "r"}, new String[]{"Editor.center", "Editor.left", "Editor.right"}, l.horizontalJust);
            this.controls.add("Editor.TextLabel.horizontal_text_justification", (Configurer)this.hJust, "grow 0");
            this.rotate = new IntConfigurer(l.rotateDegrees);
            this.controls.add("Editor.TextLabel.rotate_text_degrees", (Configurer)this.rotate);
            this.propertyNameConfig = new StringConfigurer(l.propertyName);
            this.controls.add("Editor.property_name", (Configurer)this.propertyNameConfig);
        }

        @Override
        public String getState() {
            return this.initialValue.getValueString();
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.labelKeyInput.getValueString()).append(this.command.getValueString());
            Integer i = (Integer)this.fontSize.getValue();
            if (i == null || i <= 0) {
                i = 10;
            }
            se.append(i.toString()).append(this.bg.getValueString()).append(this.fg.getValueString()).append(this.vPos.getValueString());
            i = (Integer)this.vOff.getValue();
            if (i == null) {
                i = 0;
            }
            se.append(i.toString()).append(this.hPos.getValueString());
            i = (Integer)this.hOff.getValue();
            if (i == null) {
                i = 0;
            }
            se.append(i.toString()).append(this.vJust.getValueString()).append(this.hJust.getValueString()).append(this.format.getValueString()).append(this.fontFamily.getValueString());
            int style = 0 + (this.bold.booleanValue() != false ? 1 : 0) + (this.italic.booleanValue() != false ? 2 : 0);
            se.append(style);
            i = (Integer)this.rotate.getValue();
            if (i == null) {
                i = 0;
            }
            se.append(i.toString()).append(this.propertyNameConfig.getValueString()).append(this.descConfig.getValueString());
            return Labeler.ID + se.getValue();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }
    }
}

