/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.ObscurableOptions;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.ImageSelector;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PieceAccessConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.BasicPiece;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceAccess;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PlayerAccess;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Area;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;

public class Obscurable
extends Decorator
implements TranslatablePiece {
    public static final String ID = "obs;";
    protected static final char INSET = 'I';
    protected static final char BACKGROUND = 'B';
    protected static final char PEEK = 'P';
    protected static final char IMAGE = 'G';
    protected static final String DEFAULT_PEEK_COMMAND = Resources.getString("Editor.Obscurable.default_peek_command");
    protected char obscureKey;
    protected NamedKeyStroke keyCommand;
    protected NamedKeyStroke peekKey;
    protected String imageName;
    protected String obscuredToOthersImage;
    protected String obscuredBy;
    protected ObscurableOptions obscuredOptions;
    protected String hideCommand = Resources.getString("Editor.Obscurable.default_mask_command");
    protected String peekCommand = DEFAULT_PEEK_COMMAND;
    protected GamePiece obscuredToMeView;
    protected GamePiece obscuredToOthersView;
    protected boolean peeking;
    protected char displayStyle = (char)73;
    protected String maskName = "?";
    protected PieceAccess access = PlayerAccess.getInstance();
    protected KeyCommand[] commandsWithPeek;
    protected KeyCommand[] commandsWithoutPeek;
    protected KeyCommand hide;
    protected KeyCommand peek;

    public Obscurable() {
        this("obs;M;", null);
    }

    public Obscurable(String type, GamePiece d) {
        this.mySetType(type);
        this.setInner(d);
    }

    @Override
    public void mySetState(String in) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(in, ';');
        String token = sd.nextToken("null");
        this.obscuredBy = "null".equals(token) ? null : token;
        token = sd.nextToken("");
        this.obscuredOptions = this.obscuredBy == null ? null : new ObscurableOptions(token);
    }

    @Override
    public void mySetType(String in) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(in, ';');
        st.nextToken();
        this.keyCommand = st.nextNamedKeyStroke(null);
        this.imageName = st.nextToken();
        this.obscuredToMeView = GameModule.getGameModule().createPiece("piece;;;" + this.imageName + ";;");
        this.hideCommand = st.nextToken(this.hideCommand);
        if (st.hasMoreTokens()) {
            String s = st.nextToken(String.valueOf('I'));
            this.displayStyle = s.charAt(0);
            switch (this.displayStyle) {
                case 'P': {
                    if (s.length() > 1) {
                        this.peekKey = s.length() == 2 ? NamedKeyStroke.getNamedKeyStroke(s.charAt(1), 128) : NamedHotKeyConfigurer.decode(s.substring(1));
                        this.peeking = false;
                        break;
                    }
                    this.peekKey = null;
                    this.peeking = true;
                    break;
                }
                case 'G': {
                    if (s.length() <= 1) break;
                    this.obscuredToOthersImage = s.substring(1);
                    this.obscuredToOthersView = GameModule.getGameModule().createPiece("piece;;;" + this.obscuredToOthersImage + ";;");
                    this.obscuredToMeView.setPosition(new Point());
                }
            }
        }
        this.maskName = st.nextToken(this.maskName);
        this.access = PieceAccessConfigurer.decode(st.nextToken(null));
        this.peekCommand = st.nextToken(DEFAULT_PEEK_COMMAND);
        this.commandsWithPeek = null;
        this.hide = null;
        this.peek = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.keyCommand).append(this.imageName).append(this.hideCommand);
        switch (this.displayStyle) {
            case 'P': {
                if (this.peekKey == null) {
                    se.append(this.displayStyle);
                    break;
                }
                se.append(this.displayStyle + NamedHotKeyConfigurer.encode(this.peekKey));
                break;
            }
            case 'G': {
                se.append(this.displayStyle + this.obscuredToOthersImage);
                break;
            }
            default: {
                se.append(this.displayStyle);
            }
        }
        se.append(this.maskName);
        se.append(PieceAccessConfigurer.encode(this.access));
        se.append(this.peekCommand);
        return ID + se.getValue();
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.obscuredBy == null ? "null" : this.obscuredBy);
        se.append(this.obscuredBy == null || this.obscuredOptions == null ? "" : this.obscuredOptions.encodeOptions());
        return se.getValue();
    }

    @Override
    public Rectangle boundingBox() {
        if (this.obscuredToMe()) {
            return this.bBoxObscuredToMe();
        }
        if (this.obscuredToOthers()) {
            return this.bBoxObscuredToOthers();
        }
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        if (this.obscuredToMe()) {
            return this.obscuredToMeView.getShape();
        }
        if (this.obscuredToOthers()) {
            switch (this.displayStyle) {
                case 'B': {
                    return this.obscuredToMeView.getShape();
                }
                case 'I': {
                    return this.piece.getShape();
                }
                case 'P': {
                    if (this.peeking && Boolean.TRUE.equals(this.getProperty("Selected"))) {
                        return this.piece.getShape();
                    }
                    return this.obscuredToMeView.getShape();
                }
                case 'G': {
                    Area area = new Area(this.obscuredToOthersView.getShape());
                    Shape innerShape = this.piece.getShape();
                    if (innerShape instanceof Area) {
                        area.add((Area)innerShape);
                    } else {
                        area.add(new Area(innerShape));
                    }
                    return area;
                }
            }
            return this.piece.getShape();
        }
        return this.piece.getShape();
    }

    public boolean obscuredToMe() {
        return !this.access.currentPlayerHasAccess(this.obscuredBy);
    }

    public boolean obscuredToOthers() {
        return this.obscuredBy != null;
    }

    @Override
    public void setProperty(Object key, Object val) {
        if (ID.equals(key)) {
            if (val instanceof String || val == null) {
                this.obscuredBy = (String)val;
                if ("null".equals(this.obscuredBy)) {
                    this.obscuredBy = null;
                    this.obscuredOptions = null;
                }
            }
        } else if ("Selected".equals(key)) {
            if (!Boolean.TRUE.equals(val) && this.peekKey != null) {
                this.peeking = false;
            }
            super.setProperty(key, val);
        } else if ("ObscuredToOthers".equals(key)) {
            String owner = null;
            if (Boolean.TRUE.equals(val)) {
                owner = this.access.getCurrentPlayerId();
            }
            this.obscuredBy = owner;
            this.obscuredOptions = new ObscurableOptions(ObscurableOptions.getInstance().encodeOptions());
        } else {
            super.setProperty(key, val);
        }
    }

    @Override
    public Object getProperty(Object key) {
        if ("Obscured".equals(key)) {
            return this.obscuredToMe();
        }
        if ("ObscuredToOthers".equals(key)) {
            return this.obscuredToOthers();
        }
        if (ID.equals(key)) {
            return this.obscuredBy;
        }
        if ("visibleState".equals(key)) {
            return this.myGetState() + this.isPeeking() + this.getProperty("Selected") + this.piece.getProperty(key);
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (this.obscuredToMe()) {
            return ((BasicPiece)Decorator.getInnermost(this)).getLocalizedPublicProperty(key);
        }
        if ("Obscured".equals(key)) {
            return this.obscuredToMe();
        }
        if ("ObscuredToOthers".equals(key)) {
            return this.obscuredToOthers();
        }
        if (ID.equals(key)) {
            return this.obscuredBy;
        }
        if ("visibleState".equals(key)) {
            return this.myGetState() + this.isPeeking() + this.piece.getProperty(key);
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        if (this.obscuredToMe()) {
            this.drawObscuredToMe(g, x, y, obs, zoom);
        } else if (this.obscuredToOthers()) {
            this.drawObscuredToOthers(g, x, y, obs, zoom);
        } else {
            this.piece.draw(g, x, y, obs, zoom);
        }
    }

    protected void drawObscuredToMe(Graphics g, int x, int y, Component obs, double zoom) {
        this.obscuredToMeView.draw(g, x, y, obs, zoom);
    }

    protected void drawObscuredToOthers(Graphics g, int x, int y, Component obs, double zoom) {
        switch (this.displayStyle) {
            case 'B': {
                this.obscuredToMeView.draw(g, x, y, obs, zoom);
                this.piece.draw(g, x, y, obs, zoom * 0.5);
                break;
            }
            case 'I': {
                this.piece.draw(g, x, y, obs, zoom);
                Rectangle bounds = this.piece.getShape().getBounds();
                Rectangle obsBounds = this.obscuredToMeView.getShape().getBounds();
                this.obscuredToMeView.draw(g, x - (int)(zoom * (double)bounds.width / 2.0 - 0.5 * zoom * (double)obsBounds.width / 2.0), y - (int)(zoom * (double)bounds.height / 2.0 - 0.5 * zoom * (double)obsBounds.height / 2.0), obs, zoom * 0.5);
                break;
            }
            case 'P': {
                if (this.peeking && Boolean.TRUE.equals(this.getProperty("Selected"))) {
                    this.piece.draw(g, x, y, obs, zoom);
                    break;
                }
                this.obscuredToMeView.draw(g, x, y, obs, zoom);
                break;
            }
            case 'G': {
                this.piece.draw(g, x, y, obs, zoom);
                this.obscuredToOthersView.draw(g, x, y, obs, zoom);
            }
        }
    }

    public boolean isPeeking() {
        return this.peeking;
    }

    protected Rectangle bBoxObscuredToMe() {
        return this.obscuredToMeView.boundingBox();
    }

    protected Rectangle bBoxObscuredToOthers() {
        Rectangle r;
        switch (this.displayStyle) {
            case 'B': {
                r = this.bBoxObscuredToMe();
                break;
            }
            case 'G': {
                r = this.piece.boundingBox();
                r.add(this.obscuredToOthersView.boundingBox());
                break;
            }
            default: {
                r = this.piece.boundingBox();
            }
        }
        return r;
    }

    @Override
    public String getLocalizedName() {
        String maskedName = this.maskName == null ? "?" : this.maskName;
        maskedName = this.getTranslation(maskedName);
        return this.getName(maskedName, true);
    }

    @Override
    public String getName() {
        String maskedName = this.maskName == null ? "?" : this.maskName;
        return this.getName(maskedName, false);
    }

    protected String getName(String maskedName, boolean localized) {
        if (this.obscuredToMe()) {
            return maskedName;
        }
        if (this.obscuredToOthers()) {
            return (localized ? this.piece.getLocalizedName() : this.piece.getName()) + "(" + maskedName + ")";
        }
        return localized ? this.piece.getLocalizedName() : this.piece.getName();
    }

    @Override
    public KeyCommand[] getKeyCommands() {
        if (this.obscuredToMe()) {
            Object[] myC = this.myGetKeyCommands();
            Object[] c = (KeyCommand[])Decorator.getInnermost(this).getProperty("KeyCommands");
            if (c == null) {
                return myC;
            }
            return (KeyCommand[])ArrayUtils.addAll((Object[])myC, (Object[])c);
        }
        return super.getKeyCommands();
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        ArrayList<KeyCommand> l = new ArrayList<KeyCommand>();
        GamePiece outer = Decorator.getOutermost(this);
        if (this.keyCommand == null) {
            this.keyCommand = NamedKeyStroke.getNamedKeyStroke(this.obscureKey, 128);
        }
        this.hide = new KeyCommand(this.hideCommand, this.keyCommand, outer, (TranslatablePiece)this);
        if (this.hideCommand.length() > 0 && this.isMaskable()) {
            l.add(this.hide);
            this.commandsWithoutPeek = new KeyCommand[]{this.hide};
        } else {
            this.commandsWithoutPeek = new KeyCommand[0];
        }
        this.peek = new KeyCommand(this.peekCommand, this.peekKey, outer, (TranslatablePiece)this);
        if (this.displayStyle == 'P' && this.peekKey != null && this.peekCommand.length() > 0) {
            l.add(this.peek);
        }
        this.commandsWithPeek = l.toArray(new KeyCommand[0]);
        return this.obscuredToOthers() && this.isMaskable() && this.displayStyle == 'P' && this.peekKey != null ? this.commandsWithPeek : this.commandsWithoutPeek;
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public boolean isMaskableBy(String id) {
        ProblemDialog.showDeprecated("2020-08-06");
        return this.isMaskable();
    }

    public boolean isMaskable() {
        if (this.access.currentPlayerCanModify(this.obscuredBy)) {
            return true;
        }
        if (this.obscuredOptions != null) {
            return this.obscuredOptions.isUnmaskable(this.obscuredBy);
        }
        return ObscurableOptions.getInstance().isUnmaskable(this.obscuredBy);
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        if (!this.obscuredToMe()) {
            return super.keyEvent(stroke);
        }
        if (this.isMaskable()) {
            return this.myKeyEvent(stroke);
        }
        return null;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command retVal = null;
        this.myGetKeyCommands();
        if (this.hide.matches(stroke)) {
            ChangeTracker c = new ChangeTracker(this);
            if (this.obscuredToOthers() || this.obscuredToMe()) {
                this.obscuredBy = null;
                this.obscuredOptions = null;
            } else if (!this.obscuredToMe()) {
                this.obscuredBy = this.access.getCurrentPlayerId();
                this.obscuredOptions = new ObscurableOptions(ObscurableOptions.getInstance().encodeOptions());
            }
            retVal = c.getChangeCommand();
        } else if (this.peek.matches(stroke) && this.obscuredToOthers() && Boolean.TRUE.equals(this.getProperty("Selected"))) {
            this.peeking = true;
        }
        if (retVal != null && 'P' == this.displayStyle && this.peekKey == null && this.obscuredToOthers()) {
            Runnable runnable = () -> KeyBuffer.getBuffer().remove(Decorator.getOutermost(this));
            SwingUtilities.invokeLater(runnable);
        }
        return retVal;
    }

    @Override
    public String getDescription() {
        return Resources.getString("Editor.Obscurable.trait_description");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Mask.html");
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    public static void setAllHidden(boolean allHidden) {
        ProblemDialog.showDeprecated("2020-08-06");
        if (allHidden) {
            PieceAccess.GlobalAccess.hideAll();
        } else {
            PieceAccess.GlobalAccess.revertAll();
        }
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(new String[]{this.hideCommand, this.maskName, this.peekCommand}, new String[]{Resources.getString("Editor.Obscurable.mask_command"), Resources.getString("Editor.Obscurable.name_when_masked"), Resources.getString("Editor.Obscurable.peek_command")});
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("ObscuredToOthers");
        l.add("Obscured");
        return l;
    }

    @Override
    public boolean testEquals(Object o) {
        boolean noOptions2;
        if (!(o instanceof Obscurable)) {
            return false;
        }
        Obscurable c = (Obscurable)o;
        if (!Objects.equals(this.keyCommand, c.keyCommand)) {
            return false;
        }
        if (!Objects.equals(this.imageName, c.imageName)) {
            return false;
        }
        if (!Objects.equals(this.hideCommand, c.hideCommand)) {
            return false;
        }
        if (!Objects.equals(Character.valueOf(this.displayStyle), Character.valueOf(c.displayStyle))) {
            return false;
        }
        switch (this.displayStyle) {
            case 'P': {
                if (Objects.equals(this.peekKey, c.peekKey)) break;
                return false;
            }
            case 'G': {
                if (Objects.equals(this.obscuredToOthersImage, c.obscuredToOthersImage)) break;
                return false;
            }
        }
        if (!Objects.equals(this.maskName, c.maskName)) {
            return false;
        }
        if (!Objects.equals(PieceAccessConfigurer.encode(this.access), PieceAccessConfigurer.encode(c.access))) {
            return false;
        }
        if (!Objects.equals(this.peekCommand, c.peekCommand)) {
            return false;
        }
        if (!Objects.equals(this.obscuredBy, c.obscuredBy)) {
            return false;
        }
        boolean noOptions = this.obscuredBy == null || this.obscuredOptions == null;
        boolean bl = noOptions2 = c.obscuredBy == null || c.obscuredOptions == null;
        if (!Objects.equals(noOptions, noOptions2)) {
            return false;
        }
        if (!noOptions && !noOptions2) {
            return Objects.equals(this.obscuredOptions.encodeOptions(), c.obscuredOptions.encodeOptions());
        }
        return true;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.keyCommand, this.peekKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.hideCommand, this.peekCommand);
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.maskName);
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        if (this.obscuredToOthersImage != null) {
            s.add(this.obscuredToOthersImage);
        }
    }

    private static class Ed
    implements PieceEditor {
        private final ImageSelector picker;
        private final NamedHotKeyConfigurer obscureKeyInput;
        private final StringConfigurer obscureCommandInput;
        private final StringConfigurer maskNameInput;
        private final TranslatingStringEnumConfigurer displayOption;
        private final NamedHotKeyConfigurer peekKeyInput;
        private final StringConfigurer peekCommandInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final String[] optionNames = new String[]{"B", "P", "I", "U"};
        private final String[] optionKeys = new String[]{"Editor.Obscurable.background", "Editor.Obscurable.plain", "Editor.Obscurable.inset", "Editor.Obscurable.use_image"};
        private final char[] optionChars = new char[]{'B', 'P', 'I', 'G'};
        private final ImageSelector imagePicker;
        private final PieceAccessConfigurer accessConfig;
        private final JPanel showDisplayOption;
        private final JLabel peekKeyLabel;
        private final JLabel peekCommandLabel;

        public Ed(Obscurable p) {
            this.obscureCommandInput = new StringConfigurer(p.hideCommand);
            this.controls.add("Editor.Obscurable.mask_menu_command", (Configurer)this.obscureCommandInput);
            this.obscureKeyInput = new NamedHotKeyConfigurer(p.keyCommand);
            this.controls.add("Editor.Obscurable.mask_keyboard_command", (Configurer)this.obscureKeyInput);
            this.accessConfig = new PieceAccessConfigurer(p.access);
            this.controls.add("Editor.Obscurable.can_be_masked_by", (Configurer)this.accessConfig);
            this.picker = new ImageSelector(p.imageName, 512, 512);
            this.controls.add("Editor.Obscurable.view_when_masked", (Configurer)this.picker);
            this.maskNameInput = new StringConfigurer(p.maskName);
            this.controls.add("Editor.Obscurable.name_when_masked", (Configurer)this.maskNameInput);
            JPanel displayPanel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "[][][]"));
            JLabel displayLabel = new JLabel(Resources.getString("Editor.Obscurable.display_style"));
            displayLabel.setLabelFor(displayPanel);
            this.displayOption = new TranslatingStringEnumConfigurer(this.optionNames, this.optionKeys);
            for (int i = 0; i < this.optionNames.length; ++i) {
                if (p.displayStyle != this.optionChars[i]) continue;
                this.displayOption.setValue(this.optionNames[i]);
                break;
            }
            this.controls.add(displayLabel);
            displayPanel.add(this.displayOption.getControls());
            this.showDisplayOption = new JPanel(){
                private static final long serialVersionUID = 1L;

                @Override
                public Dimension getMinimumSize() {
                    return new Dimension(60, 60);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(60, 60);
                }

                @Override
                public void paint(Graphics g) {
                    g.clearRect(0, 0, this.getWidth(), this.getHeight());
                    switch (displayOption.getValueString().charAt(0)) {
                        case 'B': {
                            g.setColor(Color.black);
                            g.fillRect(0, 0, 60, 60);
                            g.setColor(Color.white);
                            g.fillRect(15, 15, 30, 30);
                            break;
                        }
                        case 'I': {
                            g.setColor(Color.white);
                            g.fillRect(0, 0, 60, 60);
                            g.setColor(Color.black);
                            g.fillRect(0, 0, 30, 30);
                            break;
                        }
                        case 'P': {
                            g.setColor(Color.black);
                            g.fillRect(0, 0, 60, 60);
                        }
                    }
                }
            };
            displayPanel.add(this.showDisplayOption);
            this.imagePicker = new ImageSelector(p.obscuredToOthersImage, 512, 512);
            this.imagePicker.getControls().setVisible(p.displayStyle == 'G');
            displayPanel.add(this.imagePicker.getControls());
            this.controls.add((Component)displayPanel, "wrap");
            this.peekKeyLabel = new JLabel(Resources.getString("Editor.Obscurable.peek_keyboard_command"));
            this.peekKeyInput = new NamedHotKeyConfigurer(p.peekKey);
            this.peekKeyLabel.setVisible(p.displayStyle == 'P');
            this.peekKeyInput.getControls().setVisible(p.displayStyle == 'P');
            this.controls.add(this.peekKeyLabel, (Configurer)this.peekKeyInput);
            this.peekCommandLabel = new JLabel(Resources.getString("Editor.Obscurable.peek_menu_command"));
            this.peekCommandInput = new StringConfigurer(p.peekCommand);
            this.peekCommandLabel.setVisible(p.displayStyle == 'P');
            this.peekCommandInput.getControls().setVisible(p.displayStyle == 'P');
            this.controls.add(this.peekCommandLabel, (Configurer)this.peekCommandInput);
            this.displayOption.addPropertyChangeListener(evt -> {
                this.showDisplayOption.repaint();
                this.peekKeyLabel.setVisible(this.optionNames[1].equals(evt.getNewValue()));
                this.peekKeyInput.getControls().setVisible(this.optionNames[1].equals(evt.getNewValue()));
                this.peekCommandLabel.setVisible(this.optionNames[1].equals(evt.getNewValue()));
                this.peekCommandInput.getControls().setVisible(this.optionNames[1].equals(evt.getNewValue()));
                this.imagePicker.getControls().setVisible(this.optionNames[3].equals(evt.getNewValue()));
                this.showDisplayOption.setVisible(!this.optionNames[3].equals(evt.getNewValue()));
                Decorator.repack(this.controls);
            });
        }

        @Override
        public String getState() {
            return "null";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.obscureKeyInput.getValueString()).append(this.picker.getValueString()).append(this.obscureCommandInput.getValueString());
            char optionChar = 'I';
            for (int i = 0; i < this.optionNames.length; ++i) {
                if (!this.optionNames[i].equals(this.displayOption.getValueString())) continue;
                optionChar = this.optionChars[i];
                break;
            }
            switch (optionChar) {
                case 'P': {
                    String valueString = this.peekKeyInput.getValueString();
                    if (valueString != null) {
                        se.append(optionChar + valueString);
                        break;
                    }
                    se.append(optionChar);
                    break;
                }
                case 'G': {
                    se.append(optionChar + this.imagePicker.getValueString());
                    break;
                }
                default: {
                    se.append(optionChar);
                }
            }
            se.append(this.maskNameInput.getValueString());
            se.append(this.accessConfig.getValueString());
            se.append(this.peekCommandInput.getValueString());
            return Obscurable.ID + se.getValue();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }
    }
}

