/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DrawPile;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ChooseComponentDialog;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;

public class ReturnToDeck
extends Decorator
implements TranslatablePiece {
    public static final String ID = "return;";
    protected String deckId;
    protected String returnCommand;
    protected String selectDeckPrompt = Resources.getString("Editor.ReturnToDeck.select_destination");
    protected NamedKeyStroke returnKey;
    protected DrawPile deck;
    protected KeyCommand[] commands;
    protected KeyCommand myCommand;

    public ReturnToDeck() {
        this(ID + Resources.getString("Editor.ReturnToDeck.default_command") + ";R;", null);
    }

    public ReturnToDeck(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            this.myCommand = new KeyCommand(this.returnCommand, this.returnKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.commands = this.returnCommand.length() > 0 && this.returnKey != null && !this.returnKey.isNull() ? new KeyCommand[]{this.myCommand} : new KeyCommand[0];
        }
        return this.commands;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public void mySetType(String s) {
        s = s.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ';');
        this.returnCommand = st.nextToken();
        this.returnKey = st.nextNamedKeyStroke(null);
        this.deckId = st.nextToken("");
        this.selectDeckPrompt = st.nextToken(this.selectDeckPrompt);
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        return ID + se.append(this.returnCommand).append(this.returnKey).append(this.deckId).append(this.selectDeckPrompt).getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        Command comm = null;
        if (this.myCommand.matches(stroke)) {
            DrawPile pile = this.deck;
            if (pile == null || this.deckId.length() == 0) {
                pile = this.findDeck();
            }
            if (pile == null) {
                return null;
            }
            Map preMap = this.getMap();
            Point prePos = this.getPosition();
            comm = ReturnToDeck.putOldProperties(this);
            comm = comm.append(pile.addToContents(Decorator.getOutermost(this)));
            Map m = pile.getMap();
            if (!(m == null || m.getMoveKey() == null || m == preMap && this.getPosition().equals(prePos))) {
                comm.append(Decorator.getOutermost(this).keyEvent(m.getMoveKey()));
            }
            if (m != null) {
                m.repaint();
            }
        }
        return comm;
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    private DrawPile findDeck() {
        DrawPile pile = null;
        if (this.deckId.length() > 0) {
            pile = DrawPile.findDrawPile(this.deckId);
        }
        if (pile == null) {
            return this.promptForDrawPile();
        }
        this.deck = pile;
        return pile;
    }

    private DrawPile promptForDrawPile() {
        JDialog d = new JDialog((Frame)GameModule.getGameModule().getPlayerWindow(), true);
        d.setTitle(Decorator.getInnermost(this).getName());
        d.setLayout(new BoxLayout(d.getContentPane(), 1));
        List<DrawPile> piles = GameModule.getGameModule().getAllDescendantComponentsOf(DrawPile.class);
        if (piles.isEmpty()) {
            ReturnToDeck.reportDataError(this, "No decks in module.");
            return null;
        }
        class AvailableDeck {
            private final DrawPile pile;

            public AvailableDeck(DrawPile pile) {
                this.pile = pile;
            }

            public String toString() {
                return this.pile.getConfigureName();
            }
        }
        AvailableDeck[] decks = new AvailableDeck[piles.size()];
        int i = 0;
        for (DrawPile p : piles) {
            decks[i++] = new AvailableDeck(p);
        }
        JList<AvailableDeck> list = new JList<AvailableDeck>(decks);
        list.setSelectionMode(0);
        JLabel prompt = new JLabel(this.selectDeckPrompt);
        prompt.setAlignmentX(0.5f);
        d.add(prompt);
        d.add(new ScrollPane(list));
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(0.5f);
        JButton b = new JButton(Resources.getString("General.ok"));
        b.addActionListener(e -> {
            AvailableDeck selection = (AvailableDeck)list.getSelectedValue();
            if (selection != null) {
                this.deck = selection.pile;
            }
            d.dispose();
        });
        box.add(b);
        b = new JButton(Resources.getString("General.cancel"));
        b.addActionListener(e -> d.dispose());
        box.add(b);
        d.add(box);
        d.pack();
        d.setLocationRelativeTo(d.getOwner());
        d.setVisible(true);
        DrawPile pile = this.deck;
        this.deck = null;
        return pile;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        String deckName = "";
        if (this.deck != null) {
            this.findDeck();
            if (this.deck != null) {
                deckName = this.deck.getConfigureName();
            }
        }
        return this.buildDescription("Editor.ReturnToDeck.trait_description", deckName);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ReturnToDeck.html");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.returnCommand, Resources.getString("Editor.ReturnToDeck.return_to_deck_command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof ReturnToDeck)) {
            return false;
        }
        ReturnToDeck c = (ReturnToDeck)o;
        if (!Objects.equals(this.returnCommand, c.returnCommand)) {
            return false;
        }
        if (!Objects.equals(this.returnKey, c.returnKey)) {
            return false;
        }
        if (!Objects.equals(this.deckId, c.deckId)) {
            return false;
        }
        return Objects.equals(this.selectDeckPrompt, c.selectDeckPrompt);
    }

    @Override
    public List<String> getPropertyList() {
        return List.of(this.deckId);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Collections.singletonList(this.returnKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.returnCommand);
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.selectDeckPrompt);
    }

    private static class Ed
    implements PieceEditor {
        private final StringConfigurer menuName;
        private final NamedHotKeyConfigurer menuKey;
        private final TraitConfigPanel controls;
        private String deckId;
        private final JTextField tf = new JTextField(12);
        private final JLabel promptLabel;
        private final StringConfigurer promptText;
        private final BooleanConfigurer prompt;
        private final JLabel selectLabel;
        private final JPanel selectPanel;

        public Ed(ReturnToDeck p) {
            this.controls = new TraitConfigPanel();
            this.deckId = p.deckId;
            this.menuName = new StringConfigurer(p.returnCommand);
            this.controls.add("Editor.menu_command", (Configurer)this.menuName);
            this.menuKey = new NamedHotKeyConfigurer(p.returnKey);
            this.controls.add("Editor.keyboard_command", (Configurer)this.menuKey);
            this.prompt = new BooleanConfigurer(p.deckId == null || p.deckId.isEmpty());
            this.prompt.addPropertyChangeListener(e -> this.updateVisibility());
            this.controls.add("Editor.ReturnToDeck.choose_destination_deck_at_game_time", (Configurer)this.prompt);
            this.selectPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[]rel[grow,fill]"));
            JButton select = new JButton(Resources.getString("Editor.ReturnToDeck.select_deck"));
            this.tf.setEditable(false);
            this.updateDeckName();
            select.addActionListener(e -> {
                ChooseComponentDialog d = new ChooseComponentDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.controls), DrawPile.class);
                d.setTitle(Resources.getString("Editor.ReturnToDeck.select_deck"));
                d.setVisible(true);
                if (d.getTarget() != null) {
                    this.deckId = UniqueIdManager.getIdentifier((UniqueIdManager.Identifyable)((Object)d.getTarget()));
                    this.updateDeckName();
                }
            });
            this.selectPanel.add(select);
            this.selectPanel.add((Component)this.tf, "grow");
            this.selectLabel = new JLabel(Resources.getString("Editor.ReturnToDeck.selected_deck"));
            this.controls.add(this.selectLabel, (Component)this.selectPanel, "grow");
            this.promptLabel = new JLabel(Resources.getString("Editor.ReturnToDeck.prompt_for_destination_deck"));
            this.promptText = new StringConfigurer(p.selectDeckPrompt);
            this.controls.add(this.promptLabel, (Configurer)this.promptText);
            this.updateVisibility();
        }

        private void updateVisibility() {
            this.promptLabel.setVisible(this.prompt.getValueBoolean());
            this.promptText.getControls().setVisible(this.prompt.getValueBoolean());
            this.selectPanel.setVisible(!this.prompt.getValueBoolean());
            this.selectLabel.setVisible(!this.prompt.getValueBoolean());
        }

        private void updateDeckName() {
            DrawPile p = DrawPile.findDrawPile(this.deckId);
            this.tf.setText((String)(p != null ? p.getConfigureName() : "[" + Resources.getString("Editor.ReturnToDeck.none") + "]"));
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.menuName.getValueString()).append(this.menuKey.getValueString()).append(this.prompt.getValueBoolean() ? "" : this.deckId).append(this.promptText.getValueString());
            return ReturnToDeck.ID + se.getValue();
        }
    }
}

