/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.properties.PropertySource;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.FormattedStringConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.NamedKeyStrokeArrayConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LoopControl;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.KeyStroke;

public class TriggerAction
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "macro;";
    protected String name = "";
    protected String command = "";
    protected NamedKeyStroke key = NamedKeyStroke.NULL_KEYSTROKE;
    protected PropertyExpression propertyMatch = new PropertyExpression();
    protected NamedKeyStroke[] watchKeys = new NamedKeyStroke[0];
    protected NamedKeyStroke[] actionKeys = new NamedKeyStroke[0];
    protected boolean loop = false;
    protected NamedKeyStroke preLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected NamedKeyStroke postLoopKey = NamedKeyStroke.NULL_KEYSTROKE;
    protected String loopType = "counted";
    protected PropertyExpression whileExpression = new PropertyExpression();
    protected PropertyExpression untilExpression = new PropertyExpression();
    protected FormattedString loopCount = new FormattedString("1");
    protected boolean index = false;
    protected String indexProperty = "";
    protected FormattedString indexStart = new FormattedString("1");
    protected FormattedString indexStep = new FormattedString("1");
    protected int indexValue = 0;
    protected GamePiece outer;

    public TriggerAction() {
        this(ID, null);
    }

    public TriggerAction(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command.length() > 0 && this.key != null) {
            KeyCommand c = new KeyCommand(this.command, this.key, Decorator.getOutermost(this), this.matchesFilter());
            if (this.getMap() == null) {
                c.setEnabled(false);
            }
            return new KeyCommand[]{c};
        }
        return new KeyCommand[0];
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.name).append(this.command).append(this.key).append(this.propertyMatch.getExpression()).append(NamedKeyStrokeArrayConfigurer.encode(this.watchKeys)).append(NamedKeyStrokeArrayConfigurer.encode(this.actionKeys)).append(this.loop).append(this.preLoopKey).append(this.postLoopKey).append(this.loopType).append(this.whileExpression.getExpression()).append(this.untilExpression.getExpression()).append(this.loopCount.getFormat()).append(this.index).append(this.indexProperty).append(this.indexStart.getFormat()).append(this.indexStep.getFormat());
        return ID + se.getValue();
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        Command c = this.piece.keyEvent(stroke);
        return c == null ? this.myKeyEvent(stroke) : c.append(this.myKeyEvent(stroke));
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        boolean seen = false;
        if (this.key.equals(stroke)) {
            seen = true;
        }
        for (int i = 0; i < this.watchKeys.length && !seen; ++i) {
            if (!this.watchKeys[i].equals(stroke)) continue;
            seen = true;
            break;
        }
        if (!seen) {
            return null;
        }
        if (!this.matchesFilter()) {
            return null;
        }
        this.outer = Decorator.getOutermost(this);
        Command c = new NullCommand();
        if (!this.loop) {
            try {
                c = c.append(this.doLoopOnce());
            }
            catch (RecursionLimitException e) {
                RecursionLimiter.infiniteLoop(e);
            }
            return c;
        }
        this.indexValue = this.parse("Index Property Start Value", this.indexStart, this.outer);
        int step = this.parse("Index Property increment value", this.indexStep, this.outer);
        c = c.append(this.executeKey(this.preLoopKey));
        int loopCounter = 0;
        int loopCountLimit = 0;
        if ("counted".equals(this.loopType)) {
            loopCountLimit = this.loopCount.getTextAsInt((PropertySource)this.outer, Resources.getString("Editor.LoopControl.loop_count"), this);
        }
        RecursionLimitException loopException = null;
        while (!"while".equals(this.loopType) || this.whileExpression.accept(this.outer)) {
            try {
                c = c.append(this.doLoopOnce());
            }
            catch (RecursionLimitException ex) {
                loopException = ex;
                break;
            }
            if ("until".equals(this.loopType) && this.untilExpression.accept(this.outer)) break;
            if (loopCounter++ >= 500) {
                loopException = new RecursionLimitException(this);
                break;
            }
            if ("counted".equals(this.loopType) && loopCounter >= loopCountLimit) break;
            this.indexValue += step;
        }
        c = c.append(this.executeKey(this.postLoopKey));
        if (loopException != null) {
            RecursionLimiter.infiniteLoop(loopException);
        }
        return c;
    }

    private int parse(String desc, FormattedString s, GamePiece outer) {
        int i = 0;
        String val = s.getText((PropertySource)outer, "0");
        try {
            i = Integer.parseInt(val);
        }
        catch (NumberFormatException e) {
            TriggerAction.reportDataError(this, Resources.getString("Error.non_number_error"), s.debugInfo(val, desc), e);
        }
        return i;
    }

    protected boolean isIndex() {
        return this.loop && this.index && this.indexProperty != null && this.indexProperty.length() > 0;
    }

    @Override
    public Object getProperty(Object key) {
        if (this.isIndex() && this.indexProperty.equals(key)) {
            return String.valueOf(this.indexValue);
        }
        return super.getProperty(key);
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if (this.isIndex() && this.indexProperty.equals(key)) {
            return String.valueOf(this.indexValue);
        }
        return super.getLocalizedProperty(key);
    }

    protected Command doLoopOnce() throws RecursionLimitException {
        Command comm = new NullCommand();
        try {
            RecursionLimiter.startExecution(this);
            for (int i = 0; i < this.actionKeys.length && this.getMap() != null; ++i) {
                comm = comm.append(this.outer.keyEvent(this.actionKeys[i].getKeyStroke()));
            }
        }
        finally {
            RecursionLimiter.endExecution();
        }
        return comm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Command executeKey(NamedKeyStroke key) {
        if (key.isNull() || this.getMap() == null) {
            return null;
        }
        Command comm = null;
        try {
            RecursionLimiter.startExecution(this);
            comm = this.outer.keyEvent(key.getKeyStroke());
        }
        catch (RecursionLimitException e) {
            RecursionLimiter.infiniteLoop(e);
        }
        finally {
            RecursionLimiter.endExecution();
        }
        return comm;
    }

    protected boolean matchesFilter() {
        return this.propertyMatch.isNull() || this.propertyMatch.accept(Decorator.getOutermost(this));
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getDescription() {
        Object s = Resources.getString("Editor.TriggerAction.component_type");
        if (this.name.length() > 0) {
            s = (String)s + " - " + this.name;
        }
        return s;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("TriggerAction.html");
    }

    @Override
    public void mySetType(String type) {
        int i;
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.name = st.nextToken("");
        this.command = st.nextToken("Trigger");
        this.key = st.nextNamedKeyStroke('T');
        this.propertyMatch.setExpression(st.nextToken(""));
        String keys = st.nextToken("");
        if (keys.indexOf(44) > 0) {
            this.watchKeys = NamedKeyStrokeArrayConfigurer.decode(keys);
        } else {
            this.watchKeys = new NamedKeyStroke[keys.length()];
            for (i = 0; i < this.watchKeys.length; ++i) {
                this.watchKeys[i] = NamedKeyStroke.getNamedKeyStroke(keys.charAt(i), 128);
            }
        }
        keys = st.nextToken("");
        if (keys.indexOf(44) > 0) {
            this.actionKeys = NamedKeyStrokeArrayConfigurer.decode(keys);
        } else {
            this.actionKeys = new NamedKeyStroke[keys.length()];
            for (i = 0; i < this.actionKeys.length; ++i) {
                this.actionKeys[i] = NamedKeyStroke.getNamedKeyStroke(keys.charAt(i), 128);
            }
        }
        this.loop = st.nextBoolean(false);
        this.preLoopKey = st.nextNamedKeyStroke();
        this.postLoopKey = st.nextNamedKeyStroke();
        this.loopType = st.nextToken("counted");
        this.whileExpression.setExpression(st.nextToken(""));
        this.untilExpression.setExpression(st.nextToken(""));
        this.loopCount.setFormat(st.nextToken(""));
        this.index = st.nextBoolean(false);
        this.indexProperty = st.nextToken("");
        this.indexStart.setFormat(st.nextToken("1"));
        this.indexStep.setFormat(st.nextToken("1"));
    }

    @Override
    public List<String> getPropertyNames() {
        if (this.isIndex()) {
            ArrayList<String> l = new ArrayList<String>();
            l.add(this.indexProperty);
            return l;
        }
        return super.getPropertyNames();
    }

    public void setPropertyMatch(String s) {
        this.propertyMatch.setExpression(s);
    }

    public void setCommandName(String s) {
        this.command = s;
    }

    public void setKey(NamedKeyStroke k) {
        this.key = k;
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.command, this.getCommandDescription(this.name, "Trigger command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof TriggerAction)) {
            return false;
        }
        TriggerAction c = (TriggerAction)o;
        if (!Objects.equals(this.command, c.command)) {
            return false;
        }
        if (!Objects.equals(this.key, c.key)) {
            return false;
        }
        if (!Objects.equals(this.propertyMatch, c.propertyMatch)) {
            return false;
        }
        if (!Arrays.equals(this.watchKeys, c.watchKeys)) {
            return false;
        }
        if (!Arrays.equals(this.actionKeys, c.actionKeys)) {
            return false;
        }
        if (!Objects.equals(this.loop, c.loop)) {
            return false;
        }
        if (!Objects.equals(this.preLoopKey, c.preLoopKey)) {
            return false;
        }
        if (!Objects.equals(this.postLoopKey, c.postLoopKey)) {
            return false;
        }
        if (!Objects.equals(this.loopType, c.loopType)) {
            return false;
        }
        if (!Objects.equals(this.whileExpression, c.whileExpression)) {
            return false;
        }
        if (!Objects.equals(this.untilExpression, c.untilExpression)) {
            return false;
        }
        if (!Objects.equals(this.loopCount, c.loopCount)) {
            return false;
        }
        if (!Objects.equals(this.index, c.index)) {
            return false;
        }
        if (!Objects.equals(this.indexProperty, c.indexProperty)) {
            return false;
        }
        if (!Objects.equals(this.indexStart, c.indexStart)) {
            return false;
        }
        return Objects.equals(this.indexStep, c.indexStep);
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    @Override
    public List<String> getExpressionList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.propertyMatch.getExpression());
        if (this.loop) {
            if ("while".equals(this.loopType)) {
                l.add(this.whileExpression.getExpression());
            } else if ("until".equals(this.loopType)) {
                l.add(this.untilExpression.getExpression());
            } else if ("counted".equals(this.loopType)) {
                l.add(this.indexStart.getFormat());
                l.add(this.indexStep.getFormat());
            }
        }
        return l;
    }

    @Override
    public List<String> getPropertyList() {
        if (this.loop && "counted".equals(this.loopType)) {
            return List.of(this.indexProperty);
        }
        return new ArrayList<String>();
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>();
        l.add(this.key);
        Collections.addAll(l, this.watchKeys);
        Collections.addAll(l, this.actionKeys);
        if (this.loop) {
            l.add(this.preLoopKey);
            l.add(this.postLoopKey);
        }
        return l;
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.command);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer name;
        private final StringConfigurer command;
        private final NamedHotKeyConfigurer key;
        private final PropertyExpressionConfigurer propertyMatch;
        private final NamedKeyStrokeArrayConfigurer watchKeys;
        private final NamedKeyStrokeArrayConfigurer actionKeys;
        private final TraitConfigPanel box;
        private final BooleanConfigurer loopConfig;
        private final JLabel preLabel;
        private final NamedHotKeyConfigurer preLoopKeyConfig;
        private final JLabel postLabel;
        private final NamedHotKeyConfigurer postLoopKeyConfig;
        private final JLabel loopTypeLabel;
        private final TranslatingStringEnumConfigurer loopTypeConfig;
        private final JLabel whileLabel;
        private final PropertyExpressionConfigurer whileExpressionConfig;
        private final JLabel untilLabel;
        private final PropertyExpressionConfigurer untilExpressionConfig;
        private final JLabel loopCountLabel;
        private final FormattedStringConfigurer loopCountConfig;
        private final JLabel indexLabel;
        private final BooleanConfigurer indexConfig;
        private final JLabel indexPropertyLabel;
        private final StringConfigurer indexPropertyConfig;
        private final JLabel indexStartLabel;
        private final FormattedStringConfigurer indexStartConfig;
        private final JLabel indexStepLabel;
        private final FormattedStringConfigurer indexStepConfig;

        public Ed(TriggerAction piece) {
            PropertyChangeListener updateListener = arg0 -> this.updateVisibility();
            this.box = new TraitConfigPanel();
            this.name = new StringConfigurer(piece.name);
            this.name.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.name);
            this.propertyMatch = new PropertyExpressionConfigurer(piece.propertyMatch, Decorator.getOutermost(piece));
            this.propertyMatch.setHintKey("Editor.TriggerAction.property_match_hint");
            this.box.add("Editor.TriggerAction.trigger_when_properties", (Configurer)this.propertyMatch);
            this.command = new StringConfigurer(piece.command);
            this.box.add("Editor.menu_command", (Configurer)this.command);
            this.key = new NamedHotKeyConfigurer(piece.key);
            this.box.add("Editor.keyboard_command", (Configurer)this.key);
            this.watchKeys = new NamedKeyStrokeArrayConfigurer(piece.watchKeys);
            this.box.add("Editor.TriggerAction.watch_for", (Configurer)this.watchKeys);
            this.actionKeys = new NamedKeyStrokeArrayConfigurer(piece.actionKeys);
            this.box.add("Editor.TriggerAction.perform_keystrokes", (Configurer)this.actionKeys);
            this.loopConfig = new BooleanConfigurer(piece.loop);
            this.loopConfig.addPropertyChangeListener(updateListener);
            this.box.add("Editor.TriggerAction.repeat_this", (Configurer)this.loopConfig);
            this.loopTypeLabel = new JLabel(Resources.getString("Editor.LoopControl.type_of_loop"));
            this.loopTypeConfig = new TranslatingStringEnumConfigurer(LoopControl.LOOP_TYPES, LoopControl.LOOP_TYPE_DESCS, true);
            this.loopTypeConfig.setValue(piece.loopType);
            this.loopTypeConfig.addPropertyChangeListener(updateListener);
            this.box.add(this.loopTypeLabel, (Configurer)this.loopTypeConfig);
            this.loopCountLabel = new JLabel(Resources.getString("Editor.LoopControl.loop_how_many"));
            this.loopCountConfig = new FormattedExpressionConfigurer(piece.loopCount.getFormat(), piece);
            this.loopCountConfig.setHintKey("Editor.LoopControl.loop_how_many_hint");
            this.box.add(this.loopCountLabel, (Configurer)this.loopCountConfig);
            this.whileLabel = new JLabel(Resources.getString("Editor.TriggerAction.looping_continues"));
            this.whileExpressionConfig = new PropertyExpressionConfigurer(piece.whileExpression);
            this.whileExpressionConfig.setHintKey("Editor.property_match_hint");
            this.box.add(this.whileLabel, (Configurer)this.whileExpressionConfig);
            this.untilLabel = new JLabel(Resources.getString("Editor.TriggerAction.looping_ends"));
            this.untilExpressionConfig = new PropertyExpressionConfigurer(piece.untilExpression);
            this.untilExpressionConfig.setHintKey("Editor.property_match_hint");
            this.box.add(this.untilLabel, (Configurer)this.untilExpressionConfig);
            this.preLabel = new JLabel(Resources.getString("Editor.TriggerAction.keystroke_before"));
            this.preLoopKeyConfig = new NamedHotKeyConfigurer(piece.preLoopKey);
            this.box.add(this.preLabel, (Configurer)this.preLoopKeyConfig);
            this.postLabel = new JLabel(Resources.getString("Editor.TriggerAction.keystroke_after"));
            this.postLoopKeyConfig = new NamedHotKeyConfigurer(piece.postLoopKey);
            this.box.add(this.postLabel, (Configurer)this.postLoopKeyConfig);
            this.indexLabel = new JLabel(Resources.getString("Editor.LoopControl.loop_index"));
            this.indexConfig = new BooleanConfigurer(piece.index);
            this.indexConfig.addPropertyChangeListener(updateListener);
            this.box.add(this.indexLabel, (Configurer)this.indexConfig);
            this.indexPropertyLabel = new JLabel(Resources.getString("Editor.LoopControl.index_name"));
            this.indexPropertyConfig = new StringConfigurer(piece.indexProperty);
            this.indexPropertyConfig.setHintKey("Editor.LoopControl.index_name_hint");
            this.box.add(this.indexPropertyLabel, (Configurer)this.indexPropertyConfig);
            this.indexStartLabel = new JLabel(Resources.getString("Editor.LoopControl.index_start"));
            this.indexStartConfig = new FormattedExpressionConfigurer(piece.indexStart.getFormat(), piece);
            this.box.add(this.indexStartLabel, (Configurer)this.indexStartConfig);
            this.indexStepLabel = new JLabel(Resources.getString("Editor.LoopControl.index_step"));
            this.indexStepConfig = new FormattedExpressionConfigurer(piece.indexStep.getFormat(), piece);
            this.box.add(this.indexStepLabel, (Configurer)this.indexStepConfig);
            this.updateVisibility();
        }

        private void updateVisibility() {
            boolean isLoop = this.loopConfig.booleanValue();
            boolean isIndex = this.indexConfig.booleanValue();
            String type = this.loopTypeConfig.getValueString();
            this.loopTypeConfig.getControls().setVisible(isLoop);
            this.loopTypeLabel.setVisible(isLoop);
            this.loopCountConfig.getControls().setVisible(isLoop && type.equals("counted"));
            this.loopCountLabel.setVisible(isLoop && type.equals("counted"));
            this.whileExpressionConfig.getControls().setVisible(isLoop && type.equals("while"));
            this.whileLabel.setVisible(isLoop && type.equals("while"));
            this.untilExpressionConfig.getControls().setVisible(isLoop && type.equals("until"));
            this.untilLabel.setVisible(isLoop && type.equals("until"));
            this.preLoopKeyConfig.getControls().setVisible(isLoop);
            this.preLabel.setVisible(isLoop);
            this.postLoopKeyConfig.getControls().setVisible(isLoop);
            this.postLabel.setVisible(isLoop);
            this.indexConfig.getControls().setVisible(isLoop);
            this.indexLabel.setVisible(isLoop);
            this.indexPropertyConfig.getControls().setVisible(isLoop && isIndex);
            this.indexPropertyLabel.setVisible(isLoop && isIndex);
            this.indexStartConfig.getControls().setVisible(isLoop && isIndex);
            this.indexStartLabel.setVisible(isLoop && isIndex);
            this.indexStepConfig.getControls().setVisible(isLoop && isIndex);
            this.indexStepLabel.setVisible(isLoop && isIndex);
            Decorator.repack(this.box);
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.name.getValueString()).append(this.command.getValueString()).append(this.key.getValueString()).append(this.propertyMatch.getValueString()).append(this.watchKeys.getValueString()).append(this.actionKeys.getValueString()).append(this.loopConfig.getValueString()).append(this.preLoopKeyConfig.getValueString()).append(this.postLoopKeyConfig.getValueString()).append(LoopControl.loopDescToType(this.loopTypeConfig.getValueString())).append(this.whileExpressionConfig.getValueString()).append(this.untilExpressionConfig.getValueString()).append(this.loopCountConfig.getValueString()).append(this.indexConfig.getValueString()).append(this.indexPropertyConfig.getValueString()).append(this.indexStartConfig.getValueString()).append(this.indexStepConfig.getValueString());
            return TriggerAction.ID + se.getValue();
        }
    }
}

