/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.preferences;

import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.BrowserSupport;
import VASSAL.tools.SplashScreen;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.miginfocom.swing.MigLayout;

public class PrefsEditor {
    private JDialog dialog;
    private final List<Configurer> options = new ArrayList<Configurer>();
    private final List<Configurer> extras = new ArrayList<Configurer>();
    private boolean iterating = false;
    private final Map<Configurer, Object> savedValues = new HashMap<Configurer, Object>();
    private final List<Prefs> prefs = new ArrayList<Prefs>();
    private final JTabbedPane optionsTab = new JTabbedPane();
    private JDialog setupDialog;
    private Action editAction;

    public void initDialog(Frame parent) {
        if (this.dialog == null) {
            this.dialog = new JDialog(parent, true);
            this.dialog.setTitle(Resources.getString("Prefs.preferences"));
            this.dialog.setDefaultCloseOperation(0);
            this.dialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent we) {
                    PrefsEditor.this.cancel();
                }
            });
            JButton help = new JButton(Resources.getString("General.help"));
            help.addActionListener(e -> {
                int index = this.optionsTab.getSelectedIndex();
                String tabName = index >= 0 ? this.optionsTab.getTitleAt(index) : "top";
                HelpFile helpFile = HelpFile.getReferenceManualPage("Preferences.html", tabName);
                BrowserSupport.openURL(helpFile.getContents().toString());
            });
            JButton ok = new JButton(Resources.getString("General.ok"));
            ok.addActionListener(e -> this.save());
            JButton cancel = new JButton(Resources.getString("General.cancel"));
            cancel.addActionListener(e -> this.cancel());
            this.dialog.setLayout((LayoutManager)new MigLayout("insets dialog"));
            this.dialog.add((Component)this.optionsTab, "push, grow, wrap unrelated");
            this.dialog.add((Component)help, "tag help, split");
            this.dialog.add((Component)ok, "tag ok, split");
            this.dialog.add((Component)cancel, "tag cancel");
        }
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void addPrefs(Prefs p) {
        this.prefs.add(p);
    }

    public void addOption(String category, Configurer c, String prompt) {
        if (prompt != null) {
            if (this.setupDialog == null) {
                this.setupDialog = new JDialog((Frame)null, true);
                this.setupDialog.setTitle(Resources.getString("Prefs.initial_setup"));
                this.setupDialog.setLayout(new BoxLayout(this.setupDialog.getContentPane(), 1));
                this.setupDialog.setDefaultCloseOperation(0);
                this.setupDialog.addComponentListener(new ComponentAdapter(){

                    @Override
                    public void componentShown(ComponentEvent e) {
                        SplashScreen.sendAllToBack();
                    }
                });
            }
            JPanel p = new JPanel();
            p.add(new JLabel(prompt));
            this.setupDialog.add(p);
            this.setupDialog.add(c.getControls());
            JButton b = new JButton(Resources.getString("General.ok"));
            b.addActionListener(evt -> this.setupDialog.setVisible(false));
            p = new JPanel();
            p.add(b);
            this.setupDialog.add(p);
            this.setupDialog.pack();
            Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
            this.setupDialog.setLocation(d.width / 2 - this.setupDialog.getSize().width / 2, d.height / 2 - this.setupDialog.getSize().height / 2);
            this.setupDialog.setVisible(true);
            this.setupDialog.removeAll();
        }
        this.addOption(category, c);
    }

    public synchronized void addOption(String category, Configurer c) {
        JPanel pan;
        int i;
        if (category == null) {
            category = Resources.getString("Prefs.general_tab");
        }
        if ((i = this.optionsTab.indexOfTab(category)) == -1) {
            pan = new JPanel();
            pan.setLayout((LayoutManager)new MigLayout("ins panel,gapy 4", "[right][fill,grow]"));
            this.optionsTab.addTab(category, pan);
        } else {
            pan = (JPanel)this.optionsTab.getComponentAt(i);
        }
        if (this.iterating) {
            this.extras.add(c);
        } else {
            this.options.add(c);
        }
        String name = c.getName();
        JLabel label = new JLabel(name);
        c.setLabelVisibile(false);
        label.setLabelFor(c.getControls());
        pan.add(label);
        pan.add(c.getControls(), "grow,wrap");
    }

    private synchronized void storeValues() {
        this.savedValues.clear();
        for (Configurer c : this.options) {
            c.setFrozen(true);
            if (c.getValue() == null) continue;
            this.savedValues.put(c, c.getValue());
        }
    }

    protected synchronized void cancel() {
        for (Configurer c : this.options) {
            Object o = this.savedValues.get(c);
            if (o != null) {
                c.setValue(o);
            }
            c.setFrozen(false);
        }
        this.dialog.setVisible(false);
        for (Prefs p : this.prefs) {
            p.setDisableAutoWrite(false);
        }
    }

    protected synchronized void save() {
        this.iterating = true;
        for (Configurer c : this.options) {
            if (this.savedValues.get(c) == null && c.getValue() != null || this.savedValues.get(c) != null && !this.savedValues.get(c).equals(c.getValue())) {
                c.fireUpdate();
            }
            c.setFrozen(false);
        }
        this.iterating = false;
        this.options.addAll(this.extras);
        this.extras.clear();
        this.write();
        this.dialog.setVisible(false);
        for (Prefs p : this.prefs) {
            p.setDisableAutoWrite(false);
        }
    }

    public Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new AbstractAction(Resources.getString("Prefs.edit_preferences")){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    for (Prefs p : PrefsEditor.this.prefs) {
                        p.setDisableAutoWrite(true);
                    }
                    PrefsEditor.this.storeValues();
                    PrefsEditor.this.dialog.pack();
                    Dimension d = SwingUtils.getScreenSize();
                    PrefsEditor.this.dialog.setLocation(d.width / 2 - PrefsEditor.this.dialog.getWidth() / 2, 0);
                    SwingUtils.ensureOnScreen(PrefsEditor.this.dialog);
                    PrefsEditor.this.dialog.setVisible(true);
                }
            };
            this.editAction.putValue("MnemonicKey", Resources.getString("Prefs.edit_preferences").charAt(0));
        }
        return this.editAction;
    }

    public void write() {
        for (Prefs p : this.prefs) {
            try {
                p.save();
            }
            catch (IOException e) {
                WriteErrorDialog.error(e, p.getFile());
            }
        }
    }

    public void close() {
        this.write();
    }
}

