/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.search;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.i18n.Resources;
import VASSAL.tools.DataArchive;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.io.IOUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import org.jsoup.Jsoup;

public class HTMLImageFinder {
    String fileName = "";
    String fileString;

    public HTMLImageFinder(File file) {
        this.fileName = file.getName();
        DataArchive mda = GameModule.getGameModule().getDataArchive();
        try (InputStream inner = mda.getInputStream(file.getPath());
             BufferedInputStream in = new BufferedInputStream(inner);){
            this.fileString = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            ErrorDialog.dataWarning(new BadDataReport(Resources.getString("Error.not_found", "HTMLImageFinder"), file.getName(), e));
            this.fileString = "<html>...</html>";
        }
    }

    public HTMLImageFinder(String string) {
        this.fileString = string.toLowerCase().contains("<html>") ? string : "<html>" + string.trim() + "</html>";
    }

    public void addImageNames(Collection<String> s) {
        s.addAll(Jsoup.parse((String)this.fileString).getElementsByTag("img").eachAttr("src"));
    }
}

