/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.build.GameModule;
import VASSAL.configure.PasswordConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.preferences.Prefs;
import VASSAL.tools.WriteErrorDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class UsernameAndPasswordDialog
extends JDialog {
    private static final long serialVersionUID = 1L;

    public UsernameAndPasswordDialog(Frame parent) {
        super(parent, Resources.getString("Editor.UsernameAndPasswordDialog.choose_your_weapons"), true);
        this.setLocationRelativeTo(parent);
        this.setDefaultCloseOperation(2);
        this.setLayout((LayoutManager)new MigLayout("ins panel,gapy 4,wrap 2", "[right]rel[fill,grow]"));
        this.add(new JLabel(Resources.getString("WizardSupport.RealName")));
        StringConfigurer nameConfig = new StringConfigurer("");
        this.add(nameConfig.getControls());
        this.add(new JLabel(Resources.getString("WizardSupport.Password")));
        PasswordConfigurer pwd = new PasswordConfigurer(null, "");
        this.add(pwd.getControls());
        this.add(new JLabel(Resources.getString("WizardSupport.ConfirmPassword")));
        PasswordConfigurer pwd2 = new PasswordConfigurer(null, "");
        this.add(pwd2.getControls());
        JLabel note = new JLabel(Resources.getString("WizardSupport.NameAndPasswordDetails"));
        this.add((Component)note, "span 2,center");
        JLabel error = new JLabel(Resources.getString("WizardSupport.EnterNameAndPassword"));
        this.add((Component)error, "span 2,center");
        JButton ok = new JButton(Resources.getString("General.ok"));
        ok.setEnabled(false);
        ok.addActionListener(e -> {
            Prefs p = GameModule.getGameModule().getPrefs();
            p.getOption("RealName").setValue(nameConfig.getValueString());
            p.getOption("SecretName").setValue(pwd.getValueString());
            try {
                p.write();
            }
            catch (IOException ex) {
                WriteErrorDialog.error(ex, p.getFile());
            }
            this.dispose();
        });
        JButton cancel = new JButton(Resources.getString("General.cancel"));
        cancel.addActionListener(e -> this.dispose());
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]push"));
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        this.add((Component)buttonPanel, "span 2,center");
        this.pack();
        this.setMinimumSize(this.getSize());
        PropertyChangeListener pl = evt -> {
            if (nameConfig.getValue() == null || "".equals(nameConfig.getValue())) {
                if (pwd.getValue() == null || "".equals(pwd.getValue())) {
                    error.setText(Resources.getString("WizardSupport.EnterNameAndPassword"));
                } else {
                    error.setText(Resources.getString("WizardSupport.EnterYourName"));
                }
                error.setForeground(Color.black);
                ok.setEnabled(false);
            } else if (pwd.getValue() == null || "".equals(pwd.getValue())) {
                error.setText(Resources.getString("WizardSupport.EnterYourPassword"));
                error.setForeground(Color.black);
                ok.setEnabled(false);
            } else if (pwd2.getValue() == null || "".equals(pwd2.getValue())) {
                error.setText(Resources.getString("Editor.UsernameAndPasswordDialog.turn_your_key_sir"));
                error.setForeground(Color.black);
                ok.setEnabled(false);
            } else if (!pwd.getValue().equals(pwd2.getValue())) {
                error.setText(Resources.getString("WizardSupport.PasswordsDontMatch"));
                error.setForeground(Color.red);
                ok.setEnabled(false);
            } else {
                error.setText("");
                error.setForeground(Color.black);
                ok.setEnabled(true);
            }
        };
        nameConfig.addPropertyChangeListener(pl);
        pwd.addPropertyChangeListener(pl);
        pwd2.addPropertyChangeListener(pl);
    }
}

