/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.svg;

import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import java.awt.Dimension;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.NoSuchFileException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.BridgeException;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.UserAgentAdapter;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.dom.util.DOMUtilities;
import org.apache.batik.dom.util.SAXDocumentFactory;
import org.apache.batik.dom.util.XLinkSupport;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.util.XMLResourceDescriptor;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.svg.SVGDocument;
import org.w3c.dom.svg.SVGSVGElement;

public class SVGImageUtils {
    private static final SAXSVGDocumentFactory FACTORY = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());

    private SVGImageUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SVGDocument getDocument(String file, InputStream in) throws IOException {
        try (InputStream inputStream = in;){
            SAXSVGDocumentFactory sAXSVGDocumentFactory = FACTORY;
            synchronized (sAXSVGDocumentFactory) {
                SVGDocument sVGDocument = FACTORY.createSVGDocument(file, in);
                return sVGDocument;
            }
        }
        catch (DOMException e) {
            throw new IOException(e);
        }
    }

    public static Dimension getImageSize(String file, InputStream in) throws IOException {
        try {
            return SVGImageUtils.getImageSize(SVGImageUtils.getDocument(file, in));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new ImageNotFoundException(file, (Throwable)e);
        }
        catch (IOException | DOMException e) {
            throw new ImageIOException(file, (Throwable)e);
        }
    }

    public static Dimension getImageSize(SVGDocument doc) throws IOException {
        SVGSVGElement root = doc.getRootElement();
        BridgeContext bctx = new BridgeContext((UserAgent)new UserAgentAdapter());
        UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)bctx, (Element)root);
        float w = -1.0f;
        String ws = root.getAttributeNS(null, "width");
        if (!ws.isEmpty()) {
            try {
                w = UnitProcessor.svgHorizontalLengthToUserSpace((String)ws, (String)"width", (UnitProcessor.Context)uctx);
            }
            catch (BridgeException e) {
                throw new IOException(e);
            }
        }
        float h = -1.0f;
        String hs = root.getAttributeNS(null, "height");
        if (!hs.isEmpty()) {
            try {
                h = UnitProcessor.svgVerticalLengthToUserSpace((String)hs, (String)"height", (UnitProcessor.Context)uctx);
            }
            catch (BridgeException e) {
                throw new IOException(e);
            }
        }
        float[] vb = null;
        String vbs = root.getAttributeNS(null, "viewBox");
        if (!vbs.isEmpty()) {
            try {
                vb = ViewBox.parseViewBoxAttribute((Element)root, (String)vbs, (BridgeContext)bctx);
            }
            catch (BridgeException e) {
                throw new IOException(e);
            }
        }
        if (w < 0.0f || h < 0.0f) {
            if (!vbs.isEmpty()) {
                if (vb != null) {
                    if (w < 0.0f) {
                        w = vb[2];
                    }
                    if (h < 0.0f) {
                        h = vb[3];
                    }
                }
            } else if (h >= 0.0f) {
                w = h;
            } else if (w >= 0.0f) {
                h = w;
            } else {
                h = 0.0f;
                w = 0.0f;
            }
        }
        return new Dimension((int)(w + 0.5f), (int)(h + 0.5f));
    }

    public static Dimension getImageSize(InputStream in) throws IOException {
        return SVGImageUtils.getImageSize("", in);
    }

    public static List<String> getExternalReferences(String path) throws IOException {
        ArrayList<String> reflist = new ArrayList<String>();
        reflist.add(path);
        return SVGImageUtils.getExternalReferences(path, reflist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static List<String> getExternalReferences(String path, List<String> known) throws IOException {
        URL here = new URL("file", null, new File(path).getCanonicalPath());
        Document doc = null;
        try {
            SAXSVGDocumentFactory sAXSVGDocumentFactory = FACTORY;
            synchronized (sAXSVGDocumentFactory) {
                doc = FACTORY.createDocument(here.toString());
            }
        }
        catch (DOMException e) {
            throw new IOException(e);
        }
        HashSet<String> follow = new HashSet<String>();
        NodeList usenodes = doc.getElementsByTagName("use");
        for (int i = 0; i < usenodes.getLength(); ++i) {
            Element e = (Element)usenodes.item(i);
            URL url = new URL(new URL(e.getBaseURI()), XLinkSupport.getXLinkHref((Element)e));
            if (url.getProtocol().equals("file")) {
                String refpath = url.getPath();
                if (known.contains(refpath)) continue;
                follow.add(refpath);
                known.add(refpath);
                continue;
            }
            throw new IOException("unsupported protocol '" + url.getProtocol() + "' in xlink:href");
        }
        for (String s : follow) {
            known.addAll(SVGImageUtils.getExternalReferences(s, known));
        }
        return known;
    }

    public static byte[] relativizeExternalReferences(String path) throws IOException {
        SAXDocumentFactory fac = new SAXDocumentFactory((DOMImplementation)new GenericDOMImplementation(), XMLResourceDescriptor.getXMLParserClassName());
        URL here = new URL("file", null, new File(path).getCanonicalPath());
        StringWriter sw = new StringWriter();
        try {
            Document doc = fac.createDocument(here.toString());
            SVGImageUtils.relativizeElement(doc.getDocumentElement());
            DOMUtilities.writeDocument((Document)doc, (Writer)sw);
        }
        catch (DOMException e) {
            throw new IOException(e);
        }
        sw.flush();
        return sw.toString().getBytes(StandardCharsets.UTF_8);
    }

    protected static void relativizeElement(Element e) {
        NodeList children = e.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node n = children.item(i);
            if (n.getNodeType() != 1) continue;
            SVGImageUtils.relativizeElement((Element)n);
        }
        if (e.hasAttributeNS("http://www.w3.org/1999/xlink", "href")) {
            try {
                URL url = new URL(new URL(e.getBaseURI()), XLinkSupport.getXLinkHref((Element)e));
                String anchor = url.getRef();
                String name = new File(url.getPath()).getName();
                XLinkSupport.setXLinkHref((Element)e, (String)(name + "#" + anchor));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        e.removeAttributeNS("http://www.w3.org/XML/1998/namespace", "base");
    }
}

