/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.gamepieceimage;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.gamepieceimage.ColorSwatch;
import VASSAL.build.module.gamepieceimage.ColorSwatchConfigurer;
import VASSAL.build.module.gamepieceimage.GamePieceLayout;
import VASSAL.build.module.gamepieceimage.ImageItemInstance;
import VASSAL.build.module.gamepieceimage.InstanceConfigurer;
import VASSAL.build.module.gamepieceimage.Item;
import VASSAL.build.module.gamepieceimage.ItemInstance;
import VASSAL.build.module.gamepieceimage.ShapeItemInstance;
import VASSAL.build.module.gamepieceimage.SymbolItemInstance;
import VASSAL.build.module.gamepieceimage.TextBoxItemInstance;
import VASSAL.build.module.gamepieceimage.TextItemInstance;
import VASSAL.build.module.gamepieceimage.Visualizable;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.tools.ArchiveWriter;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.SourceOp;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;

public class GamePieceImage
extends AbstractConfigurable
implements Visualizable,
Cloneable,
UniqueIdManager.Identifyable {
    protected static final String NAME = "name";
    protected static final String PROPS = "props";
    public static final String PART_SIZE = "Size";
    public static final String PART_SYMBOL1 = "Symbol1";
    public static final String PART_SYMBOL2 = "Symbol2";
    public static final String BG_COLOR = "bgColor";
    public static final String BORDER_COLOR = "borderColor";
    protected List<ItemInstance> instances = new ArrayList<ItemInstance>();
    protected InstanceConfigurer defnConfig = null;
    protected GamePieceLayout layout;
    protected ColorSwatch bgColor = ColorSwatch.getWhite();
    protected ColorSwatch borderColor = ColorSwatch.getBlack();
    protected String id;
    protected static final UniqueIdManager idMgr = new UniqueIdManager("GamePieceImage");
    protected String nameInUse;
    protected Image visImage = null;
    protected SourceOp srcOp;
    private final VisibilityCondition borderCond = () -> {
        if (this.getLayout() == null) {
            return false;
        }
        return this.getLayout().isColoredBorder();
    };

    public GamePieceImage() {
        this.setConfigureName("");
    }

    public GamePieceImage(String s) {
        this.instances = InstanceConfigurer.StringToProperties(s, this);
    }

    public GamePieceImage(GamePieceLayout l) {
        this();
        this.setConfigureName(l.getConfigureName());
        this.layout = l;
    }

    public GamePieceImage(GamePieceImage defn) {
        this();
        this.setConfigureName(defn.getConfigureName());
        this.layout = defn.getLayout();
        this.bgColor = defn.getBgColor();
        this.borderColor = defn.getBorderColor();
        this.instances.addAll(defn.getInstances());
    }

    public Object clone() {
        return new GamePieceImage(this);
    }

    public List<ItemInstance> getInstances() {
        return this.instances;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.background_color"), Resources.getString("Editor.border_color"), ""};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, BgColorSwatchConfig.class, BorderColorSwatchConfig.class, DefnConfig.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, BG_COLOR, BORDER_COLOR, PROPS};
    }

    public ColorSwatch getBgColor() {
        return this.bgColor;
    }

    public ColorSwatch getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            String newName = (String)((Object)value);
            String oldName = this.getConfigureName();
            if (newName != oldName && oldName.length() > 0) {
                ArchiveWriter w = GameModule.getGameModule().getArchiveWriter();
                w.removeImage(oldName);
                w.addImage(newName, this.getEncodedImage((BufferedImage)this.visImage));
            }
            this.setConfigureName(newName);
        } else if (BG_COLOR.equals(key)) {
            if (value instanceof String) {
                value = new ColorSwatch((String)((Object)value));
            }
            this.bgColor = (ColorSwatch)((Object)value);
            if (this.defnConfig != null) {
                this.defnConfig.visualizer.rebuild();
            }
        } else if (BORDER_COLOR.equals(key)) {
            if (value instanceof String) {
                value = new ColorSwatch((String)((Object)value));
            }
            this.borderColor = (ColorSwatch)((Object)value);
            if (this.defnConfig != null) {
                this.defnConfig.visualizer.rebuild();
            }
        } else if (PROPS.equals(key)) {
            if (value instanceof String) {
                value = InstanceConfigurer.StringToProperties((String)((Object)value), this);
            }
            if (this.instances instanceof List) {
                this.instances = value;
            }
            if (this.defnConfig != null) {
                this.rebuildInstances();
                this.defnConfig.visualizer.rebuild();
                this.defnConfig.repack();
            }
        }
        if (this.defnConfig != null) {
            this.rebuildVisualizerImage();
        }
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (BG_COLOR.equals(key)) {
            return this.bgColor.encode();
        }
        if (BORDER_COLOR.equals(key)) {
            return this.borderColor.encode();
        }
        if (PROPS.equals(key)) {
            return InstanceConfigurer.PropertiesToString(this.instances);
        }
        return null;
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (BORDER_COLOR.equals(name)) {
            return this.borderCond;
        }
        return super.getAttributeVisibility(name);
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        if (this.getConfigureName() != null) {
            s.add(this.getConfigureName());
        }
    }

    @Override
    public void removeFrom(Buildable parent) {
        idMgr.remove(this);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceImage.html");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public void addTo(Buildable parent) {
        this.layout = (GamePieceLayout)parent;
        idMgr.add(this);
        this.validator = idMgr;
        this.setAllAttributesUntranslatable();
        this.rebuildInstances();
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GamePieceImage.component_type");
    }

    public void refreshConfig() {
        this.rebuildVisualizerImage();
    }

    public GamePieceLayout getLayout() {
        return this.layout;
    }

    @Override
    public int getVisualizerHeight() {
        return this.getLayout().getVisualizerHeight();
    }

    @Override
    public int getVisualizerWidth() {
        return this.getLayout().getVisualizerWidth();
    }

    @Override
    public Image getVisualizerImage() {
        if (this.visImage == null) {
            this.rebuildVisualizerImage();
        }
        return this.visImage;
    }

    @Override
    public void rebuildVisualizerImage() {
        if (this.layout != null) {
            this.visImage = this.layout.buildImage(this);
            ArchiveWriter w = GameModule.getGameModule().getArchiveWriter();
            if (w != null && this.getConfigureName() != null && this.getConfigureName().length() > 0) {
                w.addImage(this.getConfigureName(), this.getEncodedImage((BufferedImage)this.visImage));
                SourceOp op = Op.load(this.getConfigureName());
                op.update();
            }
        }
    }

    public byte[] getEncodedImage(BufferedImage bufferedImage) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)bufferedImage, "png", out);
        }
        catch (IOException e) {
            ErrorDialog.bug(e);
            return new byte[1];
        }
        return out.toByteArray();
    }

    public ItemInstance getInstance(String name) {
        for (ItemInstance instance : this.instances) {
            if (!name.equals(instance.getName())) continue;
            return instance;
        }
        return null;
    }

    public TextItemInstance getTextInstance(String name) {
        for (ItemInstance instance : this.instances) {
            if (!(instance instanceof TextItemInstance) || !name.equals(instance.getName())) continue;
            return (TextItemInstance)instance;
        }
        return null;
    }

    public TextBoxItemInstance getTextBoxInstance(String name) {
        for (ItemInstance instance : this.instances) {
            if (!(instance instanceof TextBoxItemInstance) || !name.equals(instance.getName())) continue;
            return (TextBoxItemInstance)instance;
        }
        return null;
    }

    public SymbolItemInstance getSymbolInstance(String name) {
        for (ItemInstance instance : this.instances) {
            if (!(instance instanceof SymbolItemInstance) || !name.equals(instance.getName())) continue;
            return (SymbolItemInstance)instance;
        }
        return null;
    }

    public ShapeItemInstance getShapeInstance(String name) {
        for (ItemInstance instance : this.instances) {
            if (!(instance instanceof ShapeItemInstance) || !name.equals(instance.getName())) continue;
            return (ShapeItemInstance)instance;
        }
        return null;
    }

    public ImageItemInstance getImageInstance(String name) {
        for (ItemInstance instance : this.instances) {
            if (!(instance instanceof ImageItemInstance) || !name.equals(instance.getName())) continue;
            return (ImageItemInstance)instance;
        }
        return null;
    }

    protected void rebuildInstances() {
        ArrayList<ItemInstance> newInstances = new ArrayList<ItemInstance>();
        for (ItemInstance prop : this.instances) {
            Item item = this.layout.getItem(prop.getName());
            if (item == null || !item.getType().equals(prop.getType())) continue;
            prop.setLocation(item.getLocation());
            newInstances.add(prop);
        }
        if (this.layout != null) {
            for (Item item : this.layout.getItems()) {
                ItemInstance prop;
                String name = item.getConfigureName();
                String type = item.getType();
                String location = item.getLocation();
                boolean found = false;
                Iterator<ItemInstance> iterator = this.instances.iterator();
                while (iterator.hasNext() && !(found = name.equals((prop = iterator.next()).getName()))) {
                }
                if (found) continue;
                ItemInstance instance = ItemInstance.newDefaultInstance(name, type, location);
                instance.addTo(this);
                newInstances.add(instance);
            }
        }
        this.instances = newInstances;
        if (this.defnConfig != null) {
            this.defnConfig.setValue(this.instances);
        }
        this.rebuildVisualizerImage();
    }

    public static class BgColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((GamePieceImage)c).getBgColor());
        }
    }

    public static class BorderColorSwatchConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new ColorSwatchConfigurer(key, name, ((GamePieceImage)c).getBorderColor());
        }
    }

    public static class DefnConfig
    implements ConfigurerFactory {
        static GamePieceImage id;

        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            id = (GamePieceImage)c;
            DefnConfig.id.defnConfig = new InstanceConfigurer(key, name, id);
            id.rebuildInstances();
            return DefnConfig.id.defnConfig;
        }

        public static void refresh() {
            if (DefnConfig.id.defnConfig != null) {
                DefnConfig.id.defnConfig.repack();
            }
        }
    }
}

