/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class ConfigurerWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    protected JButton okButton = new JButton(Resources.getString("General.ok"));
    protected JButton canButton = new JButton(Resources.getString("General.cancel"));
    protected boolean cancelled;

    public ConfigurerWindow(Configurer c) {
        this(c, true);
    }

    public ConfigurerWindow(Configurer c, boolean modal) {
        super((Frame)GameModule.getGameModule().getPlayerWindow(), modal);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent we) {
                ConfigurerWindow.this.dispose();
                ConfigurerWindow.this.cancelled = true;
            }
        });
        this.setLayout((LayoutManager)new MigLayout("ins 0", "[grow,fill]"));
        this.add(c.getControls(), "grow,wrap");
        c.addPropertyChangeListener(evt -> {
            if ("Configurer.name".equals(evt.getPropertyName())) {
                this.setTitle((String)evt.getNewValue());
            }
        });
        this.setTitle(c.getName());
        this.okButton.addActionListener(e -> {
            c.getValue();
            this.dispose();
            this.cancelled = false;
        });
        this.canButton.addActionListener(e -> {
            this.dispose();
            this.cancelled = true;
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.canButton);
        this.add((Component)buttonPanel, "center");
        this.cancelled = false;
        this.pack();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

