/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ImageFileFilter;
import VASSAL.tools.image.LabelUtils;
import VASSAL.tools.image.MultiResolutionRenderedImage;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;

public class ImageSelector
extends Configurer
implements ItemListener {
    private static final String NO_IMAGE = "(" + Resources.getString("Editor.ImagePicker.no_image") + ")";
    private static final int DEFAULT_SIZE = 64;
    private JPanel controls;
    private JComboBox<String> select;
    private Icon noImage;
    private JLabel imageViewer;
    private String imageName;
    private final JLabel imageScale = new JLabel();
    private final OpIcon icon = new OpIcon();
    private final int maxWidth;
    private final int maxHeight;

    public ImageSelector(String key, String name, String val, int maxWidth, int maxheight) {
        super(key, name, val);
        this.maxWidth = maxWidth;
        this.maxHeight = maxheight;
        this.initControls();
        this.setValue(val);
    }

    public ImageSelector(String key, String name, String val) {
        this(key, name, val, -1, -1);
    }

    public ImageSelector(String key, String name) {
        this(key, name, null);
    }

    public ImageSelector(String val, int maxWidth, int maxheight) {
        this(null, "", val, maxWidth, maxheight);
    }

    public ImageSelector(String val) {
        this(null, "", val);
    }

    public ImageSelector() {
        this(null, "", "", 64, 64);
    }

    @Override
    public String getValueString() {
        return (String)this.value;
    }

    @Override
    public void setValue(String s) {
        if (s == null || s.isBlank() || s.equals(NO_IMAGE)) {
            this.setImageName("");
            this.imageViewer.setIcon(this.getNoImageIcon());
            this.imageViewer.setPreferredSize(new Dimension(64, 64));
        } else {
            this.setImageName(s);
            this.icon.setOp(Op.load(s));
            if (this.maxWidth > 0 && (this.icon.getIconWidth() > this.maxWidth || this.icon.getIconHeight() > this.maxHeight)) {
                double xRatio = (double)this.maxWidth / (double)this.icon.getIconWidth();
                double yRatio = (double)this.maxHeight / (double)this.icon.getIconHeight();
                double newScale = Math.min(xRatio, yRatio);
                this.icon.setOp(Op.scale(Op.load(s), newScale));
                this.imageScale.setText("(" + (int)(newScale * 100.0) + "%)");
                this.imageScale.setVisible(true);
            } else {
                this.imageScale.setVisible(false);
            }
            this.imageViewer.setIcon(this.icon);
            this.imageViewer.setPreferredSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
        }
        this.select.removeItemListener(this);
        this.select.setSelectedItem(s);
        if (s == null) {
            this.select.setSelectedIndex(0);
        } else if (!s.equals(this.select.getSelectedItem())) {
            this.select.setSelectedItem(s + ".gif");
        }
        this.select.addItemListener(this);
        this.controls.revalidate();
        this.repack(this.controls);
        this.setValue((Object)s);
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.initControls();
        }
        return this.controls;
    }

    private void initControls() {
        this.controls = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[grow][]", "[]rel[]"));
        this.controls.setBorder(BorderFactory.createEtchedBorder());
        JButton addButton = new JButton(Resources.getString("Editor.imageSelector.add_image"));
        addButton.addActionListener(e -> this.pickImage());
        JButton clearButton = new JButton(Resources.getString("Editor.imageSelector.clear_image"));
        clearButton.addActionListener(e -> this.clearImage());
        this.select = new JComboBox<String>((String[])ArrayUtils.addFirst((Object[])GameModule.getGameModule().getDataArchive().getImageNames(), (Object)NO_IMAGE));
        this.select.setSelectedIndex(0);
        this.select.addItemListener(this);
        this.imageViewer = new JLabel(this.getNoImageIcon());
        this.imageViewer.setPreferredSize(new Dimension(64, 64));
        this.controls.add(this.select, "grow");
        this.controls.add((Component)addButton, "split,sg 1");
        this.controls.add((Component)clearButton, "sg 1,wrap");
        this.controls.add((Component)this.imageViewer, "span 2,alignx center,wrap");
        this.controls.add((Component)this.imageScale, "span 2,alignx center");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.setValue((String)this.select.getSelectedItem());
    }

    private void pickImage() {
        GameModule gm = GameModule.getGameModule();
        FileChooser fc = gm.getFileChooser();
        fc.setFileFilter(new ImageFileFilter());
        if (fc.showOpenDialog(gm.getPlayerWindow()) == 0 && fc.getSelectedFile().exists()) {
            String name = fc.getSelectedFile().getName();
            gm.getArchiveWriter().addImage(fc.getSelectedFile().getPath(), name);
            this.select.setModel(new DefaultComboBoxModel<String>((String[])ArrayUtils.addFirst((Object[])gm.getDataArchive().getImageNames(), (Object)NO_IMAGE)));
            this.setValue(name);
        } else {
            this.setValue(NO_IMAGE);
        }
    }

    private void clearImage() {
        this.setValue(NO_IMAGE);
    }

    private Icon getNoImageIcon() {
        if (this.noImage == null) {
            this.noImage = new ImageIcon(new MultiResolutionRenderedImage(64, 64, LabelUtils::noImageBoxImage));
        }
        return this.noImage;
    }

    public String getImageName() {
        return this.imageName;
    }

    private void setImageName(String imageName) {
        this.imageName = imageName;
    }
}

