/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.DragBuffer;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyBuffer;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.Stack;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class Deselect
extends Decorator
implements TranslatablePiece {
    private static final char DELIMITER = ';';
    public static final String ID = "deselect;";
    protected KeyCommand[] command;
    protected String commandName;
    protected NamedKeyStroke key;
    protected KeyCommand deselectCommand;
    protected String description;
    protected Boolean unstack;

    public Deselect() {
        this.commandName = Resources.getString("Editor.Deselect.deselect");
        this.key = new NamedKeyStroke(KeyStroke.getKeyStroke("K"));
        this.description = "";
        this.unstack = false;
    }

    public Deselect(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken();
        this.key = st.nextNamedKeyStroke('K');
        this.description = st.nextToken("");
        this.unstack = st.nextBoolean(false);
        this.command = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.key).append(this.description).append(this.unstack);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.deselectCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command = this.commandName.length() > 0 && this.key != null && !this.key.isNull() ? new KeyCommand[]{this.deselectCommand} : new KeyCommand[0];
        }
        if (this.command.length > 0) {
            this.command[0].setEnabled(this.getMap() != null);
        }
        return this.command;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        Command c = null;
        this.myGetKeyCommands();
        if (this.deselectCommand.matches(stroke)) {
            Stack stack;
            GamePiece outer = Decorator.getOutermost(this);
            Map m = this.getMap();
            if (this.unstack.booleanValue() && (stack = outer.getParent()) != null) {
                Point pos = outer.getPosition();
                stack.setExpanded(true);
                stack.remove(outer);
                c = m.placeAt(outer, pos);
            }
            outer.setProperty("Selected", false);
            DragBuffer.getBuffer().remove(outer);
            KeyBuffer.getBuffer().remove(outer);
        }
        return c;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.Deselect.deselect", this.description);
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Deselect.htm", "");
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, Resources.getString("Editor.Deselect.deselect_command"));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Deselect)) {
            return false;
        }
        Deselect c = (Deselect)o;
        if (!Objects.equals(this.commandName, c.commandName)) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        if (!Objects.equals(this.unstack, c.unstack)) {
            return false;
        }
        return Objects.equals(this.key, c.key);
    }

    @Override
    public List<String> getPropertyNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("Selected");
        return l;
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return List.of(this.key);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.commandName);
    }

    public static class Ed
    implements PieceEditor {
        private final StringConfigurer nameInput;
        private final StringConfigurer descInput;
        private final NamedHotKeyConfigurer keyInput;
        private final BooleanConfigurer unstackInput;
        private final TraitConfigPanel controls = new TraitConfigPanel();

        public Ed(Deselect p) {
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.descInput);
            this.nameInput = new StringConfigurer(p.commandName);
            this.nameInput.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.nameInput);
            this.keyInput = new NamedHotKeyConfigurer(p.key);
            this.controls.add("Editor.keyboard_command", (Configurer)this.keyInput);
            this.unstackInput = new BooleanConfigurer(p.unstack);
            this.controls.add("Editor.Deselect.remove_piece_from_stack", (Configurer)this.unstackInput);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameInput.getValueString()).append(this.keyInput.getValueString()).append(this.descInput.getValueString()).append(this.unstackInput.getValueString());
            return Deselect.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

