/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.tools.HTTPPostBuilder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public class BugUtils {
    public static void sendBugReport(String email, String description, String errorLog, Throwable t) throws IOException {
        HTTPPostBuilder pb = new HTTPPostBuilder();
        String url = "http://www.vassalengine.org/util/bug.php";
        pb.setParameter("version", Info.getReportableVersion());
        pb.setParameter("email", email);
        pb.setParameter("summary", BugUtils.getSummary(t));
        pb.setParameter("description", BugUtils.getDescription(description, errorLog));
        pb.setParameter("log", Info.getErrorLogPath().getName(), errorLog);
        try (InputStream in = pb.post("http://www.vassalengine.org/util/bug.php");){
            String result = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            try {
                if (Integer.parseInt(result) != 0) {
                    throw new NumberFormatException("Bad result: " + result);
                }
            }
            catch (NumberFormatException e) {
                throw new IOException(e);
            }
        }
    }

    private static String getDescription(String description, String errorLog) {
        return description + "\n\n" + GameModule.getGameModule().getGameName() + " v" + GameModule.getGameModule().getGameVersion() + " " + Info.getVersion() + "\n\n" + BugUtils.getStackTraceSummary(errorLog);
    }

    private static String getStackTraceSummary(String errorLog) {
        StringBuilder summary = new StringBuilder();
        Stream<String> log = errorLog.substring(errorLog.lastIndexOf("ERROR VASSAL.tools.ErrorDialog")).lines();
        log.skip(1L).limit(5L).forEach(l -> summary.append(l.replace('\t', ' ')).append('\n'));
        return summary.toString();
    }

    private static String getSummary(Throwable t) {
        String summary = "[" + GameModule.getGameModule().getGameName() + "] ";
        if (t == null) {
            summary = summary + "Automated Bug Report";
        } else {
            String tc = t.getClass().getName();
            summary = summary + tc.substring(tc.lastIndexOf(46) + 1);
            if (t.getMessage() != null) {
                summary = summary + ": " + t.getMessage();
            }
        }
        return summary;
    }

    public static String getErrorLog() {
        File f = Info.getErrorLogPath();
        try {
            return Files.readString(f.toPath(), Charset.defaultCharset());
        }
        catch (IOException e) {
            return null;
        }
    }
}

