/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.GeneralFilter;
import VASSAL.tools.image.tilecache.TileTask;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.io.File;

class ScaledTileTask
extends TileTask {
    protected final GeneralFilter.Filter filter;

    public ScaledTileTask(BufferedImage src, File dst, GeneralFilter.Filter filter, int tx, int ty, int tw, int th, int dw, int dh) {
        super(src, dst, tx, ty, tw, th, dw, dh);
        this.filter = filter;
    }

    @Override
    protected BufferedImage sliceTile() {
        int atw = Math.min(this.tw, this.dw - this.tx * this.tw);
        int ath = Math.min(this.th, this.dh - this.ty * this.th);
        int type = this.src.getType();
        BufferedImage tile = new BufferedImage(atw, ath, type);
        WritableRaster tileR = tile.getRaster().createWritableTranslatedChild(this.tx * this.tw, this.ty * this.th);
        Rectangle dstFR = new Rectangle(0, 0, this.dw, this.dh);
        GeneralFilter.zoom(tileR, dstFR, this.src, this.filter);
        return tile;
    }
}

