/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.CompoundPieceCollection;
import VASSAL.build.module.map.DefaultPieceCollection;
import VASSAL.build.module.map.LayerControl;
import VASSAL.configure.SingleChildInstance;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.counters.Deck;
import VASSAL.counters.DeckVisitor;
import VASSAL.counters.DeckVisitorDispatcher;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Stack;
import VASSAL.i18n.Resources;
import VASSAL.tools.TemporaryToolBar;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JToolBar;

public class LayeredPieceCollection
extends AbstractConfigurable {
    public static final String PROPERTY_NAME = "property";
    public static final String LAYER_ORDER = "layerOrder";
    protected Collection collection = new Collection(Resources.getString("Editor.LayeredPieceCollection.layer"), new String[0]);
    protected Map map;
    protected TemporaryToolBar tempToolBar;

    public LayeredPieceCollection() {
        this.setAttributeTranslatable(PROPERTY_NAME, false);
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.GamePieceLayers.property_layer"), Resources.getString("Editor.GamePieceLayers.order_layer")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, String[].class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{PROPERTY_NAME, LAYER_ORDER};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (PROPERTY_NAME.equals(key)) {
            return this.collection.propertyName;
        }
        if (LAYER_ORDER.equals(key)) {
            return StringArrayConfigurer.arrayToString(this.collection.layerOrder);
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (PROPERTY_NAME.equals(key)) {
            this.collection.propertyName = (String)value;
        } else if (LAYER_ORDER.equals(key)) {
            if (value instanceof String) {
                value = StringArrayConfigurer.stringToArray((String)value);
            }
            this.collection.layerOrder = value;
            this.collection.initLayers(this.collection.layerOrder.length + 1);
        }
    }

    @Override
    public void addTo(Buildable parent) {
        this.map = (Map)parent;
        this.validator = new SingleChildInstance(this.map, this.getClass());
        this.map.setPieceCollection(this.collection);
        if (this.tempToolBar != null) {
            this.tempToolBar.setDelegate(this.map);
        }
    }

    public JToolBar getToolBar() {
        if (this.tempToolBar == null) {
            this.tempToolBar = new TemporaryToolBar();
            if (this.map != null) {
                this.tempToolBar.setDelegate(this.map);
            }
        }
        return this.tempToolBar.getToolBar();
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{LayerControl.class};
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GamePieceLayers.html");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.GamePieceLayers.component_type");
    }

    @Override
    public void removeFrom(Buildable parent) {
        this.map.setPieceCollection(new DefaultPieceCollection());
        for (LayerControl lc : this.getComponentsOf(LayerControl.class)) {
            lc.removeFrom(this);
        }
    }

    public Map getMap() {
        return this.map;
    }

    public CompoundPieceCollection getPieceCollection() {
        return this.collection;
    }

    @Override
    public List<String> getPropertyList() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.collection.propertyName);
        l.addAll(Arrays.asList(this.collection.layerOrder));
        return l;
    }

    public static class Collection
    extends CompoundPieceCollection
    implements DeckVisitor {
        private String propertyName;
        private String[] layerOrder;
        private final DeckVisitorDispatcher dispatcher = new DeckVisitorDispatcher(this);

        public Collection(String propertyName, String[] layerOrder) {
            super(0);
            this.setPropertyName(propertyName);
            this.setLayerOrder(layerOrder);
        }

        public String[] getLayerOrder() {
            return this.layerOrder;
        }

        public void setLayerOrder(String[] layerOrder) {
            this.layerOrder = layerOrder;
            this.initLayers(layerOrder.length + 1);
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public void setPropertyName(String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public int getLayerForPiece(GamePiece p) {
            return (Integer)this.dispatcher.accept(p);
        }

        @Override
        public int getLayerForName(String layer) {
            for (int i = 0; i < this.layerOrder.length; ++i) {
                if (!layer.equals(this.layerOrder[i])) continue;
                return i;
            }
            return -1;
        }

        @Override
        public String getLayerNameForPiece(GamePiece p) {
            int layer = this.getLayerForPiece(p);
            return layer >= this.layerOrder.length ? "" : this.layerOrder[layer];
        }

        @Override
        protected boolean canPiecesMerge(GamePiece p1, GamePiece p2) {
            return super.canPiecesMerge(p1, p2) && this.getLayerForPiece(p1) == this.getLayerForPiece(p2);
        }

        @Override
        public Object visitDeck(Deck d) {
            return this.layerOrder.length;
        }

        @Override
        public Object visitDefault(GamePiece p) {
            String property = (String)p.getProperty(this.propertyName);
            int layer = this.layerOrder.length;
            for (int i = 0; i < this.layerOrder.length; ++i) {
                if (!this.layerOrder[i].equals(property)) continue;
                layer = i;
                break;
            }
            return layer;
        }

        @Override
        public Object visitStack(Stack s) {
            GamePiece top = s.topPiece();
            if (top == null) {
                int layer = s.getLayer();
                return layer != -1 ? layer : this.layerOrder.length;
            }
            return this.visitDefault(top);
        }
    }
}

