/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.ui;

import VASSAL.chat.Player;
import VASSAL.chat.Room;
import VASSAL.chat.ServerStatus;
import VASSAL.chat.SimpleRoom;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingWorker;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;

public class ServerStatusView
extends JTabbedPane
implements ChangeListener,
TreeSelectionListener {
    private static final long serialVersionUID = 1L;
    public static final String SELECTION_PROPERTY = "ServerStatusView.selection";
    private ServerStatus status;
    private DefaultTreeModel model;
    private DefaultTreeModel[] historicalModels;
    private JTree treeCurrent;
    private JTree[] historicalTrees;
    private int totalPlayers;
    private SwingWorker<ServerStatus.ModuleSummary[], Void> cur_request = null;
    private SwingWorker<ServerStatus.ModuleSummary[], Void> hist_request = null;

    public ServerStatusView(ServerStatus status) {
        this.status = status;
        this.initComponents();
    }

    private void initComponents() {
        JPanel current = new JPanel(new BorderLayout());
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        JButton b = new JButton(Resources.getString("Chat.refresh"));
        b.addActionListener(e -> this.refresh());
        toolbar.add(b);
        current.add((Component)toolbar, "North");
        this.treeCurrent = this.createTree();
        current.add((Component)new JScrollPane(this.treeCurrent), "Center");
        this.model = (DefaultTreeModel)this.treeCurrent.getModel();
        this.addTab(Resources.getString("Chat.current"), current);
        this.addChangeListener(this);
        this.setBorder(new TitledBorder(Resources.getString("Chat.server_connections")));
        this.setStatusServer(this.status);
    }

    private void buildHistoricalTabs() {
        while (this.getTabCount() > 1) {
            this.removeTabAt(this.getTabCount() - 1);
        }
        if (this.status != null) {
            String[] supported = this.status.getSupportedTimeRanges();
            this.historicalTrees = new JTree[supported.length];
            this.historicalModels = new DefaultTreeModel[supported.length];
            for (int i = 0; i < supported.length; ++i) {
                this.historicalTrees[i] = this.createTree();
                this.historicalModels[i] = (DefaultTreeModel)this.historicalTrees[i].getModel();
                this.addTab(supported[i], new JScrollPane(this.historicalTrees[i]));
            }
        }
    }

    private JTree createTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Resources.getString("General.VASSAL"));
        DefaultTreeModel m = new DefaultTreeModel(root, true);
        JTree tree = new JTree(m);
        tree.getSelectionModel().setSelectionMode(1);
        tree.setCellRenderer(new Render());
        tree.expandRow(0);
        tree.setLargeModel(true);
        tree.setRowHeight(18);
        tree.addTreeSelectionListener(this);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                JComponent c = (JComponent)event.getSource();
                c.setSize(c.getPreferredSize());
                c.revalidate();
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        return tree;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.status == null) {
            return;
        }
        this.refresh(this.getSelectedIndex());
        this.fireSelectionChanged();
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        this.fireSelectionChanged();
    }

    private void fireSelectionChanged() {
        TreePath path;
        Object selection = null;
        int sel = this.getSelectedIndex();
        switch (sel) {
            case 0: {
                path = this.treeCurrent.getSelectionPath();
                break;
            }
            default: {
                path = this.historicalTrees[sel - 1].getSelectionPath();
            }
        }
        if (path != null) {
            selection = path.getLastPathComponent();
        }
        if (selection instanceof DefaultMutableTreeNode) {
            selection = ((DefaultMutableTreeNode)selection).getUserObject();
        }
        this.firePropertyChange(SELECTION_PROPERTY, null, selection);
    }

    public void refresh() {
        this.refresh(0);
    }

    private void refresh(final int page) {
        if (page == 0) {
            if (this.cur_request != null && !this.cur_request.isDone()) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.cur_request = new SwingWorker<ServerStatus.ModuleSummary[], Void>(){

                @Override
                public ServerStatus.ModuleSummary[] doInBackground() {
                    return ServerStatusView.this.status.getStatus();
                }

                @Override
                protected void done() {
                    try {
                        if (ServerStatusView.this.getSelectedIndex() == 0) {
                            ServerStatusView.this.refresh(ServerStatusView.this.model, (ServerStatus.ModuleSummary[])this.get());
                            ServerStatusView.this.fireSelectionChanged();
                        }
                    }
                    catch (InterruptedException ex) {
                        ErrorDialog.bug(ex);
                    }
                    catch (ExecutionException ex) {
                        ex.printStackTrace();
                    }
                    if (ServerStatusView.this.hist_request == null || ServerStatusView.this.hist_request.isDone()) {
                        ServerStatusView.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                    ServerStatusView.this.cur_request = null;
                }
            };
            this.cur_request.execute();
        } else {
            if (this.hist_request != null && !this.hist_request.isDone()) {
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.hist_request = new SwingWorker<ServerStatus.ModuleSummary[], Void>(){

                @Override
                public ServerStatus.ModuleSummary[] doInBackground() {
                    return ServerStatusView.this.status.getHistory(ServerStatusView.this.getTitleAt(page));
                }

                @Override
                protected void done() {
                    int sel = ServerStatusView.this.getSelectedIndex();
                    if (sel == page) {
                        try {
                            ServerStatusView.this.refresh(ServerStatusView.this.historicalModels[sel - 1], (ServerStatus.ModuleSummary[])this.get());
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            ex.printStackTrace();
                        }
                        ServerStatusView.this.fireSelectionChanged();
                    } else if (sel != 0) {
                        ServerStatusView.this.hist_request = null;
                        ServerStatusView.this.refresh(sel);
                    }
                    if (ServerStatusView.this.cur_request == null || ServerStatusView.this.cur_request.isDone()) {
                        ServerStatusView.this.setCursor(Cursor.getPredefinedCursor(0));
                    }
                }
            };
            this.hist_request.execute();
        }
    }

    private void refresh(DefaultTreeModel m, ServerStatus.ModuleSummary[] modules) {
        MutableTreeNode root = (MutableTreeNode)m.getRoot();
        this.totalPlayers = 0;
        while (root.getChildCount() > 0) {
            m.removeNodeFromParent((MutableTreeNode)root.getChildAt(0));
        }
        if (modules.length == 0) {
            DefaultMutableTreeNode n = new DefaultMutableTreeNode(Resources.getString("Chat.no_connections"));
            n.setAllowsChildren(false);
        } else {
            for (ServerStatus.ModuleSummary s : modules) {
                m.insertNodeInto(this.createNode(s), root, root.getChildCount());
            }
        }
        root.setUserObject(Resources.getString("General.VASSAL") + " (" + this.totalPlayers + ")");
    }

    private DefaultMutableTreeNode createNode(Object o) {
        Object[] children = null;
        if (o instanceof ServerStatus.ModuleSummary) {
            ServerStatus.ModuleSummary ms = (ServerStatus.ModuleSummary)o;
            children = ms.getRooms();
            int players = ms.numPlayers();
            ms.setModuleName(ms.getModuleName() + " (" + players + ")");
            this.totalPlayers += players;
        } else if (o instanceof SimpleRoom) {
            SimpleRoom r = (SimpleRoom)o;
            List<Player> l = r.getPlayerList();
            r.setName(r.getName() + " (" + l.size() + ")");
            children = l.toArray(new Player[0]);
        }
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(o);
        if (children != null) {
            for (Room room : children) {
                node.add(this.createNode(room));
            }
        }
        node.setAllowsChildren(children != null);
        return node;
    }

    public void setStatusServer(ServerStatus status) {
        this.status = status;
        this.buildHistoricalTabs();
        this.setEnabled(status != null);
    }

    public static class Render
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            if (leaf) {
                this.setIcon(null);
            }
            this.putClientProperty(Resources.getString("ServerStatusView.4"), Boolean.TRUE);
            return this;
        }
    }
}

