/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.module.properties.PropertyChangerConfigurer;
import VASSAL.build.module.properties.PropertySetter;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.DynamicProperty;
import VASSAL.i18n.Resources;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.FocusListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class DynamicKeyCommandConfigurer
extends Configurer {
    protected final NamedHotKeyConfigurer keyConfig;
    protected PropertyChangerConfigurer propChangeConfig;
    protected StringConfigurer commandConfig = new StringConfigurer("");
    protected JPanel controls;
    protected DynamicProperty target;

    public DynamicKeyCommandConfigurer(DynamicProperty target) {
        super(target.getKey(), target.getKey(), new DynamicProperty.DynamicKeyCommand("", new NamedKeyStroke(), Decorator.getOutermost(target), target, new PropertySetter("", target)));
        this.commandConfig.setHint(Resources.getString("Editor.menu_command_hint"));
        this.keyConfig = new NamedHotKeyConfigurer(NamedKeyStroke.NULL_KEYSTROKE);
        this.propChangeConfig = new PropertyChangerConfigurer(null, target.getKey(), target);
        this.propChangeConfig.setValue(new PropertySetter("", target));
        this.commandConfig.addPropertyChangeListener(e -> this.updateValue());
        this.keyConfig.addPropertyChangeListener(e -> this.updateValue());
        this.propChangeConfig.addPropertyChangeListener(e -> {
            this.updateValue();
            this.repack(this.commandConfig.getControls());
        });
        this.target = target;
    }

    public DynamicProperty getTarget() {
        return this.target;
    }

    public void setTarget(DynamicProperty target) {
        this.target = target;
    }

    @Override
    public String getValueString() {
        SequenceEncoder se = new SequenceEncoder(':');
        se.append(this.commandConfig.getValueString()).append(this.keyConfig.getValueString()).append(this.propChangeConfig.getValueString());
        return se.getValue();
    }

    @Override
    public void setFrozen(boolean val) {
        super.setFrozen(val);
        this.commandConfig.setFrozen(val);
        this.keyConfig.setFrozen(val);
        this.propChangeConfig.setFrozen(val);
    }

    @Override
    public void setValue(Object value) {
        if (!this.noUpdate && value instanceof DynamicProperty.DynamicKeyCommand && this.commandConfig != null) {
            DynamicProperty.DynamicKeyCommand dkc = (DynamicProperty.DynamicKeyCommand)value;
            this.commandConfig.setValue(dkc.getName());
            this.keyConfig.setValue(dkc.getNamedKeyStroke());
            this.propChangeConfig.setValue(dkc.getPropChanger());
        }
        super.setValue(value);
    }

    public DynamicProperty.DynamicKeyCommand getKeyCommand() {
        return (DynamicProperty.DynamicKeyCommand)this.getValue();
    }

    @Override
    public void setValue(String s) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(s == null ? "" : s, ':');
        this.commandConfig.setValue(sd.nextToken(""));
        this.keyConfig.setValue(sd.nextNamedKeyStroke(null));
        this.propChangeConfig.setValue(sd.nextToken(""));
        this.updateValue();
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.buildControls();
        }
        return this.controls;
    }

    public void updateValue() {
        this.noUpdate = true;
        this.setValue(new DynamicProperty.DynamicKeyCommand(this.commandConfig.getValueString(), this.keyConfig.getValueNamedKeyStroke(), this.target, this.target, this.propChangeConfig.getPropertyChanger()));
        this.noUpdate = false;
    }

    protected void buildControls() {
        this.controls = new JPanel((LayoutManager)new MigLayout("ins panel,gapy 4,hidemode 3", "[]rel[][]rel[]"));
        this.controls.setBorder(BorderFactory.createEtchedBorder());
        JLabel label = new JLabel(Resources.getString("Editor.menu_command"));
        label.setLabelFor(this.commandConfig.getControls());
        this.controls.add(label);
        this.controls.add(this.commandConfig.getControls(), "grow");
        label = new JLabel(Resources.getString("Editor.keyboard_command"));
        label.setLabelFor(this.keyConfig.getControls());
        this.controls.add(label);
        this.controls.add(this.keyConfig.getControls(), "grow,wrap");
        this.controls.add(this.propChangeConfig.getTypeLabel());
        this.controls.add(this.propChangeConfig.getTypeControls(), "grow");
        this.controls.add(this.propChangeConfig.getChangerLabel());
        this.controls.add(this.propChangeConfig.getChangerControls(), "growx,aligny center,wrap");
        this.controls.add(this.propChangeConfig.getValuesControls(), "grow,span 4");
    }

    public Component getCommandControls() {
        return this.commandConfig.getControls();
    }

    public Component getKeyControls() {
        return this.keyConfig.getControls();
    }

    public Component getTypeControls() {
        return this.propChangeConfig.getTypeControls();
    }

    public Component getChangerControls() {
        return this.propChangeConfig.getChangerControls();
    }

    public Component getValuesControls() {
        return this.propChangeConfig.getValuesControls();
    }

    public boolean isEnumType() {
        return this.propChangeConfig.isEnumType();
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.commandConfig.setHighlighted(highlighted);
        this.keyConfig.setHighlighted(highlighted);
        this.propChangeConfig.setHighlighted(highlighted);
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.commandConfig.addFocusListener(listener);
        this.keyConfig.addFocusListener(listener);
        this.propChangeConfig.addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.commandConfig.removeFocusListener(listener);
        this.keyConfig.removeFocusListener(listener);
        this.propChangeConfig.removeFocusListener(listener);
    }
}

