/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.FormattedExpressionConfigurer;
import VASSAL.configure.StringEnumConfigurer;
import VASSAL.configure.TranslatingStringEnumConfigurer;
import VASSAL.counters.GlobalCommandTarget;
import VASSAL.i18n.Resources;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class GlobalCommandTargetConfigurer
extends Configurer {
    private JPanel controls;
    private BooleanConfigurer fastMatchLocationConfig;
    private BooleanConfigurer fastMatchPropertyConfig;
    private TranslatingStringEnumConfigurer targetTypeConfig;
    private JLabel targetTypeLabel;
    private FormattedExpressionConfigurer targetMapConfig;
    private JLabel targetMapLabel;
    private FormattedExpressionConfigurer targetBoardConfig;
    private JLabel targetBoardLabel;
    private FormattedExpressionConfigurer targetZoneConfig;
    private JLabel targetZoneLabel;
    private FormattedExpressionConfigurer targetLocationConfig;
    private JLabel targetLocationLabel;
    private FormattedExpressionConfigurer targetXConfig;
    private JLabel targetXLabel;
    private FormattedExpressionConfigurer targetYConfig;
    private JLabel targetYLabel;
    private FormattedExpressionConfigurer targetDeckConfig;
    private JLabel targetDeckLabel;
    private FormattedExpressionConfigurer targetPropertyConfig;
    private JLabel targetPropertyLabel;
    private CompareConfigurer targetCompareConfig;
    private JLabel targetCompareLabel;
    private FormattedExpressionConfigurer targetValueConfig;
    private JLabel targetValueLabel;
    private final GlobalCommandTarget target;

    public GlobalCommandTargetConfigurer(String key, String name, GlobalCommandTarget target) {
        super(key, name, target);
        this.target = new GlobalCommandTarget(target);
    }

    public GlobalCommandTargetConfigurer(String key, String name) {
        this(key, name, null);
    }

    public GlobalCommandTargetConfigurer(GlobalCommandTarget target) {
        this(null, null, target);
    }

    public GlobalCommandTarget getTarget() {
        return (GlobalCommandTarget)this.getValue();
    }

    @Override
    public String getValueString() {
        return this.getTarget().encode();
    }

    @Override
    public void setValue(String s) {
        this.setValue(new GlobalCommandTarget(s));
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new JPanel((LayoutManager)new MigLayout("hidemode 3,gapy 4", "[]rel[]rel[fill,grow]"));
            this.fastMatchLocationConfig = new BooleanConfigurer(this.target.isFastMatchLocation());
            this.fastMatchLocationConfig.addPropertyChangeListener(evt -> this.update());
            this.controls.add(this.fastMatchLocationConfig.getControls());
            this.controls.add((Component)new JLabel(Resources.getString("Editor.GlobalKeyCommand.by_location")), "wrap");
            ArrayList<String> options = new ArrayList<String>();
            ArrayList<String> i18nKeys = new ArrayList<String>();
            if (this.getTarget().getGKCtype() == GlobalCommandTarget.GKCtype.COUNTER) {
                options.add(GlobalCommandTarget.Target.CURSTACK.toString());
                options.add(GlobalCommandTarget.Target.CURMAP.toString());
                options.add(GlobalCommandTarget.Target.CURZONE.toString());
                options.add(GlobalCommandTarget.Target.CURLOC.toString());
                i18nKeys.add(GlobalCommandTarget.Target.CURSTACK.toTranslatedString());
                i18nKeys.add(GlobalCommandTarget.Target.CURMAP.toTranslatedString());
                i18nKeys.add(GlobalCommandTarget.Target.CURZONE.toTranslatedString());
                i18nKeys.add(GlobalCommandTarget.Target.CURLOC.toTranslatedString());
            }
            options.add(GlobalCommandTarget.Target.MAP.toString());
            options.add(GlobalCommandTarget.Target.ZONE.toString());
            options.add(GlobalCommandTarget.Target.LOCATION.toString());
            options.add(GlobalCommandTarget.Target.XY.toString());
            options.add(GlobalCommandTarget.Target.DECK.toString());
            i18nKeys.add(GlobalCommandTarget.Target.MAP.toTranslatedString());
            i18nKeys.add(GlobalCommandTarget.Target.ZONE.toTranslatedString());
            i18nKeys.add(GlobalCommandTarget.Target.LOCATION.toTranslatedString());
            i18nKeys.add(GlobalCommandTarget.Target.XY.toTranslatedString());
            i18nKeys.add(GlobalCommandTarget.Target.DECK.toTranslatedString());
            this.targetTypeConfig = new TranslatingStringEnumConfigurer(options, i18nKeys, this.target.getTargetType().toString());
            this.targetTypeConfig.addPropertyChangeListener(evt -> this.update());
            this.targetTypeLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.select_by"));
            this.controls.add((Component)this.targetTypeLabel, "span 2");
            this.controls.add(this.targetTypeConfig.getControls(), "growx, wrap");
            this.targetMapConfig = new FormattedExpressionConfigurer(this.target.getTargetMap().getExpression());
            this.targetMapConfig.addPropertyChangeListener(evt -> this.update());
            this.targetMapConfig.setHintKey("Editor.GlobalKeyCommand.map_name_hint");
            this.targetMapLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.map_name"));
            this.controls.add((Component)this.targetMapLabel, "span 2");
            this.controls.add(this.targetMapConfig.getControls(), "growx, wrap");
            this.targetBoardConfig = new FormattedExpressionConfigurer(this.target.getTargetBoard().getExpression());
            this.targetBoardConfig.addPropertyChangeListener(evt -> this.update());
            this.targetBoardConfig.setHintKey("Editor.GlobalKeyCommand.board_name_hint");
            this.targetBoardLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.board_name"));
            this.controls.add((Component)this.targetBoardLabel, "span 2");
            this.controls.add(this.targetBoardConfig.getControls(), "growx, wrap");
            this.targetZoneConfig = new FormattedExpressionConfigurer(this.target.getTargetZone().getExpression());
            this.targetZoneConfig.addPropertyChangeListener(evt -> this.update());
            this.targetZoneConfig.setHintKey("Editor.GlobalKeyCommand.zone_name_hint");
            this.targetZoneLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.zone_name"));
            this.controls.add((Component)this.targetZoneLabel, "span 2");
            this.controls.add(this.targetZoneConfig.getControls(), "growx, wrap");
            this.targetLocationConfig = new FormattedExpressionConfigurer(this.target.getTargetLocation().getExpression());
            this.targetLocationConfig.addPropertyChangeListener(evt -> this.update());
            this.targetLocationConfig.setHintKey("Editor.GlobalKeyCommand.location_name_hint");
            this.targetLocationLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.location_name"));
            this.controls.add((Component)this.targetLocationLabel, "span 2");
            this.controls.add(this.targetLocationConfig.getControls(), "growx, wrap");
            this.targetXConfig = new FormattedExpressionConfigurer(this.target.getTargetX().getExpression());
            this.targetXConfig.addPropertyChangeListener(evt -> this.update());
            this.targetXLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.x_position"));
            this.controls.add((Component)this.targetXLabel, "span 2");
            this.controls.add(this.targetXConfig.getControls(), "growx, wrap");
            this.targetYConfig = new FormattedExpressionConfigurer(this.target.getTargetY().getExpression());
            this.targetYConfig.addPropertyChangeListener(evt -> this.update());
            this.targetYLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.y_position"));
            this.controls.add((Component)this.targetYLabel, "span 2");
            this.controls.add(this.targetYConfig.getControls(), "growY, wrap");
            this.targetDeckConfig = new FormattedExpressionConfigurer(this.target.getTargetDeck().getExpression());
            this.targetDeckConfig.addPropertyChangeListener(evt -> this.update());
            this.targetDeckConfig.setHintKey("Editor.GlobalKeyCommand.deck_name_hint");
            this.targetDeckLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.deck_name"));
            this.controls.add((Component)this.targetDeckLabel, "span 2");
            this.controls.add(this.targetDeckConfig.getControls(), "growx, wrap");
            this.fastMatchPropertyConfig = new BooleanConfigurer(this.target.isFastMatchProperty());
            this.fastMatchPropertyConfig.addPropertyChangeListener(evt -> this.update());
            this.controls.add(this.fastMatchPropertyConfig.getControls());
            this.controls.add((Component)new JLabel(Resources.getString("Editor.GlobalKeyCommand.by_property")), "wrap");
            this.targetPropertyConfig = new FormattedExpressionConfigurer(this.target.getTargetProperty().getExpression());
            this.targetPropertyConfig.addPropertyChangeListener(evt -> this.update());
            this.targetPropertyConfig.setHintKey("Editor.GlobalKeyCommand.property_name_hint");
            this.targetPropertyLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.property_name"));
            this.controls.add((Component)this.targetPropertyLabel, "span 2");
            this.controls.add(this.targetPropertyConfig.getControls(), "wrap");
            this.targetCompareConfig = new CompareConfigurer();
            this.targetCompareConfig.setValue(this.getTarget().getTargetCompare().getSymbol());
            this.targetCompareConfig.addPropertyChangeListener(evt -> this.update());
            this.targetCompareLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.property_compare"));
            this.controls.add((Component)this.targetCompareLabel, "span 2");
            this.controls.add(this.targetCompareConfig.getControls(), "wrap");
            this.targetValueConfig = new FormattedExpressionConfigurer(this.target.getTargetValue().getExpression());
            this.targetValueConfig.addPropertyChangeListener(evt -> this.update());
            this.targetValueConfig.setHintKey("Editor.GlobalKeyCommand.property_value_hint");
            this.targetValueLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.property_value"));
            this.controls.add((Component)this.targetValueLabel, "span 2");
            this.controls.add(this.targetValueConfig.getControls(), "wrap");
            this.targetChanged();
            this.fastMatchPropertyChanged();
            this.controls.setBorder(BorderFactory.createEtchedBorder());
            if (this.getName() != null && !this.getName().isEmpty()) {
                JPanel controls2 = this.controls;
                this.controls = new JPanel((LayoutManager)new MigLayout("ins 0", "[]rel[fill,grow]"));
                this.controls.add(new JLabel(this.getName()));
                this.controls.add((Component)controls2, "growx");
            }
        }
        return this.controls;
    }

    private void targetChanged() {
        boolean fastMatchLocation = this.fastMatchLocationConfig.getValueBoolean();
        this.target.setFastMatchLocation(fastMatchLocation);
        this.target.setTargetType(this.targetTypeConfig.getValueString());
        GlobalCommandTarget.Target targetType = this.target.getTargetType();
        this.targetTypeConfig.getControls().setVisible(fastMatchLocation);
        this.targetTypeLabel.setVisible(fastMatchLocation);
        boolean mapVisible = fastMatchLocation && (targetType.equals((Object)GlobalCommandTarget.Target.MAP) || targetType.equals((Object)GlobalCommandTarget.Target.ZONE) || targetType.equals((Object)GlobalCommandTarget.Target.LOCATION) || targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetMapConfig.getControls().setVisible(fastMatchLocation && mapVisible);
        this.targetMapLabel.setVisible(fastMatchLocation && mapVisible);
        this.targetBoardConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetBoardLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetZoneConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.ZONE));
        this.targetZoneLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.ZONE));
        this.targetLocationConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.LOCATION));
        this.targetLocationLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.LOCATION));
        this.targetXConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetXLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetYConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetYLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.XY));
        this.targetDeckLabel.setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.DECK));
        this.targetDeckConfig.getControls().setVisible(fastMatchLocation && targetType.equals((Object)GlobalCommandTarget.Target.DECK));
        this.repack();
    }

    private void fastMatchPropertyChanged() {
        this.target.setFastMatchProperty(this.fastMatchPropertyConfig.getValueBoolean());
        this.targetPropertyConfig.getControls().setVisible(this.target.isFastMatchProperty());
        this.targetPropertyLabel.setVisible(this.target.isFastMatchProperty());
        this.targetValueConfig.getControls().setVisible(this.target.isFastMatchProperty());
        this.targetValueLabel.setVisible(this.target.isFastMatchProperty());
        this.targetCompareConfig.getControls().setVisible(this.target.isFastMatchProperty());
        this.targetCompareLabel.setVisible(this.target.isFastMatchProperty());
        this.repack();
    }

    private void update() {
        if (this.target == null) {
            return;
        }
        this.targetChanged();
        this.fastMatchPropertyChanged();
        this.target.setTargetValue(this.targetValueConfig.getValueString());
        this.target.setTargetCompare(GlobalCommandTarget.CompareMode.whichSymbol(this.targetCompareConfig.getValueString()));
        this.target.setTargetProperty(this.targetPropertyConfig.getValueString());
        this.target.setTargetDeck(this.targetDeckConfig.getValueString());
        this.target.setTargetY(this.targetYConfig.getValueString());
        this.target.setTargetX(this.targetXConfig.getValueString());
        this.target.setTargetLocation(this.targetLocationConfig.getValueString());
        this.target.setTargetZone(this.targetZoneConfig.getValueString());
        this.target.setTargetBoard(this.targetBoardConfig.getValueString());
        this.target.setTargetMap(this.targetMapConfig.getValueString());
        this.setValue(this.target);
    }

    @Override
    public void repack() {
        this.repack(this.controls);
    }

    private static class CompareConfigurer
    extends StringEnumConfigurer {
        CompareConfigurer() {
            super((String)null, (String)null, GlobalCommandTarget.CompareMode.getSymbols());
        }
    }
}

