/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.configure.HintTextField;
import VASSAL.configure.HotKeyConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.NamedKeyManager;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OpIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.plaf.LayerUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import net.miginfocom.swing.MigLayout;

public class NamedHotKeyConfigurer
extends Configurer
implements FocusListener {
    private static final String STROKE_HINT = Resources.getString("Editor.NamedHotKeyConfigurer.keystroke");
    private static final String NAME_HINT = Resources.getString("Editor.NamedHotKeyConfigurer.command");
    private final HintTextField keyStroke = new HintTextField(16, STROKE_HINT);
    private final HintTextField keyName = new HintTextField(16, NAME_HINT);
    private JPanel controls;
    private String lastValue;
    private JButton undoButton;

    public static String getFancyString(NamedKeyStroke k) {
        Object s = NamedHotKeyConfigurer.getString(k);
        if (((String)s).length() > 0) {
            s = "[" + (String)s + "]";
        }
        return s;
    }

    public static String getString(NamedKeyStroke k) {
        return k == null || k.isNull() ? "" : NamedHotKeyConfigurer.getString(k.getStroke());
    }

    public static String getString(KeyStroke k) {
        return NamedKeyManager.isNamed(k) ? "" : HotKeyConfigurer.getString(k);
    }

    public NamedHotKeyConfigurer(String key, String name, NamedKeyStroke val) {
        super(key, name, val);
    }

    public NamedHotKeyConfigurer(String key, String name) {
        this(key, name, new NamedKeyStroke());
    }

    public NamedHotKeyConfigurer(NamedKeyStroke val) {
        this(null, null, val);
    }

    public NamedHotKeyConfigurer() {
        this(null);
    }

    @Override
    public String getValueString() {
        return NamedHotKeyConfigurer.encode((NamedKeyStroke)this.getValue());
    }

    public NamedKeyStroke getValueNamedKeyStroke() {
        return (NamedKeyStroke)this.value;
    }

    public boolean isNamed() {
        return this.value != null && ((NamedKeyStroke)this.value).isNamed();
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        this.setFrozen(true);
        if (this.controls != null) {
            if (this.isNamed()) {
                if (this.keyName.getText().isEmpty()) {
                    this.keyName.setText(((NamedKeyStroke)this.value).getName());
                }
                this.keyStroke.setText("");
            } else {
                this.keyName.setText("");
                this.keyStroke.setText(this.keyToString());
            }
            this.updateVisibility();
        }
        this.setFrozen(false);
    }

    protected void updateVisibility() {
        this.keyName.setFocusOnly(this.iSnonNullValue());
        this.keyStroke.setFocusOnly(this.iSnonNullValue());
    }

    private boolean iSnonNullValue() {
        return this.value != null && !((NamedKeyStroke)this.value).isNull();
    }

    @Override
    public void setValue(String s) {
        this.setValue(s == null ? null : NamedHotKeyConfigurer.decode(s));
    }

    private void updateValueFromKeyName() {
        if (!this.isFrozen()) {
            String key = this.keyName.getText();
            if (key.isEmpty()) {
                this.setValue(NamedKeyStroke.NULL_KEYSTROKE);
            } else {
                this.setValue(new NamedKeyStroke(NamedKeyManager.getMarkerKeyStroke(), key));
            }
        }
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new ConfigurerPanel(this.getName(), "[fill,grow]", "[][fill,grow]");
            this.keyStroke.setMaximumSize(new Dimension(this.keyStroke.getMaximumSize().width, this.keyStroke.getPreferredSize().height));
            this.keyStroke.setText(this.keyToString());
            this.keyStroke.addKeyListener(new KeyStrokeAdapter());
            ((AbstractDocument)this.keyStroke.getDocument()).setDocumentFilter(new KeyStrokeFilter());
            this.keyStroke.addFocusListener(this);
            this.keyName.setMaximumSize(new Dimension(this.keyName.getMaximumSize().width, this.keyName.getPreferredSize().height));
            this.keyName.setText(this.getValueNamedKeyStroke() == null ? null : this.getValueNamedKeyStroke().getName());
            ((AbstractDocument)this.keyName.getDocument()).setDocumentFilter(new KeyNameFilter());
            this.keyName.addFocusListener(this);
            JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 0", "[fill,grow]0[]0[fill,grow]0[]"));
            ConfigLayerUI layerUI = new ConfigLayerUI(this);
            JLayer<JTextField> nameLayer = new JLayer<JTextField>(this.keyName, layerUI);
            panel.add(nameLayer, "grow");
            panel.add(new JLabel("-"));
            JLayer<JTextField> keyLayer = new JLayer<JTextField>(this.keyStroke, layerUI);
            panel.add(keyLayer, "grow");
            this.undoButton = new JButton(new OpIcon(Op.load("Undo16.gif")));
            int size = (int)this.keyName.getPreferredSize().getHeight();
            this.undoButton.setPreferredSize(new Dimension(size, size));
            this.undoButton.setMaximumSize(new Dimension(size, size));
            this.undoButton.addActionListener(e -> this.undo());
            this.undoButton.setEnabled(false);
            panel.add(this.undoButton);
            this.controls.add((Component)panel, "grow");
            this.updateVisibility();
        }
        return this.controls;
    }

    private void undo() {
        if (this.lastValue != null) {
            this.setValue(this.lastValue);
            this.lastValue = null;
            this.undoButton.setEnabled(false);
            this.keyName.requestFocus();
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.lastValue = this.getValueString();
        this.undoButton.setEnabled(true);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public String keyToString() {
        return NamedHotKeyConfigurer.getString((NamedKeyStroke)this.getValue());
    }

    protected boolean isPrintableAscii(char c) {
        return this.isPrintableAscii((int)c);
    }

    protected boolean isPrintableAscii(int i) {
        return i >= 32 && i <= 126;
    }

    public static NamedKeyStroke decode(String s) {
        if (s == null) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
        String[] parts = s.split(",");
        if (parts.length < 2) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
        try {
            KeyStroke stroke = KeyStroke.getKeyStroke(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]));
            String name = null;
            if (parts.length > 2) {
                name = parts[2];
            }
            return new NamedKeyStroke(stroke, name);
        }
        catch (Exception e) {
            return NamedKeyStroke.NULL_KEYSTROKE;
        }
    }

    public static String encode(NamedKeyStroke stroke) {
        if (stroke == null) {
            return "";
        }
        KeyStroke key = stroke.getStroke();
        if (key == null) {
            return "";
        }
        String s = key.getKeyCode() + "," + key.getModifiers();
        if (stroke.isNamed()) {
            s = s + "," + stroke.getName();
        }
        return s;
    }

    @Override
    public void setHighlighted(boolean highlighted) {
        super.setHighlighted(highlighted);
        this.keyStroke.setBackground(highlighted ? LIST_ENTRY_HIGHLIGHT_COLOR : Color.white);
        this.keyName.setBackground(highlighted ? LIST_ENTRY_HIGHLIGHT_COLOR : Color.white);
        this.keyStroke.repaint();
        this.keyName.repaint();
    }

    @Override
    public void addFocusListener(FocusListener listener) {
        super.addFocusListener(listener);
        this.keyStroke.addFocusListener(listener);
        this.keyName.addFocusListener(listener);
    }

    @Override
    public void removeFocusListener(FocusListener listener) {
        super.removeFocusListener(listener);
        this.keyStroke.removeFocusListener(listener);
        this.keyName.removeFocusListener(listener);
    }

    private class KeyStrokeAdapter
    extends KeyAdapter {
        private KeyStrokeAdapter() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 8: 
                case 127: {
                    NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.NULL_KEYSTROKE);
                    break;
                }
                case 16: 
                case 17: 
                case 18: 
                case 157: {
                    break;
                }
                default: {
                    NamedHotKeyConfigurer.this.setValue(NamedKeyStroke.getKeyStrokeForEvent(e));
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            NamedHotKeyConfigurer.this.keyStroke.setText(NamedHotKeyConfigurer.getString((NamedKeyStroke)NamedHotKeyConfigurer.this.getValue()));
        }
    }

    private class KeyStrokeFilter
    extends DocumentFilter {
        private KeyStrokeFilter() {
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(fb, 0, NamedHotKeyConfigurer.this.keyStroke.getText().length(), text, attrs);
        }
    }

    private class KeyNameFilter
    extends DocumentFilter {
        private KeyNameFilter() {
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            super.remove(fb, offset, length);
            NamedHotKeyConfigurer.this.updateValueFromKeyName();
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String string, AttributeSet attr) throws BadLocationException {
            super.insertString(fb, offset, string, attr);
            NamedHotKeyConfigurer.this.updateValueFromKeyName();
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            super.replace(fb, offset, length, text, attrs);
            NamedHotKeyConfigurer.this.updateValueFromKeyName();
        }
    }

    private static class ConfigLayerUI
    extends LayerUI<JTextField> {
        private static final long serialVersionUID = 1L;
        private final Configurer parent;

        public ConfigLayerUI(Configurer parent) {
            this.parent = parent;
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            super.paint(g, c);
            Object cc = ((JLayer)c).getView();
            if (this.parent.isHighlighted()) {
                Dimension d = ((Component)cc).getSize();
                g.setColor(Color.red);
                g.drawRect(0, 0, d.width - 2, d.height - 2);
            }
        }
    }
}

