/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.PredefinedSetup;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.ShowHelpAction;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RefreshPredefinedSetupsDialog
extends JDialog {
    private static final Logger logger = LoggerFactory.getLogger(RefreshPredefinedSetupsDialog.class);
    private static final long serialVersionUID = 1L;
    private JButton refreshButton;
    private JCheckBox nameCheck;
    private JCheckBox labelerNameCheck;
    private JCheckBox layerNameCheck;
    private JCheckBox testModeOn;
    private JCheckBox deletePieceNoMap;
    private final Set<String> options = new HashSet<String>();

    public RefreshPredefinedSetupsDialog(Frame owner) throws HeadlessException {
        super(owner, false);
        this.setTitle(Resources.getString("Editor.RefreshPredefinedSetupsDialog.title"));
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[fill]"));
        JPanel panel = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 1,gapy 4", "[fill]"));
        panel.setBorder(BorderFactory.createEtchedBorder());
        JPanel buttonsBox = new JPanel((LayoutManager)new MigLayout("ins 0", "push[]rel[]rel[]push"));
        this.refreshButton = new JButton(Resources.getString("General.run"));
        this.refreshButton.addActionListener(e -> this.refreshPredefinedSetups());
        this.refreshButton.setEnabled(true);
        JButton helpButton = new JButton(Resources.getString("General.help"));
        HelpFile hf = null;
        try {
            hf = new HelpFile(null, new File(new File(Documentation.getDocumentationBaseDir(), "ReferenceManual"), "SavedGameUpdater.html"));
        }
        catch (MalformedURLException ex) {
            ErrorDialog.bug(ex);
        }
        helpButton.addActionListener(new ShowHelpAction(hf.getContents(), null));
        JButton closeButton = new JButton(Resources.getString("General.cancel"));
        closeButton.addActionListener(e -> this.dispose());
        buttonsBox.add((Component)this.refreshButton, "tag ok,sg 1");
        buttonsBox.add((Component)closeButton, "tag cancel,sg 1");
        buttonsBox.add((Component)helpButton, "tag help,sg 1");
        this.nameCheck = new JCheckBox(Resources.getString("GameRefresher.use_basic_name"));
        panel.add(this.nameCheck);
        this.labelerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_labeler_descr"));
        panel.add(this.labelerNameCheck);
        this.layerNameCheck = new JCheckBox(Resources.getString("GameRefresher.use_layer_descr"));
        panel.add(this.layerNameCheck);
        this.testModeOn = new JCheckBox(Resources.getString("GameRefresher.test_mode"));
        panel.add(this.testModeOn);
        this.deletePieceNoMap = new JCheckBox(Resources.getString("GameRefresher.delete_piece_no_map"));
        this.deletePieceNoMap.setSelected(true);
        panel.add(this.deletePieceNoMap);
        panel.add((Component)buttonsBox, "grow");
        this.add((Component)panel, "grow");
        this.setLocationRelativeTo(this.getOwner());
        SwingUtils.repack(this);
    }

    protected void setOptions() {
        this.options.clear();
        if (this.nameCheck.isSelected()) {
            this.options.add("UseName");
        }
        if (this.labelerNameCheck.isSelected()) {
            this.options.add("UseLabelerName");
        }
        if (this.layerNameCheck.isSelected()) {
            this.options.add("UseLayerName");
        }
        if (this.testModeOn.isSelected()) {
            this.options.add("TestMode");
        }
        if (this.deletePieceNoMap.isSelected()) {
            this.options.add("DeleteNoMap");
        }
    }

    public void log(String message) {
        GameModule.getGameModule().warn(message);
        logger.info(message);
    }

    public boolean isTestMode() {
        return this.options.contains("TestMode");
    }

    private void refreshPredefinedSetups() {
        this.refreshButton.setEnabled(false);
        this.setOptions();
        if (this.isTestMode()) {
            this.log(Resources.getString("GameRefresher.refresh_counters_test_mode"));
        }
        GameModule mod = GameModule.getGameModule();
        List<PredefinedSetup> modulePdsAndMenus = mod.getAllDescendantComponentsOf(PredefinedSetup.class);
        ArrayList<PredefinedSetup> modulePds = new ArrayList<PredefinedSetup>();
        for (PredefinedSetup pds : modulePdsAndMenus) {
            if (pds.isMenu() || !pds.isUseFile() || pds.getFileName() == null || pds.getFileName().isBlank()) continue;
            modulePds.add(pds);
        }
        this.log(modulePds.size() + " " + Resources.getString("GameRefresher.predefined_setups_found"));
        for (PredefinedSetup pds : modulePds) {
            this.log(pds.getAttributeValueString("name") + " (" + pds.getFileName() + ")");
        }
        for (PredefinedSetup pds : modulePds) {
            try {
                pds.refresh(this.options);
            }
            catch (IOException e) {
                ErrorDialog.bug(e);
            }
        }
        this.refreshButton.setEnabled(true);
    }
}

