/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.Buildable;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidityChecker;

public class SingleChildInstance
implements ValidityChecker {
    private final AbstractConfigurable target;
    private final Class<?> childClass;

    public SingleChildInstance(AbstractConfigurable target, Class<?> childClass) {
        this.childClass = childClass;
        this.target = target;
    }

    @Override
    public void validate(Buildable b, ValidationReport report) {
        if (b == this.target && this.target.getComponentsOf(this.childClass).size() > 1) {
            report.addWarning("No more than one " + ConfigureTree.getConfigureName(this.childClass) + " allowed in " + ConfigureTree.getConfigureName(this.target));
        }
    }
}

