/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.Command;
import VASSAL.configure.Configurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.Hideable;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.Obscurable;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFinder;
import VASSAL.counters.PropertyExporter;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimitException;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.KeyStroke;

public class ActionButton
extends Decorator
implements EditablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "button;";
    protected NamedKeyStroke stroke;
    protected Rectangle bounds = new Rectangle();
    protected ButtonPusher pusher;
    protected String description = "";
    protected static final ButtonPusher globalPusher = new ButtonPusher();

    public ActionButton() {
        this(ID, null);
    }

    public ActionButton(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
        this.pusher = globalPusher;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.stroke).append(this.bounds.x).append(this.bounds.y).append(this.bounds.width).append(this.bounds.height).append(this.description);
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public void setMap(Map m) {
        this.pusher.register(m);
        this.piece.setMap(m);
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.ActionButton.trait_description", this.description);
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.stroke);
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.stroke = st.nextNamedKeyStroke('A');
        this.bounds.x = st.nextInt(-20);
        this.bounds.y = st.nextInt(-20);
        this.bounds.width = st.nextInt(40);
        this.bounds.height = st.nextInt(40);
        this.description = st.nextToken("");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("ActionButton.html");
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof ActionButton)) {
            return false;
        }
        ActionButton c = (ActionButton)o;
        if (!Objects.equals(this.bounds, c.bounds)) {
            return false;
        }
        return Objects.equals(this.description, c.description);
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    protected static class ButtonPusher {
        private final Set<Map> maps = new HashSet<Map>();
        private final java.util.Map<Component, ComponentMouseListener> componentMouseListeners = new HashMap<Component, ComponentMouseListener>();

        protected ButtonPusher() {
        }

        public void register(Map map) {
            if (map != null && !this.maps.contains(map)) {
                map.addLocalMouseListener(new MapMouseListener(map));
                this.maps.add(map);
            }
        }

        @Deprecated(since="2020-10-26", forRemoval=true)
        public void register(Component obs, GamePiece piece, int x, int y) {
            if (obs != null) {
                ComponentMouseListener l = this.componentMouseListeners.get(obs);
                if (l == null) {
                    l = new ComponentMouseListener(piece, x, y);
                    obs.addMouseListener(l);
                    this.componentMouseListeners.put(obs, l);
                } else {
                    l.xOffset = x;
                    l.yOffset = y;
                    l.target = piece;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doClick(GamePiece p, Point point) {
            GamePiece piece = p;
            while (piece instanceof Decorator) {
                if (piece instanceof Obscurable) {
                    if (((Obscurable)piece).obscuredToMe()) {
                        return;
                    }
                } else if (piece instanceof Hideable) {
                    if (((Hideable)piece).invisibleToMe()) {
                        return;
                    }
                } else if (piece instanceof ActionButton) {
                    ActionButton action = (ActionButton)piece;
                    if (action.stroke != null && action.stroke.getKeyStroke() != null && action.bounds.contains(point)) {
                        p.setProperty("snapshot", ((PropertyExporter)((Object)p)).getProperties());
                        try {
                            RecursionLimiter.startExecution(action);
                            Command command = p.keyEvent(action.stroke.getKeyStroke());
                            GameModule.getGameModule().sendAndLog(command);
                        }
                        catch (RecursionLimitException e) {
                            RecursionLimiter.infiniteLoop(e);
                        }
                        finally {
                            RecursionLimiter.endExecution();
                        }
                    }
                }
                piece = ((Decorator)piece).getInner();
            }
        }

        protected class MapMouseListener
        extends MouseAdapter {
            private final Map map;
            private GamePiece armedForClick = null;

            public MapMouseListener(Map map) {
                this.map = map;
            }

            @Override
            public void mousePressed(MouseEvent e) {
                Point point;
                GamePiece p;
                if (SwingUtils.isMainMouseButtonDown(e) && (p = this.map.findPiece(point = e.getPoint(), PieceFinder.PIECE_IN_STACK)) != null) {
                    this.armedForClick = p;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (this.armedForClick != null) {
                    if (SwingUtils.isMainMouseButtonDown(e)) {
                        Point epos = e.getPoint();
                        Shape s = this.armedForClick.getShape();
                        Point pos = this.armedForClick.getPosition();
                        Point p = new Point(epos.x - pos.x, epos.y - pos.y);
                        if (s.contains(p)) {
                            Point rel = this.map.positionOf(this.armedForClick);
                            epos.translate(-rel.x, -rel.y);
                            ButtonPusher.this.doClick(this.armedForClick, epos);
                        }
                    }
                    this.armedForClick = null;
                }
            }
        }

        @Deprecated(since="2020-10-26", forRemoval=true)
        protected class ComponentMouseListener
        extends MouseAdapter {
            private GamePiece target;
            private int xOffset;
            private int yOffset;

            public ComponentMouseListener(GamePiece piece, int x, int y) {
                this.target = piece;
                this.xOffset = x;
                this.yOffset = y;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtils.isMainMouseButtonDown(e)) {
                    Point point = e.getPoint();
                    point.translate(-this.xOffset, -this.yOffset);
                    ButtonPusher.this.doClick(this.target, point);
                    e.getComponent().repaint();
                }
            }
        }
    }

    public static class Ed
    implements PieceEditor {
        private final TraitConfigPanel box = new TraitConfigPanel();
        private final IntConfigurer xConfig;
        private final IntConfigurer yConfig;
        private final IntConfigurer widthConfig;
        private final IntConfigurer heightConfig;
        private final NamedHotKeyConfigurer strokeConfig;
        protected StringConfigurer descConfig;

        public Ed(ActionButton p) {
            this.descConfig = new StringConfigurer(p.description);
            this.descConfig.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.descConfig);
            this.strokeConfig = new NamedHotKeyConfigurer(p.stroke);
            this.box.add("Editor.ActionButton.invoke_key_command", (Configurer)this.strokeConfig);
            this.xConfig = new IntConfigurer(p.bounds.x);
            this.box.add("Editor.ActionButton.button_x_offset", (Configurer)this.xConfig);
            this.yConfig = new IntConfigurer(p.bounds.y);
            this.box.add("Editor.ActionButton.button_y_offset", (Configurer)this.yConfig);
            this.widthConfig = new IntConfigurer(p.bounds.width);
            this.box.add("Editor.ActionButton.button_width", (Configurer)this.widthConfig);
            this.heightConfig = new IntConfigurer(p.bounds.height);
            this.box.add("Editor.ActionButton.button_height", (Configurer)this.heightConfig);
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.strokeConfig.getValueString()).append(this.xConfig.getValueString()).append(this.yConfig.getValueString()).append(this.widthConfig.getValueString()).append(this.heightConfig.getValueString()).append(this.descConfig.getValueString());
            return ActionButton.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

