/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.DoubleConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.MovementMarkable;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.image.LabelUtils;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.KeyStroke;

public class Footprint
extends MovementMarkable {
    public static final String ID = "footprint;";
    private KeyCommand[] commands;
    protected boolean globalVisibility = false;
    protected String startMapId = "";
    protected List<Point> pointList = new ArrayList<Point>();
    protected NamedKeyStroke trailKey;
    protected NamedKeyStroke trailKeyOn;
    protected NamedKeyStroke trailKeyOff;
    protected NamedKeyStroke trailKeyClear;
    protected String menuCommand;
    protected boolean initiallyVisible = false;
    protected boolean globallyVisible = false;
    protected int circleRadius;
    protected int selectedTransparency;
    protected int unSelectedTransparency;
    protected Color lineColor;
    protected Color fillColor;
    protected int edgePointBuffer;
    protected int edgeDisplayBuffer;
    protected String description;
    protected static final char DEFAULT_TRAIL_KEY = 'T';
    protected static final String DEFAULT_MENU_COMMAND = Resources.getString("Editor.Footprint.movement_trail");
    protected static final Boolean DEFAULT_INITIALLY_VISIBLE = Boolean.FALSE;
    protected static final Boolean DEFAULT_GLOBALLY_VISIBLE = Boolean.FALSE;
    protected static final int DEFAULT_CIRCLE_RADIUS = 10;
    protected static final Color DEFAULT_FILL_COLOR = Color.WHITE;
    protected static final Color DEFAULT_LINE_COLOR = Color.BLACK;
    protected static final int DEFAULT_SELECTED_TRANSPARENCY = 100;
    protected static final int DEFULT_UNSELECTED_TRANSPARENCY = 50;
    protected static final int DEFAULT_EDGE_POINT_BUFFER = 20;
    protected static final int DEFAULT_EDGE_DISPLAY_BUFFER = 30;
    protected static final float LINE_WIDTH = 1.0f;
    protected Rectangle myBoundingBox;
    protected Font font;
    protected double lastZoom;
    protected boolean localVisibility;
    protected boolean initialized = false;
    protected double lineWidth;
    private KeyCommand showTrailCommand;
    private KeyCommand showTrailCommandOn;
    private KeyCommand showTrailCommandOff;
    private KeyCommand showTrailCommandClear;

    public Footprint() {
        super(ID, null);
    }

    public Footprint(String type, GamePiece p) {
        this.mySetType(type);
        this.setInner(p);
    }

    @Deprecated(since="2020-08-06", forRemoval=true)
    protected Enumeration<Point> getPointList() {
        ProblemDialog.showDeprecated("2020-08-06");
        return Collections.enumeration(this.pointList);
    }

    @Override
    public void mySetState(String newState) {
        this.pointList.clear();
        SequenceEncoder.Decoder ss = new SequenceEncoder.Decoder(newState, ';');
        this.globalVisibility = ss.nextBoolean(this.initiallyVisible);
        this.startMapId = ss.nextToken("");
        int items = ss.nextInt(0);
        for (int i = 0; i < items; ++i) {
            String point = ss.nextToken("");
            if (point.length() == 0) continue;
            SequenceEncoder.Decoder sp = new SequenceEncoder.Decoder(point, ',');
            int x = sp.nextInt(0);
            int y = sp.nextInt(0);
            this.pointList.add(new Point(x, y));
        }
    }

    @Override
    public String myGetState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.globalVisibility).append(this.startMapId).append(this.pointList.size());
        for (Point p : this.pointList) {
            se.append(p.x + "," + p.y);
        }
        return se.getValue();
    }

    @Override
    public void mySetType(String type) {
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        st.nextToken();
        this.trailKey = st.nextNamedKeyStroke('T');
        this.menuCommand = st.nextToken(DEFAULT_MENU_COMMAND);
        this.initiallyVisible = st.nextBoolean(DEFAULT_INITIALLY_VISIBLE);
        this.globallyVisible = st.nextBoolean(DEFAULT_GLOBALLY_VISIBLE);
        this.circleRadius = st.nextInt(10);
        this.fillColor = st.nextColor(DEFAULT_FILL_COLOR);
        this.lineColor = st.nextColor(DEFAULT_LINE_COLOR);
        this.selectedTransparency = st.nextInt(100);
        this.unSelectedTransparency = st.nextInt(50);
        this.edgePointBuffer = st.nextInt(20);
        this.edgeDisplayBuffer = st.nextInt(30);
        this.lineWidth = st.nextDouble(1.0);
        this.trailKeyOn = st.nextNamedKeyStroke(null);
        this.trailKeyOff = st.nextNamedKeyStroke(null);
        this.trailKeyClear = st.nextNamedKeyStroke(null);
        this.description = st.nextToken("");
        this.commands = null;
        this.showTrailCommand = null;
        this.showTrailCommandOn = null;
        this.showTrailCommandOff = null;
        this.showTrailCommandClear = null;
        if (this.initiallyVisible) {
            this.localVisibility = true;
            this.globalVisibility = true;
        }
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.trailKey).append(this.menuCommand).append(this.initiallyVisible).append(this.globallyVisible).append(this.circleRadius).append(this.fillColor).append(this.lineColor).append(this.selectedTransparency).append(this.unSelectedTransparency).append(this.edgePointBuffer).append(this.edgeDisplayBuffer).append(this.lineWidth).append(this.trailKeyOn).append(this.trailKeyOff).append(this.trailKeyClear).append(this.description);
        return ID + se.getValue();
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.trailKey, this.trailKeyOn, this.trailKeyOff, this.trailKeyClear);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.menuCommand);
    }

    @Override
    public void setProperty(Object key, Object val) {
        if ("Moved".equals(key)) {
            this.setMoved(Boolean.TRUE.equals(val));
            this.piece.setProperty(key, val);
            this.myBoundingBox = null;
        } else {
            super.setProperty(key, val);
        }
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("Moved".equals(key)) {
            Object value = this.piece.getProperty(key);
            return value == null ? super.getProperty(key) : value;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if ("Moved".equals(key)) {
            Object value = this.piece.getProperty(key);
            return value == null ? super.getProperty(key) : value;
        }
        return super.getProperty(key);
    }

    @Override
    public void setMoved(boolean justMoved) {
        if (justMoved) {
            this.recordCurrentPosition();
            Map map = this.getMap();
            this.startMapId = map != null ? map.getId() : null;
        } else {
            this.clearTrail();
        }
        this.redraw();
    }

    protected void recordCurrentPosition() {
        Point here = this.getPosition();
        if (this.pointList.isEmpty() || !this.pointList.get(this.pointList.size() - 1).equals(here)) {
            this.addPoint(here);
        } else {
            this.myBoundingBox = null;
        }
    }

    protected void clearTrail() {
        this.pointList.clear();
        this.addPoint(this.getPosition());
        if (!this.initialized) {
            this.localVisibility = this.initiallyVisible;
            this.globalVisibility = this.initiallyVisible;
            this.initialized = true;
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("MovementTrail.html");
    }

    protected void addPoint(Point p) {
        this.pointList.add(p);
        this.myBoundingBox = null;
    }

    public void redraw() {
        Map m = this.getMap();
        if (m != null) {
            m.repaint(this.getMyBoundingBox());
        }
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.Footprint.trait_description", this.description);
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        int y2;
        int x2;
        int y1;
        int x1;
        this.piece.draw(g, x, y, obs, zoom);
        Map map = this.getMap();
        if (map == null || map.getView() != obs || !this.isTrailVisible()) {
            return;
        }
        String currentMap = map.getId();
        if (!currentMap.equals(this.startMapId)) {
            this.startMapId = currentMap;
            this.clearTrail();
            return;
        }
        if (this.pointList.isEmpty()) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        if (zoom != map.getZoom() * os_scale) {
            return;
        }
        boolean selected = Boolean.TRUE.equals(Decorator.getOutermost(this).getProperty("Selected"));
        int transparencyPercent = Math.max(0, Math.min(100, selected ? this.selectedTransparency : this.unSelectedTransparency));
        float transparency = (float)transparencyPercent / 100.0f;
        Composite oldComposite = g2d.getComposite();
        Stroke oldStroke = g2d.getStroke();
        Color oldColor = g2d.getColor();
        Dimension mapsize = map.mapSize();
        int mapHeight = mapsize.height;
        int mapWidth = mapsize.width;
        int edgeHeight = Integer.parseInt(map.getAttributeValueString("edgeHeight"));
        int edgeWidth = Integer.parseInt(map.getAttributeValueString("edgeWidth"));
        int edgeClipHeight = Math.min(edgeHeight, this.edgeDisplayBuffer);
        int edgeClipWidth = Math.min(edgeWidth, this.edgeDisplayBuffer);
        int clipX = edgeWidth - edgeClipWidth;
        int clipY = edgeHeight - edgeClipHeight;
        int width = mapWidth - 2 * (edgeWidth + edgeClipWidth);
        int height = mapHeight - 2 * (edgeHeight + edgeClipHeight);
        Rectangle newClip = new Rectangle((int)((double)clipX * zoom), (int)((double)clipY * zoom), (int)((double)width * zoom), (int)((double)height * zoom));
        Rectangle visibleRect = map.componentToDrawing(map.getView().getVisibleRect(), os_scale);
        Shape oldClip = g2d.getClip();
        newClip = newClip.intersection(visibleRect);
        if (oldClip != null) {
            newClip = oldClip.getBounds().intersection(newClip);
        }
        g2d.setClip(newClip);
        g2d.setComposite(AlphaComposite.getInstance(3, transparency));
        float thickness = Math.max(1.0f, (float)(zoom * this.lineWidth));
        g2d.setStroke(new BasicStroke(thickness));
        g2d.setColor(this.lineColor);
        Rectangle circleRect = new Rectangle(edgeWidth - this.edgePointBuffer, edgeHeight - this.edgePointBuffer, mapWidth + 2 * this.edgePointBuffer, mapHeight + 2 * this.edgePointBuffer);
        Iterator<Point> i = this.pointList.iterator();
        Point cur = i.next();
        while (i.hasNext()) {
            Point next = i.next();
            x1 = (int)((double)cur.x * zoom);
            y1 = (int)((double)cur.y * zoom);
            x2 = (int)((double)next.x * zoom);
            y2 = (int)((double)next.y * zoom);
            this.drawTrack(g, x1, y1, x2, y2, zoom);
            cur = next;
        }
        Point here = this.getPosition();
        if (!here.equals(cur)) {
            x1 = (int)((double)cur.x * zoom);
            y1 = (int)((double)cur.y * zoom);
            x2 = (int)((double)here.x * zoom);
            y2 = (int)((double)here.y * zoom);
            this.drawTrack(g, x1, y1, x2, y2, zoom);
        }
        int elementCount = -1;
        for (Point p : this.pointList) {
            ++elementCount;
            if (!circleRect.contains(p) || p.equals(here)) continue;
            this.drawPoint(g, p, zoom, elementCount);
            Image image = this.getTrailImage(elementCount);
            x1 = (int)((double)(p.x - this.circleRadius) * zoom);
            y1 = (int)((double)(p.y - this.circleRadius) * zoom);
            if (selected && image != null) {
                if (zoom == 1.0) {
                    g.drawImage(image, x1, y1, obs);
                } else {
                    BufferedImage scaled = ImageUtils.transform((BufferedImage)image, zoom, 0.0);
                    g.drawImage(scaled, x1, y1, obs);
                }
            }
            String text = this.getTrailText(elementCount);
            if (!selected || text == null) continue;
            if (this.font == null || this.lastZoom != zoom) {
                x1 = (int)((double)p.x * zoom);
                y1 = (int)((double)p.y * zoom);
                Font font = new Font("Dialog", 0, (int)((double)this.circleRadius * 1.4 * zoom));
                LabelUtils.drawLabel(g, text, x1, y1, font, 0, 0, this.lineColor, null, null);
            }
            this.lastZoom = zoom;
        }
        g2d.setComposite(oldComposite);
        g2d.setStroke(oldStroke);
        g2d.setColor(oldColor);
        g.setClip(oldClip);
    }

    protected void drawPoint(Graphics g, Point p, double zoom, int elementCount) {
        int x = (int)((double)(p.x - this.circleRadius) * zoom);
        int y = (int)((double)(p.y - this.circleRadius) * zoom);
        int radius = (int)((double)(2 * this.circleRadius) * zoom);
        g.setColor(this.fillColor);
        g.fillOval(x, y, radius, radius);
        g.setColor(this.lineColor);
        g.drawOval(x, y, radius, radius);
    }

    protected void drawTrack(Graphics g, int x1, int y1, int x2, int y2, double zoom) {
        double lastSqrt = -1.0;
        int distSq = (x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1);
        int lastDistSq = -1;
        if (distSq != lastDistSq) {
            lastDistSq = distSq;
            lastSqrt = Math.sqrt(distSq);
        }
        int xDiff = (int)((double)(this.circleRadius * (x2 - x1)) * zoom / lastSqrt);
        int yDiff = (int)((double)(this.circleRadius * (y2 - y1)) * zoom / lastSqrt);
        g.drawLine(x1 + xDiff, y1 + yDiff, x2 - xDiff, y2 - yDiff);
    }

    protected Image getTrailImage(int elementCount) {
        return null;
    }

    protected String getTrailText(int elementCount) {
        return null;
    }

    protected boolean isTrailVisible() {
        if (this.globallyVisible) {
            return this.globalVisibility || this.trailKey == null;
        }
        return this.localVisibility || this.trailKey == null;
    }

    @Override
    public Rectangle boundingBox() {
        return this.isTrailVisible() && this.getMap() != null ? new Rectangle(this.getMyBoundingBox()) : this.piece.boundingBox();
    }

    public Rectangle getMyBoundingBox() {
        if (this.myBoundingBox == null) {
            Rectangle bb = this.piece.boundingBox();
            Point pos = this.piece.getPosition();
            bb.x += pos.x;
            bb.y += pos.y;
            int circleDiameter = 2 * this.circleRadius;
            Rectangle pr = new Rectangle();
            for (Point p : this.pointList) {
                pr.setBounds(p.x - this.circleRadius, p.y - this.circleRadius, circleDiameter, circleDiameter);
                bb.add(pr);
            }
            bb.x -= pos.x;
            bb.y -= pos.y;
            this.myBoundingBox = bb;
        }
        return this.myBoundingBox;
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public KeyCommand[] myGetKeyCommands() {
        if (this.commands == null) {
            if (this.trailKey != null && !this.trailKey.isNull()) {
                this.showTrailCommand = new KeyCommand(this.menuCommand, this.trailKey, Decorator.getOutermost(this), (TranslatablePiece)this);
            }
            if (this.trailKeyOn != null && !this.trailKeyOn.isNull()) {
                this.showTrailCommandOn = new KeyCommand("", this.trailKeyOn, Decorator.getOutermost(this), (TranslatablePiece)this);
            }
            if (this.trailKeyOff != null && !this.trailKeyOff.isNull()) {
                this.showTrailCommandOff = new KeyCommand("", this.trailKeyOff, Decorator.getOutermost(this), (TranslatablePiece)this);
            }
            if (this.trailKeyClear != null && !this.trailKeyClear.isNull()) {
                this.showTrailCommandClear = new KeyCommand("", this.trailKeyClear, Decorator.getOutermost(this), (TranslatablePiece)this);
            }
            this.commands = this.showTrailCommand != null && this.menuCommand.length() > 0 ? new KeyCommand[]{this.showTrailCommand} : new KeyCommand[0];
        }
        if (this.showTrailCommand != null) {
            this.showTrailCommand.setEnabled(this.getMap() != null);
        }
        return this.commands;
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        if (this.showTrailCommand != null && this.showTrailCommand.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            this.initialized = true;
            if (this.globallyVisible) {
                this.globalVisibility = !this.globalVisibility;
            } else {
                this.localVisibility = !this.localVisibility;
            }
            this.redraw();
            return tracker.getChangeCommand();
        }
        if (this.showTrailCommandOn != null && this.showTrailCommandOn.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            this.initialized = true;
            if (this.globallyVisible) {
                this.globalVisibility = true;
            } else {
                this.localVisibility = true;
            }
            this.redraw();
            return tracker.getChangeCommand();
        }
        if (this.showTrailCommandOff != null && this.showTrailCommandOff.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            this.initialized = true;
            if (this.globallyVisible) {
                this.globalVisibility = false;
            } else {
                this.localVisibility = false;
            }
            this.redraw();
            return tracker.getChangeCommand();
        }
        if (this.showTrailCommandClear != null && this.showTrailCommandClear.matches(stroke)) {
            ChangeTracker tracker = new ChangeTracker(this);
            this.clearTrail();
            return tracker.getChangeCommand();
        }
        return null;
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public PieceI18nData getI18nData() {
        PieceI18nData data = super.getI18nData();
        data.add(this.menuCommand, Resources.getString("Editor.Footprint.show_movement_trail_command"));
        return data;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Footprint)) {
            return false;
        }
        Footprint c = (Footprint)o;
        if (!Objects.equals(this.trailKey, c.trailKey)) {
            return false;
        }
        if (!Objects.equals(this.menuCommand, c.menuCommand)) {
            return false;
        }
        if (!Objects.equals(this.initiallyVisible, c.initiallyVisible)) {
            return false;
        }
        if (!Objects.equals(this.globallyVisible, c.globallyVisible)) {
            return false;
        }
        if (!Objects.equals(this.circleRadius, c.circleRadius)) {
            return false;
        }
        if (!Objects.equals(this.fillColor, c.fillColor)) {
            return false;
        }
        if (!Objects.equals(this.lineColor, c.lineColor)) {
            return false;
        }
        if (!Objects.equals(this.selectedTransparency, c.selectedTransparency)) {
            return false;
        }
        if (!Objects.equals(this.unSelectedTransparency, c.unSelectedTransparency)) {
            return false;
        }
        if (!Objects.equals(this.edgePointBuffer, c.edgePointBuffer)) {
            return false;
        }
        if (!Objects.equals(this.edgeDisplayBuffer, c.edgeDisplayBuffer)) {
            return false;
        }
        if (!Objects.equals(this.lineWidth, c.lineWidth)) {
            return false;
        }
        if (!Objects.equals(this.trailKeyOn, c.trailKeyOn)) {
            return false;
        }
        if (!Objects.equals(this.trailKeyOff, c.trailKeyOff)) {
            return false;
        }
        if (!Objects.equals(this.trailKeyClear, c.trailKeyClear)) {
            return false;
        }
        if (!Objects.equals(this.description, c.description)) {
            return false;
        }
        if (!Objects.equals(this.globalVisibility, c.globalVisibility)) {
            return false;
        }
        if (!Objects.equals(this.startMapId, c.startMapId)) {
            return false;
        }
        return Objects.equals(this.pointList, c.pointList);
    }

    protected static class Ed
    implements PieceEditor {
        private final StringConfigurer desc;
        private final NamedHotKeyConfigurer trailKeyInput;
        private final NamedHotKeyConfigurer trailKeyOn;
        private final NamedHotKeyConfigurer trailKeyOff;
        private final NamedHotKeyConfigurer trailKeyClear;
        private final TraitConfigPanel controls = new TraitConfigPanel();
        private final StringConfigurer mc;
        private final BooleanConfigurer iv;
        private final BooleanConfigurer gv;
        private final IntConfigurer cr;
        private final ColorConfigurer fc;
        private final ColorConfigurer lc;
        private final IntConfigurer st;
        private final IntConfigurer ut;
        private final IntConfigurer pb;
        private final IntConfigurer db;
        private final DoubleConfigurer lw;

        public Ed(Footprint p) {
            this.desc = new StringConfigurer(p.description);
            this.desc.setHintKey("Editor.description_hint");
            this.controls.add("Editor.description_label", (Configurer)this.desc);
            this.mc = new StringConfigurer(p.menuCommand);
            this.mc.setHintKey("Editor.menu_command_hint");
            this.controls.add("Editor.menu_command", (Configurer)this.mc);
            this.trailKeyInput = new NamedHotKeyConfigurer(p.trailKey);
            this.controls.add("Editor.keyboard_command", (Configurer)this.trailKeyInput);
            this.trailKeyOn = new NamedHotKeyConfigurer(p.trailKeyOn);
            this.controls.add("Editor.Footprint.turn_on_key_command", (Configurer)this.trailKeyOn);
            this.trailKeyOff = new NamedHotKeyConfigurer(p.trailKeyOff);
            this.controls.add("Editor.Footprint.turn_off_key_command", (Configurer)this.trailKeyOff);
            this.trailKeyClear = new NamedHotKeyConfigurer(p.trailKeyClear);
            this.controls.add("Editor.Footprint.clear_trail_key_command", (Configurer)this.trailKeyClear);
            this.iv = new BooleanConfigurer(p.initiallyVisible);
            this.controls.add("Editor.Footprint.trails_start_visible", (Configurer)this.iv);
            this.gv = new BooleanConfigurer(p.globallyVisible);
            this.controls.add("Editor.Footprint.trails_are_visible_to_all_players", (Configurer)this.gv);
            this.cr = new IntConfigurer(p.circleRadius);
            this.controls.add("Editor.Footprint.circle_radius", (Configurer)this.cr);
            this.fc = new ColorConfigurer(p.fillColor);
            this.controls.add("Editor.Footprint.circle_fill_color", (Configurer)this.fc);
            this.lc = new ColorConfigurer(p.lineColor);
            this.controls.add("Editor.Footprint.line_color", (Configurer)this.lc);
            this.lw = new DoubleConfigurer(p.lineWidth);
            this.controls.add("Editor.Footprint.line_thickness", (Configurer)this.lw);
            this.st = new IntConfigurer(p.selectedTransparency);
            this.controls.add("Editor.Footprint.selected_transparency", (Configurer)this.st);
            this.ut = new IntConfigurer(p.unSelectedTransparency);
            this.controls.add("Editor.Footprint.unselected_transparency", (Configurer)this.ut);
            this.pb = new IntConfigurer(p.edgePointBuffer);
            this.controls.add("Editor.Footprint.display_trail_points_off_map", (Configurer)this.pb);
            this.db = new IntConfigurer(p.edgeDisplayBuffer);
            this.controls.add("Editor.Footprint.display_trails_off_map", (Configurer)this.db);
        }

        @Override
        public String getState() {
            return this.gv.booleanValue() + ";;0";
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.trailKeyInput.getValueString()).append(this.mc.getValueString()).append(this.iv.getValueString()).append(this.gv.getValueString()).append(this.cr.getValueString()).append(this.fc.getValueString()).append(this.lc.getValueString()).append(this.st.getValueString()).append(this.ut.getValueString()).append(this.pb.getValueString()).append(this.db.getValueString()).append(this.lw.getValueString()).append(this.trailKeyOn.getValueString()).append(this.trailKeyOff.getValueString()).append(this.trailKeyClear.getValueString()).append(this.desc.getValueString());
            return Footprint.ID + se.getValue();
        }

        @Override
        public Component getControls() {
            return this.controls;
        }
    }
}

