/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.GameModule;
import VASSAL.build.module.Documentation;
import VASSAL.build.module.documentation.HelpWindow;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.RemoveUnusedImagesDialog;
import VASSAL.configure.SaveAction;
import VASSAL.configure.SaveAsAction;
import VASSAL.configure.ShowHelpAction;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.ValidationReportDialog;
import VASSAL.i18n.Resources;
import VASSAL.launch.AboutVASSALAction;
import VASSAL.launch.ShutDownAction;
import VASSAL.tools.ApplicationIcons;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.menu.ChildProxy;
import VASSAL.tools.menu.MenuBarProxy;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.menu.MenuProxy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.SystemUtils;

public abstract class EditorWindow
extends JFrame {
    private static final long serialVersionUID = 1L;
    protected SaveAction saveAction;
    protected SaveAsAction saveAsAction;
    protected JMenuItem componentHelpItem;
    protected final HelpWindow helpWindow = new HelpWindow(Resources.getString("Editor.ModuleEditor.reference_manual"), null);
    protected ConfigureTree tree;
    protected String moduleName = "";
    protected String extensionName = "";
    protected final JToolBar toolBar = new JToolBar();
    protected final JScrollPane scrollPane;

    public abstract String getEditorType();

    protected EditorWindow() {
        URL url;
        this.updateWindowTitle();
        this.setLayout(new BorderLayout());
        ApplicationIcons.setFor(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                EditorWindow.this.close();
            }
        });
        this.toolBar.setFloatable(false);
        this.add((Component)this.toolBar, "North");
        MenuManager mm = MenuManager.getInstance();
        MenuBarProxy mb = mm.getMenuBarProxyFor(this);
        if (SystemUtils.IS_OS_MAC) {
            mm.addToSection("Editor.File", mm.addKey("Editor.save"));
            mm.addToSection("Editor.File", mm.addKey("Editor.save_as"));
        } else {
            MenuProxy fileMenu = new MenuProxy(Resources.getString("General.file"));
            fileMenu.setMnemonic(Resources.getString("General.file.shortcut").charAt(0));
            fileMenu.add(mm.addKey("Editor.save"));
            fileMenu.add(mm.addKey("Editor.save_as"));
            fileMenu.addSeparator();
            fileMenu.add(mm.addKey("General.quit"));
            mb.add(fileMenu);
        }
        MenuProxy editMenu = new MenuProxy(Resources.getString("General.edit"));
        editMenu.setMnemonic(Resources.getString("General.edit.shortcut").charAt(0));
        editMenu.add(mm.addKey("Editor.cut"));
        editMenu.add(mm.addKey("Editor.copy"));
        editMenu.add(mm.addKey("Editor.paste"));
        editMenu.add(mm.addKey("Editor.move"));
        editMenu.addSeparator();
        editMenu.add(mm.addKey("Editor.search"));
        editMenu.addSeparator();
        editMenu.add(mm.addKey("Editor.properties"));
        editMenu.add(mm.addKey("Editor.ModuleEditor.translate"));
        MenuProxy toolsMenu = new MenuProxy(Resources.getString("General.tools"));
        toolsMenu.setMnemonic(Resources.getString("General.tools.shortcut").charAt(0));
        toolsMenu.add(mm.addKey("Editor.ModuleEditor.refresh_predefined"));
        toolsMenu.add(mm.addKey("Editor.UnusedImages.remove_unused_images"));
        if (SystemUtils.IS_OS_MAC) {
            mm.addToSection("Editor.MenuBar", editMenu);
            mm.addToSection("Editor.MenuBar", toolsMenu);
        } else {
            mb.add(editMenu);
            mb.add(toolsMenu);
        }
        if (SystemUtils.IS_OS_MAC) {
            mm.addToSection("Documentation.VASSAL", mm.addKey("Editor.ModuleEditor.reference_manual"));
        } else {
            MenuProxy helpMenu = new MenuProxy(Resources.getString("General.help"));
            helpMenu.setMnemonic(Resources.getString("General.help.shortcut").charAt(0));
            helpMenu.add(mm.addKey("Editor.ModuleEditor.table_of_contents"));
            helpMenu.add(mm.addKey("Editor.ModuleEditor.using_the_editor"));
            helpMenu.add(mm.addKey("Editor.ModuleEditor.designer_guide"));
            helpMenu.addSeparator();
            helpMenu.add(mm.addKey("Editor.ModuleEditor.module_components"));
            helpMenu.add(mm.addKey("Editor.ModuleEditor.map_components"));
            helpMenu.add(mm.addKey("Editor.ModuleEditor.toolbar_help"));
            helpMenu.addSeparator();
            helpMenu.add(mm.addKey("Editor.ModuleEditor.game_pieces_and_traits"));
            helpMenu.add(mm.addKey("Editor.ModuleEditor.expressions"));
            helpMenu.add(mm.addKey("Editor.properties"));
            helpMenu.addSeparator();
            helpMenu.add(mm.addKey("AboutScreen.about_vassal"));
            mb.add(helpMenu);
        }
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx();
        this.saveAction = new SaveAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorWindow.this.save();
                EditorWindow.this.treeStateChanged(false);
            }
        };
        this.saveAction.setEnabled(false);
        this.saveAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(83, mask));
        mm.addAction("Editor.save", this.saveAction);
        this.toolBar.add(this.saveAction);
        this.saveAsAction = new SaveAsAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorWindow.this.saveAs();
                EditorWindow.this.treeStateChanged(false);
            }
        };
        this.saveAsAction.setEnabled(false);
        this.saveAsAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(65, mask));
        mm.addAction("Editor.save_as", this.saveAsAction);
        this.toolBar.add(this.saveAsAction);
        mm.addAction("General.quit", new ShutDownAction());
        mm.addAction("Editor.UnusedImages.remove_unused_images", new AbstractAction("Remove Unused Images"){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new RemoveUnusedImagesDialog(EditorWindow.this).setVisible(true);
            }
        });
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "ReferenceManual/index.html").toURI().toURL();
            mm.addAction("Editor.ModuleEditor.table_of_contents", new ShowHelpAction("Editor.ModuleEditor.table_of_contents", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "ReferenceManual/editor.html").toURI().toURL();
            mm.addAction("Editor.ModuleEditor.using_the_editor", new ShowHelpAction("Editor.ModuleEditor.using_the_editor", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "designerguide/designerguide.pdf").toURI().toURL();
            mm.addAction("Editor.ModuleEditor.designer_guide", new ShowHelpAction("Editor.ModuleEditor.designer_guide", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "ReferenceManual/GameModule.html").toURI().toURL();
            mm.addAction("Editor.ModuleEditor.module_components", new ShowHelpAction("Editor.ModuleEditor.module_components", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "ReferenceManual/Map.html").toURI().toURL();
            mm.addAction("Editor.ModuleEditor.map_components", new ShowHelpAction("Editor.ModuleEditor.map_components", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "ReferenceManual/Toolbar.html").toURI().toURL();
            mm.addAction("Editor.ModuleEditor.toolbar_help", new ShowHelpAction("Editor.ModuleEditor.toolbar_help", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "ReferenceManual/GamePiece.html").toURI().toURL();
            mm.addAction("Editor.ModuleEditor.game_pieces_and_traits", new ShowHelpAction("Editor.ModuleEditor.game_pieces_and_traits", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "ReferenceManual/Expression.html").toURI().toURL();
            mm.addAction("Editor.ModuleEditor.expressions", new ShowHelpAction("Editor.ModuleEditor.expressions", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        try {
            url = new File(Documentation.getDocumentationBaseDir(), "ReferenceManual/Properties.html").toURI().toURL();
            mm.addAction("Editor.properties", new ShowHelpAction("Editor.properties", url, null));
        }
        catch (MalformedURLException e) {
            ErrorDialog.bug(e);
        }
        mm.addAction("AboutScreen.about_vassal", new AboutVASSALAction(this));
        this.setJMenuBar(mm.getMenuBarFor(this));
        JPanel panel = new JPanel();
        panel.setPreferredSize(new Dimension(250, 400));
        this.scrollPane = new JScrollPane(panel, 20, 30);
        this.add((Component)this.scrollPane, "Center");
        this.pack();
    }

    boolean isTempFile(String name) {
        return name == null || name.isEmpty() || "tmp".equals(name.substring(0, 3)) && name.contains(".zip");
    }

    void setModuleName(String name) {
        this.moduleName = this.isTempFile(name) ? Resources.getString("Editor.ModuleEditor.creating_new_module") : name;
        this.updateWindowTitle();
    }

    void setExtensionName(String name) {
        this.extensionName = this.isTempFile(name) ? Resources.getString("Editor.ExtensionEditor.creating_new_extension") : name;
        this.extensionName = name;
        this.updateWindowTitle();
    }

    void updateWindowTitle() {
    }

    protected MenuProxy findMenuProxy(String name, MenuBarProxy mb) {
        for (ChildProxy<?> c : mb.getChildren()) {
            MenuProxy m;
            if (!(c instanceof MenuProxy) || !name.equals((m = (MenuProxy)c).getText())) continue;
            return m;
        }
        return null;
    }

    protected abstract void save();

    protected abstract void saveAs();

    protected void close() {
        GameModule.getGameModule().quit();
    }

    protected void saver(final Runnable save) {
        ValidationReport report = new ValidationReport();
        GameModule.getGameModule().validate(GameModule.getGameModule(), report);
        if (report.getWarnings().size() == 0) {
            save.run();
        } else {
            new ValidationReportDialog(report, new ValidationReportDialog.CallBack(){

                @Override
                public void ok() {
                    save.run();
                }

                @Override
                public void cancel() {
                }
            }).setVisible(true);
        }
    }

    public void treeStateChanged(boolean changed) {
    }
}

