/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.build.module.ExtensionsLoader;
import VASSAL.launch.ExceptionHandler;
import VASSAL.launch.LaunchRequest;
import VASSAL.launch.LaunchRequestException;
import VASSAL.launch.MacOSXStartUp;
import VASSAL.launch.StartUp;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ThrowableUtils;
import VASSAL.tools.logging.LoggedOutputStream;
import VASSAL.tools.menu.MenuManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Launcher {
    private static final Logger logger = LoggerFactory.getLogger(Launcher.class);
    protected final LaunchRequest lr;
    private static Launcher instance = null;

    public static Launcher getInstance() {
        return instance;
    }

    protected Launcher(String[] args) {
        if (instance != null) {
            throw new IllegalStateException();
        }
        instance = this;
        LaunchRequest lreq = null;
        try {
            lreq = LaunchRequest.parseArgs(args);
        }
        catch (LaunchRequestException e) {
            System.err.println("VASSAL: " + e.getMessage());
            System.exit(1);
        }
        this.lr = lreq;
        StartUp start = SystemUtils.IS_OS_MAC ? new MacOSXStartUp() : new StartUp();
        start.startErrorLog();
        System.setErr(new PrintStream((OutputStream)new LoggedOutputStream(), true, Charset.defaultCharset()));
        logger.info(this.getClass().getSimpleName());
        Thread.setDefaultUncaughtExceptionHandler(new ExceptionHandler());
        start.initSystemProperties();
        this.createMenuManager();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    Launcher.this.launch();
                }
                catch (ExtensionsLoader.LoadExtensionException | IOException e2) {
                    this.warn(e2);
                }
            }

            private void warn(Exception e1) {
                ErrorDialog.showDetails(e1, ThrowableUtils.getStackTrace(e1), "Error.module_load_failed", e1.getMessage());
                System.exit(1);
            }
        });
    }

    protected abstract void launch() throws IOException;

    protected abstract MenuManager createMenuManager();
}

