/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.launch;

import VASSAL.Info;
import VASSAL.build.GameModule;
import VASSAL.configure.ConfigureTree;
import VASSAL.configure.RefreshPredefinedSetupsDialog;
import VASSAL.configure.SavedGameUpdaterDialog;
import VASSAL.i18n.Resources;
import VASSAL.launch.EditorWindow;
import VASSAL.launch.ModuleManagerUpdateHelper;
import VASSAL.tools.menu.MenuManager;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.commons.lang3.StringUtils;

public class ModuleEditorWindow
extends EditorWindow {
    private static final long serialVersionUID = 1L;
    protected Action updateSavedGame;
    protected Action refreshPredefinedSetups;

    public ModuleEditorWindow(GameModule mod) {
        this.tree = new ConfigureTree(mod, this.helpWindow, this);
        this.treeStateChanged(false);
        this.setModuleName(mod.getDataArchive().getArchive().getFile().getName());
        this.scrollPane.setViewportView(this.tree);
        MenuManager mm = MenuManager.getInstance();
        this.tree.populateEditMenu(this);
        mm.addAction("Editor.ModuleEditor.reference_manual", this.tree.getHelpAction());
        this.updateSavedGame = new AbstractAction(Resources.getString("Editor.ModuleEditor.update_saved")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new SavedGameUpdaterDialog(ModuleEditorWindow.this).setVisible(true);
            }
        };
        mm.addAction("Editor.ModuleEditor.update_saved", this.updateSavedGame);
        this.refreshPredefinedSetups = new AbstractAction(Resources.getString("Editor.ModuleEditor.refresh_predefined")){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                new RefreshPredefinedSetupsDialog(ModuleEditorWindow.this).setVisible(true);
            }
        };
        mm.addAction("Editor.ModuleEditor.refresh_predefined", this.refreshPredefinedSetups);
        this.saveAction.setEnabled(true);
        this.saveAsAction.setEnabled(true);
        this.updateSavedGame.setEnabled(true);
        this.refreshPredefinedSetups.setEnabled(true);
        this.pack();
        this.tree.requestFocus();
    }

    @Override
    public String getEditorType() {
        return Resources.getString("Editor.ModuleEditor.component_type");
    }

    @Override
    public void updateWindowTitle() {
        Object title = Resources.getString("Editor.ModuleEditor.editor_name", Info.getVersion());
        if (!StringUtils.isEmpty((CharSequence)this.moduleName)) {
            title = this.moduleName + " - " + (String)title;
        }
        this.setTitle((String)title);
    }

    @Override
    protected void save() {
        this.saver(() -> {
            GameModule g = GameModule.getGameModule();
            g.save();
            File f = g.getArchiveWriter().getArchive().getFile();
            this.setModuleName(f.getName());
            ModuleManagerUpdateHelper.sendModuleUpdate(f);
        });
    }

    @Override
    protected void saveAs() {
        this.saver(() -> {
            GameModule g = GameModule.getGameModule();
            g.saveAs();
            File f = g.getArchiveWriter().getArchive().getFile();
            this.setModuleName(f.getName());
            ModuleManagerUpdateHelper.sendModuleUpdate(f);
        });
    }
}

