/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools;

import VASSAL.tools.NamedKeyManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class NamedKeyStroke {
    public static final NamedKeyStroke NULL_KEYSTROKE = new NamedKeyStroke();
    protected KeyStroke stroke;
    protected String name;

    public NamedKeyStroke(int code, int modifiers) {
        this(code, modifiers, null);
    }

    public NamedKeyStroke(int code, int modifiers, String s) {
        this(KeyStroke.getKeyStroke(code, modifiers), s);
    }

    public NamedKeyStroke(KeyStroke k, String s) {
        this.stroke = k;
        this.name = s;
    }

    public NamedKeyStroke(KeyStroke k) {
        this(k, null);
    }

    public NamedKeyStroke(String s) {
        this(NamedKeyManager.getMarkerKeyStroke(), s);
    }

    public NamedKeyStroke() {
        this(null, null);
    }

    public boolean isNamed() {
        return this.name != null && this.name.length() != 0;
    }

    public String getName() {
        return this.name;
    }

    public boolean isNull() {
        return this.stroke == null && this.name == null || this.stroke != null && this.stroke.getKeyCode() == 0 && this.stroke.getModifiers() == 0;
    }

    public KeyStroke getStroke() {
        return this.stroke;
    }

    public boolean equals(Object o) {
        if (o instanceof NamedKeyStroke) {
            if (this.getKeyStroke() == null) {
                return ((NamedKeyStroke)o).getKeyStroke() == null;
            }
            return this.getKeyStroke().equals(((NamedKeyStroke)o).getKeyStroke());
        }
        if (o instanceof KeyStroke) {
            KeyStroke a = this.getKeyStroke();
            if (a == null) {
                return false;
            }
            return a.equals(o);
        }
        return false;
    }

    public KeyStroke getKeyStroke() {
        if (this.isNamed()) {
            return NamedKeyManager.getInstance().getKeyStroke(this);
        }
        return this.getStroke();
    }

    public static NamedKeyStroke getNamedKeyStroke(char c) {
        return NamedKeyStroke.getNamedKeyStroke(c, 0);
    }

    public static NamedKeyStroke getNamedKeyStroke(char c, int mod) {
        return new NamedKeyStroke(KeyStroke.getKeyStroke((int)c, mod));
    }

    public static NamedKeyStroke getNamedKeyStroke(int c, int mod) {
        return new NamedKeyStroke(KeyStroke.getKeyStroke(c, mod));
    }

    public static NamedKeyStroke getKeyStrokeForEvent(KeyEvent e) {
        return new NamedKeyStroke(SwingUtils.getKeyStrokeForEvent(e));
    }
}

