/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.Drawable;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.module.map.boardPicker.board.ZonedGrid;
import VASSAL.build.module.map.boardPicker.board.mapgrid.Zone;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.configure.PlayerIdFormattedStringConfigurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.VisibilityCondition;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatableConfigurerFactory;
import VASSAL.search.HTMLImageFinder;
import VASSAL.tools.FormattedString;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.KeyStroke;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class LOS_Thread
extends AbstractToolbarItem
implements MouseListener,
MouseMotionListener,
Drawable,
Configurable,
UniqueIdManager.Identifyable,
CommandEncoder {
    public static final String LOS_THREAD_COMMAND = "LOS\t";
    public static final String NAME = "threadName";
    public static final String HOTKEY = "hotkey";
    public static final String TOOLTIP = "tooltip";
    public static final String ICON_NAME = "iconName";
    public static final String LABEL = "label";
    public static final String SNAP_LOS = "snapLOS";
    public static final String SNAP_START = "snapStart";
    public static final String SNAP_END = "snapEnd";
    public static final String REPORT = "report";
    public static final String PERSISTENCE = "persistence";
    public static final String PERSISTENT_ICON_NAME = "persistentIconName";
    public static final String GLOBAL = "global";
    public static final String LOS_COLOR = "threadColor";
    public static final String DRAW_RANGE = "drawRange";
    public static final String HIDE_COUNTERS = "hideCounters";
    public static final String HIDE_OPACITY = "hideOpacity";
    public static final String RANGE_BACKGROUND = "rangeBg";
    public static final String RANGE_FOREGROUND = "rangeFg";
    public static final String RANGE_SCALE = "scale";
    public static final String RANGE_ROUNDING = "round";
    public static final String ROUND_UP = "Up";
    public static final String ROUND_DOWN = "Down";
    public static final String ROUND_OFF = "Nearest whole number";
    public static final Font RANGE_FONT = new Font("Dialog", 0, 11);
    public static final String DEFAULT_ICON = "/images/thread.gif";
    public static final String FROM_LOCATION = "FromLocation";
    public static final String TO_LOCATION = "ToLocation";
    public static final String CHECK_COUNT = "NumberOfLocationsChecked";
    public static final String CHECK_LIST = "AllLocationsChecked";
    public static final String RANGE = "Range";
    public static final String NEVER = "Never";
    public static final String ALWAYS = "Always";
    public static final String CTRL_CLICK = "Ctrl-Click & Drag";
    public static final String WHEN_PERSISTENT = "When Persisting";
    protected static final UniqueIdManager idMgr = new UniqueIdManager("LOS_Thread");
    protected boolean retainAfterRelease = false;
    protected long lastRelease = 0L;
    protected LaunchButton launch;
    protected Map map;
    protected KeyStroke hotkey;
    protected Point anchor;
    protected Point arrow;
    protected boolean visible = false;
    protected boolean drawRange;
    protected int rangeScale;
    protected double rangeRounding = 0.5;
    protected boolean hideCounters;
    protected int hideOpacity = 0;
    protected String fixedColor;
    protected Color threadColor = Color.black;
    protected Color rangeFg = Color.white;
    protected Color rangeBg = Color.black;
    protected boolean snapStart;
    protected boolean snapEnd;
    protected Point lastAnchor = new Point();
    protected Point lastArrow = new Point();
    protected Rectangle lastRangeRect = new Rectangle();
    protected String anchorLocation = "";
    protected String lastLocation = "";
    protected String lastRange = "";
    protected FormattedString reportFormat = new FormattedString(Resources.getString("Editor.LosThread.los_check_string"));
    protected List<String> checkList = new ArrayList<String>();
    protected String persistence = "Ctrl-Click & Drag";
    protected String persistentIconName;
    protected String global = "Always";
    protected String threadId = "";
    protected boolean persisting = false;
    protected boolean mirroring = false;
    protected String iconName;
    protected boolean ctrlWhenClick = false;
    protected boolean initializing;

    public LOS_Thread() {
        this.anchor = new Point(0, 0);
        this.arrow = new Point(0, 0);
        ActionListener al = e -> this.launch();
        this.setNameKey(NAME);
        this.setButtonTextKey(LABEL);
        this.setTooltipKey(TOOLTIP);
        this.setIconKey(ICON_NAME);
        this.setHotKeyKey(HOTKEY);
        this.launch = this.makeLaunchButton(Resources.getString("Editor.LosThread.show_los_thread"), Resources.getString("Editor.LosThread.thread"), DEFAULT_ICON, al);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean state) {
        this.visible = state;
    }

    @Override
    public void addTo(Buildable b) {
        idMgr.add(this);
        this.map = (Map)b;
        this.map.getView().addMouseMotionListener(this);
        this.map.addDrawComponent(this);
        this.map.getToolBar().add(this.getLaunchButton());
        GameModule.getGameModule().addCommandEncoder(this);
        GameModule.getGameModule().getPrefs().addOption(this.getConfigureName(), new BooleanConfigurer(SNAP_LOS, Resources.getString("LOS_Thread.snap_thread_preference")));
        if (this.fixedColor == null) {
            ColorConfigurer config = new ColorConfigurer(LOS_COLOR, Resources.getString("LOS_Thread.thread_color_preference"));
            GameModule.getGameModule().getPrefs().addOption(this.getConfigureName(), config);
            this.threadColor = (Color)GameModule.getGameModule().getPrefs().getValue(LOS_COLOR);
            config.addPropertyChangeListener(evt -> {
                this.threadColor = (Color)evt.getNewValue();
            });
            config.fireUpdate();
        }
    }

    @Override
    public void removeFrom(Buildable b) {
        this.map = (Map)b;
        this.map.removeDrawComponent(this);
        this.map.getToolBar().remove(this.getLaunchButton());
        GameModule.getGameModule().removeCommandEncoder(this);
        idMgr.remove(this);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (DRAW_RANGE.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.drawRange = (Boolean)value;
        } else if (RANGE_SCALE.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.rangeScale = (Integer)value;
        } else if (RANGE_ROUNDING.equals(key)) {
            this.rangeRounding = ROUND_UP.equals(value) ? 1.0 : (ROUND_DOWN.equals(value) ? 0.0 : 0.5);
        } else if (HIDE_COUNTERS.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.hideCounters = (Boolean)value;
        } else if (HIDE_OPACITY.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.setTransparency((Integer)value);
        } else if (RANGE_FOREGROUND.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.rangeFg = (Color)value;
        } else if (RANGE_BACKGROUND.equals(key)) {
            if (value instanceof String) {
                value = ColorConfigurer.stringToColor((String)value);
            }
            this.rangeBg = (Color)value;
        } else if (LOS_COLOR.equals(key)) {
            if (value instanceof Color) {
                value = ColorConfigurer.colorToString((Color)value);
            }
            this.fixedColor = (String)value;
            this.threadColor = ColorConfigurer.stringToColor(this.fixedColor);
        } else if (SNAP_START.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.snapStart = (Boolean)value;
        } else if (SNAP_END.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.snapEnd = (Boolean)value;
        } else if (REPORT.equals(key)) {
            this.reportFormat.setFormat((String)value);
        } else if (PERSISTENCE.equals(key)) {
            this.persistence = (String)value;
        } else if (PERSISTENT_ICON_NAME.equals(key)) {
            this.persistentIconName = (String)value;
        } else if (GLOBAL.equals(key)) {
            this.global = (String)value;
        } else if (ICON_NAME.equals(key)) {
            this.iconName = (String)value;
            super.setAttribute(ICON_NAME, this.iconName);
        } else {
            super.setAttribute(key, value);
        }
    }

    protected void setTransparency(int h) {
        this.hideOpacity = h < 0 ? 0 : Math.min(h, 100);
    }

    @Override
    public String getAttributeValueString(String key) {
        if (DRAW_RANGE.equals(key)) {
            return String.valueOf(this.drawRange);
        }
        if (RANGE_SCALE.equals(key)) {
            return String.valueOf(this.rangeScale);
        }
        if (RANGE_ROUNDING.equals(key)) {
            if (this.rangeRounding == 1.0) {
                return ROUND_UP;
            }
            if (this.rangeRounding == 0.0) {
                return ROUND_DOWN;
            }
            return ROUND_OFF;
        }
        if (HIDE_COUNTERS.equals(key)) {
            return String.valueOf(this.hideCounters);
        }
        if (HIDE_OPACITY.equals(key)) {
            return String.valueOf(this.hideOpacity);
        }
        if (RANGE_FOREGROUND.equals(key)) {
            return ColorConfigurer.colorToString(this.rangeFg);
        }
        if (RANGE_BACKGROUND.equals(key)) {
            return ColorConfigurer.colorToString(this.rangeBg);
        }
        if (LOS_COLOR.equals(key)) {
            return this.fixedColor;
        }
        if (SNAP_START.equals(key)) {
            return String.valueOf(this.snapStart);
        }
        if (SNAP_END.equals(key)) {
            return String.valueOf(this.snapEnd);
        }
        if (REPORT.equals(key)) {
            return this.reportFormat.getFormat();
        }
        if (PERSISTENCE.equals(key)) {
            return this.persistence;
        }
        if (PERSISTENT_ICON_NAME.equals(key)) {
            return this.persistentIconName;
        }
        if (GLOBAL.equals(key)) {
            return this.global;
        }
        if (ICON_NAME.equals(key)) {
            return this.iconName;
        }
        return super.getAttributeValueString(key);
    }

    public void setup(boolean show) {
        this.getLaunchButton().setEnabled(show);
    }

    public String getState() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.anchor.x).append(this.anchor.y).append(this.arrow.x).append(this.arrow.y);
        se.append(this.persisting);
        se.append(this.mirroring);
        return se.getValue();
    }

    public void setState(String state) {
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(state, ';');
        this.anchor.x = sd.nextInt(this.anchor.x);
        this.anchor.y = sd.nextInt(this.anchor.y);
        this.arrow.x = sd.nextInt(this.arrow.x);
        this.arrow.y = sd.nextInt(this.arrow.y);
        this.setPersisting(sd.nextBoolean(false));
        this.setMirroring(sd.nextBoolean(false));
    }

    @Override
    public void draw(Graphics g, Map m) {
        if (this.initializing || !this.visible) {
            return;
        }
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        g.setColor(this.threadColor);
        Point mapAnchor = this.map.mapToDrawing(this.anchor, os_scale);
        Point mapArrow = this.map.mapToDrawing(this.arrow, os_scale);
        g.drawLine(mapAnchor.x, mapAnchor.y, mapArrow.x, mapArrow.y);
        if (this.drawRange) {
            if (this.rangeScale > 0) {
                int dist = (int)(this.rangeRounding + this.anchor.getLocation().distance(this.arrow.getLocation()) / (double)this.rangeScale);
                this.drawRange(g, dist);
            } else {
                MapGrid grid;
                Board b = this.map.findBoard(this.anchor);
                if (b != null && (grid = b.getGrid()) != null) {
                    if (grid instanceof ZonedGrid) {
                        Point bp = new Point(this.anchor);
                        bp.translate(-b.bounds().x, -b.bounds().y);
                        Zone z = ((ZonedGrid)b.getGrid()).findZone(bp);
                        if (z != null) {
                            grid = z.getGrid();
                        }
                    }
                    if (grid != null) {
                        this.drawRange(g, grid.range(this.anchor, this.arrow));
                    }
                }
            }
        }
        this.lastAnchor = this.anchor;
        this.lastArrow = this.arrow;
    }

    @Override
    public boolean drawAboveCounters() {
        return true;
    }

    protected void launch() {
        if (!this.visible) {
            this.map.pushMouseListener(this);
            if (this.hideCounters) {
                this.map.setPieceOpacity((float)this.hideOpacity / 100.0f);
                this.map.repaint();
            }
            this.visible = true;
            this.anchor.move(0, 0);
            this.arrow.move(0, 0);
            this.retainAfterRelease = false;
            this.initializing = true;
        } else if (this.persisting) {
            this.setPersisting(false);
        }
    }

    @Override
    public void setId(String id) {
        this.threadId = id;
    }

    @Override
    public String getId() {
        return this.threadId;
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (!SwingUtils.isMainMouseButtonDown(e)) {
            return;
        }
        this.initializing = false;
        if (this.visible && !this.persisting && !this.mirroring) {
            Point p = e.getPoint();
            if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(SNAP_LOS)) || this.snapStart) {
                p = this.map.snapTo(p);
            }
            this.anchor = p;
            this.lastLocation = this.anchorLocation = this.map.localizedLocationName(this.anchor);
            this.lastRange = "";
            this.checkList.clear();
            this.ctrlWhenClick = SwingUtils.isSelectionToggle(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!SwingUtils.isMainMouseButtonDown(e)) {
            return;
        }
        if (!this.persisting && !this.mirroring) {
            if (!(!this.retainAfterRelease || this.ctrlWhenClick && this.persistence.equals(CTRL_CLICK))) {
                this.retainAfterRelease = false;
                if (this.global.equals(ALWAYS)) {
                    LOSCommand com = new LOSCommand(this, this.getAnchor(), this.getArrow(), false, true);
                    GameModule.getGameModule().sendAndLog(com);
                }
            } else if (e.getWhen() != this.lastRelease) {
                this.visible = false;
                if (this.global.equals(ALWAYS) || this.global.equals(WHEN_PERSISTENT)) {
                    if (this.persistence.equals(ALWAYS) || this.ctrlWhenClick && this.persistence.equals(CTRL_CLICK)) {
                        this.anchor = this.lastAnchor;
                        LOSCommand com = new LOSCommand(this, this.getAnchor(), this.getArrow(), true, false);
                        GameModule.getGameModule().sendAndLog(com);
                        this.setPersisting(true);
                    } else {
                        LOSCommand com = new LOSCommand(this, this.getAnchor(), this.getArrow(), false, false);
                        GameModule.getGameModule().sendAndLog(com);
                    }
                }
                this.map.setPieceOpacity(1.0f);
                this.map.popMouseListener();
                this.map.repaint();
            }
            this.lastRelease = e.getWhen();
            if (this.getLosCheckCount() > 0) {
                this.reportFormat.setProperty(FROM_LOCATION, this.anchorLocation);
                this.reportFormat.setProperty(TO_LOCATION, this.lastLocation);
                this.reportFormat.setProperty(RANGE, this.lastRange);
                this.reportFormat.setProperty(CHECK_COUNT, String.valueOf(this.getLosCheckCount()));
                this.reportFormat.setProperty(CHECK_LIST, this.getLosCheckList());
                GameModule.getGameModule().getChatter().send(this.reportFormat.getLocalizedText());
            }
        }
        this.ctrlWhenClick = false;
    }

    protected void setPersisting(boolean b) {
        this.persisting = b;
        this.visible = b;
        this.setMirroring(false);
        if (this.persisting) {
            this.launch.setAttribute(ICON_NAME, this.persistentIconName);
        } else {
            this.launch.setAttribute(ICON_NAME, this.iconName);
            this.map.repaint();
        }
    }

    protected boolean isPersisting() {
        return this.persisting;
    }

    protected void setMirroring(boolean b) {
        this.mirroring = b;
        if (this.mirroring) {
            this.visible = true;
        }
    }

    protected boolean isMirroring() {
        return this.mirroring;
    }

    protected Point getAnchor() {
        return new Point(this.anchor);
    }

    protected void setEndPoints(Point newAnchor, Point newArrow) {
        this.anchor.x = newAnchor.x;
        this.anchor.y = newAnchor.y;
        this.arrow.x = newArrow.x;
        this.arrow.y = newArrow.y;
        this.map.repaint();
    }

    protected Point getArrow() {
        return new Point(this.arrow);
    }

    protected int getLosCheckCount() {
        return this.checkList.size();
    }

    protected String getLosCheckList() {
        return StringUtils.join(this.checkList, (String)", ");
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        if (!SwingUtils.isMainMouseButtonDown(e)) {
            return;
        }
        if (this.visible && !this.persisting && !this.mirroring) {
            this.retainAfterRelease = true;
            Point p = e.getPoint();
            this.map.scrollAtEdge(p, 15);
            if (Boolean.TRUE.equals(GameModule.getGameModule().getPrefs().getValue(SNAP_LOS)) || this.snapEnd) {
                p = this.map.mapToComponent(this.map.snapTo(this.map.componentToMap(p)));
            }
            this.arrow = this.map.componentToMap(p);
            String location = this.map.localizedLocationName(this.arrow);
            if (!this.checkList.contains(location) && !location.equals(this.anchorLocation)) {
                this.checkList.add(location);
                this.lastLocation = location;
            }
            Point mapAnchor = this.lastAnchor;
            Point mapArrow = this.lastArrow;
            int fudge = (int)(1.0 / this.map.getZoom() * 2.0);
            Rectangle r = new Rectangle(Math.min(mapAnchor.x, mapArrow.x) - fudge, Math.min(mapAnchor.y, mapArrow.y) - fudge, Math.abs(mapAnchor.x - mapArrow.x) + 1 + fudge * 2, Math.abs(mapAnchor.y - mapArrow.y) + 1 + fudge * 2);
            this.map.repaint(r);
            if (this.drawRange) {
                this.map.repaint(this.lastRangeRect);
            }
        }
    }

    public void drawRange(Graphics g, int range) {
        Graphics2D g2d = (Graphics2D)g;
        double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
        Point mapArrow = this.map.mapToDrawing(this.arrow, os_scale);
        Point mapAnchor = this.map.mapToDrawing(this.anchor, os_scale);
        g.setColor(Color.black);
        g.setFont(RANGE_FONT.deriveFont((float)((double)RANGE_FONT.getSize() * os_scale)));
        FontMetrics fm = g.getFontMetrics();
        StringBuilder buffer = new StringBuilder();
        for (int dummy = range; dummy >= 1; dummy /= 10) {
            buffer.append('8');
        }
        if (buffer.length() == 0) {
            buffer.append('8');
        }
        String rangeMsg = Resources.getString("LOS_Thread.range");
        int wid = fm.stringWidth(" " + rangeMsg + "  " + buffer);
        int hgt = fm.getAscent() + 2;
        int w = mapArrow.x - mapAnchor.x;
        int h = mapArrow.y - mapAnchor.y;
        double hypot = Math.sqrt(w * w + h * h);
        int x0 = mapArrow.x + (int)((double)((wid / 2 + 20) * w) / hypot);
        int y0 = mapArrow.y + (int)((double)((hgt / 2 + 20) * h) / hypot);
        g.fillRect(x0 - wid / 2, y0 + hgt / 2 - fm.getAscent(), wid, hgt);
        g.setColor(Color.white);
        g.drawString(rangeMsg + " " + range, x0 - wid / 2 + fm.stringWidth(" "), y0 + hgt / 2);
        this.lastRangeRect.x = x0 - wid / 2 - (int)((double)wid * 0.5);
        this.lastRangeRect.y = y0 + hgt / 2 - fm.getAscent() - (int)((double)hgt * 0.5);
        this.lastRangeRect.width = wid * 2;
        this.lastRangeRect.height = hgt * 2;
        this.lastRangeRect = this.map.drawingToMap(this.lastRangeRect, os_scale);
        this.lastRange = String.valueOf(range);
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.LosThread.component_type");
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "LOS");
    }

    @Override
    public String[] getAttributeNames() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeNames(), (Object[])new String[]{REPORT, PERSISTENCE, PERSISTENT_ICON_NAME, GLOBAL, SNAP_START, SNAP_END, DRAW_RANGE, RANGE_SCALE, RANGE_ROUNDING, HIDE_COUNTERS, HIDE_OPACITY, LOS_COLOR, RANGE_FOREGROUND, RANGE_BACKGROUND});
    }

    @Override
    public String[] getAttributeDescriptions() {
        return (String[])ArrayUtils.addAll((Object[])super.getAttributeDescriptions(), (Object[])new String[]{Resources.getString("Editor.report_format"), Resources.getString("Editor.LosThread.persistence"), Resources.getString("Editor.LosThread.icon_persist"), Resources.getString("Editor.LosThread.visible"), Resources.getString("Editor.LosThread.start_grid"), Resources.getString("Editor.LosThread.end_grid"), Resources.getString("Editor.LosThread.draw_range"), Resources.getString("Editor.LosThread.pixel_range"), Resources.getString("Editor.LosThread.round_fractions"), Resources.getString("Editor.LosThread.hidden"), Resources.getString("Editor.LosThread.opacity"), Resources.getString("Editor.color_label")});
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return (Class[])ArrayUtils.addAll((Object[])super.getAttributeTypes(), (Object[])new Class[]{ReportFormatConfig.class, PersistenceOptions.class, IconConfig.class, GlobalOptions.class, Boolean.class, Boolean.class, Boolean.class, Integer.class, RoundingOptions.class, Boolean.class, Integer.class, Color.class});
    }

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        VisibilityCondition cond = null;
        if (RANGE_SCALE.equals(name) || RANGE_ROUNDING.equals(name)) {
            cond = () -> this.drawRange;
        } else if (HIDE_OPACITY.equals(name)) {
            cond = () -> this.hideCounters;
        } else if (PERSISTENT_ICON_NAME.equals(name)) {
            cond = () -> this.persistence.equals(CTRL_CLICK) || this.persistence.equals(ALWAYS);
        }
        return cond;
    }

    @Override
    public Configurable[] getConfigureComponents() {
        return new Configurable[0];
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(LOS_THREAD_COMMAND + this.getId() + "\t")) {
            return null;
        }
        SequenceEncoder.Decoder sd = new SequenceEncoder.Decoder(command, '\t');
        sd.nextToken();
        sd.nextToken();
        Point anchor = new Point(sd.nextInt(0), sd.nextInt(0));
        Point arrow = new Point(sd.nextInt(0), sd.nextInt(0));
        boolean persisting = sd.nextBoolean(false);
        boolean mirroring = sd.nextBoolean(false);
        return new LOSCommand(this, anchor, arrow, persisting, mirroring);
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof LOSCommand)) {
            return null;
        }
        LOSCommand com = (LOSCommand)c;
        SequenceEncoder se = new SequenceEncoder(com.target.getId(), '\t');
        se.append(com.newAnchor.x).append(com.newAnchor.y).append(com.newArrow.x).append(com.newArrow.y).append(com.newPersisting).append(com.newMirroring);
        return LOS_THREAD_COMMAND + se.getValue();
    }

    @Override
    public List<String> getFormattedStringList() {
        return List.of(this.reportFormat.getFormat());
    }

    @Override
    public void addLocalImageNames(Collection<String> s) {
        super.addLocalImageNames(s);
        HTMLImageFinder h = new HTMLImageFinder(this.reportFormat.getFormat());
        h.addImageNames(s);
    }

    public static class LOSCommand
    extends Command {
        protected LOS_Thread target;
        protected String oldState;
        protected Point newAnchor;
        protected Point oldAnchor;
        protected Point newArrow;
        protected Point oldArrow;
        protected boolean newPersisting;
        protected boolean oldPersisting;
        protected boolean newMirroring;
        protected boolean oldMirroring;

        public LOSCommand(LOS_Thread oTarget, Point anchor, Point arrow, boolean persisting, boolean mirroring) {
            this.target = oTarget;
            this.oldAnchor = this.target.getAnchor();
            this.oldArrow = this.target.getArrow();
            this.oldPersisting = this.target.isPersisting();
            this.oldMirroring = this.target.isMirroring();
            this.newAnchor = anchor;
            this.newArrow = arrow;
            this.newPersisting = persisting;
            this.newMirroring = mirroring;
        }

        @Override
        protected void executeCommand() {
            this.target.setEndPoints(this.newAnchor, this.newArrow);
            this.target.setPersisting(this.newPersisting);
            this.target.setMirroring(this.newMirroring);
        }

        @Override
        protected Command myUndoCommand() {
            return new LOSCommand(this.target, this.oldAnchor, this.oldArrow, this.oldPersisting, this.oldMirroring);
        }
    }

    public static class ReportFormatConfig
    implements TranslatableConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new PlayerIdFormattedStringConfigurer(key, name, new String[]{LOS_Thread.FROM_LOCATION, LOS_Thread.TO_LOCATION, LOS_Thread.RANGE, LOS_Thread.CHECK_COUNT, LOS_Thread.CHECK_LIST});
        }
    }

    public static class PersistenceOptions
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{LOS_Thread.CTRL_CLICK, LOS_Thread.NEVER, LOS_Thread.ALWAYS};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.LosThread.ctrl_click", "Editor.never", "Editor.always"};
        }
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, LOS_Thread.DEFAULT_ICON);
        }
    }

    public static class GlobalOptions
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{LOS_Thread.WHEN_PERSISTENT, LOS_Thread.NEVER, LOS_Thread.ALWAYS};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.LosThread.when_persistent", "Editor.never", "Editor.always"};
        }
    }

    public static class RoundingOptions
    extends TranslatableStringEnum {
        @Override
        public String[] getValidValues(AutoConfigurable target) {
            return new String[]{LOS_Thread.ROUND_UP, LOS_Thread.ROUND_DOWN, LOS_Thread.ROUND_OFF};
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            return new String[]{"Editor.up", "Editor.down", "Editor.LosThread.round_off"};
        }
    }
}

