/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractConfigurable;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.BadDataReport;
import VASSAL.build.Buildable;
import VASSAL.build.Configurable;
import VASSAL.build.GameModule;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.Map;
import VASSAL.build.module.NewGameIndicator;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.DrawPile;
import VASSAL.build.module.map.MenuDisplayer;
import VASSAL.build.module.map.boardPicker.Board;
import VASSAL.build.module.map.boardPicker.board.MapGrid;
import VASSAL.build.widget.PieceSlot;
import VASSAL.command.Command;
import VASSAL.configure.AutoConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.TranslatableStringEnum;
import VASSAL.configure.ValidationReport;
import VASSAL.configure.VisibilityCondition;
import VASSAL.counters.GamePiece;
import VASSAL.counters.PieceCloner;
import VASSAL.counters.Stack;
import VASSAL.i18n.ComponentI18nData;
import VASSAL.i18n.Resources;
import VASSAL.tools.AdjustableSpeedScrollPane;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.UniqueIdManager;
import VASSAL.tools.image.ImageUtils;
import VASSAL.tools.menu.MenuManager;
import VASSAL.tools.swing.SwingUtils;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DragSourceMotionListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.SystemUtils;

public class SetupStack
extends AbstractConfigurable
implements GameComponent,
UniqueIdManager.Identifyable {
    private static UniqueIdManager idMgr = new UniqueIdManager("SetupStack");
    public static final String COMMAND_PREFIX = "SETUP_STACK\t";
    protected Point pos = new Point();
    public static final String OWNING_BOARD = "owningBoard";
    public static final String X_POSITION = "x";
    public static final String Y_POSITION = "y";
    protected Map map;
    protected String owningBoardName;
    protected String id;
    public static final String NAME = "name";
    protected static NewGameIndicator indicator;
    protected StackConfigurer stackConfigurer;
    protected JButton configureButton;
    protected String location;
    protected boolean useGridLocation;
    public static final String LOCATION = "location";
    public static final String USE_GRID_LOCATION = "useGridLocation";
    protected Configurer xConfig;
    protected Configurer yConfig;
    protected Configurer locationConfig;
    protected static final Dimension DEFAULT_SIZE;
    protected static final int DELTA = 1;
    protected static final int FAST = 10;
    protected static final int FASTER = 5;
    protected static final int DEFAULT_DUMMY_SIZE = 50;

    @Override
    public VisibilityCondition getAttributeVisibility(String name) {
        if (USE_GRID_LOCATION.equals(name)) {
            return () -> {
                Board b = this.getConfigureBoard();
                return b != null && b.getGrid() != null;
            };
        }
        if (LOCATION.equals(name)) {
            return this::isUseGridLocation;
        }
        if (X_POSITION.equals(name) || Y_POSITION.equals(name)) {
            return () -> !this.isUseGridLocation();
        }
        return super.getAttributeVisibility(name);
    }

    protected boolean isUseGridLocation() {
        if (!this.useGridLocation) {
            return false;
        }
        Board b = this.getConfigureBoard();
        return b != null && b.getGrid() != null;
    }

    protected void updatePosition() {
        if (this.isUseGridLocation() && this.location != null && !this.location.equals("")) {
            try {
                this.pos = this.getConfigureBoard(true).getGrid().getLocation(this.location);
            }
            catch (MapGrid.BadCoords e) {
                ErrorDialog.dataWarning(new BadDataReport(this, "Error.setup_stack_position_error", this.location, (Throwable)e));
            }
        }
    }

    @Override
    public void validate(Buildable target, ValidationReport report) {
        if (this.isUseGridLocation()) {
            if (this.location == null) {
                report.addWarning(this.getConfigureName() + Resources.getString("SetupStack.null_location"));
            } else {
                try {
                    this.getConfigureBoard().getGrid().getLocation(this.location);
                }
                catch (MapGrid.BadCoords e) {
                    String msg = "Bad location name " + this.location + " in " + this.getConfigureName();
                    if (e.getMessage() != null) {
                        msg = msg + ":  " + e.getMessage();
                    }
                    report.addWarning(msg);
                }
            }
        }
        super.validate(target, report);
    }

    protected void updateLocation() {
        MapGrid g;
        Board b = this.getConfigureBoard();
        if (b != null && (g = b.getGrid()) != null) {
            this.location = g.locationName(this.pos);
        }
    }

    @Override
    public void setup(boolean gameStarting) {
        if (gameStarting && indicator.isNewGame() && this.isOwningBoardActive()) {
            Stack s = this.initializeContents();
            this.updatePosition();
            Point p = new Point(this.pos);
            if (this.owningBoardName == null) {
                p.translate(this.map.getEdgeBuffer().width, this.map.getEdgeBuffer().height);
            } else {
                Rectangle r = this.map.getBoardByName(this.owningBoardName).bounds();
                p.translate(r.x, r.y);
            }
            if (this.placeNonStackingSeparately()) {
                for (int i = 0; i < s.getPieceCount(); ++i) {
                    GamePiece piece = s.getPieceAt(i);
                    if (!Boolean.TRUE.equals(piece.getProperty("NoStack"))) continue;
                    s.remove(piece);
                    piece.setParent(null);
                    this.map.placeAt(piece, p);
                    --i;
                }
            }
            this.map.placeAt(s, p);
        }
    }

    protected boolean placeNonStackingSeparately() {
        return true;
    }

    @Override
    public Command getRestoreCommand() {
        return null;
    }

    @Override
    public String[] getAttributeDescriptions() {
        return new String[]{Resources.getString("Editor.name_label"), Resources.getString("Editor.StartStack.board"), Resources.getString("Editor.StartStack.grid"), Resources.getString("Editor.StartStack.location"), Resources.getString("Editor.x_position"), Resources.getString("Editor.y_position")};
    }

    @Override
    public Class<?>[] getAttributeTypes() {
        return new Class[]{String.class, OwningBoardPrompt.class, Boolean.class, String.class, Integer.class, Integer.class};
    }

    @Override
    public String[] getAttributeNames() {
        return new String[]{NAME, OWNING_BOARD, USE_GRID_LOCATION, LOCATION, X_POSITION, Y_POSITION};
    }

    @Override
    public String getAttributeValueString(String key) {
        if (NAME.equals(key)) {
            return this.getConfigureName();
        }
        if (OWNING_BOARD.equals(key)) {
            return this.owningBoardName;
        }
        if (USE_GRID_LOCATION.equals(key)) {
            return Boolean.toString(this.useGridLocation);
        }
        if (LOCATION.equals(key)) {
            return this.location;
        }
        if (X_POSITION.equals(key)) {
            return String.valueOf(this.pos.x);
        }
        if (Y_POSITION.equals(key)) {
            return String.valueOf(this.pos.y);
        }
        return null;
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (NAME.equals(key)) {
            this.setConfigureName((String)value);
        } else if (OWNING_BOARD.equals(key)) {
            List<String> selectedBoardNames;
            this.owningBoardName = "<any>".equals(value) ? (this.map != null ? ((selectedBoardNames = this.map.getBoardPicker().getSelectedBoardNames()).isEmpty() ? null : selectedBoardNames.get(0)) : null) : (String)value;
            this.updateConfigureButton();
        } else if (USE_GRID_LOCATION.equals(key)) {
            if (value instanceof String) {
                value = Boolean.valueOf((String)value);
            }
            this.useGridLocation = (Boolean)value;
        } else if (LOCATION.equals(key)) {
            this.location = (String)value;
        } else if (X_POSITION.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.pos.x = (Integer)value;
        } else if (Y_POSITION.equals(key)) {
            if (value instanceof String) {
                value = Integer.valueOf((String)value);
            }
            this.pos.y = (Integer)value;
        }
    }

    @Override
    public void add(Buildable child) {
        super.add(child);
        this.updateConfigureButton();
    }

    @Override
    public void addTo(Buildable parent) {
        if (indicator == null) {
            indicator = new NewGameIndicator(COMMAND_PREFIX);
        }
        this.map = (Map)parent;
        idMgr.add(this);
        GameModule.getGameModule().getGameState().addGameComponent(this);
        this.setAttributeTranslatable(NAME, false);
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[]{PieceSlot.class};
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("SetupStack.html");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.StartStack.component_type");
    }

    @Override
    public void removeFrom(Buildable parent) {
        idMgr.remove(this);
        GameModule.getGameModule().getGameState().removeGameComponent(this);
    }

    protected boolean isOwningBoardActive() {
        boolean active = false;
        if (this.owningBoardName == null) {
            active = true;
        } else if (this.map.getBoardByName(this.owningBoardName) != null) {
            active = true;
        }
        return active;
    }

    protected Stack initializeContents() {
        Stack s = this.createStack();
        Configurable[] c = this.getConfigureComponents();
        int num = 0;
        for (Configurable configurable : c) {
            ++num;
            if (!(configurable instanceof PieceSlot)) continue;
            PieceSlot slot = (PieceSlot)configurable;
            GamePiece p = slot.getPiece();
            if (p != null) {
                p = PieceCloner.getInstance().clonePiece(p);
                GameModule.getGameModule().getGameState().addPiece(p);
                s.add(p);
                continue;
            }
            ErrorDialog.dataWarning(new BadDataReport(slot, Resources.getString("Error.build_piece_at_start_stack", num, this.getConfigureName()), slot.getPieceDefinition()));
        }
        GameModule.getGameModule().getGameState().addPiece(s);
        return s;
    }

    protected Stack createStack() {
        return new Stack();
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Configurer getConfigurer() {
        this.config = null;
        Configurer c = super.getConfigurer();
        this.xConfig = ((AutoConfigurer)c).getConfigurer(X_POSITION);
        this.yConfig = ((AutoConfigurer)c).getConfigurer(Y_POSITION);
        this.locationConfig = ((AutoConfigurer)c).getConfigurer(LOCATION);
        this.updateConfigureButton();
        ((Container)c.getControls()).add(this.configureButton);
        return c;
    }

    protected void updateConfigureButton() {
        if (this.configureButton == null) {
            this.configureButton = new JButton(Resources.getString("Editor.SetupStack.reposition_stack"));
            this.configureButton.addActionListener(e -> this.configureStack());
        }
        this.configureButton.setEnabled(this.getConfigureBoard() != null && this.buildComponents.size() > 0);
    }

    protected void configureStack() {
        this.stackConfigurer = new StackConfigurer(this);
        this.stackConfigurer.init();
        this.stackConfigurer.setVisible(true);
    }

    protected PieceSlot getTopPiece() {
        Iterator<PieceSlot> i = this.getAllDescendantComponentsOf(PieceSlot.class).iterator();
        return i.hasNext() ? i.next() : null;
    }

    protected Board getConfigureBoard(boolean checkSelectedBoards) {
        Board board = null;
        if (this.map != null && !"<any>".equals(this.owningBoardName)) {
            board = this.map.getBoardPicker().getBoard(this.owningBoardName);
        }
        if (board == null && this.map != null) {
            String[] allBoards;
            if (checkSelectedBoards) {
                String s;
                List<String> selectedBoards = this.map.getBoardPicker().getSelectedBoardNames();
                Iterator<String> iterator = selectedBoards.iterator();
                while (iterator.hasNext() && (board = this.map.getBoardByName(s = iterator.next())) == null) {
                }
            }
            if (board == null && (allBoards = this.map.getBoardPicker().getAllowableBoardNames()).length > 0) {
                board = this.map.getBoardPicker().getBoard(allBoards[0]);
            }
        }
        return board;
    }

    protected Board getConfigureBoard() {
        return this.getConfigureBoard(false);
    }

    @Override
    public ComponentI18nData getI18nData() {
        ComponentI18nData myI18nData = super.getI18nData();
        myI18nData.setAttributeTranslatable(LOCATION, false);
        return myI18nData;
    }

    @Override
    public List<String> getExpressionList() {
        if (this.owningBoardName != null) {
            return List.of(this.owningBoardName);
        }
        return Collections.emptyList();
    }

    static {
        DEFAULT_SIZE = new Dimension(800, 600);
    }

    public static class OwningBoardPrompt
    extends TranslatableStringEnum {
        public static final String ANY = "<any>";
        public static final String ANY_NAME = Resources.getString("Editor.SetupStack.any_name");

        @Override
        public boolean isDisplayNames() {
            return true;
        }

        @Override
        public String[] getValidValues(AutoConfigurable target) {
            String[] values;
            if (target instanceof SetupStack) {
                ArrayList<String> l = new ArrayList<String>();
                l.add(ANY);
                Map m = ((SetupStack)target).map;
                if (m != null) {
                    l.addAll(Arrays.asList(m.getBoardPicker().getAllowableBoardNames()));
                } else {
                    for (Map m2 : Map.getMapList()) {
                        l.addAll(Arrays.asList(m2.getBoardPicker().getAllowableBoardNames()));
                    }
                }
                values = l.toArray(new String[0]);
            } else {
                values = new String[]{ANY};
            }
            return values;
        }

        @Override
        public String[] getI18nKeys(AutoConfigurable target) {
            String[] values;
            if (target instanceof SetupStack) {
                ArrayList<String> l = new ArrayList<String>();
                l.add(ANY_NAME);
                Map m = ((SetupStack)target).map;
                if (m != null) {
                    l.addAll(Arrays.asList(m.getBoardPicker().getAllowableLocalizedBoardNames()));
                } else {
                    for (Map m2 : Map.getMapList()) {
                        l.addAll(Arrays.asList(m2.getBoardPicker().getAllowableLocalizedBoardNames()));
                    }
                }
                values = l.toArray(new String[0]);
            } else {
                values = new String[]{ANY_NAME};
            }
            return values;
        }
    }

    public class StackConfigurer
    extends JFrame
    implements ActionListener,
    KeyListener,
    MouseListener {
        private static final long serialVersionUID = 1L;
        protected Board board;
        protected View view;
        protected JScrollPane scroll;
        protected SetupStack myStack;
        protected PieceSlot mySlot;
        protected GamePiece myPiece;
        protected Point savePosition;
        protected Dimension dummySize;
        protected BufferedImage dummyImage;

        public StackConfigurer(SetupStack stack) {
            super(Resources.getString("Editor.SetupStack.adjust_at_start_stack"));
            this.setJMenuBar(MenuManager.getInstance().getMenuBarFor(this));
            this.myStack = stack;
            this.mySlot = stack.getTopPiece();
            if (this.mySlot != null) {
                this.myPiece = this.mySlot.getPiece();
            }
            this.myStack.updatePosition();
            this.savePosition = new Point(this.myStack.pos);
            this.dummySize = stack instanceof DrawPile ? new Dimension(((DrawPile)stack).getSize()) : new Dimension(50, 50);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent e) {
                    StackConfigurer.this.cancel();
                }
            });
        }

        protected void init() {
            this.board = SetupStack.this.getConfigureBoard();
            this.view = new View(this.board, this.myStack);
            this.view.addKeyListener(this);
            this.view.addMouseListener(this);
            this.view.setFocusable(true);
            this.scroll = new AdjustableSpeedScrollPane(this.view, 22, 32);
            this.scroll.setPreferredSize(DEFAULT_SIZE);
            this.add((Component)this.scroll, "Center");
            Box textPanel = Box.createVerticalBox();
            textPanel.add(new JLabel(Resources.getString("Editor.SetupStack.arrow_keys_move_stack")));
            textPanel.add(new JLabel(Resources.getString(SystemUtils.IS_OS_MAC ? "Editor.SetupStack.shift_command_keys_move_stack_faster_mac" : "Editor.SetupStack.ctrl_shift_keys_move_stack_faster")));
            Box displayPanel = Box.createHorizontalBox();
            Box buttonPanel = Box.createHorizontalBox();
            JButton snapButton = new JButton(Resources.getString("Editor.SetupStack.snap_to_grid"));
            snapButton.addActionListener(e -> {
                this.snap();
                this.view.grabFocus();
            });
            buttonPanel.add(snapButton);
            JButton okButton = new JButton(Resources.getString("General.ok"));
            okButton.addActionListener(e -> {
                this.setVisible(false);
                SetupStack.this.xConfig.setValue(String.valueOf(this.myStack.pos.x));
                SetupStack.this.yConfig.setValue(String.valueOf(this.myStack.pos.y));
                if (SetupStack.this.locationConfig != null) {
                    SetupStack.this.updateLocation();
                    SetupStack.this.locationConfig.setValue(SetupStack.this.location);
                }
            });
            JPanel okPanel = new JPanel();
            okPanel.add(okButton);
            JButton canButton = new JButton(Resources.getString("General.cancel"));
            canButton.addActionListener(e -> {
                this.cancel();
                this.setVisible(false);
            });
            okPanel.add(canButton);
            Box controlPanel = Box.createHorizontalBox();
            controlPanel.add(textPanel);
            controlPanel.add(displayPanel);
            controlPanel.add(buttonPanel);
            Box mainPanel = Box.createVerticalBox();
            mainPanel.add(controlPanel);
            mainPanel.add(okPanel);
            this.add((Component)mainPanel, "South");
            this.scroll.revalidate();
            this.updateDisplay();
            this.pack();
            this.repaint();
        }

        protected void cancel() {
            this.myStack.pos.x = this.savePosition.x;
            this.myStack.pos.y = this.savePosition.y;
        }

        public void updateDisplay() {
            if (!this.view.getVisibleRect().contains(this.myStack.pos)) {
                this.view.center(new Point(this.myStack.pos.x, this.myStack.pos.y));
            }
        }

        protected void snap() {
            MapGrid grid = this.board.getGrid();
            if (grid != null) {
                Point snapTo = grid.snapTo(SetupStack.this.pos);
                SetupStack.this.pos.x = snapTo.x;
                SetupStack.this.pos.y = snapTo.y;
                this.updateDisplay();
                this.repaint();
            }
        }

        public JScrollPane getScroll() {
            return this.scroll;
        }

        public BufferedImage getDummyImage() {
            if (this.dummyImage == null) {
                this.dummyImage = ImageUtils.createCompatibleTranslucentImage(this.dummySize.width * 2, this.dummySize.height * 2);
                Graphics2D g = this.dummyImage.createGraphics();
                g.setColor(Color.white);
                g.fillRect(0, 0, this.dummySize.width, this.dummySize.height);
                g.setColor(Color.black);
                g.drawRect(0, 0, this.dummySize.width, this.dummySize.height);
                g.dispose();
            }
            return this.dummyImage;
        }

        public void drawDummyImage(Graphics g, int x, int y) {
            this.drawDummyImage(g, x - this.dummySize.width / 2, y - this.dummySize.height / 2, null, 1.0);
        }

        public void drawDummyImage(Graphics g, int x, int y, Component obs, double zoom) {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform orig_t = g2d.getTransform();
            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
            AffineTransform scaled_t = new AffineTransform(orig_t);
            scaled_t.scale(os_scale, os_scale);
            g2d.setTransform(scaled_t);
            x = (int)((double)x / os_scale);
            y = (int)((double)y / os_scale);
            g.drawImage(this.getDummyImage(), x, y, obs);
            g2d.setTransform(orig_t);
        }

        public void drawImage(Graphics g, int x, int y, Component obs, double zoom) {
            Rectangle r;
            Rectangle rectangle = r = this.myPiece == null ? null : this.myPiece.boundingBox();
            if (r == null || r.width == 0 || r.height == 0) {
                this.drawDummyImage(g, x, y);
            } else {
                this.myPiece.draw(g, x, y, obs, zoom);
            }
        }

        public Rectangle getPieceBoundingBox() {
            Rectangle r;
            Rectangle rectangle = r = this.myPiece == null ? new Rectangle() : this.myPiece.getShape().getBounds();
            if (r.width == 0 || r.height == 0) {
                r.x = 0 - this.dummySize.width / 2;
                r.y = 0 - this.dummySize.height / 2;
                r.width = this.dummySize.width;
                r.height = this.dummySize.height;
            }
            return r;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            switch (e.getKeyCode()) {
                case 38: {
                    this.adjustY(-1, e);
                    break;
                }
                case 40: {
                    this.adjustY(1, e);
                    break;
                }
                case 37: {
                    this.adjustX(-1, e);
                    break;
                }
                case 39: {
                    this.adjustX(1, e);
                    break;
                }
                default: {
                    if (this.myPiece == null) break;
                    this.myPiece.keyEvent(SwingUtils.getKeyStrokeForEvent(e));
                }
            }
            this.updateDisplay();
            this.repaint();
            e.consume();
        }

        protected void adjustX(int direction, KeyEvent e) {
            int newX;
            int delta = direction * 1;
            if (e.isShiftDown()) {
                delta *= 10;
            }
            if (SwingUtils.isModifierKeyDown(e)) {
                delta *= 5;
            }
            if ((newX = this.myStack.pos.x + delta) < 0) {
                newX = 0;
            }
            if ((double)newX >= this.board.getSize().getWidth()) {
                newX = (int)this.board.getSize().getWidth() - 1;
            }
            this.myStack.pos.x = newX;
        }

        protected void adjustY(int direction, KeyEvent e) {
            int newY;
            int delta = direction * 1;
            if (e.isShiftDown()) {
                delta *= 10;
            }
            if (SwingUtils.isModifierKeyDown(e)) {
                delta *= 5;
            }
            if ((newY = this.myStack.pos.y + delta) < 0) {
                newY = 0;
            }
            if ((double)newY >= this.board.getSize().getHeight()) {
                newY = (int)this.board.getSize().getHeight() - 1;
            }
            this.myStack.pos.y = newY;
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        protected void maybePopup(MouseEvent e) {
            if (!e.isPopupTrigger() || this.myPiece == null) {
                return;
            }
            Rectangle r = this.getPieceBoundingBox();
            r.translate(SetupStack.this.pos.x, SetupStack.this.pos.y);
            if (r.contains(e.getPoint())) {
                JPopupMenu popup = MenuDisplayer.createPopup(this.myPiece);
                popup.addPopupMenuListener(new PopupMenuListener(){

                    @Override
                    public void popupMenuCanceled(PopupMenuEvent evt) {
                        StackConfigurer.this.view.repaint();
                    }

                    @Override
                    public void popupMenuWillBecomeInvisible(PopupMenuEvent evt) {
                        StackConfigurer.this.view.repaint();
                    }

                    @Override
                    public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
                    }
                });
                if (this.view.isShowing()) {
                    popup.show(this.view, e.getX(), e.getY());
                }
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybePopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybePopup(e);
        }
    }

    public static class View
    extends JPanel
    implements DropTargetListener,
    DragGestureListener,
    DragSourceListener,
    DragSourceMotionListener {
        private static final long serialVersionUID = 1L;
        protected static final int CURSOR_ALPHA = 127;
        protected static final int EXTRA_BORDER = 4;
        protected Board myBoard;
        protected MapGrid myGrid;
        protected SetupStack myStack;
        protected GamePiece myPiece;
        protected PieceSlot slot;
        protected DragSource ds = DragSource.getDefaultDragSource();
        protected boolean isDragging = false;
        protected JLabel dragCursor;
        protected JLayeredPane drawWin;
        protected Point drawOffset = new Point();
        protected Rectangle boundingBox;
        protected int currentPieceOffsetX;
        protected int currentPieceOffsetY;
        protected int originalPieceOffsetX;
        protected int originalPieceOffsetY;
        protected Point lastDragLocation = new Point();

        public View(Board b, SetupStack s) {
            this.myBoard = b;
            this.myGrid = b.getGrid();
            this.myStack = s;
            this.slot = this.myStack.getTopPiece();
            if (this.slot != null) {
                this.myPiece = this.slot.getPiece();
            }
            new DropTarget(this, 2, this);
            this.ds.createDefaultDragGestureRecognizer(this, 2, this);
            this.setFocusTraversalKeysEnabled(false);
        }

        @Override
        public void paint(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            double os_scale = g2d.getDeviceConfiguration().getDefaultTransform().getScaleX();
            AffineTransform orig_t = g2d.getTransform();
            g2d.setTransform(SwingUtils.descaleTransform(orig_t));
            this.myBoard.draw(g, 0, 0, os_scale, this);
            if (this.myGrid != null) {
                Rectangle bounds = new Rectangle(new Point(), this.myBoard.bounds().getSize());
                bounds.width = (int)((double)bounds.width * os_scale);
                bounds.height = (int)((double)bounds.height * os_scale);
                this.myGrid.draw(g, bounds, bounds, os_scale, false);
            }
            int x = (int)((double)this.myStack.pos.x * os_scale);
            int y = (int)((double)this.myStack.pos.y * os_scale);
            this.myStack.stackConfigurer.drawImage(g, x, y, this, os_scale);
            g2d.setTransform(orig_t);
        }

        @Override
        public void update(Graphics g) {
            this.paint(g);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.myBoard.bounds().width, this.myBoard.bounds().height);
        }

        public void center(Point p) {
            Rectangle r = this.getVisibleRect();
            if (r.width == 0) {
                r.width = SetupStack.DEFAULT_SIZE.width;
                r.height = SetupStack.DEFAULT_SIZE.height;
            }
            int x = p.x - r.width / 2;
            int y = p.y - r.height / 2;
            if (x < 0) {
                x = 0;
            }
            if (y < 0) {
                y = 0;
            }
            this.scrollRectToVisible(new Rectangle(x, y, r.width, r.height));
        }

        @Override
        public void dragEnter(DropTargetDragEvent arg0) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            this.scrollAtEdge(e.getLocation(), 15);
        }

        public void scrollAtEdge(Point evtPt, int dist) {
            JScrollPane scroll = this.myStack.stackConfigurer.getScroll();
            Point p = new Point(evtPt.x - scroll.getViewport().getViewPosition().x, evtPt.y - scroll.getViewport().getViewPosition().y);
            int dx = 0;
            int dy = 0;
            if (p.x < dist && p.x >= 0) {
                dx = -1;
            }
            if (p.x >= scroll.getViewport().getSize().width - dist && p.x < scroll.getViewport().getSize().width) {
                dx = 1;
            }
            if (p.y < dist && p.y >= 0) {
                dy = -1;
            }
            if (p.y >= scroll.getViewport().getSize().height - dist && p.y < scroll.getViewport().getSize().height) {
                dy = 1;
            }
            if (dx != 0 || dy != 0) {
                Rectangle r = new Rectangle(scroll.getViewport().getViewRect());
                r.translate(2 * dist * dx, 2 * dist * dy);
                r = r.intersection(new Rectangle(new Point(0, 0), this.getPreferredSize()));
                this.scrollRectToVisible(r);
            }
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent arg0) {
        }

        @Override
        public void drop(DropTargetDropEvent event) {
            this.removeDragCursor();
            Point pos = event.getLocation();
            pos.translate(this.currentPieceOffsetX, this.currentPieceOffsetY);
            this.myStack.pos.x = pos.x;
            this.myStack.pos.y = pos.y;
            this.myStack.stackConfigurer.updateDisplay();
            this.repaint();
        }

        @Override
        public void dragExit(DropTargetEvent arg0) {
        }

        @Override
        public void dragEnter(DragSourceDragEvent arg0) {
        }

        @Override
        public void dragOver(DragSourceDragEvent arg0) {
        }

        @Override
        public void dropActionChanged(DragSourceDragEvent arg0) {
        }

        @Override
        public void dragDropEnd(DragSourceDropEvent arg0) {
            this.removeDragCursor();
        }

        @Override
        public void dragExit(DragSourceEvent arg0) {
        }

        @Override
        public void dragGestureRecognized(DragGestureEvent dge) {
            if (!SwingUtils.isDragTrigger(dge)) {
                return;
            }
            Point mousePosition = dge.getDragOrigin();
            Point piecePosition = new Point(this.myStack.pos);
            Rectangle r = this.myStack.stackConfigurer.getPieceBoundingBox();
            r.translate(piecePosition.x, piecePosition.y);
            if (!r.contains(mousePosition)) {
                return;
            }
            this.originalPieceOffsetX = piecePosition.x - mousePosition.x;
            this.originalPieceOffsetY = piecePosition.y - mousePosition.y;
            this.drawWin = null;
            this.makeDragCursor();
            this.setDragCursor();
            SwingUtilities.convertPointToScreen(mousePosition, this.drawWin);
            this.moveDragCursor(mousePosition.x, mousePosition.y);
            try {
                dge.startDrag(Cursor.getPredefinedCursor(12), new StringSelection(""), this);
                dge.getDragSource().addDragSourceMotionListener(this);
            }
            catch (InvalidDnDOperationException e) {
                ErrorDialog.bug(e);
            }
        }

        protected void setDragCursor() {
            JRootPane rootWin = SwingUtilities.getRootPane(this);
            if (rootWin != null) {
                if (this.dragCursor.getParent() != null) {
                    this.dragCursor.getParent().remove(this.dragCursor);
                }
                this.drawWin = rootWin.getLayeredPane();
                this.calcDrawOffset();
                this.dragCursor.setVisible(true);
                this.drawWin.add((Component)this.dragCursor, JLayeredPane.DRAG_LAYER);
            }
        }

        protected void moveDragCursor(int dragX, int dragY) {
            if (this.drawWin != null) {
                this.dragCursor.setLocation(dragX - this.drawOffset.x, dragY - this.drawOffset.y);
            }
        }

        private void removeDragCursor() {
            if (this.drawWin != null) {
                if (this.dragCursor != null) {
                    this.dragCursor.setVisible(false);
                    this.drawWin.remove(this.dragCursor);
                }
                this.drawWin = null;
            }
        }

        private void calcDrawOffset() {
            if (this.drawWin != null) {
                this.drawOffset.x = -this.boundingBox.x - this.currentPieceOffsetX + 4;
                this.drawOffset.y = -this.boundingBox.y - this.currentPieceOffsetY + 4;
                SwingUtilities.convertPointToScreen(this.drawOffset, this.drawWin);
            }
        }

        private BufferedImage featherDragImage(BufferedImage src, int w, int h, int b) {
            BufferedImage dst = ImageUtils.createCompatibleTranslucentImage(w, h);
            Graphics2D g = dst.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g.setColor(new Color(255, 255, 255, 127));
            g.fillRect(0, 0, w, h);
            for (int f = 0; f < b; ++f) {
                int alpha = 127 * (f + 1) / b;
                g.setColor(new Color(255, 255, 255, alpha));
                g.drawRect(f, f, w - 2 * f, h - 2 * f);
            }
            g.setComposite(AlphaComposite.getInstance(5));
            g.drawImage((Image)src, 0, 0, null);
            g.dispose();
            return dst;
        }

        private void makeDragCursor() {
            if (this.dragCursor == null) {
                this.dragCursor = new JLabel();
                this.dragCursor.setVisible(false);
            }
            this.currentPieceOffsetX = this.originalPieceOffsetX;
            this.currentPieceOffsetY = this.originalPieceOffsetY;
            this.boundingBox = this.myStack.stackConfigurer.getPieceBoundingBox();
            this.calcDrawOffset();
            int w = this.boundingBox.width + 8;
            int h = this.boundingBox.height + 8;
            BufferedImage cursorImage = ImageUtils.createCompatibleTranslucentImage(w, h);
            Graphics2D g = cursorImage.createGraphics();
            this.myStack.stackConfigurer.drawImage(g, 4 - this.boundingBox.x, 4 - this.boundingBox.y, this.dragCursor, 1.0);
            g.dispose();
            this.dragCursor.setSize(w, h);
            cursorImage = this.featherDragImage(cursorImage, w, h, 4);
            this.dragCursor.setIcon(new ImageIcon(cursorImage));
        }

        @Override
        public void dragMouseMoved(DragSourceDragEvent event) {
            if (!event.getLocation().equals(this.lastDragLocation)) {
                this.lastDragLocation = event.getLocation();
                this.moveDragCursor(event.getX(), event.getY());
                if (this.dragCursor != null && !this.dragCursor.isVisible()) {
                    this.dragCursor.setVisible(true);
                }
            }
        }
    }
}

