/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.build.GameModule;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerPanel;
import VASSAL.i18n.Resources;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.ImageFileFilter;
import VASSAL.tools.imageop.Op;
import VASSAL.tools.imageop.OwningOpMultiResolutionImage;
import VASSAL.tools.imageop.SourceOp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class IconConfigurer
extends Configurer {
    private JPanel controls;
    private String imageName;
    private final String defaultImage;
    private Icon icon;
    private JPanel holdingPanel;
    private final JLabel iconLabel = new JLabel();
    private static final int MAX_ICON_DISPLAY_SIZE = 128;

    public IconConfigurer(String defaultImage) {
        this(null, "", defaultImage);
    }

    public IconConfigurer(String key, String name, String defaultImage) {
        super(key, name);
        this.defaultImage = defaultImage;
    }

    @Override
    public String getValueString() {
        return this.imageName;
    }

    @Override
    public void setValue(Object o) {
        super.setValue(o);
        this.setSize();
    }

    @Override
    public void setValue(String s) {
        SourceOp sop;
        this.icon = null;
        String string = this.imageName = s == null ? "" : s;
        if (this.imageName.length() > 0 && (sop = Op.load(this.imageName)).getImage() != null) {
            this.icon = new ImageIcon(new OwningOpMultiResolutionImage(sop));
        }
        this.iconLabel.setIcon(this.icon);
        this.setValue((Object)this.imageName);
    }

    public Icon getIconValue() {
        return this.icon;
    }

    @Override
    public Component getControls() {
        if (this.controls == null) {
            this.controls = new ConfigurerPanel(this.getName(), "[]rel[]rel[]", "[]rel[]rel[]rel[]", "[fill,grow]");
            this.iconLabel.setIcon(this.icon);
            this.holdingPanel = new JPanel((LayoutManager)new MigLayout("ins 0", "[grow,fill]", "[grow,fill]"));
            this.holdingPanel.add((Component)this.iconLabel, "grow");
            this.controls.add(this.holdingPanel);
            JButton reset = new JButton(Resources.getString("Editor.select"));
            reset.addActionListener(e -> this.selectImage());
            this.controls.add((Component)reset, "aligny center, growy 0");
            if (this.defaultImage != null) {
                JButton useDefault = new JButton(Resources.getString("Editor.default"));
                useDefault.addActionListener(e -> this.setValue(this.defaultImage));
                this.controls.add((Component)useDefault, "aligny center, growy 0");
            }
        }
        return this.controls;
    }

    private void setSize() {
        if (this.holdingPanel != null) {
            if (this.icon == null) {
                this.holdingPanel.setPreferredSize(new Dimension(32, 32));
                this.holdingPanel.setMinimumSize(new Dimension(32, 32));
            } else {
                this.holdingPanel.setPreferredSize(new Dimension(this.icon.getIconWidth(), this.icon.getIconHeight()));
                this.holdingPanel.setMinimumSize(new Dimension(Math.min(this.icon.getIconWidth(), 128), Math.min(this.icon.getIconHeight(), 128)));
                this.holdingPanel.setMaximumSize(new Dimension(128, 128));
            }
            this.repack();
            this.holdingPanel.repaint();
        }
    }

    private void selectImage() {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        fc.setFileFilter(new ImageFileFilter());
        if (fc.showOpenDialog(this.getControls()) != 0) {
            this.setValue(null);
        } else {
            File f = fc.getSelectedFile();
            if (f != null && f.exists()) {
                GameModule.getGameModule().getArchiveWriter().addImage(f.getPath(), f.getName());
                this.setValue(f.getName());
            }
        }
    }
}

