/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.build.module.map.MassKeyCommand;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.GlobalCommandTargetConfigurer;
import VASSAL.configure.IntConfigurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.configure.PropertyExpression;
import VASSAL.configure.PropertyExpressionConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.BooleanAndPieceFilter;
import VASSAL.counters.Decorator;
import VASSAL.counters.GamePiece;
import VASSAL.counters.GlobalCommand;
import VASSAL.counters.GlobalCommandTarget;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceFilter;
import VASSAL.counters.RangeFilter;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.i18n.PieceI18nData;
import VASSAL.i18n.Resources;
import VASSAL.i18n.TranslatablePiece;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.RecursionLimiter;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class CounterGlobalKeyCommand
extends Decorator
implements TranslatablePiece,
RecursionLimiter.Loopable {
    public static final String ID = "globalkey;";
    protected KeyCommand[] command;
    protected String commandName;
    protected NamedKeyStroke key;
    protected NamedKeyStroke globalKey;
    protected GlobalCommand globalCommand = new GlobalCommand(this);
    protected PropertyExpression propertiesFilter = new PropertyExpression();
    protected boolean restrictRange;
    protected boolean fixedRange = true;
    protected int range;
    protected String rangeProperty = "";
    private KeyCommand myCommand;
    protected String description;
    protected GlobalCommandTarget target = new GlobalCommandTarget(GlobalCommandTarget.GKCtype.COUNTER);

    public CounterGlobalKeyCommand() {
        this(ID, null);
    }

    public CounterGlobalKeyCommand(String type, GamePiece inner) {
        this.mySetType(type);
        this.setInner(inner);
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.commandName = st.nextToken(Resources.getString("Editor.GlobalkeyCommand.command"));
        this.key = st.nextNamedKeyStroke('G');
        this.globalKey = st.nextNamedKeyStroke('K');
        this.propertiesFilter.setExpression(st.nextToken(""));
        this.restrictRange = st.nextBoolean(false);
        this.range = st.nextInt(1);
        this.globalCommand.setReportSingle(st.nextBoolean(true));
        this.globalCommand.setKeyStroke(this.globalKey);
        this.fixedRange = st.nextBoolean(true);
        this.rangeProperty = st.nextToken("");
        this.description = st.nextToken("");
        this.globalCommand.setSelectFromDeck(st.nextInt(-1));
        this.target.decode(st.nextToken(""));
        this.target.setGKCtype(GlobalCommandTarget.GKCtype.COUNTER);
        this.target.setCurPiece(this);
        this.globalCommand.setPropertySource(Decorator.getOutermost(this));
        this.command = null;
    }

    @Override
    public String myGetType() {
        SequenceEncoder se = new SequenceEncoder(';');
        se.append(this.commandName).append(this.key).append(this.globalKey).append(this.propertiesFilter.getExpression()).append(this.restrictRange).append(this.range).append(this.globalCommand.isReportSingle()).append(this.fixedRange).append(this.rangeProperty).append(this.description).append(this.globalCommand.getSelectFromDeck()).append(this.target.encode());
        return ID + se.getValue();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        if (this.command == null) {
            this.myCommand = new KeyCommand(this.commandName, this.key, Decorator.getOutermost(this), (TranslatablePiece)this);
            this.command = this.commandName.length() > 0 && this.key != null && !this.key.isNull() ? new KeyCommand[]{this.myCommand} : new KeyCommand[0];
        }
        if (this.command.length > 0) {
            this.command[0].setEnabled(this.getMap() != null);
        }
        return this.command;
    }

    @Override
    public String myGetState() {
        return "";
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        this.myGetKeyCommands();
        return this.myCommand.matches(stroke) ? this.apply() : null;
    }

    @Override
    public void mySetState(String newState) {
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public List<NamedKeyStroke> getNamedKeyStrokeList() {
        return Arrays.asList(this.key, this.globalKey);
    }

    @Override
    public List<String> getMenuTextList() {
        return List.of(this.commandName);
    }

    @Override
    public List<String> getExpressionList() {
        return List.of(this.propertiesFilter.getExpression());
    }

    @Override
    public List<String> getFormattedStringList() {
        if (this.globalCommand != null) {
            return List.of(this.globalCommand.getReportFormat());
        }
        return Collections.emptyList();
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    @Override
    public String getDescription() {
        Object d = Resources.getString("Editor.GlobalkeyCommand.global_key_command");
        if (this.description.length() > 0) {
            d = (String)d + " - " + this.description;
        }
        return d;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("GlobalKeyCommand.html");
    }

    public Command apply() {
        PieceFilter filter = this.propertiesFilter.getFilter(Decorator.getOutermost(this));
        Command c = new NullCommand();
        if (this.restrictRange) {
            int r = this.range;
            if (!this.fixedRange) {
                String rangeValue = (String)Decorator.getOutermost(this).getProperty(this.rangeProperty);
                try {
                    r = Integer.parseInt(rangeValue);
                }
                catch (NumberFormatException e) {
                    CounterGlobalKeyCommand.reportDataError(this, Resources.getString("Error.non_number_error"), "range[" + this.rangeProperty + "]=" + rangeValue, e);
                }
            }
            filter = new BooleanAndPieceFilter(filter, new RangeFilter(this.getMap(), this.getPosition(), r));
        }
        c = c.append(this.globalCommand.apply(Map.getMapList().toArray(new Map[0]), filter, this.target));
        return c;
    }

    @Override
    public PieceI18nData getI18nData() {
        return this.getI18nData(this.commandName, this.getCommandDescription(this.description, Resources.getString("Editor.menu_command")));
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof CounterGlobalKeyCommand)) {
            return false;
        }
        CounterGlobalKeyCommand trait = (CounterGlobalKeyCommand)o;
        if (!Objects.equals(this.commandName, trait.commandName)) {
            return false;
        }
        if (!Objects.equals(this.key, trait.key)) {
            return false;
        }
        if (!Objects.equals(this.globalKey, trait.globalKey)) {
            return false;
        }
        if (!Objects.equals(this.propertiesFilter.getExpression(), trait.propertiesFilter.getExpression())) {
            return false;
        }
        if (!Objects.equals(this.restrictRange, trait.restrictRange)) {
            return false;
        }
        if (!Objects.equals(this.range, trait.range)) {
            return false;
        }
        if (!Objects.equals(this.globalCommand.isReportSingle(), trait.globalCommand.isReportSingle())) {
            return false;
        }
        if (!Objects.equals(this.fixedRange, trait.fixedRange)) {
            return false;
        }
        if (!Objects.equals(this.rangeProperty, trait.rangeProperty)) {
            return false;
        }
        if (!Objects.equals(this.description, trait.description)) {
            return false;
        }
        if (!Objects.equals(this.target, trait.target)) {
            return false;
        }
        return Objects.equals(this.globalCommand.getSelectFromDeck(), trait.globalCommand.getSelectFromDeck());
    }

    @Override
    public String getComponentName() {
        return this.piece.getName();
    }

    @Override
    public String getComponentTypeName() {
        return this.getDescription();
    }

    public static class Ed
    implements PieceEditor {
        protected StringConfigurer nameInput;
        protected NamedHotKeyConfigurer keyInput;
        protected NamedHotKeyConfigurer globalKey;
        protected PropertyExpressionConfigurer propertyMatch;
        protected MassKeyCommand.DeckPolicyConfig deckPolicy;
        protected BooleanConfigurer suppress;
        protected BooleanConfigurer restrictRange;
        protected BooleanConfigurer fixedRange;
        protected JLabel fixedRangeLabel;
        protected IntConfigurer range;
        protected JLabel rangeLabel;
        protected StringConfigurer rangeProperty;
        protected JLabel rangePropertyLabel;
        protected StringConfigurer descInput;
        protected JPanel controls;
        protected TraitConfigPanel traitPanel;
        protected GlobalCommandTargetConfigurer targetConfig;

        public Ed(CounterGlobalKeyCommand p) {
            PropertyChangeListener pl = evt -> {
                boolean isRange = Boolean.TRUE.equals(this.restrictRange.getValue());
                boolean isFixed = Boolean.TRUE.equals(this.fixedRange.getValue());
                this.range.getControls().setVisible(isRange && isFixed);
                this.rangeLabel.setVisible(isRange && isFixed);
                this.fixedRange.getControls().setVisible(isRange);
                this.fixedRangeLabel.setVisible(isRange);
                this.rangeProperty.getControls().setVisible(isRange && !isFixed);
                this.rangePropertyLabel.setVisible(isRange && !isFixed);
                Decorator.repack(this.range);
            };
            this.traitPanel = new TraitConfigPanel();
            this.controls = this.traitPanel;
            this.descInput = new StringConfigurer(p.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.traitPanel.add("Editor.description_label", (Configurer)this.descInput);
            this.nameInput = new StringConfigurer(p.commandName);
            this.nameInput.setHintKey("Editor.menu_command_hint");
            this.traitPanel.add("Editor.menu_command", (Configurer)this.nameInput);
            this.keyInput = new NamedHotKeyConfigurer(p.key);
            this.traitPanel.add("Editor.keyboard_command", (Configurer)this.keyInput);
            this.globalKey = new NamedHotKeyConfigurer(p.globalKey);
            this.traitPanel.add("Editor.GlobalkeyCommand.global_key_command", (Configurer)this.globalKey);
            this.targetConfig = new GlobalCommandTargetConfigurer(p.target);
            this.traitPanel.add("Editor.GlobalKeyCommand.pre_select", (Configurer)this.targetConfig);
            this.propertyMatch = new PropertyExpressionConfigurer(p.propertiesFilter);
            this.traitPanel.add("Editor.GlobalKeyCommand.matching_properties", (Configurer)this.propertyMatch);
            this.deckPolicy = new MassKeyCommand.DeckPolicyConfig(false);
            this.deckPolicy.setValue(p.globalCommand.getSelectFromDeck());
            this.traitPanel.add("Editor.GlobalKeyCommand.deck_policy", (Configurer)this.deckPolicy);
            this.restrictRange = new BooleanConfigurer(p.restrictRange);
            this.traitPanel.add("Editor.GlobalKeyCommand.restrict_range", (Configurer)this.restrictRange);
            this.restrictRange.addPropertyChangeListener(pl);
            this.fixedRange = new BooleanConfigurer(p.fixedRange);
            this.fixedRangeLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.fixed_range"));
            this.traitPanel.add(this.fixedRangeLabel, (Configurer)this.fixedRange);
            this.fixedRange.addPropertyChangeListener(pl);
            this.range = new IntConfigurer(p.range);
            this.rangeLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.range"));
            this.traitPanel.add(this.rangeLabel, (Configurer)this.range);
            this.rangeProperty = new StringConfigurer(p.rangeProperty);
            this.rangeProperty.setHintKey("Editor.GlobalKeyCommand.range_property_hint");
            this.rangePropertyLabel = new JLabel(Resources.getString("Editor.GlobalKeyCommand.range_property"));
            this.traitPanel.add(this.rangePropertyLabel, (Configurer)this.rangeProperty);
            this.suppress = new BooleanConfigurer(p.globalCommand.isReportSingle());
            this.traitPanel.add("Editor.GlobalKeyCommand.Editor_MassKey_suppress", (Configurer)this.suppress);
            pl.propertyChange(null);
        }

        @Override
        public Component getControls() {
            return this.controls;
        }

        @Override
        public String getType() {
            SequenceEncoder se = new SequenceEncoder(';');
            se.append(this.nameInput.getValueString()).append(this.keyInput.getValueString()).append(this.globalKey.getValueString()).append(this.propertyMatch.getValueString()).append(this.restrictRange.getValueString()).append(this.range.getValueString()).append(this.suppress.booleanValue()).append(this.fixedRange.booleanValue()).append(this.rangeProperty.getValueString()).append(this.descInput.getValueString()).append(this.deckPolicy.getIntValue()).append(this.targetConfig.getValueString());
            return CounterGlobalKeyCommand.ID + se.getValue();
        }

        @Override
        public String getState() {
            return "";
        }
    }
}

