/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.counters;

import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.PlayerRoster;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.command.ChangeTracker;
import VASSAL.command.Command;
import VASSAL.command.NullCommand;
import VASSAL.configure.BooleanConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.StringArrayConfigurer;
import VASSAL.configure.StringConfigurer;
import VASSAL.counters.Decorator;
import VASSAL.counters.EditablePiece;
import VASSAL.counters.GamePiece;
import VASSAL.counters.KeyCommand;
import VASSAL.counters.PieceEditor;
import VASSAL.counters.PieceVisitor;
import VASSAL.counters.PieceVisitorDispatcher;
import VASSAL.counters.Stack;
import VASSAL.counters.TraitConfigPanel;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.KeyStroke;

public class Restricted
extends Decorator
implements EditablePiece {
    public static final String ID = "restrict;";
    private String[] side;
    private boolean restrictByPlayer;
    private String owningPlayer = "";
    private boolean restrictMovement = true;
    private static PlayerRoster.SideChangeListener handleRetirement;
    private String description = "";

    public Restricted() {
        this(ID, null);
    }

    public Restricted(String type, GamePiece p) {
        this.setInner(p);
        this.mySetType(type);
        if (handleRetirement == null) {
            handleRetirement = new RetirementHandler();
            GameModule.getGameModule().addSideChangeListenerToPlayerRoster(handleRetirement);
        }
    }

    @Override
    public String getDescription() {
        return this.buildDescription("Editor.Restricted.trait_description", this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("RestrictedAccess.html");
    }

    @Override
    public void mySetType(String type) {
        type = type.substring(ID.length());
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(type, ';');
        this.side = st.nextStringArray(0);
        this.restrictByPlayer = st.nextBoolean(false);
        this.restrictMovement = st.nextBoolean(true);
        this.description = st.nextToken("");
    }

    @Override
    public Shape getShape() {
        return this.piece.getShape();
    }

    @Override
    public Rectangle boundingBox() {
        return this.piece.boundingBox();
    }

    @Override
    public void draw(Graphics g, int x, int y, Component obs, double zoom) {
        this.piece.draw(g, x, y, obs, zoom);
    }

    @Override
    public String getName() {
        return this.piece.getName();
    }

    @Override
    protected KeyCommand[] myGetKeyCommands() {
        return new KeyCommand[0];
    }

    public boolean isRestricted() {
        boolean restricted = false;
        if (this.restrictByPlayer) {
            boolean bl = restricted = this.owningPlayer.length() > 0 && !GameModule.getUserId().equals(this.owningPlayer);
        }
        if ((restricted || !this.restrictByPlayer) && PlayerRoster.isActive() && GameModule.getGameModule().getGameState().isGameStarted()) {
            restricted = true;
            for (String s : this.side) {
                if (!s.equals(PlayerRoster.getMySide())) continue;
                restricted = false;
                break;
            }
        }
        return restricted;
    }

    @Override
    public void setProperty(Object key, Object val) {
        if ("Selected".equals(key) && Boolean.TRUE.equals(val) && this.restrictByPlayer && this.owningPlayer.length() == 0 && this.getMap() != null) {
            this.owningPlayer = GameModule.getUserId();
        }
        super.setProperty(key, val);
    }

    @Override
    protected KeyCommand[] getKeyCommands() {
        if (!this.isRestricted()) {
            return super.getKeyCommands();
        }
        return new KeyCommand[0];
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        if ("Restricted".equals(key)) {
            return this.isRestricted();
        }
        if ("RestrictedMovement".equals(key)) {
            return this.isRestricted() && this.restrictMovement;
        }
        return super.getLocalizedProperty(key);
    }

    @Override
    public Object getProperty(Object key) {
        if ("Restricted".equals(key)) {
            return this.isRestricted();
        }
        if ("RestrictedMovement".equals(key)) {
            return this.isRestricted() && this.restrictMovement;
        }
        return super.getProperty(key);
    }

    @Override
    public String myGetState() {
        return this.owningPlayer;
    }

    @Override
    public String myGetType() {
        return ID + new SequenceEncoder(';').append(this.side).append(this.restrictByPlayer).append(this.restrictMovement).append(this.description).getValue();
    }

    @Override
    public Command myKeyEvent(KeyStroke stroke) {
        return null;
    }

    @Override
    public Command keyEvent(KeyStroke stroke) {
        if (!this.isRestricted()) {
            return super.keyEvent(stroke);
        }
        return null;
    }

    @Override
    public void mySetState(String newState) {
        this.owningPlayer = newState;
    }

    @Override
    public boolean testEquals(Object o) {
        if (!(o instanceof Restricted)) {
            return false;
        }
        Restricted c = (Restricted)o;
        if (!Arrays.equals(this.side, c.side)) {
            return false;
        }
        if (!Objects.equals(this.restrictByPlayer, c.restrictByPlayer)) {
            return false;
        }
        if (!Objects.equals(this.restrictMovement, c.restrictMovement)) {
            return false;
        }
        return Objects.equals(this.owningPlayer, c.owningPlayer);
    }

    @Override
    public PieceEditor getEditor() {
        return new Ed(this);
    }

    private static class RetirementHandler
    implements PlayerRoster.SideChangeListener,
    PieceVisitor {
        private RetirementHandler() {
        }

        @Override
        public void sideChanged(String oldSide, String newSide) {
            if (newSide == null) {
                PieceVisitorDispatcher d = new PieceVisitorDispatcher(this);
                Command c = new NullCommand();
                for (Map m : GameModule.getGameModule().getComponentsOf(Map.class)) {
                    for (GamePiece piece : m.getPieces()) {
                        c = c.append((Command)d.accept(piece));
                    }
                }
                GameModule.getGameModule().sendAndLog(c);
            }
        }

        @Override
        public Object visitDefault(GamePiece p) {
            Restricted r = (Restricted)Decorator.getDecorator(p, Restricted.class);
            if (r != null && r.restrictByPlayer && GameModule.getUserId().equals(r.owningPlayer)) {
                ChangeTracker t = new ChangeTracker(p);
                r.owningPlayer = "";
                return t.getChangeCommand();
            }
            return null;
        }

        @Override
        public Object visitStack(Stack s) {
            Command c = new NullCommand();
            for (GamePiece gamePiece : s.asList()) {
                c = c.append((Command)this.visitDefault(gamePiece));
            }
            return c;
        }
    }

    public static class Ed
    implements PieceEditor {
        private final BooleanConfigurer byPlayer;
        private final StringArrayConfigurer config;
        private final BooleanConfigurer movementConfig;
        private final TraitConfigPanel box = new TraitConfigPanel();
        private final StringConfigurer descInput;

        public Ed(Restricted r) {
            this.descInput = new StringConfigurer(r.description);
            this.descInput.setHintKey("Editor.description_hint");
            this.box.add("Editor.description_label", (Configurer)this.descInput);
            this.config = new StringArrayConfigurer(r.side);
            this.config.setHintKey("Editor.PieceAccessConfigurer.side_hint");
            this.box.add("Editor.Restricted.belongs_to_side", (Configurer)this.config);
            this.byPlayer = new BooleanConfigurer(r.restrictByPlayer);
            this.box.add("Editor.Restricted.also_belongs", (Configurer)this.byPlayer);
            this.movementConfig = new BooleanConfigurer(r.restrictMovement);
            this.box.add("Editor.Restricted.prevent_non_owning", (Configurer)this.movementConfig);
        }

        @Override
        public Component getControls() {
            return this.box;
        }

        @Override
        public String getState() {
            return "";
        }

        @Override
        public String getType() {
            return Restricted.ID + new SequenceEncoder(';').append(this.config.getValueString()).append(this.byPlayer.booleanValue()).append(this.movementConfig.booleanValue()).append(this.descInput.getValueString()).getValue();
        }
    }
}

