/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.tools.image.tilecache;

import VASSAL.tools.image.ImageIOException;
import VASSAL.tools.image.ImageNotFoundException;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.digest.DigestUtils;

public class TileUtils {
    private TileUtils() {
    }

    public static BufferedImage read(String src) throws ImageIOException {
        return TileUtils.read(new File(src));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static BufferedImage read(File src) throws ImageIOException {
        try (InputStream fin = Files.newInputStream(src.toPath(), new OpenOption[0]);){
            BufferedImage bufferedImage;
            try (BufferedInputStream in = new BufferedInputStream(fin);){
                bufferedImage = TileUtils.read(in);
            }
            return bufferedImage;
        }
        catch (NoSuchFileException e) {
            throw new ImageNotFoundException(src, (Throwable)e);
        }
        catch (IOException e) {
            throw new ImageIOException(src, (Throwable)e);
        }
    }

    public static BufferedImage read(InputStream in) throws IOException {
        byte[] header = TileUtils.readHeader(in);
        ByteBuffer bb = ByteBuffer.wrap(header);
        byte[] sig = new byte[6];
        bb.get(sig);
        TileUtils.checkSignature(sig);
        int w = bb.getInt();
        int h = bb.getInt();
        int type = bb.getInt();
        byte[] cdata = in.readAllBytes();
        try (ByteArrayInputStream bin = new ByteArrayInputStream(cdata);
             GZIPInputStream zin = new GZIPInputStream(bin);){
            bb = ByteBuffer.wrap(zin.readAllBytes());
        }
        BufferedImage img = new BufferedImage(w, h, type);
        DataBufferInt db = (DataBufferInt)img.getRaster().getDataBuffer();
        int[] data = db.getData();
        IntBuffer ib = bb.asIntBuffer();
        ib.get(data);
        return img;
    }

    static byte[] readHeader(InputStream in) throws IOException {
        byte[] header = new byte[18];
        if (in.readNBytes(header, 0, header.length) != header.length) {
            throw new IOException("header too short!");
        }
        return header;
    }

    static void checkSignature(byte[] sig) throws IOException {
        if (!Arrays.equals(sig, "VASSAL".getBytes(StandardCharsets.UTF_8))) {
            throw new IOException("bad signature: got \"" + new String(sig, StandardCharsets.UTF_8) + "\", expected \"VASSAL\"");
        }
    }

    public static Dimension size(String src) throws ImageIOException {
        return TileUtils.size(new File(src));
    }

    public static Dimension size(File src) throws ImageIOException {
        Dimension dimension;
        block9: {
            InputStream in = Files.newInputStream(src.toPath(), new OpenOption[0]);
            try {
                dimension = TileUtils.size(in);
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NoSuchFileException e) {
                    throw new ImageNotFoundException(src, (Throwable)e);
                }
                catch (IOException e) {
                    throw new ImageIOException(src, (Throwable)e);
                }
            }
            in.close();
        }
        return dimension;
    }

    public static Dimension size(InputStream in) throws IOException {
        byte[] header = TileUtils.readHeader(in);
        ByteBuffer bb = ByteBuffer.wrap(header);
        byte[] sig = new byte[6];
        bb.get(sig);
        TileUtils.checkSignature(sig);
        return new Dimension(bb.getInt(), bb.getInt());
    }

    public static void write(BufferedImage tile, String dst) throws ImageIOException {
        TileUtils.write(tile, new File(dst));
    }

    public static void write(BufferedImage tile, File dst) throws ImageIOException {
        try (OutputStream fout = Files.newOutputStream(dst.toPath(), new OpenOption[0]);
             BufferedOutputStream out = new BufferedOutputStream(fout);){
            TileUtils.write(tile, out);
        }
        catch (IOException e) {
            throw new ImageIOException(dst, (Throwable)e);
        }
    }

    public static void write(BufferedImage tile, OutputStream out) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(18);
        bb.put("VASSAL".getBytes(StandardCharsets.UTF_8)).putInt(tile.getWidth()).putInt(tile.getHeight()).putInt(tile.getType());
        out.write(bb.array());
        DataBufferInt db = (DataBufferInt)tile.getRaster().getDataBuffer();
        int[] data = db.getData();
        bb = ByteBuffer.allocate(4 * data.length);
        bb.asIntBuffer().put(data);
        GZIPOutputStream zout = new GZIPOutputStream(out);
        zout.write(bb.array());
        zout.finish();
    }

    public static int tileCount(Dimension i, Dimension t) {
        return TileUtils.tileCount(i.width, i.height, t.width, t.height);
    }

    public static int tileCount(int iw, int ih, int tw, int th) {
        int tcount = 0;
        int div = 1;
        while (iw / div > 0 && ih / div > 0) {
            tcount += TileUtils.tileCountAtScale(iw, ih, tw, th, div);
            div <<= 1;
        }
        return tcount;
    }

    public static int tileCountAtScale(Dimension i, Dimension t, int div) {
        return TileUtils.tileCountAtScale(i.width, i.height, t.width, t.height, div);
    }

    public static int tileCountAtScale(int iw, int ih, int tw, int th, int div) {
        if (iw < 1) {
            throw new IllegalArgumentException("iw = " + iw + " < 1");
        }
        if (ih < 1) {
            throw new IllegalArgumentException("ih = " + ih + " < 1");
        }
        if (tw < 1) {
            throw new IllegalArgumentException("tw = " + tw + " < 1");
        }
        if (th < 1) {
            throw new IllegalArgumentException("th = " + th + " < 1");
        }
        if (div < 1) {
            throw new IllegalArgumentException("div = " + div + " < 1");
        }
        int cols = (int)Math.ceil((double)(iw / div) / (double)tw);
        int rows = (int)Math.ceil((double)(ih / div) / (double)th);
        return cols * rows;
    }

    public static String tileName(String iname, int tileX, int tileY, int div) {
        String sha = DigestUtils.sha1Hex((String)(iname + "(" + tileX + "," + tileY + "@1:" + div));
        return sha.substring(0, 1) + "/" + sha.substring(0, 2) + "/" + sha;
    }
}

