/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.map;

import VASSAL.build.AbstractToolbarItem;
import VASSAL.build.AutoConfigurable;
import VASSAL.build.Buildable;
import VASSAL.build.GameModule;
import VASSAL.build.module.Map;
import VASSAL.build.module.documentation.HelpFile;
import VASSAL.configure.ColorConfigurer;
import VASSAL.configure.Configurer;
import VASSAL.configure.ConfigurerFactory;
import VASSAL.configure.IconConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.LaunchButton;
import VASSAL.tools.ProblemDialog;
import VASSAL.tools.WriteErrorDialog;
import VASSAL.tools.filechooser.FileChooser;
import VASSAL.tools.filechooser.PNGFileFilter;
import VASSAL.tools.swing.ProgressDialog;
import VASSAL.tools.swing.SwingUtils;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.event.IIOWriteProgressListener;
import javax.imageio.stream.ImageOutputStream;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImageSaver
extends AbstractToolbarItem {
    private static final Logger logger = LoggerFactory.getLogger(ImageSaver.class);
    protected LaunchButton launch;
    protected Map map;
    protected boolean promptToSplit = false;
    protected static final String DEFAULT_ICON = "/images/camera.gif";
    protected static final String BUTTON_TEXT = "buttonText";
    protected static ProgressDialog dialog;
    protected static final String HOTKEY = "hotkey";
    protected static final String TOOLTIP = "tooltip";
    protected static final String ICON_NAME = "icon";

    public ImageSaver() {
        ActionListener al = e -> this.writeMapAsImage();
        this.setNameKey("");
        this.setButtonTextKey(BUTTON_TEXT);
        this.launch = this.makeLaunchButton(Resources.getString("Editor.ImageSaver.save_map_as_png_image"), "", DEFAULT_ICON, al);
    }

    public ImageSaver(Map m) {
        this.map = m;
    }

    @Override
    public void addTo(Buildable b) {
        this.map = (Map)b;
        this.map.getToolBar().add(this.launch);
    }

    @Override
    public void removeFrom(Buildable b) {
        this.map = (Map)b;
        this.map.getToolBar().remove(this.launch);
        this.map.getToolBar().revalidate();
    }

    public void writeMapAsImage() {
        FileChooser fc = GameModule.getGameModule().getFileChooser();
        fc.setSelectedFile(new File(fc.getCurrentDirectory(), GameModule.getGameModule().getLocalizedGameName() + "Map.png"));
        fc.addChoosableFileFilter(new PNGFileFilter());
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this.map.getView());
        if (fc.showSaveDialog(frame) != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        dialog = new ProgressDialog(frame, Resources.getString("Editor.ImageSaver.saving_map_image_title"), Resources.getString("Editor.ImageSaver.saving_map_image_text"));
        int l = Resources.getString("Editor.ImageSaver.saving_map_image_as").length() + file.getName().length() + 7;
        dialog.setLabel("N".repeat(Math.max(0, l)));
        SwingUtils.repack(dialog);
        dialog.setLabel(Resources.getString("Editor.ImageSaver.saving_map_image_as") + " ");
        dialog.setIndeterminate(true);
        dialog.setLocationRelativeTo(frame);
        Dimension s = this.map.mapSize();
        if (s.width == 0) {
            s.width = 1;
        }
        if (s.height == 0) {
            s.height = 1;
        }
        double zoom = this.map.getZoom();
        int w = (int)Math.round((double)s.width * zoom);
        int h = (int)Math.round((double)s.height * zoom);
        if (w < 1 || h < 1) {
            if (s.width < s.height) {
                w = 1;
                h = s.height / s.width;
            } else {
                h = 1;
                w = s.width / s.height;
            }
        }
        this.writeMapRectAsImage(file, 0, 0, w, h);
        dialog.setVisible(true);
    }

    protected void writeMapRectAsImage(File file, int x, int y, int w, int h) {
        SnapshotTask task = new SnapshotTask(file, x, y, w, h);
        task.addPropertyChangeListener(e -> {
            if ("progress".equals(e.getPropertyName())) {
                dialog.setProgress((Integer)e.getNewValue());
            } else if ("state".equals(e.getPropertyName()) && e.getNewValue() == SwingWorker.StateValue.DONE) {
                dialog.setVisible(false);
                dialog.dispose();
            }
        });
        dialog.addActionListener(e -> task.cancel(true));
        task.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated(since="2020-08-06", forRemoval=true)
    public void writeImage(OutputStream[] out) throws IOException {
        ProblemDialog.showDeprecated("2020-08-06");
        Dimension buffer = this.map.getEdgeBuffer();
        int totalWidth = (int)((double)(this.map.mapSize().width - 2 * buffer.width) * this.map.getZoom());
        int totalHeight = (int)((double)(this.map.mapSize().height - 2 * buffer.height) * this.map.getZoom());
        for (int i = 0; i < out.length; ++i) {
            int height = totalHeight / out.length;
            if (i == out.length - 1) {
                height = totalHeight - height * (out.length - 1);
            }
            Image output = this.map.getView().createImage(totalWidth, height);
            Graphics2D gg = (Graphics2D)output.getGraphics();
            this.map.paintRegion(gg, new Rectangle(-((int)(this.map.getZoom() * (double)buffer.width)), -((int)(this.map.getZoom() * (double)buffer.height)) + height * i, totalWidth, totalHeight), null);
            gg.dispose();
            try {
                MediaTracker t = new MediaTracker(this.map.getView());
                t.addImage(output, 0);
                t.waitForID(0);
            }
            catch (Exception e) {
                logger.error("", (Throwable)e);
            }
            try {
                if (output instanceof RenderedImage) {
                    ImageIO.write((RenderedImage)((Object)output), "png", out[i]);
                    continue;
                }
                throw new IOException("Bad image type");
            }
            finally {
                try {
                    out[i].close();
                }
                catch (IOException e) {
                    logger.error("", (Throwable)e);
                }
            }
        }
    }

    @Override
    public HelpFile getHelpFile() {
        return HelpFile.getReferenceManualPage("Map.html", "ImageCapture");
    }

    public static String getConfigureTypeName() {
        return Resources.getString("Editor.ImageSaver.component_type");
    }

    public Class<?>[] getAllowableConfigureComponents() {
        return new Class[0];
    }

    private class SnapshotTask
    extends SwingWorker<Void, Void> {
        private int tiles;
        private int tilesDone = 0;
        private final File file;
        private final int x;
        private final int y;
        private final int w;
        private final int h;
        private final Color bg;
        private final List<File> files;

        public SnapshotTask(File file, int x, int y, int w, int h) {
            this.bg = ColorConfigurer.stringToColor(ImageSaver.this.map.getAttributeValueString("backgroundcolor"));
            this.files = new ArrayList<File>();
            this.file = file;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeImage(File f, BufferedImage img, Rectangle r) throws IOException {
            this.files.add(f);
            if (f.exists()) {
                if (!f.canWrite()) {
                    throw new IOException("Cannot write to the file \"" + f.getAbsolutePath() + "\"");
                }
            } else {
                File p = f.getParentFile();
                if (p.isDirectory() && !p.canWrite()) {
                    throw new IOException("Cannot write to the directory \"" + p.getAbsolutePath() + "\"");
                }
            }
            SwingUtilities.invokeLater(() -> {
                dialog.setLabel(Resources.getString("Editor.ImageSaver.saving_map_image_as") + " " + f.getName() + ":");
                dialog.setIndeterminate(true);
            });
            Graphics2D g = img.createGraphics();
            Color oc = g.getColor();
            g.setColor(this.bg);
            g.fillRect(0, 0, img.getWidth(), img.getHeight());
            g.setColor(oc);
            g.translate(-r.x, -r.y);
            ImageSaver.this.map.paintRegion(g, r, null);
            g.dispose();
            SwingUtilities.invokeLater(() -> dialog.setIndeterminate(false));
            ImageWriter iw = ImageIO.getImageWritersByFormatName("png").next();
            iw.addIIOWriteProgressListener(new IIOWriteProgressListener(){

                @Override
                public void imageComplete(ImageWriter source) {
                }

                @Override
                public void imageProgress(ImageWriter source, float percentageDone) {
                    SnapshotTask.this.setProgress(Math.round(((float)(100 * SnapshotTask.this.tilesDone) + percentageDone) / (float)SnapshotTask.this.tiles));
                }

                @Override
                public void imageStarted(ImageWriter source, int imageIndex) {
                }

                @Override
                public void thumbnailComplete(ImageWriter source) {
                }

                @Override
                public void thumbnailProgress(ImageWriter source, float percentageDone) {
                }

                @Override
                public void thumbnailStarted(ImageWriter source, int imageIndex, int thumbnailIndex) {
                }

                @Override
                public void writeAborted(ImageWriter source) {
                }
            });
            try (ImageOutputStream os = ImageIO.createImageOutputStream(f);){
                if (os == null) {
                    throw new IOException("Failed to write file " + f.getAbsolutePath());
                }
                iw.setOutput(os);
                iw.write(img);
            }
            finally {
                iw.dispose();
            }
        }

        @Override
        public Void doInBackground() throws IOException {
            this.setProgress(0);
            int tw = this.w;
            int th = this.h;
            BufferedImage img = null;
            while ((long)tw * (long)th > 0x1FFFFFFFL) {
                if (tw > th) {
                    tw = (int)Math.ceil((double)tw / 2.0);
                    continue;
                }
                th = (int)Math.ceil((double)th / 2.0);
            }
            while (img == null) {
                try {
                    img = new BufferedImage(tw, th, 2);
                }
                catch (OutOfMemoryError e) {
                    if (tw > th) {
                        tw = (int)Math.ceil((double)tw / 2.0);
                        continue;
                    }
                    th = (int)Math.ceil((double)th / 2.0);
                }
            }
            if (tw == this.w && th == this.h) {
                this.tiles = 1;
                this.writeImage(this.file, img, new Rectangle(0, 0, this.w, this.h));
            } else {
                String suffix;
                String base;
                String s = this.file.getName();
                if (s.endsWith(".png")) {
                    base = s.substring(0, s.lastIndexOf(46));
                    suffix = ".png";
                } else {
                    base = s;
                    suffix = "";
                }
                int tcols = (int)Math.ceil((double)this.w / (double)tw);
                int trows = (int)Math.ceil((double)this.h / (double)th);
                this.tiles = tcols * trows;
                for (int tx = 0; tx < tcols; ++tx) {
                    for (int ty = 0; ty < trows; ++ty) {
                        File f = new File(this.file.getParent(), base + "." + tx + "." + ty + suffix);
                        Rectangle r = new Rectangle(tw * tx, th * ty, Math.min(tw, this.w - tw * tx), Math.min(th, this.h - th * ty));
                        this.writeImage(f, img, r);
                        ++this.tilesDone;
                    }
                }
            }
            return null;
        }

        @Override
        protected void done() {
            try {
                this.get();
            }
            catch (CancellationException e) {
                for (File f : this.files) {
                    f.delete();
                }
            }
            catch (InterruptedException e) {
                ErrorDialog.bug(e);
            }
            catch (ExecutionException e) {
                Throwable c = e;
                while ((c = c.getCause()) instanceof ExecutionException) {
                }
                if (c instanceof IOException) {
                    WriteErrorDialog.error((Throwable)e, (IOException)c, this.files.get(this.files.size() - 1));
                }
                if (c instanceof InterruptedException) {
                    for (File f : this.files) {
                        f.delete();
                    }
                }
                ErrorDialog.bug(e);
            }
        }
    }

    @Deprecated(since="2020-10-01", forRemoval=true)
    public static class IconConfig
    implements ConfigurerFactory {
        @Override
        public Configurer getConfigurer(AutoConfigurable c, String key, String name) {
            return new IconConfigurer(key, name, ImageSaver.DEFAULT_ICON);
        }
    }
}

