/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.noteswindow;

import VASSAL.build.BadDataReport;
import VASSAL.build.GameModule;
import VASSAL.build.module.Chatter;
import VASSAL.build.module.GameComponent;
import VASSAL.build.module.GlobalOptions;
import VASSAL.build.module.noteswindow.AddSecretNoteCommand;
import VASSAL.build.module.noteswindow.SecretNote;
import VASSAL.command.Command;
import VASSAL.command.CommandEncoder;
import VASSAL.configure.StringConfigurer;
import VASSAL.configure.TextConfigurer;
import VASSAL.i18n.Resources;
import VASSAL.tools.ErrorDialog;
import VASSAL.tools.ScrollPane;
import VASSAL.tools.SequenceEncoder;
import VASSAL.tools.WarningDialog;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public class SecretNotesController
implements GameComponent,
CommandEncoder,
AddSecretNoteCommand.Interface {
    public static final String COMMAND_PREFIX = "SNOTE\t";
    private final Controls controls;
    private JPanel panel;
    private final List<SecretNote> notes = new ArrayList<SecretNote>();
    private List<SecretNote> lastSavedNotes;
    public static final int COL_HANDLE = 0;
    public static final int COL_DTM = 1;
    public static final int COL_NAME = 2;
    public static final int COL_REVEALED = 3;
    private static final String INTERNAL_DATETIME_FORMAT = "MM/dd/yyyy h:mm a";
    public static final DateFormat INTERNAL_DATE_FORMATTER = new SimpleDateFormat("MM/dd/yyyy h:mm a");
    public static final DateFormat LOCAL_DATE_FORMATTER = DateFormat.getDateTimeInstance(3, 3, Locale.getDefault());

    public SecretNotesController() {
        this.controls = new Controls();
    }

    @Override
    public Command getRestoreCommand() {
        AddSecretNoteCommand comm = null;
        for (SecretNote note : this.notes) {
            AddSecretNoteCommand c = new AddSecretNoteCommand(this, note);
            if (comm == null) {
                comm = c;
                continue;
            }
            comm.append(c);
        }
        return comm;
    }

    @Override
    public void setup(boolean gameStarting) {
        if (!gameStarting) {
            this.notes.clear();
            this.controls.refresh();
        }
    }

    @Override
    public Command decode(String command) {
        if (!command.startsWith(COMMAND_PREFIX)) {
            return null;
        }
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(command.substring(COMMAND_PREFIX.length()), '\t');
        String name = st.nextToken();
        String owner = st.nextToken();
        boolean hidden = "true".equals(st.nextToken());
        String text = TextConfigurer.restoreNewlines(st.nextToken());
        String handle = "";
        Date date = null;
        if (st.hasMoreTokens()) {
            String formattedDate = st.nextToken();
            try {
                date = new SimpleDateFormat(INTERNAL_DATETIME_FORMAT).parse(formattedDate);
            }
            catch (ParseException e) {
                ErrorDialog.dataWarning(new BadDataReport("Illegal date format", formattedDate, e));
            }
        }
        if (st.hasMoreTokens()) {
            handle = st.nextToken();
        }
        SecretNote note = new SecretNote(name, owner, text, hidden, date, handle);
        return new AddSecretNoteCommand(this, note);
    }

    @Override
    public String encode(Command c) {
        if (!(c instanceof AddSecretNoteCommand)) {
            return null;
        }
        SecretNote note = ((AddSecretNoteCommand)c).getNote();
        SequenceEncoder se = new SequenceEncoder('\t');
        String date = note.getDate() == null ? "" : new SimpleDateFormat(INTERNAL_DATETIME_FORMAT).format(note.getDate());
        return COMMAND_PREFIX + se.append(note.getName()).append(note.getOwner()).append(note.isHidden()).append(TextConfigurer.escapeNewlines(note.getText())).append(date).append(note.getHandle()).getValue();
    }

    @Override
    public void addSecretNote(SecretNote note) {
        int index = this.notes.indexOf(note);
        if (index >= 0) {
            this.notes.set(index, note);
        } else {
            this.notes.add(0, note);
        }
        this.controls.refresh();
    }

    public JComponent getControls() {
        if (this.panel == null) {
            this.panel = new JPanel();
            this.panel.setLayout(new BoxLayout(this.panel, 1));
            JLabel l = new JLabel(Resources.getString("Notes.visible_once_revealed"));
            l.setAlignmentX(0.0f);
            this.panel.add(l);
            this.panel.add(this.controls);
        }
        return this.panel;
    }

    public Command save() {
        AddSecretNoteCommand comm = null;
        for (SecretNote secretNote : this.notes) {
            int index = this.lastSavedNotes.indexOf(secretNote);
            if (index >= 0 && this.lastSavedNotes.get(index).isHidden() == secretNote.isHidden()) continue;
            Command c = new AddSecretNoteCommand(this, secretNote);
            if (comm == null) {
                comm = c;
            } else {
                comm.append(c);
            }
            String msg = index < 0 ? "* " + Resources.getString("Notes.has_created", GlobalOptions.getInstance().getPlayerId(), secretNote.getName()) + " *" : "* " + Resources.getString("Notes.has_revealed", GlobalOptions.getInstance().getPlayerId(), secretNote.getName()) + " *";
            c = new Chatter.DisplayText(GameModule.getGameModule().getChatter(), msg);
            c.execute();
            comm.append(c);
        }
        return comm;
    }

    public void captureState() {
        this.lastSavedNotes = new ArrayList<SecretNote>(this.notes);
    }

    public void restoreState() {
        this.notes.clear();
        this.notes.addAll(this.lastSavedNotes);
        this.controls.refresh();
    }

    public SecretNote getNoteForName(String s) {
        for (SecretNote n : this.notes) {
            if (!n.getName().equals(s)) continue;
            return n;
        }
        return null;
    }

    private class Controls
    extends JPanel
    implements ItemListener {
        private static final long serialVersionUID = 1L;
        private final JTextArea text;
        private final JTable table;
        private final JButton revealButton;
        private final String[] columnNames = new String[]{Resources.getString("Notes.player"), Resources.getString("Notes.date_time"), Resources.getString("Notes.note_name"), Resources.getString("Notes.revealed")};

        public Controls() {
            this.setLayout(new BoxLayout(this, 1));
            this.table = new JTable(new MyTableModel());
            this.initColumns(this.table);
            this.table.setSelectionMode(0);
            ListSelectionModel rowSM = this.table.getSelectionModel();
            rowSM.addListSelectionListener(e -> {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    this.displaySelected();
                }
            });
            ScrollPane secretScroll = new ScrollPane(this.table);
            this.table.setPreferredScrollableViewportSize(new Dimension(500, 100));
            this.add(secretScroll);
            Box b = Box.createHorizontalBox();
            b.setAlignmentX(0.0f);
            JButton newButton = new JButton(Resources.getString("General.new"));
            newButton.addActionListener(e -> this.createNewNote());
            b.add(newButton);
            this.revealButton = new JButton(Resources.getString("Notes.reveal"));
            this.revealButton.addActionListener(e -> this.revealSelectedNote());
            this.revealButton.setEnabled(false);
            b.add(this.revealButton);
            this.add(b);
            this.text = new JTextArea(6, 20);
            this.text.setEditable(false);
            ScrollPane scroll = new ScrollPane(this.text);
            scroll.setBorder(new TitledBorder(Resources.getString("Notes.text")));
            this.add(scroll);
        }

        private void initColumns(JTable t) {
            for (int i = 0; i < this.columnNames.length; ++i) {
                int width;
                TableColumn column = t.getColumnModel().getColumn(i);
                switch (i) {
                    case 0: {
                        width = 60;
                        break;
                    }
                    case 1: {
                        width = 100;
                        break;
                    }
                    case 2: {
                        width = 280;
                        break;
                    }
                    case 3: {
                        width = 60;
                        break;
                    }
                    default: {
                        width = 100;
                    }
                }
                column.setPreferredWidth(width);
            }
        }

        public void refresh() {
            this.table.setModel(new MyTableModel());
            this.initColumns(this.table);
            this.displaySelected();
        }

        private void revealSelectedNote() {
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow < 0) {
                return;
            }
            String selectedName = (String)this.table.getValueAt(selectedRow, 2);
            SecretNote note = SecretNotesController.this.getNoteForName(selectedName);
            if (note.getOwner().equals(GameModule.getUserId()) && (note = new SecretNote(note.getName(), note.getOwner(), note.getText(), false, note.getDate(), note.getHandle())) != null) {
                int i = SecretNotesController.this.notes.indexOf(note);
                SecretNotesController.this.notes.set(i, note);
                this.refresh();
            }
        }

        public void createNewNote() {
            Dialog parent = (Dialog)SwingUtilities.getAncestorOfClass(Dialog.class, this);
            JDialog d = parent != null ? new JDialog(parent, true) : new JDialog((Frame)SwingUtilities.getAncestorOfClass(Frame.class, this), true);
            d.setTitle(Resources.getString("Notes.delayed_note"));
            StringConfigurer name = new StringConfigurer(null, Resources.getString("Notes.name"));
            TextConfigurer text = new TextConfigurer(null, Resources.getString("Notes.text"));
            d.setLayout(new BoxLayout(d.getContentPane(), 1));
            d.add(name.getControls());
            d.add(text.getControls());
            Box buttonPanel = Box.createHorizontalBox();
            JButton okButton = new JButton(Resources.getString("General.ok"));
            okButton.addActionListener(e -> {
                SecretNote note = new SecretNote(name.getValueString(), GameModule.getUserId(), (String)text.getValue(), true);
                if (SecretNotesController.this.notes.contains(note)) {
                    WarningDialog.show((Component)this, "Notes.note_exists", new Object[0]);
                } else {
                    SecretNotesController.this.notes.add(0, note);
                    this.refresh();
                    d.dispose();
                }
            });
            PropertyChangeListener l = evt -> okButton.setEnabled(name.getValueString() != null && name.getValueString().length() > 0 && text.getValueString() != null && text.getValueString().length() > 0);
            name.addPropertyChangeListener(l);
            text.addPropertyChangeListener(l);
            okButton.setEnabled(false);
            buttonPanel.add(okButton);
            JButton cancelButton = new JButton(Resources.getString("General.cancel"));
            cancelButton.addActionListener(e -> d.dispose());
            d.add(buttonPanel);
            d.pack();
            d.setLocationRelativeTo(d.getOwner());
            d.setVisible(true);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            this.displaySelected();
        }

        private void displaySelected() {
            this.revealButton.setEnabled(false);
            this.text.setText("");
            int selectedRow = this.table.getSelectedRow();
            if (selectedRow < 0) {
                return;
            }
            String selectedName = (String)this.table.getValueAt(selectedRow, 2);
            SecretNote note = SecretNotesController.this.getNoteForName(selectedName);
            if (note != null) {
                if (note.getOwner().equals(GameModule.getUserId())) {
                    this.text.setText(note.getText());
                    this.revealButton.setEnabled(note.isHidden());
                } else {
                    this.text.setText(note.isHidden() ? Resources.getString("Notes.message_not_revealed") : note.getText());
                }
            }
        }

        public class MyTableModel
        extends AbstractTableModel {
            private static final long serialVersionUID = 1L;

            @Override
            public String getColumnName(int col) {
                return Controls.this.columnNames[col];
            }

            @Override
            public int getRowCount() {
                return SecretNotesController.this.notes.size();
            }

            @Override
            public int getColumnCount() {
                return Controls.this.columnNames.length;
            }

            @Override
            public Object getValueAt(int row, int col) {
                SecretNote note = SecretNotesController.this.notes.get(row);
                switch (col) {
                    case 0: {
                        return note.getHandle();
                    }
                    case 1: {
                        return note.getDate() == null ? "" : LOCAL_DATE_FORMATTER.format(note.getDate());
                    }
                    case 2: {
                        return note.getName();
                    }
                    case 3: {
                        return !note.isHidden();
                    }
                }
                return null;
            }

            @Override
            public Class<?> getColumnClass(int c) {
                return this.getValueAt(0, c).getClass();
            }

            @Override
            public boolean isCellEditable(int row, int col) {
                return false;
            }

            @Override
            public void setValueAt(Object value, int row, int col) {
            }
        }
    }
}

