/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.build.module.properties;

import VASSAL.build.module.properties.PropertySource;
import VASSAL.counters.GamePiece;
import java.util.Collection;

public class SumProperties
implements PropertySource {
    protected Collection<GamePiece> pieces;

    public SumProperties(Collection<GamePiece> pieces) {
        this.pieces = pieces;
    }

    @Override
    public Object getProperty(Object key) {
        Object value = null;
        String keyString = key.toString();
        if (keyString.startsWith("sum(") && keyString.endsWith(")")) {
            String propertyName = keyString.substring(4, keyString.length() - 1);
            int sum = 0;
            boolean indeterminate = false;
            for (GamePiece p : this.pieces) {
                Object val = p.getLocalizedProperty(propertyName);
                if (val != null) {
                    try {
                        sum += Integer.parseInt(val.toString());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                indeterminate = true;
            }
            value = sum == 0 && indeterminate ? "?" : sum + (indeterminate ? "+?" : "");
        } else if (!this.pieces.isEmpty()) {
            value = this.pieces.iterator().next().getProperty(key);
        }
        return value;
    }

    @Override
    public Object getLocalizedProperty(Object key) {
        return this.getProperty(key);
    }
}

