/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.chat.node;

import VASSAL.chat.node.AsynchronousServerNode;
import VASSAL.chat.node.LockWatcher;
import VASSAL.chat.node.PlayerNode;
import VASSAL.chat.node.Protocol;
import VASSAL.chat.node.SocketHandler;
import VASSAL.chat.node.SocketWatcher;
import VASSAL.tools.ArgsParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Properties;

public class Server
extends Thread {
    private final AsynchronousServerNode rootNode;
    private final ServerSocket socket;

    public Server(AsynchronousServerNode rootNode, int port) throws IOException {
        this.rootNode = rootNode;
        this.socket = new ServerSocket(port);
        System.err.println("Started server on port " + port);
        this.start();
    }

    @Override
    public void run() {
        int consecutiveFailures = 0;
        while (consecutiveFailures < 10) {
            try {
                Socket s = this.socket.accept();
                new PlayerNode(s, this.rootNode);
                consecutiveFailures = 0;
            }
            catch (Exception e) {
                e.printStackTrace();
                ++consecutiveFailures;
            }
        }
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Properties p = new ArgsParser(args).getProperties();
        int port = Integer.parseInt(p.getProperty("port", "5050"));
        String reportURL = p.getProperty("URL", "http://www.vassalengine.org/util/");
        if ("null".equals(reportURL)) {
            reportURL = null;
        }
        if (!"true".equals(p.getProperty("test"))) {
            new Server(new AsynchronousServerNode(reportURL), port);
            new LockWatcher(1800000L, 60000L, port).start();
        }
        if (p.getProperty("test") != null) {
            Socket soc = new Socket("localHost", port);
            SocketHandler handler = new SocketHandler(soc, new SocketWatcher(){

                @Override
                public void handleMessage(String msg) {
                    System.err.println(msg);
                }

                @Override
                public void socketClosed(SocketHandler handler) {
                }
            });
            handler.start();
            handler.writeLine(Protocol.encodeRegisterCommand("rk", "test/Main Room", ""));
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("JOIN")) {
                        String room = line.substring("JOIN".length()).trim();
                        handler.writeLine(Protocol.encodeJoinCommand("test/" + room));
                        continue;
                    }
                    if (line.startsWith("BYE")) {
                        handler.close();
                        continue;
                    }
                    if (line.startsWith("HELLO")) {
                        soc = new Socket("localHost", port);
                        handler = new SocketHandler(soc, new SocketWatcher(){

                            @Override
                            public void handleMessage(String msg) {
                                System.err.println(msg);
                            }

                            @Override
                            public void socketClosed(SocketHandler handler) {
                            }
                        });
                        handler.start();
                        handler.writeLine(Protocol.encodeRegisterCommand("rk", "test/Main Room", ""));
                        continue;
                    }
                    if (line.startsWith("*")) {
                        int length = Integer.parseInt(line.substring(1));
                        StringBuilder buffer = new StringBuilder();
                        for (int i = 0; i < length; ++i) {
                            char c = (char)(97 + i % 10);
                            if (c == 'a') {
                                c = 'A';
                            }
                            buffer.append(c);
                        }
                        String msg = Protocol.encodeForwardCommand("test/*", buffer.toString());
                        handler.writeLine(msg);
                        continue;
                    }
                    handler.writeLine(line);
                }
            }
            finally {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

