/*
 * Decompiled with CFR 0.152.
 */
package VASSAL.configure;

import VASSAL.configure.AbstractConfigurableListEntry;
import VASSAL.configure.ConfigurableList;
import VASSAL.configure.ConfigurableListController;
import VASSAL.configure.ConfigurableListEntry;
import VASSAL.configure.Configurer;
import VASSAL.configure.NamedHotKeyConfigurer;
import VASSAL.tools.NamedKeyStroke;
import VASSAL.tools.SequenceEncoder;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.ArrayUtils;

public class NamedKeyStrokeArrayConfigurer
extends Configurer
implements ConfigurableList {
    private JPanel controls;
    private JPanel panel;
    private int selectedEntryIndex = -1;
    private final List<NKSAEntry> entries = new ArrayList<NKSAEntry>();
    private ConfigurableListController controller;

    public NamedKeyStrokeArrayConfigurer(String key, String name) {
        super(key, name);
    }

    public NamedKeyStrokeArrayConfigurer(String key, String name, NamedKeyStroke[] val) {
        super(key, name, val);
    }

    public NamedKeyStrokeArrayConfigurer(String key, String name, List<NamedKeyStroke> val) {
        this(key, name, val.toArray(new NamedKeyStroke[0]));
    }

    public NamedKeyStrokeArrayConfigurer(NamedKeyStroke[] val) {
        this((String)null, "", val);
    }

    public NamedKeyStroke[] getNameKeyStrokeArrayValue() {
        return (NamedKeyStroke[])this.getValue();
    }

    @Override
    public Component getControls() {
        if (this.panel == null) {
            this.panel = new JPanel((LayoutManager)new MigLayout("ins 0,gapy 4", "[grow,fill][]"));
            this.controls = new JPanel((LayoutManager)new MigLayout("gapy 4", "[grow,fill][]"));
            this.controls.setBorder(BorderFactory.createEtchedBorder());
            this.panel.add((Component)this.controls, "grow");
            this.panel.add((Component)this.getListController(), "growy 0,aligny center");
            this.rebuildControls();
        }
        return this.panel;
    }

    private void rebuildControls(int focus) {
        this.rebuildControls();
        this.entries.get(focus).requestFocus();
    }

    private void rebuildControls() {
        NamedKeyStroke[] keys;
        this.entries.clear();
        this.controls.removeAll();
        for (NamedKeyStroke key : keys = this.getNameKeyStrokeArrayValue()) {
            NKSAEntry entry = new NKSAEntry(this, key);
            this.controls.add(entry.getConfigurer().getControls());
            this.controls.add((Component)entry.getRemoveButton(), "growx 0,wrap");
            this.entries.add(entry);
        }
        this.updateControls();
        this.repack();
    }

    private void updateControls() {
        int i = 0;
        for (NKSAEntry entry : this.entries) {
            entry.setHighlighted(i++ == this.getSelectedEntryIndex());
        }
        this.getListController();
        this.controller.setCanMoveUp(this.getSelectedEntryIndex() > 0);
        this.controller.setCanMoveDown(this.getSelectedEntryIndex() >= 0 && this.getSelectedEntryIndex() < this.entries.size() - 1);
        this.controls.repaint();
    }

    @Override
    public String getValueString() {
        return NamedKeyStrokeArrayConfigurer.encode(this.getKeyStrokes());
    }

    @Override
    public void setValue(String s) {
        this.setValue(NamedKeyStrokeArrayConfigurer.decode(s));
    }

    @Override
    public void setValue(Object o) {
        super.setValue(ArrayUtils.clone((Object[])((NamedKeyStroke[])o)));
        if (this.controls != null) {
            this.rebuildControls();
        }
    }

    private void setKeyValue(int pos, NamedKeyStroke stroke) {
        NamedKeyStroke[] oldValue = (NamedKeyStroke[])ArrayUtils.clone((Object[])this.getNameKeyStrokeArrayValue());
        this.getNameKeyStrokeArrayValue()[pos] = stroke;
        if (!this.frozen) {
            this.changeSupport.firePropertyChange(this.key, oldValue, this.getNameKeyStrokeArrayValue());
        }
    }

    public NamedKeyStroke[] getKeyStrokes() {
        ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>();
        for (NKSAEntry entry : this.entries) {
            NamedKeyStroke value = (NamedKeyStroke)entry.getConfigurer().getValue();
            if (value == null) continue;
            l.add(value);
        }
        return l.toArray(new NamedKeyStroke[0]);
    }

    public static NamedKeyStroke[] decode(String s) {
        if (s == null) {
            return null;
        }
        ArrayList<NamedKeyStroke> l = new ArrayList<NamedKeyStroke>();
        SequenceEncoder.Decoder st = new SequenceEncoder.Decoder(s, ',');
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.isEmpty()) continue;
            l.add(NamedHotKeyConfigurer.decode(token));
        }
        return l.toArray(new NamedKeyStroke[0]);
    }

    public static String encode(NamedKeyStroke[] keys) {
        if (keys == null) {
            return null;
        }
        SequenceEncoder se = new SequenceEncoder(',');
        for (NamedKeyStroke key : keys) {
            if (key.isNull()) continue;
            se.append(NamedHotKeyConfigurer.encode(key));
        }
        return se.getValue() != null ? se.getValue() : "";
    }

    @Override
    public void moveEntryUp() {
        if (this.getSelectedEntryIndex() < 0) {
            return;
        }
        int pos = this.getSelectedEntryIndex();
        Object[] keys = this.getValue() == null ? new NamedKeyStroke[]{} : this.getNameKeyStrokeArrayValue();
        NamedKeyStroke moving = keys[pos];
        keys = (NamedKeyStroke[])ArrayUtils.remove((Object[])keys, (int)pos);
        keys = (NamedKeyStroke[])ArrayUtils.insert((int)(pos - 1), (Object[])keys, (Object[])new NamedKeyStroke[]{moving});
        this.setValue(keys);
        this.setSelectedEntryIndex(pos - 1);
        this.rebuildControls();
    }

    @Override
    public void moveEntryDown() {
        if (this.getSelectedEntryIndex() < 0) {
            return;
        }
        int pos = this.getSelectedEntryIndex();
        Object[] keys = this.getValue() == null ? new NamedKeyStroke[]{} : this.getNameKeyStrokeArrayValue();
        NamedKeyStroke moving = keys[pos];
        keys = (NamedKeyStroke[])ArrayUtils.remove((Object[])keys, (int)pos);
        keys = (NamedKeyStroke[])ArrayUtils.insert((int)(pos + 1), (Object[])keys, (Object[])new NamedKeyStroke[]{moving});
        this.setValue(keys);
        this.setSelectedEntryIndex(pos + 1);
        this.rebuildControls();
    }

    @Override
    public void addEntry() {
        int newEntry;
        Object[] keys;
        int pos = this.getSelectedEntryIndex();
        Object[] objectArray = keys = this.getValue() == null ? new NamedKeyStroke[]{} : this.getNameKeyStrokeArrayValue();
        if (this.entries.isEmpty() || this.getSelectedEntryIndex() < 0) {
            this.setValue(ArrayUtils.add((Object[])keys, (Object)new NamedKeyStroke()));
            newEntry = this.getNameKeyStrokeArrayValue().length - 1;
            this.setSelectedEntryIndex(newEntry);
        } else {
            newEntry = pos + 1;
            this.setValue(ArrayUtils.insert((int)newEntry, (Object[])keys, (Object[])new NamedKeyStroke[]{new NamedKeyStroke()}));
            this.setSelectedEntryIndex(newEntry);
        }
        this.rebuildControls(newEntry);
    }

    @Override
    public void deleteEntry(ConfigurableListEntry entry) {
        int pos = this.entries.indexOf(entry);
        Object[] keys = this.getValue() == null ? new NamedKeyStroke[]{} : this.getNameKeyStrokeArrayValue();
        this.setValue(ArrayUtils.remove((Object[])keys, (int)pos));
        this.setSelectedEntryIndex(Math.min(pos, this.entries.size() - 1));
        if (this.selectedEntryIndex >= 0) {
            this.entries.get(this.selectedEntryIndex).requestFocus();
        }
    }

    @Override
    public JComponent getListController() {
        if (this.controller == null) {
            this.controller = new ConfigurableListController(this);
        }
        return this.controller;
    }

    @Override
    public void selectEntry(ConfigurableListEntry entry) {
        this.setSelectedEntryIndex(entry == null ? -1 : this.entries.indexOf(entry));
        this.updateControls();
    }

    @Override
    public void repack() {
        this.repack(this.panel);
    }

    @Override
    public void setSelectedEntryIndex(int index) {
        this.selectedEntryIndex = Math.min(index, this.entries.size() - 1);
    }

    @Override
    public int getSelectedEntryIndex() {
        return this.selectedEntryIndex;
    }

    @Override
    public void entryChanged(ConfigurableListEntry entry) {
        this.setKeyValue(this.entries.indexOf(entry), (NamedKeyStroke)entry.getConfigurer().getValue());
    }

    static class NKSAEntry
    extends AbstractConfigurableListEntry {
        public NKSAEntry(ConfigurableList parentConfig, Object value) {
            super(parentConfig, value);
        }

        public NKSAEntry(ConfigurableList parentConfig) {
            this(parentConfig, null);
        }

        @Override
        public Configurer buildChildConfigurer(Object value) {
            NamedHotKeyConfigurer c = new NamedHotKeyConfigurer();
            ((Configurer)c).setValue(value);
            return c;
        }

        @Override
        public void setHighlighted(boolean b) {
            this.getConfigurer().setHighlighted(b);
        }
    }
}

